/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.web.handler;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.beans.ConstructorProperties;
import java.lang.reflect.Parameter;
import org.apache.commons.lang.SerializationException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jspare.core.container.ContainerUtils;
import org.jspare.vertx.web.annotation.handling.ArrayModel;
import org.jspare.vertx.web.annotation.handling.ArrayModelParser;
import org.jspare.vertx.web.annotation.handling.Header;
import org.jspare.vertx.web.annotation.handling.MapModel;
import org.jspare.vertx.web.annotation.handling.MapModelParser;
import org.jspare.vertx.web.annotation.handling.Model;
import org.jspare.vertx.web.builder.HandlerData;
import org.jspare.vertx.web.handler.APIHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHandler
implements Handler<RoutingContext> {
    private static final Logger log = LoggerFactory.getLogger(DefaultHandler.class);
    protected final HandlerData handlerData;

    public void handle(RoutingContext context) {
        try {
            context.vertx().exceptionHandler(t -> context.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end(ExceptionUtils.getStackTrace((Throwable)t)));
            Object newInstance = this.instantiateHandler();
            this.setHandlingParameters(context, newInstance);
            this.handlerData.bodyEndHandler().forEach(h -> context.addBodyEndHandler(event -> h.handle(context)));
            Object[] parameters = this.collectParameters(context);
            this.handlerData.method().invoke(newInstance, parameters);
        }
        catch (Throwable t2) {
            this.catchInvoke(context, t2);
        }
    }

    protected void catchInvoke(RoutingContext routingContext, Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        log.info("Error: {}", (Object)this.handlerData.toStringLine());
        log.error(t.getMessage(), t);
        routingContext.response().setStatusCode(500).end(t.toString());
    }

    protected Object[] collectParameters(RoutingContext routingContext) {
        Object[] parameters = new Object[this.handlerData.method().getParameterCount()];
        int i = 0;
        for (Parameter parameter : this.handlerData.method().getParameters()) {
            parameters[i] = this.resolveParameter(parameter, routingContext);
            ++i;
        }
        return parameters;
    }

    protected Object instantiateHandler() {
        Object newInstance = this.handlerData.clazz().newInstance();
        ContainerUtils.processInjection(newInstance);
        return newInstance;
    }

    protected Object resolveParameter(Parameter parameter, RoutingContext routingContext) {
        if (parameter.getType().equals(RoutingContext.class)) {
            return routingContext;
        }
        if (parameter.getType().equals(HttpServerRequest.class)) {
            return routingContext.request();
        }
        if (parameter.getType().equals(HttpServerResponse.class)) {
            return routingContext.response();
        }
        if (parameter.getType().equals(JsonObject.class)) {
            if (StringUtils.isEmpty((String)routingContext.getBody().toString())) {
                return null;
            }
            return routingContext.getBodyAsJson();
        }
        if (StringUtils.isNotEmpty((String)routingContext.request().getParam(parameter.getName()))) {
            return routingContext.request().getParam(parameter.getName());
        }
        if (parameter.isAnnotationPresent(ArrayModel.class)) {
            ArrayModel am = parameter.getAnnotation(ArrayModel.class);
            Class<?> clazz = am.value();
            return ArrayModelParser.toList(routingContext.getBody().toString(), clazz);
        }
        if (parameter.isAnnotationPresent(MapModel.class)) {
            MapModel mm = parameter.getAnnotation(MapModel.class);
            Class<?> value = mm.value();
            return MapModelParser.toMap(routingContext.getBody().toString(), value);
        }
        if (parameter.getType().getPackage().getName().endsWith(".model") || parameter.getType().isAnnotationPresent(Model.class) || parameter.isAnnotationPresent(Model.class)) {
            try {
                if (routingContext.getBody() == null) {
                    return null;
                }
                return Json.decodeValue((String)routingContext.getBody().toString(), parameter.getType());
            }
            catch (SerializationException e) {
                log.debug("Invalid content of body for class [{}] on parameter [{}]", parameter.getClass(), (Object)parameter.getName());
                return null;
            }
        }
        if (parameter.isAnnotationPresent(org.jspare.vertx.web.annotation.handling.Parameter.class)) {
            String parameterName = parameter.getAnnotation(org.jspare.vertx.web.annotation.handling.Parameter.class).value();
            Class<?> typeOfParameter = parameter.getType();
            if (typeOfParameter.equals(Integer.class)) {
                return Integer.parseInt(routingContext.request().getParam(parameterName));
            }
            if (typeOfParameter.equals(Double.class)) {
                return Double.parseDouble(routingContext.request().getParam(parameterName));
            }
            if (typeOfParameter.equals(Long.class)) {
                return Long.parseLong(routingContext.request().getParam(parameterName));
            }
            return routingContext.request().getParam(parameterName);
        }
        if (parameter.isAnnotationPresent(Header.class)) {
            String headerName = parameter.getAnnotation(Header.class).value();
            return routingContext.request().getHeader(headerName);
        }
        return null;
    }

    protected void sendStatus(RoutingContext routingContext, HttpResponseStatus status) {
        routingContext.response().setStatusCode(status.code()).setStatusMessage(status.reasonPhrase()).end(status.reasonPhrase());
    }

    protected void setHandlingParameters(RoutingContext routingContext, Object newInstance) {
        if (newInstance instanceof APIHandler) {
            ((APIHandler)newInstance).setVertx(routingContext.vertx());
            ((APIHandler)newInstance).setReq(routingContext.request());
            ((APIHandler)newInstance).setRes(routingContext.response());
            ((APIHandler)newInstance).setContext(routingContext);
        }
    }

    @ConstructorProperties(value={"handlerData"})
    public DefaultHandler(HandlerData handlerData) {
        this.handlerData = handlerData;
    }
}

