/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.web.handler;

import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import java.lang.reflect.Parameter;
import org.jspare.vertx.web.annotation.handling.Header;
import org.jspare.vertx.web.builder.HandlerData;
import org.jspare.vertx.web.handler.APIHandler;

public final class DefaultSockJSHandler {
    public static void socketHandler(HandlerData handlerData, SockJSSocket event) {
        Object instance = handlerData.clazz().newInstance();
        DefaultSockJSHandler.setHandlingParameters(event, instance);
        Object[] parameters = DefaultSockJSHandler.collectParameters(handlerData, event);
        handlerData.method().invoke(instance, parameters);
    }

    private static Object[] collectParameters(HandlerData handlerData, SockJSSocket event) {
        Object[] parameters = new Object[handlerData.method().getParameterCount()];
        int i = 0;
        for (Parameter parameter : handlerData.method().getParameters()) {
            parameters[i] = DefaultSockJSHandler.resolveParameter(parameter, event);
            ++i;
        }
        return parameters;
    }

    protected static Object resolveParameter(Parameter parameter, SockJSSocket event) {
        if (parameter.getType().equals(SockJSSocket.class)) {
            return event;
        }
        if (parameter.isAnnotationPresent(Header.class)) {
            String headerName = parameter.getAnnotation(Header.class).value();
            return event.headers().get(headerName);
        }
        if (parameter.getType().equals(SocketAddress.class)) {
            return event.localAddress();
        }
        if (parameter.getType().equals(Session.class)) {
            return event.webSession();
        }
        if (parameter.getType().equals(User.class)) {
            return event.webUser();
        }
        return null;
    }

    protected static void setHandlingParameters(SockJSSocket event, Object newInstance) {
        if (newInstance instanceof APIHandler) {
            ((APIHandler)newInstance).setSockJSEvent(event);
        }
    }

    private DefaultSockJSHandler() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

