/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.web.builder;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import java.beans.ConstructorProperties;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.jspare.vertx.web.builder.HandlerType;

public class HandlerData
implements Cloneable {
    private Class<?> clazz;
    private Method method;
    private HandlerType handlerType;
    private Class<? extends Handler<RoutingContext>> routeHandlerClass;
    private SockJSHandler sockJSHandler;
    private String path = "";
    private int order;
    private boolean pathRegex;
    private String httpMethod;
    private String consumes;
    private String produces;
    private AuthHandler authHandler;

    public String toStringLine() {
        StringBuilder line = new StringBuilder();
        line.append(String.format("[%s.%s]", this.clazz().getSimpleName(), this.method().getName()));
        line.append(String.format("[%s]", new Object[]{this.handlerType}));
        if (StringUtils.isNotEmpty((String)this.httpMethod())) {
            line.append(String.format("[%s] ", this.httpMethod()));
        }
        if (StringUtils.isNotEmpty((String)this.path())) {
            line.append(String.format("[%s] ", this.path()));
        } else {
            line.append(String.format("[%s] ", this.clazz().getSimpleName())).append(String.format("[%s] ", this.method().getName()));
        }
        return line.toString();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Class<?> clazz() {
        return this.clazz;
    }

    public Method method() {
        return this.method;
    }

    public HandlerType handlerType() {
        return this.handlerType;
    }

    public Class<? extends Handler<RoutingContext>> routeHandlerClass() {
        return this.routeHandlerClass;
    }

    public SockJSHandler sockJSHandler() {
        return this.sockJSHandler;
    }

    public String path() {
        return this.path;
    }

    public int order() {
        return this.order;
    }

    public boolean pathRegex() {
        return this.pathRegex;
    }

    public String httpMethod() {
        return this.httpMethod;
    }

    public String consumes() {
        return this.consumes;
    }

    public String produces() {
        return this.produces;
    }

    public AuthHandler authHandler() {
        return this.authHandler;
    }

    public HandlerData clazz(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    public HandlerData method(Method method) {
        this.method = method;
        return this;
    }

    public HandlerData handlerType(HandlerType handlerType) {
        this.handlerType = handlerType;
        return this;
    }

    public HandlerData routeHandlerClass(Class<? extends Handler<RoutingContext>> routeHandlerClass) {
        this.routeHandlerClass = routeHandlerClass;
        return this;
    }

    public HandlerData sockJSHandler(SockJSHandler sockJSHandler) {
        this.sockJSHandler = sockJSHandler;
        return this;
    }

    public HandlerData path(String path) {
        this.path = path;
        return this;
    }

    public HandlerData order(int order) {
        this.order = order;
        return this;
    }

    public HandlerData pathRegex(boolean pathRegex) {
        this.pathRegex = pathRegex;
        return this;
    }

    public HandlerData httpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public HandlerData consumes(String consumes) {
        this.consumes = consumes;
        return this;
    }

    public HandlerData produces(String produces) {
        this.produces = produces;
        return this;
    }

    public HandlerData authHandler(AuthHandler authHandler) {
        this.authHandler = authHandler;
        return this;
    }

    public String toString() {
        return "HandlerData(clazz=" + this.clazz() + ", method=" + this.method() + ", handlerType=" + (Object)((Object)this.handlerType()) + ", routeHandlerClass=" + this.routeHandlerClass() + ", sockJSHandler=" + this.sockJSHandler() + ", path=" + this.path() + ", order=" + this.order() + ", pathRegex=" + this.pathRegex() + ", httpMethod=" + this.httpMethod() + ", consumes=" + this.consumes() + ", produces=" + this.produces() + ", authHandler=" + this.authHandler() + ")";
    }

    public HandlerData() {
    }

    @ConstructorProperties(value={"clazz", "method", "handlerType", "routeHandlerClass", "sockJSHandler", "path", "order", "pathRegex", "httpMethod", "consumes", "produces", "authHandler"})
    public HandlerData(Class<?> clazz, Method method, HandlerType handlerType, Class<? extends Handler<RoutingContext>> routeHandlerClass, SockJSHandler sockJSHandler, String path, int order, boolean pathRegex, String httpMethod, String consumes, String produces, AuthHandler authHandler) {
        this.clazz = clazz;
        this.method = method;
        this.handlerType = handlerType;
        this.routeHandlerClass = routeHandlerClass;
        this.sockJSHandler = sockJSHandler;
        this.path = path;
        this.order = order;
        this.pathRegex = pathRegex;
        this.httpMethod = httpMethod;
        this.consumes = consumes;
        this.produces = produces;
        this.authHandler = authHandler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HandlerData)) {
            return false;
        }
        HandlerData other = (HandlerData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<?> this$clazz = this.clazz();
        Class<?> other$clazz = other.clazz();
        if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
            return false;
        }
        Method this$method = this.method();
        Method other$method = other.method();
        if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
            return false;
        }
        HandlerType this$handlerType = this.handlerType();
        HandlerType other$handlerType = other.handlerType();
        if (this$handlerType == null ? other$handlerType != null : !((Object)((Object)this$handlerType)).equals((Object)other$handlerType)) {
            return false;
        }
        Class<? extends Handler<RoutingContext>> this$routeHandlerClass = this.routeHandlerClass();
        Class<? extends Handler<RoutingContext>> other$routeHandlerClass = other.routeHandlerClass();
        if (this$routeHandlerClass == null ? other$routeHandlerClass != null : !this$routeHandlerClass.equals(other$routeHandlerClass)) {
            return false;
        }
        SockJSHandler this$sockJSHandler = this.sockJSHandler();
        SockJSHandler other$sockJSHandler = other.sockJSHandler();
        if (this$sockJSHandler == null ? other$sockJSHandler != null : !this$sockJSHandler.equals(other$sockJSHandler)) {
            return false;
        }
        String this$path = this.path();
        String other$path = other.path();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        if (this.order() != other.order()) {
            return false;
        }
        if (this.pathRegex() != other.pathRegex()) {
            return false;
        }
        String this$httpMethod = this.httpMethod();
        String other$httpMethod = other.httpMethod();
        if (this$httpMethod == null ? other$httpMethod != null : !this$httpMethod.equals(other$httpMethod)) {
            return false;
        }
        String this$consumes = this.consumes();
        String other$consumes = other.consumes();
        if (this$consumes == null ? other$consumes != null : !this$consumes.equals(other$consumes)) {
            return false;
        }
        String this$produces = this.produces();
        String other$produces = other.produces();
        if (this$produces == null ? other$produces != null : !this$produces.equals(other$produces)) {
            return false;
        }
        AuthHandler this$authHandler = this.authHandler();
        AuthHandler other$authHandler = other.authHandler();
        return !(this$authHandler == null ? other$authHandler != null : !this$authHandler.equals(other$authHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HandlerData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $clazz = this.clazz();
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        Method $method = this.method();
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        HandlerType $handlerType = this.handlerType();
        result = result * 59 + ($handlerType == null ? 43 : ((Object)((Object)$handlerType)).hashCode());
        Class<? extends Handler<RoutingContext>> $routeHandlerClass = this.routeHandlerClass();
        result = result * 59 + ($routeHandlerClass == null ? 43 : $routeHandlerClass.hashCode());
        SockJSHandler $sockJSHandler = this.sockJSHandler();
        result = result * 59 + ($sockJSHandler == null ? 43 : $sockJSHandler.hashCode());
        String $path = this.path();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        result = result * 59 + this.order();
        result = result * 59 + (this.pathRegex() ? 79 : 97);
        String $httpMethod = this.httpMethod();
        result = result * 59 + ($httpMethod == null ? 43 : $httpMethod.hashCode());
        String $consumes = this.consumes();
        result = result * 59 + ($consumes == null ? 43 : $consumes.hashCode());
        String $produces = this.produces();
        result = result * 59 + ($produces == null ? 43 : $produces.hashCode());
        AuthHandler $authHandler = this.authHandler();
        result = result * 59 + ($authHandler == null ? 43 : $authHandler.hashCode());
        return result;
    }
}

