/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.web.builder;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import org.apache.commons.lang.StringUtils;
import org.jspare.vertx.web.builder.HandlerData;
import org.jspare.vertx.web.builder.HandlerType;
import org.jspare.vertx.web.handler.DefaultSockJSHandler;

public final class HandlerWrapper {
    public static void prepareHandler(Router router, HandlerData handlerData) {
        HandlerWrapper.setHandler(router, handlerData);
    }

    protected static Route createRoute(Router router, HandlerData data) {
        Route route = router.route();
        HandlerWrapper.setOrder(data, route);
        if (StringUtils.isNotEmpty((String)data.httpMethod())) {
            HandlerWrapper.setMethod(data, route);
        }
        if (StringUtils.isNotEmpty((String)data.path())) {
            HandlerWrapper.setPath(data, route);
        }
        if (StringUtils.isNotEmpty((String)data.consumes())) {
            HandlerWrapper.setConsumes(data, route);
        }
        if (StringUtils.isNotEmpty((String)data.produces())) {
            HandlerWrapper.setProduces(data, route);
        }
        return route;
    }

    private static void setOrder(HandlerData data, Route route) {
        if (Integer.MIN_VALUE != data.order()) {
            route.order(data.order());
        }
    }

    protected static void setConsumes(HandlerData data, Route route) {
        route.consumes(data.consumes());
    }

    protected static void setHandler(Router router, HandlerData data) {
        if (data.authHandler() != null) {
            Route authRoute = HandlerWrapper.createRoute(router, data);
            authRoute.handler((Handler)data.authHandler());
        }
        Route hdRegRoute = HandlerWrapper.createRoute(router, data);
        Route route = HandlerWrapper.createRoute(router, data);
        hdRegRoute.order(Integer.MIN_VALUE).handler(ctx -> {
            ctx.put("__HANDLER_DATA_CTX", (Object)data);
            ctx.next();
        });
        if (HandlerType.HANDLER.equals((Object)data.handlerType())) {
            route.handler(HandlerWrapper.prepareHandler(data));
        } else if (HandlerType.FAILURE_HANDLER.equals((Object)data.handlerType())) {
            route.failureHandler(HandlerWrapper.prepareHandler(data));
        } else if (HandlerType.BLOCKING_HANDLER.equals((Object)data.handlerType())) {
            route.blockingHandler(HandlerWrapper.prepareHandler(data), false);
        } else if (HandlerType.SOCKETJS_HANDLER.equals((Object)data.handlerType())) {
            route.handler(HandlerWrapper.prepareSockJsHandler(data));
        }
    }

    protected static void setMethod(HandlerData data, Route route) {
        route.method(HttpMethod.valueOf((String)data.httpMethod()));
    }

    protected static void setPath(HandlerData data, Route route) {
        if (data.pathRegex()) {
            route.pathRegex(data.path());
        } else {
            route.path(data.path());
        }
    }

    protected static void setProduces(HandlerData data, Route route) {
        route.produces(data.produces());
    }

    private static Handler<RoutingContext> prepareHandler(HandlerData handlerData) {
        return handlerData.routeHandlerClass().getConstructor(HandlerData.class).newInstance(handlerData);
    }

    private static Handler<RoutingContext> prepareSockJsHandler(HandlerData handlerData) {
        return handlerData.sockJSHandler().socketHandler(e -> DefaultSockJSHandler.socketHandler(handlerData, e));
    }

    private HandlerWrapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

