/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.web.module;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jspare.core.Environment;
import org.jspare.vertx.AbstractModule;
import org.jspare.vertx.Modularized;
import org.jspare.vertx.web.annotation.module.BuilderAware;
import org.jspare.vertx.web.annotation.module.HandlerAware;
import org.jspare.vertx.web.annotation.module.ListenHandler;
import org.jspare.vertx.web.annotation.module.RouterBuilderAware;
import org.jspare.vertx.web.annotation.module.Routes;
import org.jspare.vertx.web.builder.HttpServerBuilder;
import org.jspare.vertx.web.builder.RouterBuilder;
import org.jspare.vertx.web.module.AnnotationHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(HttpServerModule.class);

    public Future<Void> init(Modularized instance, JsonObject config) {
        Future loadFuture = Future.future();
        Vertx vertx = instance.getVertx();
        HttpServerOptions options = this.getOptions(instance, config);
        Router router = Router.router((Vertx)vertx);
        this.setRouter(instance, router);
        HttpServer server = HttpServerBuilder.create(vertx).httpServerOptions(options).router(router).build();
        Optional<Method> oMethod = Arrays.asList(instance.getClass().getDeclaredMethods()).stream().filter(m -> m.isAnnotationPresent(ListenHandler.class)).findFirst();
        server.listen(ar -> {
            if (ar.failed()) {
                loadFuture.fail(ar.cause());
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("HttpServerModule started at port {}", (Object)((HttpServer)ar.result()).actualPort());
            }
            if (oMethod.isPresent() && ((Method)oMethod.get()).getParameterCount() == 1 && ((Method)oMethod.get()).getParameters()[0].getType().equals(AsyncResult.class)) {
                try {
                    Method method = (Method)oMethod.get();
                    method.setAccessible(true);
                    method.invoke((Object)instance, ar);
                }
                catch (Exception e) {
                    loadFuture.fail((Throwable)e);
                    return;
                }
            }
            loadFuture.complete();
        });
        return loadFuture;
    }

    private HttpServerOptions getOptions(Modularized modularized, JsonObject config) {
        Optional<Method> oMethod = Arrays.asList(modularized.getClass().getDeclaredMethods()).stream().filter(m -> HttpServerOptions.class.equals(m.getReturnType())).findFirst();
        if (oMethod.isPresent() && oMethod.get().getParameterCount() == 0) {
            Method method = oMethod.get();
            method.setAccessible(true);
            return (HttpServerOptions)method.invoke((Object)modularized, new Object[0]);
        }
        return new HttpServerOptions(config);
    }

    private void setRouter(Modularized modularized, Router router) {
        RouterBuilder builder = RouterBuilder.create(modularized.getVertx(), router);
        this.getHandlerAwareAnnotations(modularized).forEach(a -> this.setHandlerAnnotation(modularized, builder, a));
        this.buildMethodAware(modularized, builder);
        this.buildAuthHandler(modularized, builder);
        this.builderAnnAware(modularized, builder);
        builder.build();
    }

    private void buildMethodAware(Modularized modularized, RouterBuilder builder) throws InvocationTargetException, IllegalAccessException {
        Optional<Method> oMethod = Arrays.asList(modularized.getClass().getDeclaredMethods()).stream().filter(m -> m.isAnnotationPresent(RouterBuilderAware.class)).findFirst();
        if (oMethod.isPresent() && oMethod.get().getParameterCount() == 1 && oMethod.get().getParameters()[0].getType().equals(RouterBuilder.class)) {
            Method method = oMethod.get();
            method.setAccessible(true);
            method.invoke((Object)modularized, new Object[]{builder});
        }
        if (modularized.getClass().isAnnotationPresent(Routes.class)) {
            Routes routes = modularized.getClass().getAnnotation(Routes.class);
            builder.scanClasspath(routes.scanClasspath());
            Arrays.asList(routes.routes()).forEach(builder::addRoute);
            Arrays.asList(routes.skipRoutes()).forEach(builder::skipRoute);
            Arrays.asList(routes.scanPackages()).forEach(builder::addRoutePackage);
        }
    }

    private Stream<Annotation> getHandlerAwareAnnotations(Modularized modularized) {
        Class<?> clazz = modularized.getClass();
        return Arrays.asList(clazz.getAnnotations()).stream().filter(a -> a.annotationType().isAnnotationPresent(HandlerAware.class));
    }

    private <A extends Annotation> void setHandlerAnnotation(Modularized modularized, RouterBuilder builder, A annotation) {
        Class<?> factoryClass = annotation.annotationType().getDeclaredClasses()[0];
        if (factoryClass == null) {
            if (log.isWarnEnabled()) {
                log.warn("AnnotationAware class {} without AnnotationHandlerFactory", (Object)annotation.getClass().getName());
            }
            return;
        }
        AnnotationHandlerFactory factory = (AnnotationHandlerFactory)factoryClass.newInstance();
        Handler<RoutingContext> handler = factory.factory(annotation, modularized);
        builder.addHandler(handler);
        if (log.isDebugEnabled()) {
            log.debug("Handler {} created and registered on RouterBuilder by AnnotationHandlerAware", (Object)handler.getClass().getName());
        }
    }

    private void buildAuthHandler(Modularized instance, RouterBuilder builder) throws IllegalAccessException, InstantiationException {
        if (instance.getClass().isAnnotationPresent(org.jspare.vertx.web.annotation.module.AuthHandler.class)) {
            org.jspare.vertx.web.annotation.module.AuthHandler ann = instance.getClass().getAnnotation(org.jspare.vertx.web.annotation.module.AuthHandler.class);
            Supplier<AuthHandler> supplier = () -> (AuthHandler)Environment.provide(ann.value());
            builder.authHandler(supplier);
        }
    }

    private void builderAnnAware(Modularized instance, RouterBuilder builder) throws IllegalAccessException, InstantiationException {
        if (instance.getClass().isAnnotationPresent(BuilderAware.class)) {
            for (Class<? extends Handler<RouterBuilder>> clazz : instance.getClass().getAnnotation(BuilderAware.class).value()) {
                Handler<RouterBuilder> handler = clazz.newInstance();
                handler.handle((Object)builder);
            }
        }
    }
}

