/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.builder;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jspare.core.annotation.Resource;
import org.jspare.core.container.ContainerUtils;
import org.jspare.vertx.annotation.Consumer;
import org.jspare.vertx.annotation.EventBusController;
import org.jspare.vertx.builder.Collector;
import org.jspare.vertx.builder.EventBusData;

@Resource
public class EventBusCollector
implements Collector<Collection<EventBusData>> {
    private Map<Class<?>, Object> controllers = new HashMap();

    @Override
    public Collection<EventBusData> collect(Class<?> clazz, Object ... args) {
        ArrayList<EventBusData> handlers = new ArrayList<EventBusData>();
        ArrayList methodsCollected = new ArrayList();
        Arrays.asList(clazz.getDeclaredMethods()).forEach(m -> {
            if (m.isAnnotationPresent(Consumer.class)) {
                methodsCollected.add(m);
            }
        });
        if (!methodsCollected.isEmpty()) {
            Object instance = this.getInstance(clazz);
            handlers.addAll(methodsCollected.stream().map(method -> {
                Consumer consumer = method.getAnnotation(Consumer.class);
                return new EventBusData(instance, (Method)method, consumer.value());
            }).collect(Collectors.toList()));
        }
        return handlers;
    }

    private Object getInstance(Class<?> clazz) {
        if (!clazz.isAnnotationPresent(EventBusController.class)) {
            return this.instantiate(clazz);
        }
        EventBusController anEventBusController = clazz.getAnnotation(EventBusController.class);
        Object instance = this.controllers.get(clazz);
        if (instance != null) {
            return instance;
        }
        instance = this.instantiate(clazz);
        if (anEventBusController.retention()) {
            this.controllers.put(clazz, instance);
        }
        return instance;
    }

    private Object instantiate(Class<?> clazz) {
        Object instance = clazz.newInstance();
        ContainerUtils.processInjection(instance);
        return instance;
    }
}

