/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.builder;

import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassAnnotationMatchProcessor;
import io.vertx.core.Vertx;
import io.vertx.serviceproxy.ProxyHelper;
import java.util.HashSet;
import java.util.Set;
import org.jspare.core.container.Environment;
import org.jspare.vertx.annotation.RegisterProxyService;
import org.jspare.vertx.builder.AbstractBuilder;
import org.jspare.vertx.builder.ClasspathScannerUtils;
import org.jspare.vertx.builder.ProxyServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServiceBuilder
extends AbstractBuilder<Void> {
    private static final Logger log = LoggerFactory.getLogger(ProxyServiceBuilder.class);
    private static final int NUMBER_CLASSPATH_SCANNER_THREADS = 3;
    private final Vertx vertx;
    private boolean scanClasspath;
    private Set<Class<?>> classes;
    private Set<String> scanSpecs;

    public static ProxyServiceBuilder create(Vertx vertx) {
        return new ProxyServiceBuilder(vertx);
    }

    private ProxyServiceBuilder(Vertx vertx) {
        this.vertx = vertx;
        this.scanClasspath = false;
        this.classes = new HashSet();
        this.scanSpecs = new HashSet<String>();
    }

    public ProxyServiceBuilder addProxyService(Class<?> clazz) {
        this.classes.add(clazz);
        return this;
    }

    @Override
    public Void build() {
        if (this.scanClasspath) {
            this.scanSpecs.clear();
            this.scanSpecs.add(".*");
        }
        ClassAnnotationMatchProcessor processor = c -> this.classes.add(c);
        this.scanSpecs.forEach(scanSpec -> ClasspathScannerUtils.scanner(scanSpec).matchClassesWithAnnotation(RegisterProxyService.class, processor).scan(3));
        this.classes.forEach(this::registerProxyService);
        return null;
    }

    private <T> void registerProxyService(Class<T> clazz) {
        if (!clazz.isAnnotationPresent(RegisterProxyService.class)) {
            log.warn("Cannot register service {} with ProxyHelper. One possible cause, the class is not annotated bt ProxyHandler annotation.");
            return;
        }
        RegisterProxyService proxyHandler = clazz.getAnnotation(RegisterProxyService.class);
        String address = ProxyServiceUtils.getAddress(proxyHandler, clazz);
        Object service = Environment.my(clazz);
        ProxyHelper.registerService(clazz, (Vertx)this.vertx, (Object)service, (String)address);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProxyServiceBuilder)) {
            return false;
        }
        ProxyServiceBuilder other = (ProxyServiceBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vertx this$vertx = this.vertx;
        Vertx other$vertx = other.vertx;
        if (this$vertx == null ? other$vertx != null : !this$vertx.equals(other$vertx)) {
            return false;
        }
        if (this.scanClasspath() != other.scanClasspath()) {
            return false;
        }
        Set<Class<?>> this$classes = this.classes();
        Set<Class<?>> other$classes = other.classes();
        if (this$classes == null ? other$classes != null : !((Object)this$classes).equals(other$classes)) {
            return false;
        }
        Set<String> this$scanSpecs = this.scanSpecs();
        Set<String> other$scanSpecs = other.scanSpecs();
        return !(this$scanSpecs == null ? other$scanSpecs != null : !((Object)this$scanSpecs).equals(other$scanSpecs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProxyServiceBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vertx $vertx = this.vertx;
        result = result * 59 + ($vertx == null ? 43 : $vertx.hashCode());
        result = result * 59 + (this.scanClasspath() ? 79 : 97);
        Set<Class<?>> $classes = this.classes();
        result = result * 59 + ($classes == null ? 43 : ((Object)$classes).hashCode());
        Set<String> $scanSpecs = this.scanSpecs();
        result = result * 59 + ($scanSpecs == null ? 43 : ((Object)$scanSpecs).hashCode());
        return result;
    }

    public boolean scanClasspath() {
        return this.scanClasspath;
    }

    public ProxyServiceBuilder scanClasspath(boolean scanClasspath) {
        this.scanClasspath = scanClasspath;
        return this;
    }

    public Set<Class<?>> classes() {
        return this.classes;
    }

    public ProxyServiceBuilder classes(Set<Class<?>> classes) {
        this.classes = classes;
        return this;
    }

    public Set<String> scanSpecs() {
        return this.scanSpecs;
    }

    public ProxyServiceBuilder scanSpecs(Set<String> scanSpecs) {
        this.scanSpecs = scanSpecs;
        return this;
    }
}

