/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.experimental;

import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassAnnotationMatchProcessor;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import java.util.Arrays;
import java.util.HashMap;
import org.jspare.core.annotation.Resource;
import org.jspare.vertx.annotation.VertxInject;
import org.jspare.vertx.builder.ClasspathScannerUtils;
import org.jspare.vertx.experimental.AutoConfiguration;
import org.jspare.vertx.experimental.Configurable;
import org.jspare.vertx.experimental.Module;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Resource
public class AutoConfigurationInitializer {
    private static final Logger log = LoggerFactory.getLogger(AutoConfigurationInitializer.class);
    @VertxInject
    private Vertx vertx;

    public void initialize(Verticle verticle) {
        if (verticle == null || verticle.getVertx() == null || !verticle.getClass().isAnnotationPresent(AutoConfiguration.class)) {
            return;
        }
        AutoConfiguration cfg = verticle.getClass().getAnnotation(AutoConfiguration.class);
        HashMap moduleClasses = new HashMap();
        ClassAnnotationMatchProcessor processor = c -> moduleClasses.put(c.getAnnotation(Module.class).value(), c);
        ClasspathScannerUtils.scanner(".*").matchClassesWithAnnotation(Module.class, processor).scan();
        Arrays.asList(cfg.value()).forEach(m -> {
            try {
                Class mclasse = (Class)moduleClasses.get(m.value());
                Configurable mi = (Configurable)mclasse.newInstance();
                if (mi != null) {
                    mi.execute(verticle, m.config());
                }
            }
            catch (Exception e) {
                log.error("Faile init autoconfig", (Throwable)e);
            }
        });
    }
}

