/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.injector;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.file.FileSystem;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.SharedData;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.jspare.core.container.Context;
import org.jspare.core.container.Environment;
import org.jspare.core.container.InjectorStrategy;
import org.jspare.core.container.MySupport;
import org.jspare.core.exception.EnvironmentException;
import org.jspare.core.exception.Errors;
import org.jspare.vertx.annotation.SharedWorkerExecutor;
import org.jspare.vertx.annotation.VertxInject;
import org.jspare.vertx.utils.JsonObjectLoader;

public class VertxInjectStrategy
extends MySupport
implements InjectorStrategy {
    private static final String DEFAULT_WORKER_EXECUTOR_NAME = "defaultWorkerExecutor";
    private static final String VERTX_PATTERN = "vertx:%s";

    public static String formatInstanceKey(String instanceRef) {
        return String.format(VERTX_PATTERN, instanceRef);
    }

    public void inject(Object result, Field field) {
        Vertx vertx = (Vertx)((Context)Environment.my(Context.class)).getAs((Object)"__vertxHolder");
        try {
            VertxInject inject = field.getAnnotation(VertxInject.class);
            Optional<Vertx> oVertx = Optional.ofNullable(vertx);
            if (oVertx.isPresent()) {
                vertx = oVertx.get();
            } else {
                VertxOptions options = null;
                options = StringUtils.isNotEmpty((String)inject.vertxOptions()) ? ((JsonObjectLoader)Environment.my(JsonObjectLoader.class)).loadOptions(inject.vertxOptions(), VertxOptions.class) : new VertxOptions();
                vertx = Vertx.vertx((VertxOptions)options);
            }
            this.setField(result, field, vertx);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new EnvironmentException(Errors.INVALID_INJECTION.throwable((Throwable)e));
        }
    }

    protected void setField(Object result, Field field, Vertx vertx) throws IllegalArgumentException, IllegalAccessException {
        field.setAccessible(true);
        if (Vertx.class.equals(field.getType())) {
            field.set(result, vertx);
        } else if (io.vertx.core.Context.class.equals(field.getType())) {
            field.set(result, vertx.getOrCreateContext());
        } else if (JsonObject.class.equals(field.getType())) {
            field.set(result, vertx.getOrCreateContext().config());
        } else if (EventBus.class.equals(field.getType())) {
            field.set(result, vertx.eventBus());
        } else if (WorkerExecutor.class.equals(field.getType())) {
            if (field.isAnnotationPresent(SharedWorkerExecutor.class)) {
                SharedWorkerExecutor annWe = field.getAnnotation(SharedWorkerExecutor.class);
                field.set(result, vertx.createSharedWorkerExecutor(annWe.name(), annWe.poolSize(), annWe.maxExecuteTime()));
            } else {
                field.set(result, vertx.createSharedWorkerExecutor(DEFAULT_WORKER_EXECUTOR_NAME));
            }
        } else if (FileSystem.class.equals(field.getType())) {
            field.set(result, vertx.fileSystem());
        } else if (SharedData.class.equals(field.getType())) {
            field.set(result, vertx.sharedData());
        }
    }

    public Class<? extends Annotation> annotationType() {
        return VertxInject.class;
    }
}

