/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.injector;

import io.vertx.core.Vertx;
import io.vertx.serviceproxy.ProxyHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.jspare.core.container.InjectorStrategy;
import org.jspare.core.container.MySupport;
import org.jspare.vertx.annotation.VertxInject;
import org.jspare.vertx.annotation.VertxProxyInject;
import org.jspare.vertx.builder.ProxyServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxProxyInjectStrategy
extends MySupport
implements InjectorStrategy {
    private static final Logger log = LoggerFactory.getLogger(VertxProxyInjectStrategy.class);
    @VertxInject
    private Vertx vertx;

    public void inject(Object obj, Field field) {
        try {
            VertxProxyInject proxyHandler = field.getAnnotation(VertxProxyInject.class);
            String address = ProxyServiceUtils.getAddress(proxyHandler, field.getType());
            Object value = ProxyHelper.createProxy(field.getType(), (Vertx)this.vertx, (String)address);
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | IllegalStateException e) {
            log.error("Cannot create proxy to {}", (Object)field.getName(), (Object)e);
        }
    }

    public Class<? extends Annotation> annotationType() {
        return VertxProxyInject.class;
    }
}

