/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import org.jspare.core.MySupport;
import org.jspare.core.internal.Bind;
import org.jspare.vertx.Modularized;
import org.jspare.vertx.Module;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModule
extends MySupport
implements Module {
    private static final Logger log = LoggerFactory.getLogger(AbstractModule.class);
    @Inject
    private Vertx vertx;
    private Modularized instance;
    private JsonObject config;

    @Override
    public Future<Void> init(Modularized instance, JsonObject config) {
        Future future;
        block2: {
            this.instance = instance;
            this.config = config;
            future = Future.future();
            try {
                this.loadAsync((Future<Void>)future);
            }
            catch (Throwable t) {
                log.error("Failed to load module [{}] - {}", new Object[]{this.getInstance().getClass().getName(), t.getMessage(), t});
                log.trace(t.getMessage(), t);
                if (future.isComplete()) break block2;
                future.fail(t);
            }
        }
        return future;
    }

    protected void loadAsync(Future<Void> future) {
        this.load();
        future.complete();
    }

    protected void load() {
    }

    protected <T> Bind<T> bind(Class<T> clazz) {
        return Bind.bind(clazz);
    }

    protected void bindConstant(String name, String value) {
        this.bind(String.class).name(name).registry((Object)value);
    }

    @Deprecated
    protected <T> void hookIfPresent(Class<T> ann, Handler<T> execute) {
        if (this.instance.getClass().isAnnotationPresent(ann)) {
            Class<T> annClass = ann;
            T instance = this.getClass().getAnnotation(annClass);
            execute.handle(instance);
        }
    }

    protected <T> void doHookIfPresent(Class<T> ann, BiConsumer<AnnotatedElement, T> execute) {
        Class<T> annClass = ann;
        Target target = annClass.getAnnotation(Target.class);
        if (this.isCheckType(target, ElementType.TYPE)) {
            this.executeHookType(annClass, execute);
        }
        if (this.isCheckType(target, ElementType.METHOD)) {
            this.executeHookMethods(annClass, execute);
        }
    }

    protected <T> void doHookIfPresent(Class<T> ann, Handler<T> execute) {
        Class<T> annClass = ann;
        Target target = annClass.getAnnotation(Target.class);
        if (this.isCheckType(target, ElementType.TYPE)) {
            this.executeHookType(annClass, (a, t) -> execute.handle(t));
        }
        if (this.isCheckType(target, ElementType.METHOD)) {
            this.executeHookMethods(annClass, (a, t) -> execute.handle(t));
        }
    }

    protected boolean hasAnnotationInType(AnnotatedElement annElement, Class<? extends Annotation> annClass) {
        return annElement.isAnnotationPresent(annClass);
    }

    private boolean isCheckType(Target target, ElementType type) {
        return target != null ? Arrays.asList(target.value()).contains((Object)type) : false;
    }

    private <T> void executeHookMethods(Class<? extends Annotation> annClass, BiConsumer<AnnotatedElement, T> biConsumer) {
        Arrays.stream(this.instance.getClass().getDeclaredMethods()).forEach(m -> {
            if (this.hasAnnotationInType((AnnotatedElement)m, annClass)) {
                Object instance = m.getAnnotation(annClass);
                biConsumer.accept((AnnotatedElement)m, instance);
            }
        });
    }

    private <T> void executeHookType(Class<? extends Annotation> annClass, BiConsumer<AnnotatedElement, T> biConsumer) {
        if (this.hasAnnotationInType(this.instance.getClass(), annClass)) {
            Annotation result = this.instance.getClass().getAnnotation(annClass);
            biConsumer.accept(this.getClass(), (Class<?>)((Object)result));
        }
    }

    @Override
    public Vertx getVertx() {
        return this.vertx;
    }

    public Modularized getInstance() {
        return this.instance;
    }

    @Override
    public JsonObject getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(JsonObject config) {
        this.config = config;
    }
}

