/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx;

import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataObjectConverter {
    private static final Logger log = LoggerFactory.getLogger(DataObjectConverter.class);

    public static JsonObject toJson(Object obj, JsonObject json) {
        json = json.mergeIn(DataObjectConverter.toJson(obj));
        return json;
    }

    public static JsonObject toJson(Object obj) {
        return new JsonObject(Json.encode((Object)obj));
    }

    public static <T> T fromJson(JsonObject json, T obj) {
        BeanUtils.copyProperties(obj, (Object)Json.decodeValue((String)json.encode(), obj.getClass()));
        return obj;
    }

    public static <T> T fromJson(JsonObject json, Class<T> clazz) {
        String encode = json.encode();
        return (T)Json.decodeValue((String)encode, clazz);
    }

    private DataObjectConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

