/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.builder;

import io.github.lukehutch.fastclasspathscanner.matchprocessor.MethodAnnotationMatchProcessor;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import java.util.ArrayList;
import java.util.List;
import org.jspare.core.Environment;
import org.jspare.vertx.annotation.Consumer;
import org.jspare.vertx.builder.AbstractBuilder;
import org.jspare.vertx.builder.EventBusCollector;
import org.jspare.vertx.utils.ClasspathScannerUtils;

public class EventBusBuilder
extends AbstractBuilder<Void> {
    private static final int NUMBER_CLASSPATH_SCANNER_THREADS = 3;
    private final Vertx vertx;
    private boolean scanClasspath;
    private List<Class<?>> classes;
    private List<String> scanSpecs;

    private EventBusBuilder(Vertx vertx) {
        this.vertx = vertx;
        this.scanClasspath = false;
        this.classes = new ArrayList();
        this.scanSpecs = new ArrayList<String>();
    }

    public static EventBusBuilder create(Vertx vertx) {
        return new EventBusBuilder(vertx);
    }

    @Override
    public Void build() {
        if (this.scanClasspath) {
            this.scanSpecs.clear();
            this.scanSpecs.add(".*");
        }
        MethodAnnotationMatchProcessor processor = (c, m) -> this.classes.add(c);
        this.scanSpecs.forEach(scanSpec -> ClasspathScannerUtils.scanner(scanSpec).matchClassesWithMethodAnnotation(Consumer.class, processor).scan(3));
        ArrayList consumers = new ArrayList();
        this.classes.forEach(c -> consumers.addAll(((EventBusCollector)Environment.my(EventBusCollector.class)).collect((Class)c, new Object[0])));
        EventBus eventBus = this.vertx.eventBus();
        consumers.forEach(md -> eventBus.consumer(md.name(), md.wrap()));
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventBusBuilder)) {
            return false;
        }
        EventBusBuilder other = (EventBusBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vertx this$vertx = this.vertx();
        Vertx other$vertx = other.vertx();
        if (this$vertx == null ? other$vertx != null : !this$vertx.equals(other$vertx)) {
            return false;
        }
        if (this.scanClasspath() != other.scanClasspath()) {
            return false;
        }
        List<Class<?>> this$classes = this.classes();
        List<Class<?>> other$classes = other.classes();
        if (this$classes == null ? other$classes != null : !((Object)this$classes).equals(other$classes)) {
            return false;
        }
        List<String> this$scanSpecs = this.scanSpecs();
        List<String> other$scanSpecs = other.scanSpecs();
        return !(this$scanSpecs == null ? other$scanSpecs != null : !((Object)this$scanSpecs).equals(other$scanSpecs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventBusBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vertx $vertx = this.vertx();
        result = result * 59 + ($vertx == null ? 43 : $vertx.hashCode());
        result = result * 59 + (this.scanClasspath() ? 79 : 97);
        List<Class<?>> $classes = this.classes();
        result = result * 59 + ($classes == null ? 43 : ((Object)$classes).hashCode());
        List<String> $scanSpecs = this.scanSpecs();
        result = result * 59 + ($scanSpecs == null ? 43 : ((Object)$scanSpecs).hashCode());
        return result;
    }

    public Vertx vertx() {
        return this.vertx;
    }

    public boolean scanClasspath() {
        return this.scanClasspath;
    }

    public EventBusBuilder scanClasspath(boolean scanClasspath) {
        this.scanClasspath = scanClasspath;
        return this;
    }

    public List<Class<?>> classes() {
        return this.classes;
    }

    public EventBusBuilder classes(List<Class<?>> classes) {
        this.classes = classes;
        return this;
    }

    public List<String> scanSpecs() {
        return this.scanSpecs;
    }

    public EventBusBuilder scanSpecs(List<String> scanSpecs) {
        this.scanSpecs = scanSpecs;
        return this;
    }
}

