/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.builder;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jspare.core.Environment;
import org.jspare.vertx.annotation.Consumer;
import org.jspare.vertx.builder.Collector;
import org.jspare.vertx.builder.EventBusData;

public class EventBusCollector
implements Collector<Collection<EventBusData>> {
    @Override
    public Collection<EventBusData> collect(Class<?> clazz, Object ... args) {
        ArrayList<EventBusData> handlers = new ArrayList<EventBusData>();
        ArrayList methodsCollected = new ArrayList();
        Arrays.asList(clazz.getDeclaredMethods()).forEach(m -> {
            if (m.isAnnotationPresent(Consumer.class)) {
                methodsCollected.add(m);
            }
        });
        if (!methodsCollected.isEmpty()) {
            Object instance = this.getInstance(clazz);
            handlers.addAll(methodsCollected.stream().map(method -> {
                Consumer consumer = method.getAnnotation(Consumer.class);
                return new EventBusData(instance, (Method)method, consumer.value());
            }).collect(Collectors.toList()));
        }
        return handlers;
    }

    private Object getInstance(Class<?> clazz) {
        return Environment.my(clazz);
    }
}

