/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.builder;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import java.util.function.Consumer;
import org.jspare.vertx.builder.AbstractBuilder;
import org.jspare.vertx.cdi.EnvironmentLoader;

public class VertxBuilder
extends AbstractBuilder<Future<Vertx>> {
    private String name;
    private Vertx vertx;
    private VertxOptions options;

    private VertxBuilder() {
    }

    public static VertxBuilder create() {
        return new VertxBuilder();
    }

    public static VertxBuilder create(VertxOptions vertxOptions) {
        return new VertxBuilder().options(vertxOptions);
    }

    @Override
    public Future<Vertx> build() {
        Future future = Future.future();
        Consumer<Vertx> runner = vertx -> {
            this.vertx = vertx;
            future.complete(vertx);
        };
        if (this.vertx != null) {
            runner.accept(this.vertx);
        } else {
            this.createVertx(runner);
        }
        EnvironmentLoader.bindInterfaces((Vertx)this.vertx);
        return future;
    }

    protected void createVertx(Consumer<Vertx> runner) {
        if (this.options == null) {
            this.options = new VertxOptions();
        }
        if (this.options.isClustered()) {
            Vertx.clusteredVertx((VertxOptions)this.options, res -> {
                if (res.succeeded()) {
                    Vertx vertx = (Vertx)res.result();
                    runner.accept(vertx);
                } else {
                    res.cause().printStackTrace();
                }
            });
        } else {
            runner.accept(Vertx.vertx((VertxOptions)this.options));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VertxBuilder)) {
            return false;
        }
        VertxBuilder other = (VertxBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name();
        String other$name = other.name();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Vertx this$vertx = this.vertx();
        Vertx other$vertx = other.vertx();
        if (this$vertx == null ? other$vertx != null : !this$vertx.equals(other$vertx)) {
            return false;
        }
        VertxOptions this$options = this.options();
        VertxOptions other$options = other.options();
        return !(this$options == null ? other$options != null : !this$options.equals(other$options));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VertxBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Vertx $vertx = this.vertx();
        result = result * 59 + ($vertx == null ? 43 : $vertx.hashCode());
        VertxOptions $options = this.options();
        result = result * 59 + ($options == null ? 43 : $options.hashCode());
        return result;
    }

    public String name() {
        return this.name;
    }

    public VertxBuilder name(String name) {
        this.name = name;
        return this;
    }

    public Vertx vertx() {
        return this.vertx;
    }

    public VertxBuilder vertx(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    public VertxOptions options() {
        return this.options;
    }

    public VertxBuilder options(VertxOptions options) {
        this.options = options;
        return this;
    }
}

