/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.concurrent;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.CompositeFutureImpl;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class FutureSupplier {
    public static <R> Future<List<R>> sequenceFuture(List<Future<R>> futures) {
        return CompositeFutureImpl.all((Future[])futures.toArray(new Future[futures.size()])).map(v -> futures.stream().map(Future::result).collect(Collectors.toList()));
    }

    public static <T> Future<T> supply(Supplier<T> event) {
        Future future = Future.future();
        try {
            future.complete(event.get());
        }
        catch (Throwable e) {
            future.fail(e);
        }
        return future;
    }

    public static <T> Future<T> supply(Handler<Void> event) {
        Future future = Future.future();
        try {
            event.handle(null);
            future.complete();
        }
        catch (Throwable e) {
            future.fail(e);
        }
        return future;
    }

    private FutureSupplier() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

