/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.concurrent;

import io.vertx.core.Future;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class ReduceFuture {
    private final List<Supplier<Future>> elements;
    private AtomicInteger count;
    private Future<Void> future;

    public ReduceFuture(List<Supplier<Future>> elements) {
        this.elements = elements;
        this.init();
    }

    public static ReduceFuture create(List<Supplier<Future>> futures) {
        return new ReduceFuture(futures);
    }

    private void init() {
        this.future = Future.future();
        this.count = new AtomicInteger(0);
    }

    public Future<Void> reduce() {
        this.perform();
        return this.future;
    }

    private void perform() {
        if (this.future.isComplete()) {
            return;
        }
        Future el = this.elements.get(this.count.get()).get();
        el.setHandler(ar -> {
            if (ar.succeeded()) {
                if (this.count.incrementAndGet() == this.elements.size()) {
                    this.future.complete();
                } else {
                    this.perform();
                }
            } else {
                this.future.fail(ar.cause());
            }
        });
    }
}

