/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.internal;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.jspare.core.Environment;
import org.jspare.core.MySupport;
import org.jspare.vertx.Modularized;
import org.jspare.vertx.Module;
import org.jspare.vertx.annotation.Modules;
import org.jspare.vertx.annotation.PrintConfig;
import org.jspare.vertx.concurrent.ReduceFuture;
import org.jspare.vertx.internal.InitilizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleInitializer
extends MySupport {
    private static final Logger log = LoggerFactory.getLogger(ModuleInitializer.class);
    private List<Class<? extends Module>> loadedModules = new ArrayList<Class<? extends Module>>();
    @Inject
    private Vertx vertx;

    public Future<Void> initialize(Modularized modularized) {
        if (log.isDebugEnabled()) {
            log.debug("Initialize Auto Configuration for {}", (Object)modularized.getClass().getName());
        }
        Future initFuture = Future.future();
        if (modularized == null || !modularized.getClass().isAnnotationPresent(Modules.class)) {
            initFuture.complete();
            return initFuture;
        }
        JsonObject config = new JsonObject();
        config.mergeIn(modularized.getConfig());
        if (log.isInfoEnabled() && modularized.getClass().isAnnotationPresent(PrintConfig.class)) {
            log.info("Config: {}", (Object)modularized.getConfig());
        }
        ArrayList<Supplier<Future>> futures = new ArrayList<Supplier<Future>>();
        try {
            this.lookupModules(futures, modularized);
        }
        catch (Throwable e) {
            return Future.failedFuture((Throwable)e);
        }
        ReduceFuture.create(futures).reduce().setHandler(ar -> {
            if (ar.succeeded()) {
                initFuture.complete();
            } else {
                initFuture.fail(ar.cause());
            }
        });
        return initFuture;
    }

    private void lookupModules(List<Supplier<Future>> futures, Modularized modularized) throws InitilizationException {
        if (!modularized.getClass().isAnnotationPresent(Modules.class)) {
            return;
        }
        Modules modules = modularized.getClass().getAnnotation(Modules.class);
        JsonObject config = modularized.getConfig();
        Arrays.asList(modules.value()).forEach(m -> {
            Class<? extends Module> mClazz = m.value();
            try {
                if (this.hasLoaded(mClazz) && m.persistent()) {
                    futures.add(() -> Future.succeededFuture());
                    return;
                }
                if (m.persistent()) {
                    this.loadedModules.add(mClazz);
                }
                Module mi = (Module)Environment.provide(mClazz);
                mi.setConfig(config);
                Module module = mi;
                synchronized (module) {
                    this.lookupModules(futures, mi);
                    if (mi != null) {
                        futures.add(() -> this.initModule(modularized, config, mClazz, mi));
                    }
                }
            }
            catch (Exception e) {
                log.error("Failed to load {}", (Object)m.value().getName(), (Object)e);
            }
        });
    }

    private boolean hasLoaded(Class<? extends Module> mName) {
        return this.loadedModules.contains(mName);
    }

    private boolean moduleHasDependencies(Module module) {
        return module.getClass().isAnnotationPresent(Modules.class);
    }

    private boolean allDependenciesHasLoaded(Module module) {
        return this.getDependenciesDisjunction(module).isEmpty();
    }

    private Collection<Class<? extends Module>> getDependenciesDisjunction(Module module) {
        Modules dependencies = module.getClass().getAnnotation(Modules.class);
        return CollectionUtils.disjunction(Arrays.asList(dependencies.value()), this.loadedModules);
    }

    private Future initModule(Modularized modularized, JsonObject config, Class<? extends Module> mClazz, Module mi) {
        if (log.isDebugEnabled()) {
            log.debug("Init Module: {}", (Object)mi.getClass().getName());
        }
        Environment.inject((Object)modularized);
        Environment.inject((Object)mi);
        return mi.init(modularized, config);
    }
}

