/*
 * Decompiled with CFR 0.152.
 */
package org.jspare.vertx.utils;

import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class JsonObjectLoader {
    private static final String CONVERTER_PATTERN = "%sConverter";
    private Charset defaultCharset = StandardCharsets.UTF_8;
    private String defaultRootPath = "vertx";

    public JsonObject loadOptions(String filename) {
        return this.loadOptions(this.defaultRootPath, filename);
    }

    public <T> T loadOptions(String filename, Class<T> optionClazz) {
        return this.loadOptions(this.defaultRootPath, filename, optionClazz);
    }

    public JsonObject loadOptions(String defaultRootPath, String filename) {
        String json = null;
        Path path = Paths.get(defaultRootPath, filename);
        File file = path.toFile();
        json = file.exists() ? FileUtils.readFileToString((File)path.toFile(), (Charset)this.defaultCharset) : IOUtils.toString((InputStream)this.getClass().getResourceAsStream(String.format("/%s", path.toString())), (Charset)this.getDefaultCharset());
        return new JsonObject(json);
    }

    public <T> T loadOptions(String defaultRootPath, String filename, Class<T> optionClazz) {
        String optionClassName = String.format(CONVERTER_PATTERN, optionClazz.getName());
        Method method = Class.forName(optionClassName).getDeclaredMethod("fromJson", JsonObject.class, optionClazz);
        T instance = optionClazz.newInstance();
        method.invoke(null, this.loadOptions(defaultRootPath, filename), instance);
        return instance;
    }

    public void setDefaultCharset(Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setDefaultRootPath(String defaultRootPath) {
        this.defaultRootPath = defaultRootPath;
    }

    public String getDefaultRootPath() {
        return this.defaultRootPath;
    }
}

