/*
 * Decompiled with CFR 0.152.
 */
package org.jspringbot.keyword.config;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jspringbot.keyword.config.ConfigDomainObject;
import org.jspringbot.keyword.expression.ELUtils;
import org.jspringbot.keyword.expression.ExpressionHelper;
import org.jspringbot.spring.ApplicationContextHolder;
import org.jspringbot.syntax.HighlightRobotLogger;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceEditor;

public class ConfigHelper {
    private static final Logger LOGGER = Logger.getLogger(ConfigHelper.class);
    public static final HighlightRobotLogger LOG = HighlightRobotLogger.getLogger(ConfigHelper.class);
    private Map<String, Properties> domainProperties = new HashMap<String, Properties>();
    private String selectedDomain;

    public boolean hasDomain(String domain) {
        return this.domainProperties.containsKey(domain);
    }

    public String getSelectedDomain() {
        return this.selectedDomain;
    }

    private void addProperties(String domain, File file) throws IOException {
        String filename = file.getName();
        Properties properties = new Properties();
        if (StringUtils.endsWith((String)filename, (String)".properties")) {
            properties.load(new FileReader(file));
        } else if (StringUtils.endsWith((String)filename, (String)".xml")) {
            properties.loadFromXML(new FileInputStream(file));
        }
        this.domainProperties.put(domain, properties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws IOException {
        ResourceEditor editor = new ResourceEditor();
        editor.setAsText("classpath:config/");
        Resource configDirResource = (Resource)editor.getValue();
        boolean hasConfigDirectory = true;
        boolean hasConfigProperties = true;
        if (configDirResource != null) {
            try {
                File configDir = configDirResource.getFile();
                if (configDir.isDirectory()) {
                    File[] propertiesFiles;
                    for (File propFile : propertiesFiles = configDir.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            return StringUtils.endsWith((String)file.getName(), (String)".properties") || StringUtils.endsWith((String)file.getName(), (String)".xml");
                        }
                    })) {
                        String filename = propFile.getName();
                        String name = StringUtils.substring((String)filename, (int)0, (int)StringUtils.indexOf((String)filename, (String)"."));
                        this.addProperties(name, propFile);
                    }
                }
            }
            catch (IOException e) {
                hasConfigDirectory = false;
            }
        }
        editor.setAsText("classpath:config.properties");
        Resource configPropertiesResource = (Resource)editor.getValue();
        if (configPropertiesResource != null) {
            try {
                File configPropertiesFile = configPropertiesResource.getFile();
                if (configPropertiesFile.isFile()) {
                    Properties configs = new Properties();
                    configs.load(new FileReader(configPropertiesFile));
                    for (Map.Entry<Object, Object> entry : configs.entrySet()) {
                        String name = (String)entry.getKey();
                        editor.setAsText(String.valueOf(entry.getValue()));
                        try {
                            Resource resource = (Resource)editor.getValue();
                            this.addProperties(name, resource.getFile());
                        }
                        catch (Exception e) {
                            throw new IOException(String.format("Unable to load config '%s'.", name), e);
                        }
                    }
                }
            }
            catch (IOException e) {
                hasConfigProperties = false;
            }
        }
        if (!hasConfigDirectory && !hasConfigProperties) {
            LOGGER.warn((Object)"No configuration found.");
        }
    }

    public void selectDomain(String selectedDomain) {
        LOG.keywordAppender().appendProperty("Selected Domain", (Object)selectedDomain);
        if (!this.domainProperties.containsKey(selectedDomain)) {
            throw new IllegalArgumentException(String.format("Unsupported selected domain '%s'", selectedDomain));
        }
        this.selectedDomain = selectedDomain;
    }

    ConfigDomainObject createDomainObjectInternal() {
        return this.createDomainObjectInternal(this.selectedDomain);
    }

    ConfigDomainObject createDomainObjectInternal(String selectedDomain) {
        if (!this.domainProperties.containsKey(selectedDomain)) {
            throw new IllegalArgumentException(String.format("Unsupported selected domain '%s'", selectedDomain));
        }
        return new ConfigDomainObject(selectedDomain, this.domainProperties.get(selectedDomain));
    }

    public ConfigDomainObject createDomainObject(String selectedDomain) {
        LOG.keywordAppender().appendProperty("Domain", (Object)selectedDomain);
        return this.createDomainObjectInternal(selectedDomain);
    }

    public Boolean getBooleanProperty(String key) {
        Boolean value = Boolean.valueOf(this.getProperty(key));
        LOG.keywordAppender().appendProperty("Property Boolean Value", (Object)value);
        return value;
    }

    public Long getLongProperty(String key) {
        Long value = Long.valueOf(this.getProperty(key));
        LOG.keywordAppender().appendProperty("Property Long Value", (Object)value);
        return value;
    }

    public Integer getIntegerProperty(String key) {
        Integer value = Integer.valueOf(this.getProperty(key));
        LOG.keywordAppender().appendProperty("Property Integer Value", (Object)value);
        return value;
    }

    public Double getDoubleProperty(String key) {
        Double value = Double.valueOf(this.getProperty(key));
        LOG.keywordAppender().appendProperty("Property Double Value", (Object)value);
        return value;
    }

    public static String evaluate(String value) {
        try {
            ApplicationContextHolder.get().getBean(ExpressionHelper.class);
            return ELUtils.replaceVars((String)value);
        }
        catch (Exception e) {
            LOGGER.warn((Object)e.getMessage(), (Throwable)e);
            return value;
        }
    }

    public String getProperty(String key) {
        LOG.keywordAppender().appendProperty("Current Selected Domain", (Object)this.selectedDomain).appendProperty("Property Key", (Object)key);
        if (this.selectedDomain == null) {
            throw new IllegalStateException("No domain selected");
        }
        Properties properties = this.domainProperties.get(this.selectedDomain);
        if (!properties.containsKey(key)) {
            throw new IllegalArgumentException(String.format("No property found for key '%s'", key));
        }
        LOG.keywordAppender().appendProperty("Property String Value", (Object)properties.getProperty(key));
        return ConfigHelper.evaluate(properties.getProperty(key));
    }
}

