/*
 * Decompiled with CFR 0.152.
 */
package org.jspringbot.keyword.csv;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.jspringbot.keyword.csv.CSVState;
import org.jspringbot.syntax.HighlightRobotLogger;

public class CSVHelper {
    public static final HighlightRobotLogger LOG = HighlightRobotLogger.getLogger(CSVHelper.class);
    private CSVState currentState;
    private Map<String, CSVState> states = new HashMap<String, CSVState>();

    public void parseCSVString(String name, String csv) throws IOException {
        this.currentState = new CSVState(name);
        this.currentState.parseCSVString(csv);
        this.states.put(name, this.currentState);
    }

    public void parseCSVResource(String name, String resource) throws Exception {
        this.currentState = new CSVState(name);
        this.currentState.parseCSVResource(resource);
        this.states.put(name, this.currentState);
    }

    public void appendCSVLine(String csvLine) throws IOException {
        this.currentState.appendCSVLine(csvLine);
    }

    public void parseCSVString(String csv) throws IOException {
        this.parseCSVString(String.valueOf(System.currentTimeMillis()), csv);
    }

    public void parseCSVResource(String resource) throws Exception {
        this.parseCSVResource(String.valueOf(System.currentTimeMillis()), resource);
    }

    public void createAlias(String name) {
        LOG.html("State <b>%s</b> with alias <b>%s</b>", new Object[]{this.currentState.getName(), name});
        this.states.put(name, this.currentState);
        this.currentState = this.states.get(name);
    }

    public void switchState(String name) {
        Validate.isTrue((boolean)this.states.containsKey(name), (String)String.format("CSV state with name '%s' not found.", name));
        LOG.html("Switching to <b>%s</b>", new Object[]{name});
        this.currentState = this.states.get(name);
    }

    public void startDisjunction() {
        this.currentState.startDisjunction();
    }

    public void endDisjunction() {
        this.currentState.endDisjunction();
    }

    public void startConjunction() {
        this.currentState.startConjunction();
    }

    public void endConjunction() {
        this.currentState.endConjunction();
    }

    public List<String[]> getLines() {
        return this.currentState.getLines();
    }

    public void setHeaders(String headers) throws IOException {
        this.currentState.setHeaders(headers);
    }

    public void setFirstLineAsHeader() {
        this.currentState.setFirstLineAsHeader();
    }

    public void createCriteria() {
        this.currentState.createCriteria();
    }

    public void addColumnNameEqualsRestriction(String name, String value) {
        this.currentState.addColumnNameEqualsRestriction(name, value);
    }

    public void addColumnIndexEqualsRestriction(int index, String value) {
        this.currentState.addColumnIndexEqualsRestriction(index, value);
    }

    public int projectCount() {
        return this.currentState.projectCount();
    }

    public void createStateFromList(String name) {
        this.currentState = this.currentState.listAsNewState(name);
        this.states.put(name, this.currentState);
    }

    public List<String[]> list() {
        return this.currentState.list();
    }

    public List<Map<String, String>> map() {
        return this.currentState.map();
    }

    public String[] firstResult() {
        return this.currentState.firstResult();
    }

    public Map<String, String> firstMapResult() {
        return this.currentState.firstMapResult();
    }

    public String[] uniqueResult() {
        return this.currentState.uniqueResult();
    }

    public Map<String, String> uniqueMapResult() {
        return this.currentState.uniqueMapResult();
    }

    public String firstResultColumnIndex(int index) {
        return this.currentState.firstResultColumnIndex(index);
    }

    public String firstResultColumnName(String name) {
        return this.currentState.firstResultColumnName(name);
    }

    public String lastResultColumnIndex(int index) {
        return this.currentState.lastResultColumnIndex(index);
    }

    public String lastResultColumnName(String name) {
        return this.currentState.lastResultColumnName(name);
    }

    public List<String> listColumnName(String name) {
        return this.currentState.listColumnName(name);
    }

    public List<String> listColumnIndex(int index) {
        return this.currentState.listColumnIndex(index);
    }

    public String[] lastResult() {
        return this.currentState.lastResult();
    }

    public String getColumnValue(String[] line, String name) {
        return this.currentState.getColumnValue(line, name);
    }

    public List<String> getColumnValues(int index) {
        return this.currentState.getColumnValues(index);
    }
}

