/*
 * Decompiled with CFR 0.152.
 */
package org.jspringbot.keyword.csv;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.jspringbot.keyword.csv.criteria.CSVLineCriteria;
import org.jspringbot.keyword.csv.criteria.ConjunctionRestriction;
import org.jspringbot.keyword.csv.criteria.DisjunctionRestriction;
import org.jspringbot.keyword.csv.criteria.RestrictionAppender;
import org.jspringbot.keyword.csv.criteria.Restrictions;
import org.jspringbot.keyword.expression.utils.ELFileUtils;
import org.jspringbot.syntax.HighlightRobotLogger;

public class CSVState {
    public static final HighlightRobotLogger LOG = HighlightRobotLogger.getLogger(CSVState.class);
    public static final String OR_DISJUNCTION = "OR";
    public static final String AND_CONJUNCTION = "AND";
    public static int MAX_LOG_LINES = 50;
    private List<String[]> lines;
    private String[] headerRow;
    private Map<String, Integer> headers;
    private String name;
    private CSVLineCriteria currentCriteria;
    private List<String[]> queryResults;
    private Stack<RestrictionAppender> appender;
    private File openedFile;

    public CSVState(String name) {
        this.name = name;
    }

    public CSVState listAsNewState(String name) {
        CSVState newState = new CSVState(name);
        newState.lines = this.list();
        newState.headers = this.headers;
        return newState;
    }

    public String getName() {
        return this.name;
    }

    public void createCriteria() {
        this.appender = new Stack();
        this.currentCriteria = new CSVLineCriteria(this.lines, this.headers);
        this.queryResults = null;
        this.appender.push(this.currentCriteria);
    }

    public void startDisjunction() {
        this.appender.push(Restrictions.disjunction());
    }

    public void startConjunction() {
        this.appender.push(Restrictions.conjunction());
    }

    public void endDisjunction() {
        RestrictionAppender disjunction = this.appender.pop();
        if (!DisjunctionRestriction.class.isInstance(disjunction)) {
            throw new IllegalStateException("Last started was not an or disjunction.");
        }
        this.appender.peek().append((DisjunctionRestriction)disjunction);
    }

    public void endConjunction() {
        RestrictionAppender conjunction = this.appender.pop();
        if (!ConjunctionRestriction.class.isInstance(conjunction)) {
            throw new IllegalStateException("Last started was not an and conjunction.");
        }
        this.appender.peek().append((ConjunctionRestriction)conjunction);
    }

    public void addColumnNameEqualsRestriction(String name, String value) {
        this.appender.peek().append(Restrictions.columnNameEquals(name, value));
        this.queryResults = null;
        LOG.createAppender().append("Add Column Name Equals Restriction:", new Object[0]).appendProperty("Column Name", (Object)name).appendProperty("Column Value Equals", (Object)value).appendProperty("junction", (Object)this.getJunction()).log();
    }

    private String getJunction() {
        if (DisjunctionRestriction.class.isInstance(this.appender.peek())) {
            return OR_DISJUNCTION;
        }
        return AND_CONJUNCTION;
    }

    public void addColumnIndexEqualsRestriction(int index, String value) {
        this.appender.peek().append(Restrictions.columnIndexEquals(index, value));
        LOG.createAppender().append("Add Column Index Equals Restriction:", new Object[0]).appendProperty("Column Index", (Object)index).appendProperty("Column Value Equals", (Object)value).appendProperty("junction", (Object)this.getJunction()).log();
    }

    public int projectCount() {
        int count = this.currentCriteria.count();
        LOG.createAppender().append("Projected Count:", new Object[0]).appendProperty("Count", (Object)count).log();
        return count;
    }

    public List<String[]> list() {
        if (this.currentCriteria == null) {
            throw new IllegalStateException("No csv criteria was created.");
        }
        if (CollectionUtils.isEmpty(this.appender)) {
            throw new IllegalStateException("No restriction appenders found.");
        }
        if (this.appender.size() != 1) {
            throw new IllegalStateException("Junction restriction was not properly ended.");
        }
        if (this.queryResults == null) {
            this.queryResults = this.currentCriteria.list();
        }
        LOG.createAppender().append("CSV List Result:", new Object[0]).appendText(this.toCSV(this.queryResults), new Object[0]).log();
        return this.queryResults;
    }

    public List<Map<String, String>> map() {
        if (this.currentCriteria == null) {
            throw new IllegalStateException("No csv criteria was created.");
        }
        if (CollectionUtils.isEmpty(this.appender)) {
            throw new IllegalStateException("No restriction appenders found.");
        }
        if (this.appender.size() != 1) {
            throw new IllegalStateException("Junction restriction was not properly ended.");
        }
        if (this.queryResults == null) {
            this.queryResults = this.currentCriteria.list();
        }
        LOG.createAppender().append("CSV Map Result:", new Object[0]).appendText(this.toCSV(this.queryResults), new Object[0]).log();
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>(this.queryResults.size());
        for (String[] item : this.queryResults) {
            results.add(this.toMap(item));
        }
        return results;
    }

    public String[] uniqueResult() {
        String[] result = this.currentCriteria.uniqueResult();
        LOG.createAppender().append("Unique Result:", new Object[0]).appendPropertyStringArray("Result", result).log();
        return result;
    }

    public Map<String, String> uniqueMapResult() {
        String[] result = this.currentCriteria.uniqueResult();
        Map<String, String> row = this.toMap(result);
        LOG.createAppender().append("Unique Map Result:", new Object[0]).appendProperty("Result", row).log();
        return row;
    }

    private Map<String, String> toMap(String[] result) {
        if (this.headerRow == null || this.headerRow.length == 0) {
            throw new IllegalStateException("No headers found.");
        }
        CaseInsensitiveMap row = new CaseInsensitiveMap(result.length);
        for (int i = 0; i < this.headerRow.length; ++i) {
            row.put(this.headerRow[i], result[i]);
        }
        return row;
    }

    public String[] firstResult() {
        String[] result = this.currentCriteria.firstResult();
        LOG.createAppender().append("First Result:", new Object[0]).appendPropertyStringArray("Result", result).log();
        return result;
    }

    public Map<String, String> firstMapResult() {
        String[] result = this.currentCriteria.firstResult();
        Map<String, String> row = this.toMap(result);
        LOG.createAppender().append("First Map Result:", new Object[0]).appendProperty("Result", row).log();
        return row;
    }

    public String firstResultColumnIndex(int index) {
        String[] result = this.firstResult();
        String resultStr = result[index];
        LOG.createAppender().append("First Result Column Index:", new Object[0]).appendProperty("Column Index", (Object)index).appendProperty("Column Value", (Object)resultStr).log();
        return resultStr;
    }

    public String firstResultColumnName(String name) {
        Validate.isTrue((boolean)this.headers.containsKey(name), (String)String.format("No header with name '%s'", name));
        String result = this.firstResultColumnIndex(this.headers.get(name));
        LOG.createAppender().append("First Result Column Name:", new Object[0]).appendProperty("Column Name", (Object)name).appendProperty("Column Value", (Object)result).log();
        return result;
    }

    public String lastResultColumnIndex(int index) {
        String[] result = this.lastResult();
        String columnValue = result[index];
        LOG.createAppender().append("Last Result Column Index:", new Object[0]).appendProperty("Column Index", (Object)index).appendProperty("Column Value", (Object)columnValue).log();
        return columnValue;
    }

    public String lastResultColumnName(String name) {
        Validate.isTrue((boolean)this.headers.containsKey(name), (String)String.format("No header with name '%s'", name));
        String columnValue = this.lastResultColumnIndex(this.headers.get(name));
        LOG.createAppender().append("Last Result Column Name:", new Object[0]).appendProperty("Column Name", (Object)name).appendProperty("Column Value", (Object)columnValue).log();
        return columnValue;
    }

    public String getColumnValue(String[] line, String name) {
        return line[this.headers.get(name)];
    }

    public List<String> getColumnValues(int index) {
        List<String[]> results = this.list();
        ArrayList<String> columnList = new ArrayList<String>(results.size());
        for (String[] line : results) {
            columnList.add(line[index]);
        }
        return columnList;
    }

    public List<String> listColumnName(String name) {
        List<String> result = this.listColumnIndex(this.headers.get(name));
        LOG.createAppender().append("List Column Name:", new Object[0]).appendProperty("Column Name", (Object)name).log();
        return result;
    }

    public List<String> listColumnIndex(int index) {
        Validate.isTrue((boolean)this.headers.containsKey(this.name), (String)String.format("No header with name '%s'", this.name));
        List<String[]> results = this.list();
        ArrayList<String> columnList = new ArrayList<String>(results.size());
        for (String[] line : results) {
            columnList.add(line[index]);
        }
        LOG.createAppender().append("List Column Index:", new Object[0]).appendProperty("Column Index", (Object)index).appendPropertyStringArray("Result", columnList.toArray(new String[columnList.size()])).log();
        return columnList;
    }

    public String[] lastResult() {
        return this.currentCriteria.lastResult();
    }

    public void parseCSVString(String csv) throws IOException {
        this.readAll(new StringReader(csv));
        LOG.createAppender().appendBold("Parse CSV String:", new Object[0]).append(" (count=%d)", new Object[]{CollectionUtils.size(this.lines)}).appendText(this.toCSV(this.lines), new Object[0]).log();
    }

    public void parseCSVResource(String resource) throws Exception {
        this.openedFile = ELFileUtils.resource((Object[])new Object[]{resource});
        HighlightRobotLogger.HtmlAppender appender = LOG.createAppender().appendBold("Parse CSV Resource:", new Object[0]);
        if (this.openedFile.isFile()) {
            this.readAll(new InputStreamReader(ELFileUtils.stream((Object[])new Object[]{this.openedFile})));
            appender.append(" (count=%d)", new Object[]{CollectionUtils.size(this.lines)});
            if (CollectionUtils.size(this.lines) <= MAX_LOG_LINES) {
                appender.appendText(this.toCSV(this.lines), new Object[0]);
            }
        } else {
            appender.append("file not found", new Object[0]);
            this.lines = new ArrayList<String[]>();
        }
        appender.log();
    }

    public void appendCSVLine(String csv) throws IOException {
        LOG.createAppender().appendBold("Append CSV Line:", new Object[0]).appendCode(csv, new Object[0]).log();
        CSVWriter writer = new CSVWriter((Writer)new FileWriter(this.openedFile, true));
        if (this.headerRow != null && CollectionUtils.isEmpty(this.lines)) {
            writer.writeNext(this.headerRow);
        }
        String[] line = this.toLine(csv);
        this.lines.add(line);
        writer.writeNext(line);
        writer.close();
    }

    private void setHeaders(String[] headers) {
        this.headerRow = headers;
        this.headers = new HashMap<String, Integer>(headers.length);
        for (int i = 0; i < headers.length; ++i) {
            this.headers.put(headers[i], i);
        }
        LOG.createAppender().append("Set Headers:", new Object[0]).appendPropertyStringArray("Headers", headers).log();
    }

    public void setHeaders(String headers) throws IOException {
        this.setHeaders(this.toLine(headers));
    }

    public void setFirstLineAsHeader() {
        if (CollectionUtils.isNotEmpty(this.lines)) {
            ListIterator<String[]> itr = this.lines.listIterator();
            this.setHeaders(itr.next());
            itr.remove();
        }
    }

    private String toCSV(List<String[]> lines) {
        StringWriter str = new StringWriter();
        CSVWriter writer = new CSVWriter((Writer)str);
        writer.writeAll(lines);
        str.flush();
        return str.toString();
    }

    public String[] toLine(String csv) throws IOException {
        StringReader str = new StringReader(csv);
        CSVReader reader = new CSVReader((Reader)str);
        return reader.readNext();
    }

    private void readAll(Reader reader) throws IOException {
        CSVReader r = new CSVReader(reader);
        try {
            this.lines = r.readAll();
        }
        finally {
            IOUtils.closeQuietly((Closeable)r);
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public List<String[]> getLines() {
        return this.lines;
    }
}

