/*
 * Decompiled with CFR 0.152.
 */
package org.jspringbot.keyword.csv.criteria;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.jspringbot.keyword.csv.criteria.Restriction;
import org.jspringbot.keyword.csv.criteria.RestrictionAppender;

public class CSVLineCriteria
implements RestrictionAppender {
    private List<Restriction> restrictions;
    private List<String[]> lines;
    private Map<String, Integer> headers;

    public CSVLineCriteria(List<String[]> lines, Map<String, Integer> headers) {
        this.lines = lines;
        this.headers = headers;
        this.restrictions = new LinkedList<Restriction>();
    }

    public CSVLineCriteria add(Restriction restriction) {
        this.restrictions.add(restriction);
        return this;
    }

    @Override
    public void append(Restriction r) {
        this.add(r);
    }

    private boolean matches(String[] line) {
        for (Restriction r : this.restrictions) {
            if (r.matches(line, this.headers)) continue;
            return false;
        }
        return true;
    }

    public String[] uniqueResult() {
        LinkedList<String[]> items = this.list();
        if (CollectionUtils.isEmpty(items)) {
            return null;
        }
        if (CollectionUtils.size(items) > 1) {
            throw new IllegalStateException("Has more than one entries found.");
        }
        return (String[])items.iterator().next();
    }

    public String[] firstResult() {
        LinkedList<String[]> items = this.list();
        if (CollectionUtils.isEmpty(items)) {
            throw new IllegalStateException("No items found.");
        }
        return items.getFirst();
    }

    public String[] lastResult() {
        LinkedList<String[]> items = this.list();
        if (CollectionUtils.isEmpty(items)) {
            throw new IllegalStateException("No items found.");
        }
        return items.getLast();
    }

    public LinkedList<String[]> list() {
        LinkedList<String[]> results = new LinkedList<String[]>();
        for (String[] line : this.lines) {
            if (!this.matches(line)) continue;
            results.add(line);
        }
        return results;
    }

    public int count() {
        return CollectionUtils.size(this.list());
    }
}

