/*
 * Decompiled with CFR 0.152.
 */
package org.jspringbot.keyword.csv.criteria;

import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jspringbot.keyword.csv.criteria.Restriction;

public class ColumnEqualsRestriction
implements Restriction {
    private Integer index;
    private String name;
    private String value;

    public ColumnEqualsRestriction(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public ColumnEqualsRestriction(Integer index, String value) {
        this.index = index;
        this.value = value;
    }

    @Override
    public boolean matches(String[] line, Map<String, Integer> headers) {
        Validate.isTrue((MapUtils.isNotEmpty(headers) && this.name != null && headers.containsKey(this.name) || this.index != null ? 1 : 0) != 0, (String)"index or name is invalid.");
        if (this.name != null) {
            this.index = headers.get(this.name);
        }
        assert (this.index != null);
        return StringUtils.equals((String)line[this.index], (String)this.value);
    }
}

