/*
 * Decompiled with CFR 0.152.
 */
package org.jspringbot.keyword.url;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class URLHelper {
    private URL url;
    private List<NameValuePair> parameterList;
    private Map<String, List<String>> parameters;

    public void parse(String urlString) throws MalformedURLException {
        this.url = new URL(urlString);
        this.parameterList = URLEncodedUtils.parse((String)this.url.getQuery(), (Charset)Charset.forName("utf-8"));
        System.out.println("ParameterList = " + this.parameterList);
        this.parameters = new HashMap<String, List<String>>(this.parameterList.size());
        for (NameValuePair nv : this.parameterList) {
            List<String> values = this.parameters.get(nv.getName());
            if (values == null) {
                values = new ArrayList<String>();
                values.add(nv.getValue());
                this.parameters.put(nv.getName(), values);
                System.out.println(" - keyvaluepair " + nv.getName() + " - " + values);
                continue;
            }
            values.add(nv.getValue());
            this.parameters.put(nv.getName(), values);
            System.out.println(" - keyvaluepair " + nv.getName() + " - " + values);
        }
        System.out.println("\nparameters " + this.parameters);
    }

    public void assertHost(String host) {
        Validate.isTrue((boolean)StringUtils.equals((String)this.url.getHost(), (String)host));
    }

    public void assertPort(int port) {
        Validate.isTrue((this.url.getPort() == port ? 1 : 0) != 0);
    }

    public void assertProtocol(String protocol) {
        Validate.isTrue((boolean)StringUtils.equals((String)this.url.getProtocol(), (String)protocol));
    }

    public void assertPath(String path) {
        Validate.isTrue((boolean)StringUtils.equals((String)this.url.getPath(), (String)path));
    }

    public void assertParameterCount(int count) {
        Validate.isTrue((this.parameterList.size() == count ? 1 : 0) != 0);
    }

    public void assertParameterKeyExist(String name) {
        Validate.isTrue((boolean)this.parameters.containsKey(name));
    }

    public void assertParameterKeyDoesNotExist(String name) {
        Validate.isTrue((!this.parameters.containsKey(name) ? 1 : 0) != 0);
    }

    public void assertParameter(String name, String value) {
        List<String> values = this.parameters.get(name);
        if (CollectionUtils.isEmpty(values)) {
            throw new IllegalArgumentException("No parameter with name " + name);
        }
        System.out.println(" ==== name param: " + name + " value param: " + value + " parameter values: " + this.parameters.get(name) + " parameter exist: " + values.contains(value));
        Validate.isTrue((boolean)values.contains(value));
    }
}

