/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.ri.annotations.guice;

import com.google.inject.Injector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheResolverFactory;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.aopalliance.intercept.MethodInvocation;
import org.jsr107.ri.annotations.AbstractCacheLookupUtil;
import org.jsr107.ri.annotations.InternalCacheInvocationContext;
import org.jsr107.ri.annotations.InternalCacheKeyInvocationContext;
import org.jsr107.ri.annotations.StaticCacheInvocationContext;
import org.jsr107.ri.annotations.StaticCacheKeyInvocationContext;
import org.jsr107.ri.annotations.guice.GuiceInternalCacheInvocationContext;
import org.jsr107.ri.annotations.guice.GuiceInternalCacheKeyInvocationContext;

@Singleton
public class CacheLookupUtil
extends AbstractCacheLookupUtil<MethodInvocation> {
    private final Injector injector;
    private final CacheKeyGenerator defaultCacheKeyGenerator;
    private final CacheResolverFactory defaultCacheResolverFactory;

    @Inject
    public CacheLookupUtil(Injector injector, CacheKeyGenerator defaultCacheKeyGenerator, CacheResolverFactory defaultCacheResolverFactory) {
        this.injector = injector;
        this.defaultCacheKeyGenerator = defaultCacheKeyGenerator;
        this.defaultCacheResolverFactory = defaultCacheResolverFactory;
    }

    protected InternalCacheKeyInvocationContext<? extends Annotation> createCacheKeyInvocationContextImpl(StaticCacheKeyInvocationContext<? extends Annotation> staticCacheKeyInvocationContext, MethodInvocation invocation) {
        return new GuiceInternalCacheKeyInvocationContext<Annotation>(staticCacheKeyInvocationContext, invocation);
    }

    protected InternalCacheInvocationContext<? extends Annotation> createCacheInvocationContextImpl(StaticCacheInvocationContext<? extends Annotation> staticCacheInvocationContext, MethodInvocation invocation) {
        return new GuiceInternalCacheInvocationContext<Annotation>(staticCacheInvocationContext, invocation);
    }

    protected Class<?> getTargetClass(MethodInvocation invocation) {
        return invocation.getThis().getClass();
    }

    protected Method getMethod(MethodInvocation invocation) {
        return invocation.getMethod();
    }

    protected <T> T getObjectByType(Class<T> type) {
        return (T)this.injector.getInstance(type);
    }

    protected CacheKeyGenerator getDefaultCacheKeyGenerator() {
        return this.defaultCacheKeyGenerator;
    }

    protected CacheResolverFactory getDefaultCacheResolverFactory() {
        return this.defaultCacheResolverFactory;
    }
}

