/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.jsweet.JSweetConfig;
import org.jsweet.transpiler.EcmaScriptComplianceLevel;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.ModuleImportDescriptor;
import org.jsweet.transpiler.OverloadScanner;
import org.jsweet.transpiler.SourcePosition;
import org.jsweet.transpiler.TranspilationHandler;
import org.jsweet.transpiler.extension.PrinterAdapter;
import org.jsweet.transpiler.model.ArrayAccessElement;
import org.jsweet.transpiler.model.AssignmentElement;
import org.jsweet.transpiler.model.AssignmentWithOperatorElement;
import org.jsweet.transpiler.model.BinaryOperatorElement;
import org.jsweet.transpiler.model.CaseElement;
import org.jsweet.transpiler.model.CompilationUnitElement;
import org.jsweet.transpiler.model.ExtendedElement;
import org.jsweet.transpiler.model.ForeachLoopElement;
import org.jsweet.transpiler.model.ImportElement;
import org.jsweet.transpiler.model.MethodInvocationElement;
import org.jsweet.transpiler.model.NewClassElement;
import org.jsweet.transpiler.model.TypeCastElement;
import org.jsweet.transpiler.model.UnaryOperatorElement;
import org.jsweet.transpiler.model.support.CompilationUnitElementSupport;
import org.jsweet.transpiler.model.support.NewArrayElementSupport;
import org.jsweet.transpiler.util.AbstractTreePrinter;
import org.jsweet.transpiler.util.JSDoc;
import org.jsweet.transpiler.util.Util;

public class Java2TypeScriptTranslator
extends AbstractTreePrinter {
    public static final String PARENT_CLASS_FIELD_NAME = "__parent";
    public static final String INTERFACES_FIELD_NAME = "__interfaces";
    public static final String STATIC_INITIALIZATION_SUFFIX = "_$LI$";
    public static final String CLASS_NAME_IN_CONSTRUCTOR = "__class";
    public static final String ANONYMOUS_PREFIX = "$";
    public static final String ENUM_WRAPPER_CLASS_SUFFIX = "_$WRAPPER";
    public static final String ENUM_WRAPPER_CLASS_WRAPPERS = "_$wrappers";
    public static final String ENUM_WRAPPER_CLASS_NAME = "_$name";
    public static final String ENUM_WRAPPER_CLASS_ORDINAL = "_$ordinal";
    public static final String VAR_DECL_KEYWORD = "let";
    public static final Pattern BODY_MARKER = Pattern.compile("\\{\\{\\s*body\\s*\\}\\}");
    public static final Pattern BASE_INDENT_MARKER = Pattern.compile("\\{\\{\\s*baseIndent\\s*\\}\\}");
    public static final Pattern INDENT_MARKER = Pattern.compile("\\{\\{\\s*indent\\s*\\}\\}");
    public static final Pattern METHOD_NAME_MARKER = Pattern.compile("\\{\\{\\s*methodName\\s*\\}\\}");
    public static final Pattern CLASS_NAME_MARKER = Pattern.compile("\\{\\{\\s*className\\s*\\}\\}");
    public static final String GENERATOR_PREFIX = "__generator_";
    protected static Logger logger = Logger.getLogger(Java2TypeScriptTranslator.class);
    private final Stack<ComparisonMode> comparisonModeStack = new Stack();
    private Stack<ClassScope> scope = new Stack();
    private boolean isAnnotationScope = false;
    private boolean isDefinitionScope = false;
    public static final Map<String, String> TYPE_MAPPING;
    private static final Map<String, String> CONSTRUCTOR_TYPE_MAPPING;
    private PackageElement topLevelPackage;
    private boolean inTypeParameters = false;
    private boolean disableTypeSubstitution = false;
    private boolean printCoreMethodDelegate = false;
    private boolean staticInitializedAssignment = false;
    protected boolean inRollback = false;
    Stack<TypeMirror> rootConditionalAssignedTypes = new Stack();
    Stack<TypeMirror> rootArrayAssignedTypes = new Stack();

    public void enterComparisonMode(ComparisonMode comparisonMode) {
        this.comparisonModeStack.push(comparisonMode);
    }

    public void exitComparisonMode() {
        this.comparisonModeStack.pop();
    }

    private ComparisonMode getComparisonMode() {
        if (this.comparisonModeStack.isEmpty()) {
            return ComparisonMode.STRICT;
        }
        if (this.comparisonModeStack.peek() == ComparisonMode.STRICT) {
            return ComparisonMode.FORCE_STRICT;
        }
        return ComparisonMode.LOOSE;
    }

    protected final boolean isTopLevelScope() {
        return this.getIndent() == 0;
    }

    protected final ClassScope getScope() {
        return this.scope.peek();
    }

    protected final ClassScope getScope(int i) {
        return (ClassScope)this.scope.get(this.scope.size() - 1 - i);
    }

    public void enterScope() {
        this.scope.push(new ClassScope(this.context, this.getCompilationUnit()));
    }

    public void exitScope() {
        this.scope.pop();
    }

    public Java2TypeScriptTranslator(PrinterAdapter adapter, TranspilationHandler logHandler, JSweetContext context, CompilationUnitTree compilationUnit, boolean fillSourceMap) {
        super(logHandler, context, compilationUnit, adapter, fillSourceMap);
    }

    private static String mapConstructorType(String typeName) {
        if (CONSTRUCTOR_TYPE_MAPPING.containsKey(typeName)) {
            return CONSTRUCTOR_TYPE_MAPPING.get(typeName);
        }
        return typeName;
    }

    public void useModule(ModuleImportDescriptor moduleImport) {
        if (moduleImport != null) {
            this.useModule(false, moduleImport.isDirect(), moduleImport.getTargetPackage(), null, moduleImport.getImportedName(), moduleImport.getPathToImportedClass(), null);
        }
    }

    private void useModule(boolean require, boolean direct, PackageElement targetPackage, Tree sourceTree, String targetName, String moduleName, Element sourceElement) {
        for (Tree tree : this.getCompilationUnit().getTypeDecls()) {
            if (!(tree instanceof ClassTree) || !targetName.equals(Util.getElement((ClassTree)tree).getSimpleName().toString())) continue;
            return;
        }
        if (this.context.useModules && targetPackage != null) {
            this.context.packageDependencies.add(targetPackage);
            PackageElement packageElement = (PackageElement)Util.getElement(this.compilationUnit.getPackage());
            this.context.packageDependencies.add(packageElement);
            this.context.packageDependencies.addEdge(packageElement, targetPackage);
        }
        this.context.registerUsedModule(moduleName);
        Set<String> importedNames = this.context.getImportedNames(this.compilationUnit.getSourceFile().getName());
        if (!importedNames.contains(targetName)) {
            if (this.context.useModules) {
                if (this.context.isExcludedSourcePath(this.util().getSourceFilePath(sourceElement))) {
                    return;
                }
                if (sourceElement instanceof TypeElement && this.context.hasAnnotationType(sourceElement, "jsweet.lang.Decorator")) {
                    this.context.forceTopImports();
                }
                if (!(this.context.moduleBundleMode || !(sourceElement instanceof TypeElement) || !this.util().isSourceElement(sourceElement) || sourceElement instanceof TypeElement && this.context.referenceAnalyzer != null && this.context.referenceAnalyzer.isDependent(this.compilationUnit, (TypeElement)sourceElement))) {
                    this.context.addTopFooterStatement("import." + targetName, "import { " + targetName + " } from '" + moduleName + "';\n");
                } else if (direct) {
                    this.context.addHeader("import." + targetName, "import " + targetName + " = " + moduleName + ";\n");
                } else {
                    boolean bl;
                    boolean bl2 = bl = require || "Globals".equals(targetName);
                    if (bl) {
                        if (this.context.useRequireForModules) {
                            this.context.addHeader("import." + targetName, "import " + targetName + " = require(" + this.getStringLiteralQuote() + moduleName + this.getStringLiteralQuote() + ");\n");
                        } else {
                            this.context.addHeader("import." + targetName, "import * as " + targetName + " from '" + moduleName + "';\n");
                        }
                    } else {
                        this.context.addHeader("import." + targetName, "import { " + targetName + " } from '" + moduleName + "';\n");
                    }
                }
            }
            this.context.registerImportedName(this.compilationUnit.getSourceFile().getName(), sourceElement, targetName);
        }
    }

    private boolean checkRootPackageParent(CompilationUnitTree topLevel, PackageElement rootPackage, PackageElement parentPackage) {
        if (parentPackage == null) {
            return true;
        }
        if (!this.context.options.isNoRootDirectories() || this.context.options.isBundle()) {
            return true;
        }
        if (this.context.isRootPackage(parentPackage)) {
            this.report((Tree)topLevel.getPackageName(), JSweetProblem.ENCLOSED_ROOT_PACKAGES, rootPackage.getQualifiedName().toString(), parentPackage.getQualifiedName().toString());
            return false;
        }
        for (Element element : parentPackage.getEnclosedElements()) {
            if (!(element instanceof TypeElement) || !this.util().isSourceElement(element)) continue;
            this.report((Tree)topLevel.getPackageName(), JSweetProblem.CLASS_OUT_OF_ROOT_PACKAGE_SCOPE, this.util().getQualifiedName(element), rootPackage.getQualifiedName().toString());
            return false;
        }
        return this.checkRootPackageParent(topLevel, rootPackage, this.util().getParentPackage(parentPackage));
    }

    private ModuleImportDescriptor getModuleImportDescriptor(String importedName, TypeElement importedClass) {
        return this.getAdapter().getModuleImportDescriptor((CompilationUnitElement)this.createExtendedElement(this.compilationUnit), importedName, importedClass);
    }

    private boolean isMappedOrErasedType(Element typeElement) {
        return this.context.isMappedType(this.util().getQualifiedName(typeElement)) || this.context.hasAnnotationType(typeElement, "jsweet.lang.Erased");
    }

    public void ensureModuleIsUsed(Element element) {
        ModuleImportDescriptor moduleImport;
        if (this.context.useModules && element instanceof TypeElement && (moduleImport = this.getAdapter().getModuleImportDescriptor(this.getCompilationUnitElement(), element.getSimpleName().toString(), (TypeElement)element)) != null) {
            this.useModule(moduleImport);
        }
    }

    @Override
    public Void visitCompilationUnit(final CompilationUnitTree compilationUnit, Trees trees) {
        PackageElement rootPackage;
        PackageElement packageElement = (PackageElement)Util.getElement(compilationUnit.getPackage());
        if (this.context.isPackageErased(packageElement)) {
            return Java2TypeScriptTranslator.returnNothing();
        }
        String packageFullName = this.util().getPackageFullNameForCompilationUnit(compilationUnit);
        this.isDefinitionScope = packageFullName.startsWith("def.");
        if (packageElement != null && this.context.hasAnnotationType(packageElement, "jsweet.lang.Module")) {
            this.context.addExportedElement(this.context.getAnnotationValue(packageElement, "jsweet.lang.Module", String.class, null), packageElement, this.getCompilationUnit());
        }
        if ((rootPackage = this.context.getFirstEnclosingRootPackage(packageElement)) != null && !this.checkRootPackageParent(compilationUnit, rootPackage, this.util().getParentPackage(rootPackage))) {
            return Java2TypeScriptTranslator.returnNothing();
        }
        this.context.importedTopPackages.clear();
        this.context.rootPackages.add(rootPackage);
        this.topLevelPackage = this.context.getTopLevelPackage(packageElement);
        if (this.topLevelPackage != null) {
            this.context.topLevelPackageNames.add(this.topLevelPackage.getQualifiedName().toString());
        }
        this.footer.delete(0, this.footer.length());
        this.setCompilationUnit(compilationUnit);
        this.getAdapter().beforeCompilationUnit();
        boolean globalModule = "globals".equals(packageFullName) || packageFullName.endsWith(".globals");
        String rootRelativePackageName = "";
        if (!globalModule && (rootRelativePackageName = this.getRootRelativeName(packageElement)).length() == 0) {
            globalModule = true;
        }
        ArrayList<String> packageSegments = new ArrayList<String>(Arrays.asList(rootRelativePackageName.split("\\.")));
        packageSegments.retainAll(JSweetConfig.TS_TOP_LEVEL_KEYWORDS);
        if (!packageSegments.isEmpty()) {
            this.report((Tree)compilationUnit.getPackageName(), JSweetProblem.PACKAGE_NAME_CONTAINS_KEYWORD, packageSegments);
        }
        this.detectAndUseImportedModules(compilationUnit);
        this.detectAndUseModulesFromReferencedTypes(compilationUnit);
        new TreeScanner<Void, Trees>(){
            Stack<Tree> stack = new Stack();

            @Override
            public Void scan(Tree tree, Trees trees) {
                if (tree != null) {
                    this.stack.push(tree);
                    try {
                        super.scan(tree, trees);
                    }
                    finally {
                        this.stack.pop();
                    }
                }
                return Java2TypeScriptTranslator.returnNothing();
            }

            public <T extends Tree> T getParent(Class<T> type) {
                for (int i = this.stack.size() - 2; i >= 0; --i) {
                    if (!type.isAssignableFrom(((Tree)this.stack.get(i)).getClass())) continue;
                    return (T)((Tree)this.stack.get(i));
                }
                return null;
            }

            @Override
            public Void visitIdentifier(IdentifierTree identifier, Trees trees) {
                PackageElement compilationUnitPackageElement = (PackageElement)Util.getElement(compilationUnit.getPackage());
                Object identifierElement = Util.getElement(identifier);
                if (identifierElement instanceof PackageElement) {
                    Tree tree;
                    if (this.getParent(ImportTree.class) != null) {
                        return Java2TypeScriptTranslator.returnNothing();
                    }
                    boolean isSourceType = false;
                    for (int i = this.stack.size() - 2; i >= 0 && (tree = (Tree)this.stack.get(i)) instanceof MemberSelectTree; --i) {
                        MemberSelectTree selectTree = (MemberSelectTree)tree;
                        Object selectElement = Util.getElement(selectTree);
                        if (!(selectElement instanceof TypeElement) || !Java2TypeScriptTranslator.this.util().isSourceElement((Element)selectElement)) continue;
                        isSourceType = true;
                        break;
                    }
                    if (!isSourceType) {
                        return Java2TypeScriptTranslator.returnNothing();
                    }
                    PackageElement identifierPackage = (PackageElement)identifierElement;
                    String pathToModulePackage = Java2TypeScriptTranslator.this.util().getRelativePath(compilationUnitPackageElement, identifierPackage);
                    if (pathToModulePackage == null) {
                        return Java2TypeScriptTranslator.returnNothing();
                    }
                    File moduleFile = new File(new File(pathToModulePackage), "module");
                    if (!identifierPackage.getSimpleName().toString().equals(compilationUnitPackageElement.getSimpleName().toString())) {
                        Java2TypeScriptTranslator.this.useModule(false, false, identifierPackage, identifier, identifierPackage.getSimpleName().toString(), moduleFile.getPath().replace('\\', '/'), null);
                    }
                } else if (identifierElement instanceof TypeElement && "globals".equals(identifierElement.getEnclosingElement().getSimpleName().toString())) {
                    String pathToModulePackage = Java2TypeScriptTranslator.this.util().getRelativePath(compilationUnitPackageElement, identifierElement.getEnclosingElement());
                    if (pathToModulePackage == null) {
                        return Java2TypeScriptTranslator.returnNothing();
                    }
                    File moduleFile = new File(new File(pathToModulePackage), "module");
                    if (!identifierElement.getEnclosingElement().getSimpleName().toString().equals(compilationUnitPackageElement.getSimpleName().toString())) {
                        Java2TypeScriptTranslator.this.useModule(false, false, (PackageElement)identifierElement.getEnclosingElement(), identifier, "globals", moduleFile.getPath().replace('\\', '/'), null);
                    }
                }
                return Java2TypeScriptTranslator.returnNothing();
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree invocation, Trees trees) {
                PackageElement compilationUnitPackageElement = (PackageElement)Util.getElement(compilationUnit.getPackage());
                if (invocation.getMethodSelect() instanceof IdentifierTree && JSweetConfig.TS_STRICT_MODE_KEYWORDS.contains(invocation.getMethodSelect().toString().toLowerCase())) {
                    Object invokedMethodElement = Util.getElement((IdentifierTree)invocation.getMethodSelect());
                    PackageElement invocationPackage = Java2TypeScriptTranslator.this.util().getParentElement((Element)invokedMethodElement, PackageElement.class);
                    String rootRelativeInvocationPackageName = Java2TypeScriptTranslator.this.getRootRelativeName(invocationPackage);
                    if (rootRelativeInvocationPackageName.indexOf(46) == -1) {
                        return (Void)super.visitMethodInvocation(invocation, trees);
                    }
                    String targetRootPackageName = rootRelativeInvocationPackageName.substring(0, rootRelativeInvocationPackageName.indexOf(46));
                    String pathToReachRootPackage = Java2TypeScriptTranslator.this.util().getRelativePath("/" + compilationUnitPackageElement.getQualifiedName().toString().replace('.', '/'), "/" + targetRootPackageName);
                    if (pathToReachRootPackage == null) {
                        return (Void)super.visitMethodInvocation(invocation, trees);
                    }
                    File moduleFile = new File(new File(pathToReachRootPackage), "module");
                    if (!invocationPackage.toString().equals(compilationUnitPackageElement.getSimpleName().toString())) {
                        Java2TypeScriptTranslator.this.useModule(false, false, invocationPackage, invocation, targetRootPackageName, moduleFile.getPath().replace('\\', '/'), null);
                    }
                }
                return (Void)super.visitMethodInvocation(invocation, trees);
            }
        };
        if (!globalModule && !this.context.useModules) {
            this.printIndent();
            if (this.isDefinitionScope) {
                this.print("declare ");
            } else if (this.context.moduleBundleMode) {
                this.print("export ");
            }
            this.print("namespace ").print(rootRelativePackageName).print(" {").startIndent().println();
        }
        for (ImportTree importTree : compilationUnit.getImports()) {
            this.print(importTree);
        }
        for (ClassTree classTree : this.util().getSortedClassDeclarations(compilationUnit.getTypeDecls(), compilationUnit)) {
            this.printIndent();
            int pos = this.getCurrentPosition();
            this.print(classTree);
            if (this.getCurrentPosition() == pos) {
                this.removeLastIndent();
                continue;
            }
            this.println().println();
        }
        if (!globalModule && !this.context.useModules) {
            this.removeLastChar().endIndent().printIndent().print("}").println();
        }
        if (this.footer.length() > 0) {
            this.println().print(this.footer.toString());
        }
        globalModule = false;
        return Java2TypeScriptTranslator.returnNothing();
    }

    private void detectAndUseModulesFromReferencedTypes(CompilationUnitTree compilationUnit) {
        if (this.context.useModules) {
            new UsedTypesScanner().scan((Tree)compilationUnit, this.context.trees);
        }
    }

    private void detectAndUseImportedModules(CompilationUnitTree compilationUnit) {
        for (final ImportTree importTree : compilationUnit.getImports()) {
            TreeScanner<Void, Trees> importedModulesScanner = new TreeScanner<Void, Trees>(){

                @Override
                public Void scan(Tree tree, Trees trees) {
                    if (tree instanceof MemberSelectTree) {
                        MemberSelectTree qualifier;
                        Object subMemberSelectElement;
                        MemberSelectTree qualified = (MemberSelectTree)tree;
                        Object memberSelectElement = Util.getElement(tree);
                        if (memberSelectElement != null) {
                            if (Java2TypeScriptTranslator.this.context.hasAnnotationType((Element)memberSelectElement, "jsweet.lang.Module")) {
                                String targetName = Java2TypeScriptTranslator.this.createImportAliasFromFieldAccess(qualified);
                                String actualName = Java2TypeScriptTranslator.this.context.getAnnotationValue((Element)memberSelectElement, "jsweet.lang.Module", String.class, null);
                                Java2TypeScriptTranslator.this.useModule(true, false, null, importTree, targetName, actualName, (Element)memberSelectElement);
                            }
                        } else if (qualified.getExpression() instanceof MemberSelectTree && (subMemberSelectElement = Util.getElement(qualifier = (MemberSelectTree)qualified.getExpression())) != null) {
                            try {
                                for (Element element : subMemberSelectElement.getEnclosedElements()) {
                                    if (!qualified.getIdentifier().equals(element.getSimpleName()) || !Java2TypeScriptTranslator.this.context.hasAnnotationType(element, "jsweet.lang.Module")) continue;
                                    String targetName = Java2TypeScriptTranslator.this.createImportAliasFromSymbol(element);
                                    String actualName = Java2TypeScriptTranslator.this.context.getAnnotationValue(element, "jsweet.lang.Module", String.class, null);
                                    Java2TypeScriptTranslator.this.useModule(true, false, null, importTree, targetName, actualName, element);
                                    break;
                                }
                            }
                            catch (Exception e) {
                                logger.error((Object)"error occurred collecting modules from static imports", (Throwable)e);
                            }
                        }
                    }
                    return (Void)super.scan(tree, trees);
                }
            };
            importedModulesScanner.scan(importTree.getQualifiedIdentifier(), this.context.trees);
            for (ImportTree importTree2 : compilationUnit.getImports()) {
                ModuleImportDescriptor moduleImport;
                Object qualifiedElement;
                if (!(importTree2.getQualifiedIdentifier() instanceof MemberSelectTree)) continue;
                MemberSelectTree qualified = (MemberSelectTree)importTree2.getQualifiedIdentifier();
                String importedName = qualified.getIdentifier().toString();
                if (importTree2.isStatic() && qualified.getExpression() instanceof MemberSelectTree) {
                    qualified = (MemberSelectTree)qualified.getExpression();
                }
                if (!((qualifiedElement = Util.getElement(qualified)) instanceof TypeElement)) continue;
                boolean globals = "Globals".equals(qualifiedElement.getSimpleName().toString());
                if (!globals) {
                    importedName = qualified.getIdentifier().toString();
                }
                TypeElement importedClass = (TypeElement)qualifiedElement;
                String qualId = importTree2.getQualifiedIdentifier().toString();
                String adaptedQualId = this.getAdapter().needsImport((ImportElement)this.createExtendedElement(importTree2), qualId);
                if (!globals && adaptedQualId == null || (moduleImport = this.getModuleImportDescriptor(importedName, importedClass)) == null) continue;
                this.useModule(false, moduleImport.isDirect(), moduleImport.getTargetPackage(), importTree2, moduleImport.getImportedName(), moduleImport.getPathToImportedClass(), null);
            }
        }
    }

    private String createImportAliasFromFieldAccess(MemberSelectTree access) {
        String name = this.extractNameFromAnnotatedSymbol((Element)Util.getElement(access));
        if (name != null) {
            return name;
        }
        return access.getIdentifier().toString();
    }

    private String createImportAliasFromSymbol(Element symbol) {
        String name = this.extractNameFromAnnotatedSymbol(symbol);
        if (name != null) {
            return name;
        }
        return symbol.getSimpleName().toString();
    }

    private String extractNameFromAnnotatedSymbol(Element symbol) {
        if (this.context.hasAnnotationType(symbol, "jsweet.lang.Name")) {
            return this.context.getAnnotationValue(symbol, "jsweet.lang.Name", String.class, null);
        }
        return null;
    }

    private void printDocComment(Tree element) {
        this.printDocComment(element, false);
    }

    private void printDocComment(Tree tree, boolean newline) {
        if (this.compilationUnit != null) {
            TreePath treePath = TreePath.getPath(this.compilationUnit, tree);
            Object element = Util.getElement(tree);
            if (treePath == null && element != null) {
                treePath = this.trees().getPath((Element)element);
            }
            String docComment = this.trees().getDocComment(treePath);
            String commentText = JSDoc.adaptDocComment(this.context, treePath, tree, docComment);
            if (element != null) {
                commentText = this.getAdapter().adaptDocComment((Element)element, commentText);
            }
            ArrayList<String> lines = new ArrayList<String>();
            if (commentText != null) {
                lines.addAll(Arrays.asList(commentText.split("\n")));
            }
            if (!lines.isEmpty()) {
                if (newline) {
                    this.println().printIndent();
                }
                this.print("/**").println();
                for (String line : lines) {
                    this.printIndent().print(" * ").print(line.trim()).println();
                }
                this.removeLastChar();
                this.println().printIndent().print(" ").print("*/").println();
                this.printIndent();
            }
        }
    }

    private void printAnonymousClassTypeArgs(NewClassTree newClass) {
        ParameterizedTypeTree tapply;
        if (newClass.getIdentifier() instanceof ParameterizedTypeTree && (tapply = (ParameterizedTypeTree)((Object)newClass.getIdentifier())).getTypeArguments() != null && !tapply.getTypeArguments().isEmpty()) {
            boolean printed = false;
            this.print("<");
            for (Tree tree : tapply.getTypeArguments()) {
                Object typeArgType = Util.getType(tree);
                if (!(typeArgType instanceof TypeVariable)) continue;
                printed = true;
                this.print(tree).print(", ");
            }
            if (printed) {
                this.removeLastChars(2);
                this.print(">");
            } else {
                this.removeLastChar();
            }
        }
    }

    protected boolean isAnonymousClass() {
        return this.scope.size() > 1 && this.getScope((int)1).isAnonymousClass;
    }

    private boolean isInnerClass() {
        return this.scope.size() > 1 && this.getScope((int)1).isInnerClass;
    }

    private boolean isLocalClass() {
        return this.scope.size() > 1 && this.getScope((int)1).isLocalClass;
    }

    @Override
    public final AbstractTreePrinter substituteAndPrintType(Tree typeTree) {
        return this.substituteAndPrintType(typeTree, false, this.inTypeParameters, true, this.disableTypeSubstitution);
    }

    private AbstractTreePrinter printArguments(List<? extends Tree> arguments) {
        int i = 1;
        for (Tree tree : arguments) {
            this.printArgument(tree, i++).print(", ");
        }
        if (arguments.size() > 0) {
            this.removeLastChars(2);
        }
        return this;
    }

    private AbstractTreePrinter printArgument(Tree argument, int i) {
        this.print("p" + i + ": ");
        this.substituteAndPrintType(argument, false, false, true, false);
        return this;
    }

    private AbstractTreePrinter substituteAndPrintType(Tree typeTree, boolean arrayComponent, boolean inTypeParameters, boolean completeRawTypes, boolean disableSubstitution) {
        if (typeTree instanceof IntersectionTypeTree) {
            for (Tree tree : ((IntersectionTypeTree)typeTree).getBounds()) {
                this.substituteAndPrintType(tree, arrayComponent, inTypeParameters, completeRawTypes, disableSubstitution);
                this.print(" & ");
            }
            this.removeLastChars(3);
            return this;
        }
        Object typeElement = Util.getTypeElement(typeTree);
        Object t = Util.getType(typeTree);
        if (typeElement instanceof TypeParameterElement && this.getAdapter().typeVariablesToErase.contains(typeElement)) {
            return this.print("any");
        }
        if (!disableSubstitution) {
            Object mapped;
            if (this.context.hasAnnotationType((Element)typeElement, "jsweet.lang.Erased")) {
                return this.print("any");
            }
            if (this.context.hasAnnotationType((Element)typeElement, "jsweet.lang.ObjectType")) {
                return this.print("any");
            }
            String typeFullName = this.util().getQualifiedName((TypeMirror)t);
            if (Runnable.class.getName().equals(typeFullName)) {
                if (arrayComponent) {
                    this.print("(");
                }
                this.print("() => void");
                if (arrayComponent) {
                    this.print(")");
                }
                return this;
            }
            if (typeTree instanceof ParameterizedTypeTree) {
                ParameterizedTypeTree typeApply = (ParameterizedTypeTree)typeTree;
                TypeElement typeElement2 = (TypeElement)Util.getTypeElement(typeApply.getType());
                String typeName = typeElement2.getSimpleName().toString();
                String mappedTypeName = this.context.getTypeMappingTarget(typeName);
                if (mappedTypeName != null && mappedTypeName.endsWith("<>")) {
                    this.print(typeName.substring(0, mappedTypeName.length() - 2));
                    return this;
                }
                if (typeFullName.startsWith("jsweet.util.tuple.")) {
                    this.print("[");
                    for (Tree tree : typeApply.getTypeArguments()) {
                        this.substituteAndPrintType(tree, arrayComponent, inTypeParameters, completeRawTypes, false).print(",");
                    }
                    if (typeApply.getTypeArguments().size() > 0) {
                        this.removeLastChar();
                    }
                    this.print("]");
                    return this;
                }
                if (typeFullName.startsWith("jsweet.util.union.Union")) {
                    this.print("(");
                    for (Tree tree : typeApply.getTypeArguments()) {
                        this.print("(");
                        this.substituteAndPrintType(tree, arrayComponent, inTypeParameters, completeRawTypes, false);
                        this.print(")");
                        this.print("|");
                    }
                    if (typeApply.getTypeArguments().size() > 0) {
                        this.removeLastChar();
                    }
                    this.print(")");
                    return this;
                }
                if (typeFullName.startsWith("jsweet.util.") || typeFullName.startsWith("java.util.function.")) {
                    if (typeName.endsWith("Consumer") || typeName.startsWith("Consumer")) {
                        if (arrayComponent) {
                            this.print("(");
                        }
                        this.print("(");
                        if (typeName.startsWith("Int") || typeName.startsWith("Long") || typeName.startsWith("Double")) {
                            this.print("p0: number");
                        } else {
                            this.printArguments(typeApply.getTypeArguments());
                        }
                        this.print(") => void");
                        if (arrayComponent) {
                            this.print(")");
                        }
                        return this;
                    }
                    if (typeName.endsWith("Function") || typeName.startsWith("Function")) {
                        if (arrayComponent) {
                            this.print("(");
                        }
                        this.print("(");
                        if (typeName.startsWith("Int") || typeName.startsWith("Long") || typeName.startsWith("Double")) {
                            this.print("p0: number");
                        } else {
                            this.printArguments(typeApply.getTypeArguments().subList(0, typeApply.getTypeArguments().size() - 1));
                        }
                        this.print(") => ");
                        this.substituteAndPrintType(this.util().last(typeApply.getTypeArguments()), arrayComponent, inTypeParameters, completeRawTypes, false);
                        if (arrayComponent) {
                            this.print(")");
                        }
                        return this;
                    }
                    if (typeName.endsWith("Supplier") || typeName.startsWith("Supplier")) {
                        if (arrayComponent) {
                            this.print("(");
                        }
                        this.print("(");
                        this.print(") => ");
                        if (typeName.startsWith("Int") || typeName.startsWith("Long") || typeName.startsWith("Double")) {
                            this.print("number");
                        } else {
                            this.substituteAndPrintType(typeApply.getTypeArguments().get(0), arrayComponent, inTypeParameters, completeRawTypes, false);
                        }
                        if (arrayComponent) {
                            this.print(")");
                        }
                        return this;
                    }
                    if (typeName.endsWith("Predicate")) {
                        if (arrayComponent) {
                            this.print("(");
                        }
                        this.print("(");
                        if (typeName.startsWith("Int") || typeName.startsWith("Long") || typeName.startsWith("Double")) {
                            this.print("p0: number");
                        } else {
                            this.printArguments(typeApply.getTypeArguments());
                        }
                        this.print(") => boolean");
                        if (arrayComponent) {
                            this.print(")");
                        }
                        return this;
                    }
                    if (typeName.endsWith("Operator")) {
                        if (arrayComponent) {
                            this.print("(");
                        }
                        this.print("(");
                        this.printArgument(typeApply.getTypeArguments().get(0), 1);
                        if (typeName.startsWith("Binary")) {
                            this.print(", ");
                            this.printArgument(typeApply.getTypeArguments().get(0), 2);
                        }
                        this.print(") => ");
                        this.substituteAndPrintType(typeApply.getTypeArguments().get(0), arrayComponent, inTypeParameters, completeRawTypes, false);
                        if (arrayComponent) {
                            this.print(")");
                        }
                        return this;
                    }
                }
                if (t.toString().startsWith(Class.class.getName() + "<")) {
                    return this.print("any");
                }
            } else {
                if (!(typeTree instanceof ArrayTypeTree) && typeFullName.startsWith("java.util.function.")) {
                    return this.print("any");
                }
                String mappedType = this.context.getTypeMappingTarget(typeFullName);
                if (mappedType != null) {
                    if (mappedType.endsWith("<>")) {
                        this.print(mappedType.substring(0, mappedType.length() - 2));
                    } else {
                        this.print(mappedType);
                        if (completeRawTypes && typeElement != null && !((TypeElement)typeElement).getTypeParameters().isEmpty() && !this.context.getTypeMappingTarget(typeFullName).equals("any")) {
                            this.printAnyTypeArguments(((TypeElement)typeElement).getTypeParameters().size());
                        }
                    }
                    return this;
                }
            }
            for (BiFunction<ExtendedElement, String, Object> biFunction : this.context.getFunctionalTypeMappings()) {
                mapped = biFunction.apply((ExtendedElement)this.createExtendedElement(typeTree), typeFullName);
                if (mapped instanceof String) {
                    this.print((String)mapped);
                    return this;
                }
                if (mapped instanceof Tree) {
                    this.substituteAndPrintType((Tree)mapped);
                    return this;
                }
                if (!(mapped instanceof TypeMirror)) continue;
                this.print(this.getAdapter().getMappedType((TypeMirror)mapped));
                return this;
            }
            for (Function function : this.context.getFunctionalTypeMirrorMappings()) {
                mapped = (String)function.apply(t);
                if (mapped == null) continue;
                this.print((String)mapped);
                return this;
            }
        }
        if (typeTree instanceof ParameterizedTypeTree) {
            ParameterizedTypeTree typeApply = (ParameterizedTypeTree)typeTree;
            this.substituteAndPrintType(typeApply.getType(), arrayComponent, inTypeParameters, false, disableSubstitution);
            if (!(typeApply.getTypeArguments().isEmpty() || "any".equals(this.getLastPrintedString(3)) || "Object".equals(this.getLastPrintedString(6)))) {
                this.print("<");
                for (Tree tree : typeApply.getTypeArguments()) {
                    this.substituteAndPrintType(tree, arrayComponent, false, completeRawTypes, false).print(", ");
                }
                if (typeApply.getTypeArguments().size() > 0) {
                    this.removeLastChars(2);
                }
                this.print(">");
            }
            return this;
        }
        if (typeTree instanceof WildcardTree) {
            WildcardTree wildcard = (WildcardTree)typeTree;
            String name = this.context.getWildcardName(wildcard);
            if (name == null) {
                return this.print("any");
            }
            this.print(name);
            if (inTypeParameters) {
                this.print(" extends ");
                return this.substituteAndPrintType(wildcard.getBound(), arrayComponent, false, completeRawTypes, disableSubstitution);
            }
            return this;
        }
        if (typeTree instanceof ArrayTypeTree) {
            return this.substituteAndPrintType(((ArrayTypeTree)typeTree).getType(), true, inTypeParameters, completeRawTypes, disableSubstitution).print("[]");
        }
        if (completeRawTypes && typeElement instanceof TypeElement && ((TypeElement)typeElement).getTypeParameters() != null && !((TypeElement)typeElement).getTypeParameters().isEmpty()) {
            this.print(typeTree);
            this.print("<");
            for (int i = 0; i < ((TypeElement)typeElement).getTypeParameters().size(); ++i) {
                this.print("any, ");
            }
            this.removeLastChars(2);
            this.print(">");
            return this;
        }
        return this.print(typeTree);
    }

    private String getClassName(TypeElement clazz) {
        Object name = this.context.hasClassNameMapping(clazz) ? this.context.getClassNameMapping(clazz) : clazz.getSimpleName().toString();
        if (clazz.getKind() == ElementKind.ENUM) {
            name = (String)name + ENUM_WRAPPER_CLASS_SUFFIX;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Void visitClass(ClassTree classTree, Trees trees) {
        boolean bl;
        boolean bl2;
        void var14_46;
        boolean requiresDecoratorFunction;
        Tree testParent;
        TypeElement classTypeElement = (TypeElement)Util.getElement(classTree);
        if (this.getAdapter().substituteType(classTypeElement)) {
            this.getAdapter().afterType(classTypeElement);
            return null;
        }
        if (this.context.isIgnored(classTree, this.compilationUnit)) {
            this.getAdapter().afterType(classTypeElement);
            return Java2TypeScriptTranslator.returnNothing();
        }
        Object name = classTree.getSimpleName().toString();
        if (this.context.hasClassNameMapping(classTypeElement)) {
            name = this.context.getClassNameMapping(classTypeElement);
        }
        if (!this.scope.isEmpty() && this.getScope().anonymousClasses.contains(classTree)) {
            name = this.getScope().name + ANONYMOUS_PREFIX + this.getScope().anonymousClasses.indexOf(classTree);
        }
        if ((testParent = this.getFirstParent(ClassTree.class, MethodTree.class)) != null && testParent instanceof MethodTree && !this.isLocalClass()) {
            this.getScope().localClasses.add(classTree);
            return Java2TypeScriptTranslator.returnNothing();
        }
        this.enterScope();
        this.getScope().name = name;
        ClassTree parent = this.getParent(ClassTree.class);
        ArrayList parentTypeVars = new ArrayList();
        if (parent != null) {
            this.getScope().innerClass = true;
            if (!(classTree.getModifiers().getFlags().contains((Object)Modifier.STATIC) || this.getScope(1).getAnonymousClassConstructorFromClassTree(classTree) != null && this.isStaticAnonymousClass(this.getScope(1).getAnonymousClassConstructorFromClassTree(classTree), this.getCompilationUnit()))) {
                this.getScope().innerClassNotStatic = true;
                if (parent.getTypeParameters() != null) {
                    parentTypeVars.addAll(parent.getTypeParameters().stream().map(t -> (TypeParameterElement)Util.getTypeElement(t)).collect(Collectors.toList()));
                    this.getAdapter().typeVariablesToErase.addAll(parentTypeVars);
                }
            }
        }
        this.getScope().declareClassScope = this.context.hasAnnotationType(classTypeElement, "jsweet.lang.Ambient") || this.isDefinitionScope;
        this.getScope().interfaceScope = false;
        this.getScope().removedSuperclass = false;
        this.getScope().enumScope = false;
        this.getScope().enumWrapperClassScope = false;
        if (this.getScope().declareClassScope) {
            if (this.context.hasAnnotationType(classTypeElement, "jsweet.lang.Decorator")) {
                this.print("declare function ").print((String)name).print("(...args: any[]);").println();
                this.exitScope();
                return Java2TypeScriptTranslator.returnNothing();
            }
        } else if (this.context.lookupDecoratorAnnotation(classTypeElement.getQualifiedName().toString()) != null && (requiresDecoratorFunction = this.context.getAnnotationValue(classTypeElement, "jsweet.lang.Decorator", Boolean.class, true).booleanValue())) {
            JSweetContext.GlobalMethodInfos globalDecoratorFunction = this.context.lookupGlobalMethod(classTypeElement.getQualifiedName().toString());
            if (globalDecoratorFunction == null) {
                this.report((Tree)classTree, JSweetProblem.CANNOT_FIND_GLOBAL_DECORATOR_FUNCTION, classTypeElement.getQualifiedName());
            } else {
                CompilationUnitTree previousCompilUnit = this.getCompilationUnit();
                this.getScope().decoratorScope = true;
                this.compilationUnit = globalDecoratorFunction.compilationUnitTree;
                try {
                    this.enter(globalDecoratorFunction.classTree);
                    this.print(globalDecoratorFunction.methodTree);
                    this.exit();
                }
                finally {
                    this.getScope().decoratorScope = false;
                    this.compilationUnit = previousCompilUnit;
                }
            }
            this.exitScope();
            return Java2TypeScriptTranslator.returnNothing();
        }
        HashSet<JSweetContext.DefaultMethodEntry> defaultMethods = null;
        boolean globals = "Globals".equals(classTree.getSimpleName().toString());
        if (globals && classTree.getExtendsClause() != null) {
            this.report((Tree)classTree, JSweetProblem.GLOBALS_CLASS_CANNOT_HAVE_SUPERCLASS, new Object[0]);
        }
        ArrayList<TypeMirror> implementedInterfaces = new ArrayList<TypeMirror>();
        if (!globals) {
            NewClassTree newClass;
            if (classTree.getExtendsClause() != null && "Globals".equals(Util.getTypeElement(classTree.getExtendsClause()).getSimpleName().toString())) {
                this.report((Tree)classTree, JSweetProblem.GLOBALS_CLASS_CANNOT_BE_SUBCLASSED, new Object[0]);
                return Java2TypeScriptTranslator.returnNothing();
            }
            if (classTree.getKind() != Tree.Kind.ENUM || this.scope.size() <= 1 || !this.getScope((int)1).isComplexEnum) {
                this.printDocComment(classTree);
            } else {
                this.print("/** @ignore */").println().printIndent();
            }
            this.print(classTree.getModifiers());
            if (!this.isTopLevelScope() || this.context.useModules || this.context.moduleBundleMode || this.isAnonymousClass() || this.isInnerClass() || this.isLocalClass()) {
                this.print("export ");
            }
            if (this.context.isInterface(classTypeElement)) {
                this.print("interface ");
                this.getScope().interfaceScope = true;
            } else if (classTree.getKind() == Tree.Kind.ENUM) {
                if (this.getScope().declareClassScope && (this.getIndent() == 0 || !this.isDefinitionScope)) {
                    this.print("declare ");
                }
                if (this.scope.size() > 1 && this.getScope((int)1).isComplexEnum) {
                    if (this.util().hasAbstractMethod(classTypeElement)) {
                        this.print("abstract ");
                    }
                    this.print("class ");
                    this.getScope().enumWrapperClassScope = true;
                } else {
                    this.print("enum ");
                    this.getScope().enumScope = true;
                    if (this.context.hasAnnotationType(classTypeElement, "jsweet.lang.StringEnum")) {
                        this.getScope().stringEnumScope = true;
                        this.getScope().enumWrapperClassScope = false;
                        this.getScope().isComplexEnum = false;
                    }
                }
            } else {
                if (this.getScope().declareClassScope && (this.getIndent() == 0 || !this.isDefinitionScope)) {
                    this.print("declare ");
                }
                defaultMethods = new HashSet<JSweetContext.DefaultMethodEntry>();
                this.util().findDefaultMethodsInType(defaultMethods, this.context, classTypeElement);
                TypeElement superClass = (TypeElement)Util.getElement(classTypeElement.getSuperclass());
                if (this.util().isSourceElement(superClass) && !this.isMappedOrErasedType(superClass)) {
                    HashSet<JSweetContext.DefaultMethodEntry> superClassDefaultMethods = new HashSet<JSweetContext.DefaultMethodEntry>();
                    this.util().findDefaultMethodsInType(superClassDefaultMethods, this.context, superClass);
                    defaultMethods.removeAll(superClassDefaultMethods);
                }
                if (classTree.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT)) {
                    this.print("abstract ");
                }
                this.print("class ");
            }
            this.print((String)name + (this.getScope().enumWrapperClassScope ? ENUM_WRAPPER_CLASS_SUFFIX : ""));
            if (classTree.getTypeParameters() != null && classTree.getTypeParameters().size() > 0) {
                this.print("<").printArgList(null, classTree.getTypeParameters()).print(">");
            } else if (this.isAnonymousClass() && this.isStaticAnonymousClass(newClass = this.getScope((int)1).anonymousClassesConstructors.get(this.getScope((int)1).anonymousClasses.indexOf(classTree)), this.getCompilationUnit())) {
                this.printAnonymousClassTypeArgs(newClass);
            }
            TypeMirror mixin = null;
            if (this.context.hasAnnotationType(classTypeElement, "jsweet.lang.Mixin")) {
                mixin = this.context.getAnnotationValue(classTypeElement, "jsweet.lang.Mixin", TypeMirror.class, null);
                for (AnnotationMirror annotationMirror : classTypeElement.getAnnotationMirrors()) {
                    if (!"jsweet.lang.Mixin".equals(annotationMirror.getAnnotationType().toString())) continue;
                    Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry = Util.firstOrDefault(annotationMirror.getElementValues().entrySet());
                    AnnotationValue annotationValue = entry.getValue();
                    TypeMirror typeMirror = (TypeMirror)annotationValue.getValue();
                    TypeElement typeElement = (TypeElement)this.types().asElement(typeMirror);
                    String string = this.getRootRelativeName(typeElement);
                    String mixinName = this.getRootRelativeName(classTypeElement);
                    if (!mixinName.equals(string)) {
                        this.report((Tree)classTree, JSweetProblem.WRONG_MIXIN_NAME, mixinName, string);
                        continue;
                    }
                    if (!typeElement.equals(classTypeElement)) continue;
                    this.report((Tree)classTree, JSweetProblem.SELF_MIXIN_TARGET, mixinName);
                }
            }
            boolean extendsInterface = false;
            if (classTree.getExtendsClause() != null) {
                boolean bl3;
                TypeElement typeElement = (TypeElement)Util.getTypeElement(classTree.getExtendsClause());
                TypeMirror typeMirror = typeElement.asType();
                boolean bl4 = false;
                if (this.context.hasAnnotationType(classTypeElement, "jsweet.lang.SyntacticIterable") && typeElement.getQualifiedName().toString().equals(Iterable.class.getName())) {
                    bl3 = true;
                }
                if (!this.getAdapter().substituteExtends(classTypeElement)) {
                    if (!(bl3 || JSweetConfig.isJDKReplacementMode() || "def.js.Object".equals(typeMirror.toString()) || Object.class.getName().equals(typeMirror.toString()) || mixin != null && this.types().isSameType(mixin, typeMirror) || this.getAdapter().eraseSuperClass(classTypeElement, typeElement))) {
                        if (!this.getScope().interfaceScope && this.context.isInterface(typeElement)) {
                            extendsInterface = true;
                            this.print(" implements ");
                            implementedInterfaces.add(typeMirror);
                        } else {
                            this.print(" extends ");
                        }
                        if (this.getScope().enumWrapperClassScope && this.getScope((int)1).anonymousClasses.contains(classTree)) {
                            this.print(classTree.getExtendsClause().toString() + ENUM_WRAPPER_CLASS_SUFFIX);
                        } else {
                            this.disableTypeSubstitution = !this.getAdapter().isSubstituteSuperTypes();
                            this.substituteAndPrintType(classTree.getExtendsClause());
                            this.disableTypeSubstitution = false;
                        }
                        if (this.context.classesWithWrongConstructorOverload.contains(classTypeElement)) {
                            this.getScope().hasConstructorOverloadWithSuperClass = true;
                        }
                    } else {
                        this.getScope().removedSuperclass = true;
                    }
                }
            }
            if (!(this.getAdapter().substituteImplements(classTypeElement) || classTree.getImplementsClause() == null || classTree.getImplementsClause().isEmpty() || this.getScope().enumScope)) {
                ArrayList<? extends Tree> arrayList = new ArrayList<Tree>(classTree.getImplementsClause());
                if (this.context.hasAnnotationType(classTypeElement, "jsweet.lang.SyntacticIterable")) {
                    for (Tree tree : classTree.getImplementsClause()) {
                        TypeElement typeElement = (TypeElement)Util.getTypeElement(tree);
                        if (!typeElement.getQualifiedName().toString().equals(Iterable.class.getName())) continue;
                        arrayList.remove(tree);
                    }
                }
                for (Tree tree : classTree.getImplementsClause()) {
                    TypeElement typeElement = (TypeElement)Util.getTypeElement(tree);
                    if (!this.context.isFunctionalType(typeElement) && !this.getAdapter().eraseSuperInterface(classTypeElement, typeElement)) continue;
                    arrayList.remove(tree);
                }
                if (!arrayList.isEmpty()) {
                    if (!extendsInterface) {
                        if (this.getScope().interfaceScope) {
                            this.print(" extends ");
                        } else {
                            this.print(" implements ");
                        }
                    } else {
                        this.print(", ");
                    }
                    for (Tree tree : arrayList) {
                        Object t3 = Util.getType(tree);
                        this.disableTypeSubstitution = !this.getAdapter().isSubstituteSuperTypes();
                        this.substituteAndPrintType(tree);
                        this.disableTypeSubstitution = false;
                        implementedInterfaces.add((TypeMirror)t3);
                        this.print(", ");
                    }
                    this.removeLastChars(2);
                }
            }
            this.print(" {").println().startIndent();
        }
        this.getAdapter().beforeTypeBody(classTypeElement);
        if (this.getScope().innerClassNotStatic && !this.getScope().interfaceScope && !this.getScope().enumScope && !this.getScope().enumWrapperClassScope) {
            this.printIndent().print("public __parent: any;").println();
        }
        HashSet<MethodTree> injectedDefaultMethods = new HashSet<MethodTree>();
        HashMap<MethodTree, JSweetContext.DefaultMethodEntry> injectedDefaultMethodMap = new HashMap<MethodTree, JSweetContext.DefaultMethodEntry>();
        if (defaultMethods != null && !defaultMethods.isEmpty()) {
            for (JSweetContext.DefaultMethodEntry defaultMethodEntry : defaultMethods) {
                ExecutableElement executableElement = this.util().findMethodDeclarationInType2(classTypeElement, defaultMethodEntry.methodTree.getName().toString(), defaultMethodEntry.methodType);
                if (executableElement != null && executableElement != defaultMethodEntry.methodElement) continue;
                injectedDefaultMethods.add(defaultMethodEntry.methodTree);
                injectedDefaultMethodMap.put(defaultMethodEntry.methodTree, defaultMethodEntry);
            }
        }
        if (this.getScope().enumScope) {
            this.printIndent();
        }
        if (globals) {
            this.removeLastIndent();
        }
        for (Tree tree : classTree.getMembers()) {
            VariableTree variableTree;
            VariableElement variableElement;
            if (tree instanceof ClassTree) {
                this.getScope().hasInnerClass = true;
            }
            if (!(tree instanceof VariableTree) || (variableElement = (VariableElement)Util.getElement(variableTree = (VariableTree)tree)).getModifiers().contains((Object)Modifier.STATIC) || variableTree.getInitializer() == null) continue;
            this.getScope().fieldsWithInitializers.add(variableTree);
        }
        if (!(globals || this.getScope().enumScope || this.context.isInterface(classTypeElement) || this.context.getStaticInitializerCount(classTypeElement) <= 0)) {
            void var15_59;
            void var15_56;
            this.printIndent().print("static __static_initialized: boolean = false;").println();
            int n = this.context.getStaticInitializerCount(classTypeElement);
            String string = this.getClassName(classTypeElement) + ".";
            this.printIndent().print("static __static_initialize() { ");
            this.print("if (!" + string + "__static_initialized) { ");
            this.print(string + "__static_initialized = true; ");
            boolean bl5 = false;
            while (var15_56 < n) {
                this.print(string + "__static_initializer_" + (int)var15_56 + "(); ");
                ++var15_56;
            }
            this.print("} }").println().println();
            String string2 = this.getQualifiedTypeName(classTypeElement, globals, true);
            if (this.util().isPartOfAnEnum(classTypeElement)) {
                String string3 = string2 + ENUM_WRAPPER_CLASS_SUFFIX;
            }
            this.context.addTopFooterStatement((String)(StringUtils.isBlank((CharSequence)var15_59) ? "" : (String)var15_59 + ".__static_initialize();"));
        }
        boolean bl6 = false;
        ArrayList<? extends Tree> arrayList = new ArrayList<Tree>();
        arrayList.addAll(injectedDefaultMethods);
        arrayList.addAll(classTree.getMembers());
        if (this.context.options.isSortClassMembers()) {
            List list = arrayList.stream().filter(t -> t instanceof MethodTree || t instanceof VariableTree).sorted((t1, t2) -> this.getAdapter().getClassMemberComparator().compare((ExtendedElement)this.createExtendedElement((Tree)t1), (ExtendedElement)this.createExtendedElement((Tree)t2))).collect(Collectors.toList());
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList2.addAll(list);
            for (Tree tree : classTree.getMembers()) {
                if (arrayList2.contains(tree)) continue;
                arrayList2.add(tree);
            }
        }
        for (Tree tree : var14_46) {
            Object t4;
            if (injectedDefaultMethods.contains(tree)) {
                MethodTree methodTree = (MethodTree)tree;
                JSweetContext.DefaultMethodEntry defaultMethodEntry = (JSweetContext.DefaultMethodEntry)injectedDefaultMethodMap.get(methodTree);
                this.getScope().defaultMethodScope = true;
                this.getAdapter().typeVariablesToErase.addAll(((TypeElement)defaultMethodEntry.methodElement.getEnclosingElement()).getTypeParameters());
                if (this.context.useModules) {
                    UsedTypesScanner scanner = new UsedTypesScanner();
                    if (!this.context.hasAnnotationType(defaultMethodEntry.methodElement, "jsweet.lang.Erased")) {
                        if (this.context.hasAnnotationType(defaultMethodEntry.methodElement, "jsweet.lang.Replace")) {
                            scanner.scan(defaultMethodEntry.methodTree.getParameters(), trees);
                            scanner.scan(defaultMethodEntry.methodTree.getReturnType(), trees);
                            scanner.scan(defaultMethodEntry.methodTree.getThrows(), trees);
                            scanner.scan(defaultMethodEntry.methodTree.getTypeParameters(), trees);
                            scanner.scan((Tree)defaultMethodEntry.methodTree.getReceiverParameter(), trees);
                        } else {
                            scanner.scan((Tree)defaultMethodEntry.methodTree, trees);
                        }
                    }
                }
                if (!this.context.hasAnnotationType(defaultMethodEntry.methodElement, "jsweet.lang.Erased")) {
                    this.printIndent().print("/* Default method injected from " + defaultMethodEntry.enclosingClassElement.getQualifiedName() + " */").println();
                }
                this.printIndent().print(methodTree).println();
                this.getAdapter().typeVariablesToErase.removeAll(((TypeElement)defaultMethodEntry.methodElement.getEnclosingElement()).getTypeParameters());
                this.getScope().defaultMethodScope = false;
                continue;
            }
            if (this.getScope().interfaceScope && (t4 = Util.getElementNoErrors(tree)) != null && (tree instanceof MethodTree || tree instanceof VariableTree) && t4.getModifiers().contains((Object)Modifier.STATIC) || this.getScope().interfaceScope && tree instanceof MethodTree && this.util().isOverridingBuiltInJavaObjectMethod((ExecutableElement)Util.getElement(tree)) || tree instanceof ClassTree) continue;
            if (tree instanceof VariableTree) {
                if (this.getScope().enumScope && Util.getElement(tree).getKind() != ElementKind.ENUM_CONSTANT) {
                    this.getScope().isComplexEnum = true;
                    continue;
                }
                if (this.shouldPrintFieldInitializationInConstructor((VariableTree)tree)) {
                    bl2 = true;
                }
            }
            if (tree instanceof BlockTree && !((BlockTree)tree).isStatic()) {
                bl2 = true;
            }
            if (!this.getScope().enumScope) {
                this.printIndent();
            }
            int n = this.getCurrentPosition();
            this.print(tree);
            if (this.getScope().enumScope && tree.getKind() == Tree.Kind.VARIABLE && this.getScope().stringEnumScope) {
                this.print(" =  " + this.getStringLiteralQuote());
                this.print(tree);
                this.print(this.getStringLiteralQuote());
            }
            if (this.getCurrentPosition() == n) {
                if (this.getScope().enumScope) continue;
                this.removeLastIndent();
                continue;
            }
            if (tree instanceof VariableTree) {
                if (this.getScope().enumScope) {
                    this.print(", ");
                    continue;
                }
                if (this.getLastPrintedChar() != '}') {
                    this.print(";");
                }
                this.println().println();
                continue;
            }
            this.println().println();
        }
        if (!this.getScope().interfaceScope && classTree.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT)) {
            ArrayList<ExecutableElement> arrayList3 = new ArrayList<ExecutableElement>();
            for (TypeMirror typeMirror : implementedInterfaces) {
                this.context.grabMethodsToBeImplemented(arrayList3, (TypeElement)this.types().asElement(typeMirror));
            }
            arrayList3.sort((m1, m2) -> m1.getSimpleName().toString().compareTo(m2.getSimpleName().toString()));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (ExecutableElement executableElement : arrayList3) {
                OverloadScanner.Overload o;
                if (executableElement.getKind() != ElementKind.METHOD || this.context.hasAnnotationType(executableElement, "jsweet.lang.Erased") || this.isMappedOrErasedType(this.util().getParentElement(executableElement, TypeElement.class)) || this.getScope().generatedMethodNames.contains(executableElement.getSimpleName().toString())) continue;
                ExecutableType methodType = (ExecutableType)executableElement.asType();
                ExecutableElement s = this.util().findMethodDeclarationInType(classTypeElement, executableElement.getSimpleName().toString(), methodType, true);
                if (Object.class.getName().equals(s.getEnclosingElement().toString())) {
                    s = null;
                }
                boolean printAbstractDeclaration = false;
                if (s != null && !s.getEnclosingElement().equals(classTypeElement) && !s.isDefault() && (this.context.isInterface((TypeElement)s.getEnclosingElement()) || s.getModifiers().contains((Object)Modifier.ABSTRACT))) {
                    printAbstractDeclaration = true;
                }
                if (printAbstractDeclaration && (o = this.context.getOverload(classTypeElement, executableElement)) != null && o.getMethodsCount() > 1 && !o.isValid && !methodType.equals(o.getCoreEntry().methodType)) {
                    printAbstractDeclaration = false;
                }
                if (s != null && !printAbstractDeclaration) continue;
                String signature = this.getContext().types.erasure(methodType).toString();
                String methodName = executableElement.getSimpleName().toString();
                if (hashMap.containsKey(methodName) && ((String)hashMap.get(methodName)).equals(signature)) continue;
                this.printAbstractMethodDeclaration(executableElement);
                hashMap.put(methodName, signature);
            }
        }
        if (!(this.getScope().hasDeclaredConstructor || this.getScope().interfaceScope || this.getScope().enumScope || this.getScope().declareClassScope)) {
            HashSet<String> hashSet = new HashSet<String>();
            this.context.grabSupportedInterfaceNames(hashSet, classTypeElement, this.getAdapter());
            if (!hashSet.isEmpty() || this.getScope().innerClass || this.getScope().innerClassNotStatic || bl2) {
                TypeElement typeElement;
                int n;
                this.printIndent().print("constructor(");
                boolean bl7 = false;
                if (this.getScope().innerClassNotStatic) {
                    this.print("__parent: any");
                    boolean bl8 = true;
                }
                int n2 = n = this.scope.size() > 1 ? this.getScope((int)1).anonymousClasses.indexOf(classTree) : -1;
                if (n != -1) {
                    void var18_128;
                    boolean bl9 = false;
                    while (var18_128 < this.getScope((int)1).anonymousClassesConstructors.get(n).getArguments().size()) {
                        boolean bl10;
                        if (!bl10) {
                            bl10 = true;
                        } else {
                            this.print(", ");
                        }
                        this.print("__arg" + (int)var18_128 + ": any");
                        ++var18_128;
                    }
                    for (VariableElement v : this.getScope((int)1).finalVariables.get(n)) {
                        boolean bl11;
                        if (!bl11) {
                            bl11 = true;
                        } else {
                            this.print(", ");
                        }
                        this.print("private " + v.getSimpleName() + ": any");
                    }
                }
                this.print(") {").startIndent().println();
                if (classTree.getExtendsClause() != null && !this.getScope().removedSuperclass && !this.context.isInterface(typeElement = (TypeElement)Util.getTypeElement(classTree.getExtendsClause()))) {
                    this.printIndent().print("super(");
                    boolean hasArg = false;
                    if (this.getScope().innerClassNotStatic && typeElement.getEnclosingElement() instanceof TypeElement && !typeElement.getModifiers().contains((Object)Modifier.STATIC)) {
                        this.print(PARENT_CLASS_FIELD_NAME);
                        hasArg = true;
                    }
                    if (n != -1) {
                        for (int i = 0; i < this.getScope((int)1).anonymousClassesConstructors.get(n).getArguments().size(); ++i) {
                            if (hasArg) {
                                this.print(", ");
                            } else {
                                hasArg = true;
                            }
                            this.print("__arg" + i);
                        }
                    }
                    this.print(");").println();
                }
                this.printInstanceInitialization(classTree, null);
                this.endIndent().printIndent().print("}").println().println();
            }
        }
        this.removeLastChar();
        if (this.getScope().enumWrapperClassScope && !this.getScope((int)1).anonymousClasses.contains(classTree)) {
            this.printIndent().print("public name(): string { return this._$name; }").println();
            this.printIndent().print("public ordinal(): number { return this._$ordinal; }").println();
            this.printIndent().print("public compareTo(other: any): number { return this._$ordinal - (isNaN(other)?other._$ordinal:other); }").println();
        }
        if (this.getScope().enumScope) {
            this.removeLastChar().println();
        }
        this.getAdapter().afterTypeBody(classTypeElement);
        if (!globals) {
            this.endIndent().printIndent().print("}");
            if (!(this.getScope().interfaceScope || this.getScope().declareClassScope || this.getScope().enumScope || this.getScope().enumWrapperClassScope && classTypeElement.getNestingKind() == NestingKind.ANONYMOUS)) {
                if (classTypeElement.getNestingKind() != NestingKind.ANONYMOUS) {
                    this.println().printIndent().print((String)(this.getScope().enumWrapperClassScope ? classTypeElement.getSimpleName().toString() : name)).print("[" + this.getStringLiteralQuote() + CLASS_NAME_IN_CONSTRUCTOR + this.getStringLiteralQuote() + "] = ").print(this.getStringLiteralQuote() + classTypeElement.getQualifiedName().toString() + this.getStringLiteralQuote() + ";");
                }
                HashSet<String> hashSet = new HashSet<String>();
                this.context.grabSupportedInterfaceNames(hashSet, classTypeElement, this.getAdapter());
                if (!hashSet.isEmpty()) {
                    this.println().printIndent().print((String)(this.getScope().enumWrapperClassScope ? classTypeElement.getSimpleName().toString() : name)).print("[" + this.getStringLiteralQuote() + INTERFACES_FIELD_NAME + this.getStringLiteralQuote() + "] = ");
                    this.print("[");
                    for (String string : hashSet) {
                        this.print(this.getStringLiteralQuote()).print(string).print(this.getStringLiteralQuote() + ",");
                    }
                    this.removeLastChar();
                    this.print("];").println();
                }
                if (!this.getScope().enumWrapperClassScope) {
                    this.println();
                }
            }
        }
        if (this.getScope().isComplexEnum) {
            this.println().println().printIndent();
            this.visitClass(classTree, trees);
        }
        boolean bl12 = false;
        if (this.getScope().interfaceScope) {
            boolean bl13;
            for (Tree tree : classTree.getMembers()) {
                Object t5 = Util.getElementNoErrors(tree);
                if (!(tree instanceof MethodTree) && !(tree instanceof VariableTree) || !t5.getModifiers().contains((Object)Modifier.STATIC) || tree instanceof VariableTree && this.context.hasAnnotationType((Element)t5, "jsweet.lang.StringType", "jsweet.lang.Erased")) continue;
                if (!bl13) {
                    bl13 = true;
                    this.println().println().printIndent();
                    if (this.getIndent() != 0 || this.context.useModules || this.context.moduleBundleMode) {
                        this.print("export ");
                    } else if (this.isDefinitionScope) {
                        this.print("declare ");
                    }
                    this.print("namespace ").print(classTree.getSimpleName().toString()).print(" {").startIndent();
                }
                this.println().println().printIndent().print(tree);
                if (!(tree instanceof VariableTree)) continue;
                this.print(";");
            }
            if (bl13) {
                this.println().endIndent().printIndent().print("}").println();
            }
        }
        boolean bl14 = false;
        for (Tree tree : this.util().getSortedClassDeclarations(classTree.getMembers(), this.compilationUnit)) {
            boolean bl15;
            ClassTree classTree2;
            if (!(tree instanceof ClassTree) || this.context.isIgnored(classTree2 = (ClassTree)tree, this.compilationUnit)) continue;
            if (!bl15) {
                bl15 = true;
                this.println().println().printIndent();
                if (!this.isTopLevelScope() || this.context.useModules || this.context.moduleBundleMode) {
                    this.print("export ");
                } else if (this.isDefinitionScope) {
                    this.print("declare ");
                }
                this.print("namespace ").print((String)name).print(" {").startIndent();
            }
            this.getScope().isInnerClass = true;
            this.println().println().printIndent().print(classTree2);
            this.getScope().isInnerClass = false;
        }
        for (ClassTree classTree3 : this.getScope().anonymousClasses) {
            boolean bl16;
            if (!bl16) {
                bl16 = true;
                this.println().println().printIndent();
                if (!this.isTopLevelScope() || this.context.useModules || this.context.moduleBundleMode) {
                    this.print("export ");
                }
                this.print("namespace ").print((String)name).print(" {").startIndent();
            }
            this.getScope().isAnonymousClass = true;
            this.println().println().printIndent().print(classTree3);
            this.getScope().isAnonymousClass = false;
        }
        for (ClassTree classTree4 : this.getScope().localClasses) {
            if (!bl) {
                bl = true;
                this.println().println().printIndent();
                if (!this.isTopLevelScope() || this.context.useModules) {
                    this.print("export ");
                }
                this.print("namespace ").print((String)name).print(" {").startIndent();
            }
            this.getScope().isLocalClass = true;
            this.println().println().printIndent().print(classTree4);
            this.getScope().isLocalClass = false;
        }
        if (bl) {
            this.println().endIndent().printIndent().print("}").println();
        }
        if (this.getScope().enumScope && this.getScope().isComplexEnum && !this.getScope().anonymousClasses.contains(classTree)) {
            this.println().printIndent().print(classTypeElement.getSimpleName().toString()).print("[" + this.getStringLiteralQuote() + ENUM_WRAPPER_CLASS_WRAPPERS + this.getStringLiteralQuote() + "] = {");
            boolean bl17 = false;
            for (Tree tree : classTree.getMembers()) {
                Object memberElement = Util.getElementNoErrors(tree);
                if (!(tree instanceof VariableTree) || memberElement.getKind() != ElementKind.ENUM_CONSTANT) continue;
                VariableTree varDecl = (VariableTree)tree;
                NewClassTree newClass = (NewClassTree)varDecl.getInitializer();
                ClassTree clazz = classTree;
                try {
                    void var16_100;
                    if (this.getScope().stringEnumScope) {
                        this.print(this.getStringLiteralQuote());
                        this.print(memberElement.getSimpleName().toString());
                        this.print(this.getStringLiteralQuote());
                    } else {
                        this.print("" + (int)var16_100);
                    }
                    this.print(": ");
                    int anonymousClassIndex = this.getScope().anonymousClasses.indexOf(newClass.getClassBody());
                    if (anonymousClassIndex >= 0) {
                        this.print("new ").print(clazz.getSimpleName().toString() + "." + clazz.getSimpleName().toString() + ANONYMOUS_PREFIX + anonymousClassIndex + ENUM_WRAPPER_CLASS_SUFFIX).print("(");
                    } else {
                        this.print("new ").print(clazz.getSimpleName().toString() + ENUM_WRAPPER_CLASS_SUFFIX).print("(");
                    }
                    this.print((int)(++var16_100) + ", ");
                    this.print(this.getStringLiteralQuote() + memberElement.getSimpleName().toString() + this.getStringLiteralQuote());
                    if (!newClass.getArguments().isEmpty()) {
                        this.print(", ");
                    }
                    this.printArgList(null, newClass.getArguments()).print(")");
                    this.print(", ");
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            this.removeLastChars(2);
            this.print("};").println();
        }
        if (this.getScope().mainMethod != null && this.getScope().mainMethod.getParameters().size() < 2 && this.getScope().getMainMethodElement().getEnclosingElement().equals(classTypeElement)) {
            void var17_121;
            void var16_103;
            String string = this.getQualifiedTypeName(classTypeElement, globals, true);
            if (this.util().isPartOfAnEnum(classTypeElement)) {
                String string4 = string + ENUM_WRAPPER_CLASS_SUFFIX;
            }
            void var17_119 = var16_103;
            if (!StringUtils.isBlank((CharSequence)var16_103)) {
                String string5 = (String)var16_103 + ".";
            }
            this.context.entryFiles.add(new File(this.compilationUnit.getSourceFile().getName()));
            this.context.addFooterStatement((String)var17_121 + "main(" + (this.getScope().mainMethod.getParameters().isEmpty() ? "" : "null") + ");");
        }
        this.getAdapter().typeVariablesToErase.removeAll(parentTypeVars);
        this.exitScope();
        this.getAdapter().afterType(classTypeElement);
        return Java2TypeScriptTranslator.returnNothing();
    }

    private void printAbstractMethodDeclaration(ExecutableElement method) {
        this.printIndent().print("public abstract ").print(method.getSimpleName().toString());
        this.print("(");
        if (method.getParameters() != null && !method.getParameters().isEmpty()) {
            for (VariableElement variableElement : method.getParameters()) {
                this.print(variableElement.getSimpleName().toString()).print("?: any");
                this.print(", ");
            }
            this.removeLastChars(2);
        }
        this.print(")");
        this.print(": any;").println();
    }

    private String getTSMethodName(MethodTree methodDecl) {
        String name;
        ExecutableElement methodElement = (ExecutableElement)Util.getElement(methodDecl);
        switch (name = this.context.getActualName(methodElement)) {
            case "<init>": {
                return "constructor";
            }
            case "$apply": 
            case "$applyStatic": {
                return "";
            }
            case "apply": 
            case "applyStatic": {
                if (this.context.deprecatedApply) {
                    return "";
                }
                return name;
            }
            case "$new": {
                return "new";
            }
        }
        if (this.context.hasMethodNameMapping(methodElement)) {
            return this.context.getMethodNameMapping(methodElement);
        }
        return name;
    }

    protected boolean isDebugMode(MethodTree methodDecl) {
        ExecutableElement methodElement = (ExecutableElement)Util.getElement(methodDecl);
        return methodDecl != null && !this.getScope().constructor && this.context.options.isDebugMode() && !this.context.hasAnnotationType(methodElement, "jsweet.lang.NoDebug") && !this.context.hasAnnotationType(methodElement.getEnclosingElement(), "jsweet.lang.NoDebug");
    }

    private boolean isInterfaceMethod(ClassTree parent, MethodTree method) {
        ExecutableElement methodElement = (ExecutableElement)Util.getElement(method);
        TypeElement parentElement = (TypeElement)Util.getElement(parent);
        return this.context.isInterface(parentElement) && !methodElement.getModifiers().contains((Object)Modifier.STATIC);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitMethod(MethodTree methodTree, Trees trees) {
        VariableElement v;
        ExecutableElement methodElement = (ExecutableElement)Util.getElement(methodTree);
        if (this.getAdapter().substituteExecutable(methodElement)) {
            return Java2TypeScriptTranslator.returnNothing();
        }
        if (this.context.hasAnnotationType(methodElement, "jsweet.lang.Erased")) {
            return Java2TypeScriptTranslator.returnNothing();
        }
        ClassTree parent = (ClassTree)this.getParent();
        TypeElement parentElement = (TypeElement)Util.getElement(parent);
        if (!this.getScope().enumWrapperClassScope && parent != null && this.util().isGeneratedConstructor(methodTree, parent, methodElement)) {
            return Java2TypeScriptTranslator.returnNothing();
        }
        if ("$get".equals(methodTree.getName().toString()) && methodTree.getParameters().size() == 1) {
            this.print("[").print(methodTree.getParameters().get(0)).print("]: ");
            this.substituteAndPrintType(methodTree.getReturnType()).print(";");
            return Java2TypeScriptTranslator.returnNothing();
        }
        boolean bl = this.getScope().constructor = methodElement.getKind() == ElementKind.CONSTRUCTOR;
        if (this.getScope().enumScope) {
            if (this.getScope().constructor) {
                if (parent != null && this.util().getStartPosition(methodTree, this.getCompilationUnit()) != this.util().getStartPosition(parent, this.getCompilationUnit())) {
                    this.getScope().isComplexEnum = true;
                }
            } else {
                this.getScope().isComplexEnum = true;
            }
            return Java2TypeScriptTranslator.returnNothing();
        }
        if (this.getScope().isDeclareClassScope() && parent.getExtendsClause() != null && !this.getScope().constructor) {
            TypeElement superTypeElement = (TypeElement)Util.getTypeElement(parent.getExtendsClause());
            ExecutableElement superMethod = this.util().findMethodDeclarationInType(superTypeElement, methodTree.getName().toString(), (ExecutableType)Util.getType(methodTree));
            if (superMethod != null && this.util().isSourceElement(superMethod)) {
                return Java2TypeScriptTranslator.returnNothing();
            }
        }
        OverloadScanner.Overload overload = null;
        boolean inOverload = false;
        boolean inCoreWrongOverload = false;
        if (parent != null) {
            overload = this.context.getOverload(parentElement, methodElement);
            boolean bl2 = inOverload = overload != null && overload.getMethodsCount() > 1;
            if (inOverload) {
                if (!overload.isValid) {
                    if (!this.printCoreMethodDelegate) {
                        if (overload.getCoreMethod().equals(methodTree)) {
                            inCoreWrongOverload = true;
                            if (!this.isInterfaceMethod(parent, methodTree) && methodElement.getKind() != ElementKind.CONSTRUCTOR && parentElement.equals(overload.getCoreMethodElement().getEnclosingElement())) {
                                this.printCoreMethodDelegate = true;
                                this.visitMethod(overload.getCoreMethod(), trees);
                                this.println().println().printIndent();
                                this.printCoreMethodDelegate = false;
                            }
                        } else {
                            if (methodElement.getKind() == ElementKind.CONSTRUCTOR) {
                                return Java2TypeScriptTranslator.returnNothing();
                            }
                            boolean addCoreMethod = false;
                            boolean bl3 = addCoreMethod = !overload.printed && overload.getCoreMethodElement().getEnclosingElement() != parentElement && !overload.getCoreMethodElement().getModifiers().contains((Object)Modifier.DEFAULT) && (!overload.getCoreMethodElement().getModifiers().contains((Object)Modifier.ABSTRACT) || this.isInterfaceMethod(parent, methodTree) || !this.types().isSubtype(parentElement.asType(), overload.getCoreMethodElement().getEnclosingElement().asType()));
                            if (!overload.printed && !addCoreMethod && overload.getCoreMethodElement().getKind() == ElementKind.METHOD) {
                                boolean bl4 = addCoreMethod = this.util().findMethodDeclarationInType(parentElement, methodTree.getName().toString(), (ExecutableType)overload.getCoreMethodElement().asType()) == null;
                            }
                            if (addCoreMethod) {
                                this.visitMethod(overload.getCoreMethod(), trees);
                                overload.printed = true;
                                if (!this.isInterfaceMethod(parent, methodTree)) {
                                    this.println().println().printIndent();
                                }
                            }
                            if (this.isInterfaceMethod(parent, methodTree)) {
                                return Java2TypeScriptTranslator.returnNothing();
                            }
                        }
                    }
                } else if (!overload.getCoreMethod().equals(methodTree)) {
                    return Java2TypeScriptTranslator.returnNothing();
                }
            }
        }
        boolean ambient = this.context.hasAnnotationType(methodElement, "jsweet.lang.Ambient");
        if (inOverload && !inCoreWrongOverload && (ambient || this.isDefinitionScope)) {
            return Java2TypeScriptTranslator.returnNothing();
        }
        if (this.isDebugMode(methodTree)) {
            this.printMethodModifiers(methodTree, parent, this.getScope().constructor, inOverload, overload);
            this.print(this.getTSMethodName(methodTree)).print("(");
            this.printArgList(null, methodTree.getParameters());
            this.print("): ");
            this.substituteAndPrintType(methodTree.getReturnType());
            this.print(" {").println();
            this.startIndent().printIndent();
            if (!this.util().isVoidType(methodElement.getReturnType())) {
                this.print("return ");
            }
            this.print("__debug_exec('" + (parentElement == null ? "null" : parentElement.getQualifiedName()) + "', '" + methodTree.getName() + "', ");
            if (!methodTree.getParameters().isEmpty()) {
                this.print("[");
                for (VariableTree variableTree : methodTree.getParameters()) {
                    this.print("'" + variableTree.getName() + "', ");
                }
                this.removeLastChars(2);
                this.print("]");
            } else {
                this.print("undefined");
            }
            this.print(", this, arguments, ");
            if (methodElement.getModifiers().contains((Object)Modifier.STATIC)) {
                this.print(methodElement.getEnclosingElement().getSimpleName().toString());
            } else {
                this.print("this");
            }
            this.print(".__generator_" + this.getTSMethodName(methodTree) + "(");
            for (VariableTree variableTree : methodTree.getParameters()) {
                VariableElement paramElement = (VariableElement)Util.getElement(variableTree);
                this.print(this.context.getActualName(paramElement) + ", ");
            }
            if (!methodTree.getParameters().isEmpty()) {
                this.removeLastChars(2);
            }
            this.print("));");
            this.println().endIndent().printIndent();
            this.print("}").println().println().printIndent();
        }
        if (inOverload && !overload.isValid) {
            for (MethodTree methodTree2 : overload.getMethods()) {
                if (methodTree2 == methodTree) continue;
                for (AnnotationTree annotationTree : methodTree2.getModifiers().getAnnotations()) {
                    if (methodTree.getModifiers().getAnnotations().stream().anyMatch(a -> a.getAnnotationType().toString().equals(anno.getAnnotationType().toString()))) continue;
                    this.util().addAnnotation(methodTree.getModifiers(), annotationTree);
                }
            }
        }
        this.print(methodTree.getModifiers());
        if (methodTree.getModifiers().getFlags().contains((Object)Modifier.NATIVE)) {
            if (!(this.getScope().declareClassScope || ambient || this.getScope().interfaceScope)) {
                this.report((Tree)methodTree, methodTree.getName(), JSweetProblem.NATIVE_MODIFIER_IS_NOT_ALLOWED, methodTree.getName());
            }
        } else if (this.getScope().declareClassScope && !this.getScope().constructor && !this.getScope().interfaceScope && !methodTree.getModifiers().getFlags().contains((Object)Modifier.DEFAULT)) {
            this.report((Tree)methodTree, methodTree.getName(), JSweetProblem.INVALID_METHOD_BODY_IN_INTERFACE, methodTree.getName(), parent == null ? "<no class>" : parent.getSimpleName());
        }
        if (methodTree.getName().toString().equals("constructor")) {
            this.report((Tree)methodTree, methodTree.getName(), JSweetProblem.CONSTRUCTOR_MEMBER, new Object[0]);
        }
        if (parent != null && (v = this.util().findFieldDeclaration(parentElement, methodTree.getName())) != null && this.context.getFieldNameMapping(v) == null) {
            if (this.isDefinitionScope) {
                return Java2TypeScriptTranslator.returnNothing();
            }
            if (methodTree.getName().toString().equals(this.context.getActualName(v))) {
                this.report((Tree)methodTree, methodTree.getName(), JSweetProblem.METHOD_CONFLICTS_FIELD, methodTree.getName(), parentElement);
            }
        }
        if ("main".equals(methodTree.getName().toString()) && methodTree.getModifiers().getFlags().contains((Object)Modifier.STATIC) && !this.context.hasAnnotationType(methodElement, "jsweet.lang.Disabled") && (this.scope.size() == 1 || this.scope.size() == 2 && this.getScope().enumWrapperClassScope)) {
            this.getScope().mainMethod = methodTree;
        }
        boolean globals = parent == null ? false : "Globals".equals(parent.getSimpleName().toString());
        boolean bl5 = globals = globals || this.getScope().interfaceScope && methodTree.getModifiers().getFlags().contains((Object)Modifier.STATIC);
        if (!inOverload || inCoreWrongOverload) {
            this.printDocComment(methodTree);
        }
        if (parent == null) {
            this.printAsyncKeyword(methodTree);
            this.print("function ");
        } else if (globals) {
            if (this.getScope().constructor && methodElement.getModifiers().contains((Object)Modifier.PRIVATE) && methodTree.getParameters().isEmpty()) {
                return Java2TypeScriptTranslator.returnNothing();
            }
            if (this.getScope().constructor) {
                this.report((Tree)methodTree, methodTree.getName(), JSweetProblem.GLOBAL_CONSTRUCTOR_DEF, new Object[0]);
                return Java2TypeScriptTranslator.returnNothing();
            }
            if (this.context.lookupDecoratorAnnotation((parentElement.getQualifiedName() + "." + methodTree.getName()).replace("Globals.", "")) != null && !this.getScope().decoratorScope) {
                return Java2TypeScriptTranslator.returnNothing();
            }
            if (!methodTree.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                this.report((Tree)methodTree, methodTree.getName(), JSweetProblem.GLOBALS_CAN_ONLY_HAVE_STATIC_MEMBERS, new Object[0]);
                return Java2TypeScriptTranslator.returnNothing();
            }
            if (this.context.hasAnnotationType(methodElement, "jsweet.lang.Module")) {
                this.getContext().addExportedElement(this.context.getAnnotationValue(methodElement, "jsweet.lang.Module", String.class, null), methodElement, this.getCompilationUnit());
            }
            if (this.context.useModules || this.context.moduleBundleMode) {
                if (!methodTree.getModifiers().getFlags().contains((Object)Modifier.PRIVATE)) {
                    this.print("export ");
                }
            } else if (!this.isTopLevelScope()) {
                this.print("export ");
            }
            if (ambient || this.getIndent() == 0 && this.isDefinitionScope) {
                this.print("declare ");
            }
            this.printAsyncKeyword(methodTree);
            this.print("function ");
        } else {
            this.printMethodModifiers(methodTree, parent, this.getScope().constructor, inOverload, overload);
            this.printAsyncKeyword(methodTree);
            if (ambient) {
                this.report((Tree)methodTree, methodTree.getName(), JSweetProblem.WRONG_USE_OF_AMBIENT, methodTree.getName());
            }
        }
        if (parent == null || !this.context.isFunctionalType((Element)Util.getTypeElement(parent))) {
            if (this.isDebugMode(methodTree)) {
                this.print("*").print(GENERATOR_PREFIX);
            }
            if (inOverload && !overload.isValid && !inCoreWrongOverload) {
                this.print(this.getOverloadMethodName(methodElement));
            } else {
                String string = this.getTSMethodName(methodTree);
                this.getScope().generatedMethodNames.add(string);
                if (this.doesMemberNameRequireQuotes(string)) {
                    this.print("'" + string + "'");
                } else {
                    this.print(string);
                }
            }
        }
        if (inOverload && inCoreWrongOverload) {
            int n;
            boolean bl6 = false;
            for (OverloadScanner.OverloadMethodEntry overloadMethodEntry : overload.getEntries()) {
                n = Math.max(n, overloadMethodEntry.methodElement.getTypeParameters().size());
            }
            if (n > 0) {
                this.print("<");
                for (int i = 0; i < n; ++i) {
                    this.print("T" + i + " = any, ");
                }
                this.removeLastChars(2);
                this.print(">");
            }
        } else if (methodTree.getTypeParameters() != null && !methodTree.getTypeParameters().isEmpty() || this.getContext().getWildcards(methodElement) != null) {
            this.inTypeParameters = true;
            this.print("<");
            if (methodTree.getTypeParameters() != null && !methodTree.getTypeParameters().isEmpty()) {
                this.printArgList(null, methodTree.getTypeParameters());
                if (this.getContext().getWildcards(methodElement) != null) {
                    this.print(", ");
                }
            }
            if (this.getContext().getWildcards(methodElement) != null) {
                this.printArgList(null, this.getContext().getWildcards(methodElement), this::substituteAndPrintType);
            }
            this.print(">");
            this.inTypeParameters = false;
        }
        this.print("(");
        this.printMethodArgs(methodTree, overload, inOverload, inCoreWrongOverload, this.getScope());
        this.print(")");
        this.printMethodReturnDeclaration(methodTree, overload, inCoreWrongOverload);
        if (inCoreWrongOverload && this.isInterfaceMethod(parent, methodTree)) {
            this.print(";");
            return Java2TypeScriptTranslator.returnNothing();
        }
        if (methodTree.getBody() == null && (!inCoreWrongOverload || this.getScope().declareClassScope) || methodTree.getModifiers().getFlags().contains((Object)Modifier.DEFAULT) && !this.getScope().defaultMethodScope) {
            if (!this.getScope().interfaceScope && methodTree.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT) && inOverload && !overload.isValid) {
                this.print(" {");
                this.print(" throw new Error('cannot invoke abstract overloaded method... check your argument(s) type(s)'); ");
                this.print("}");
            } else {
                this.print(";");
            }
        } else {
            if (!this.getScope().declareClassScope && this.getScope().interfaceScope && !methodTree.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                this.report((Tree)methodTree, methodTree.getName(), JSweetProblem.INVALID_METHOD_BODY_IN_INTERFACE, methodTree.getName(), parent == null ? "<no class>" : parent.getSimpleName());
            }
            if (this.getScope().declareClassScope) {
                if (!this.getScope().constructor || methodTree.getBody() != null && methodTree.getBody().getStatements().isEmpty()) {
                    this.report((Tree)methodTree, methodTree.getName(), JSweetProblem.INVALID_METHOD_BODY_IN_INTERFACE, methodTree.getName(), parent == null ? "<no class>" : parent.getSimpleName());
                }
                this.print(";");
            } else if (inCoreWrongOverload) {
                this.print(" {").println().startIndent().printIndent();
                this.printCoreOverloadMethodBody(methodTree, parent, overload);
                this.print(" else throw new Error('invalid overload');");
                this.endIndent().println().printIndent().print("}");
            } else {
                this.print(" ").print("{").println().startIndent();
                if (!this.getAdapter().substituteMethodBody(parentElement, methodElement)) {
                    void var11_32;
                    void var11_30;
                    void var11_24;
                    Object var11_22 = null;
                    if (this.context.hasAnnotationType(methodElement, "jsweet.lang.Replace")) {
                        String string = this.context.getAnnotationValue(methodElement, "jsweet.lang.Replace", String.class, null);
                    }
                    boolean fieldsInitPrinted = false;
                    int n = this.getCurrentPosition();
                    if (var11_24 == null || BODY_MARKER.matcher((CharSequence)var11_24).find()) {
                        this.enter(methodTree.getBody());
                        List<? extends StatementTree> statements = methodTree.getBody().getStatements();
                        if (!statements.isEmpty() && statements.get(0).toString().startsWith("super(")) {
                            this.printBlockStatement(statements.get(0));
                            if (parent != null) {
                                this.printInstanceInitialization(parent, methodElement);
                                fieldsInitPrinted = true;
                            }
                            this.printBlockStatements(statements.subList(1, statements.size()));
                        } else {
                            if (parent != null) {
                                this.printInstanceInitialization(parent, methodElement);
                                fieldsInitPrinted = true;
                            }
                            this.printBlockStatements(statements);
                        }
                        this.exit();
                        if (var11_24 != null) {
                            String orgBody = this.getOutput().substring(n);
                            this.removeLastChars(this.getCurrentPosition() - n);
                            String string4 = BODY_MARKER.matcher((CharSequence)var11_24).replaceAll(orgBody);
                            string4 = BASE_INDENT_MARKER.matcher(string4).replaceAll(this.getIndentString());
                            string4 = INDENT_MARKER.matcher(string4).replaceAll("    ");
                            string4 = METHOD_NAME_MARKER.matcher(string4).replaceAll(methodTree.getName().toString());
                            TypeElement parentTypeElement = (TypeElement)Util.getElement(parent);
                            String string5 = CLASS_NAME_MARKER.matcher(string4).replaceAll(parentTypeElement.getQualifiedName().toString());
                        }
                    }
                    if (var11_30 != null && var11_30.trim().startsWith("super(")) {
                        String superCall = var11_30.substring(0, var11_30.indexOf(59) + 1);
                        String string = var11_30.substring(var11_30.indexOf(59) + 1);
                        this.println(superCall);
                    }
                    if (!fieldsInitPrinted && parent != null) {
                        this.printInstanceInitialization(parent, methodElement);
                        fieldsInitPrinted = true;
                    }
                    if (var11_32 != null) {
                        if (methodElement.getKind() == ElementKind.CONSTRUCTOR) {
                            this.getScope().hasDeclaredConstructor = true;
                        }
                        this.printIndent().print((String)var11_32).println();
                    }
                }
                this.endIndent().printIndent().print("}");
            }
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    private void printCoreOverloadMethodBody(MethodTree methodDecl, ClassTree parent, OverloadScanner.Overload overload) {
        if (this.getAdapter().substituteOverloadMethodBody((TypeElement)Util.getElement(parent), overload)) {
            return;
        }
        boolean wasPrinted = false;
        for (OverloadScanner.OverloadMethodEntry overloadMethodEntry : overload.getEntries()) {
            MethodTree method = overloadMethodEntry.methodTree;
            ExecutableElement methodElement = overloadMethodEntry.methodElement;
            if (this.context.isInterface((TypeElement)methodElement.getEnclosingElement()) && !method.getModifiers().getFlags().contains((Object)Modifier.DEFAULT) && !method.getModifiers().getFlags().contains((Object)Modifier.STATIC)) continue;
            TypeElement parentElement = (TypeElement)Util.getElement(parent);
            if (!this.util().isParent(parentElement, (TypeElement)methodElement.getEnclosingElement())) continue;
            if (wasPrinted) {
                this.print(" else ");
            }
            wasPrinted = true;
            this.print("if (");
            this.printMethodParamsTest(overload, overloadMethodEntry);
            this.print(") ");
            if (methodElement.getKind() == ElementKind.CONSTRUCTOR || methodElement.getModifiers().contains((Object)Modifier.DEFAULT) && method.equals(overload.getCoreMethod())) {
                this.printInlinedMethod(overload, method, methodDecl.getParameters());
                continue;
            }
            if (parentElement != methodElement.getEnclosingElement() && this.context.getOverload((TypeElement)methodElement.getEnclosingElement(), methodElement).getCoreMethod() == method) {
                this.print("{").println().startIndent().printIndent();
                if ((method.getBody() == null || method.getModifiers().getFlags().contains((Object)Modifier.DEFAULT) && !this.getScope().defaultMethodScope) && !this.getScope().interfaceScope && method.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT)) {
                    this.print(" throw new Error('cannot invoke abstract overloaded method... check your argument(s) type(s)'); ");
                } else {
                    String tsMethodAccess = this.getTSMemberAccess(this.getTSMethodName(methodDecl), true);
                    if (!"void".equals(Util.getType(method.getReturnType()).toString())) {
                        this.print("return ");
                    }
                    this.print("super" + tsMethodAccess);
                    this.print("(");
                    for (int j = 0; j < method.getParameters().size(); ++j) {
                        this.print(this.avoidJSKeyword(overload.getCoreMethod().getParameters().get(j).getName().toString())).print(", ");
                    }
                    if (!method.getParameters().isEmpty()) {
                        this.removeLastChars(2);
                    }
                    this.print(");");
                }
                this.println().endIndent().printIndent().print("}");
                continue;
            }
            this.print("{").println().startIndent().printIndent();
            this.print("return <any>");
            if (this.isAsyncMethod(method)) {
                this.print("await ");
            }
            if (!this.util().isGlobalsClassName(parent.getSimpleName().toString())) {
                if (methodElement.getModifiers().contains((Object)Modifier.STATIC)) {
                    this.print(this.getQualifiedTypeName(parentElement, false, false).toString());
                    if (this.util().isPartOfAnEnum(parentElement)) {
                        this.print(ENUM_WRAPPER_CLASS_SUFFIX);
                    }
                } else {
                    this.print("this");
                }
                this.print(".");
            }
            this.print(this.getOverloadMethodName(methodElement)).print("(");
            for (int j = 0; j < method.getParameters().size(); ++j) {
                if (j == method.getParameters().size() - 1 && this.util().hasVarargs(methodElement)) {
                    this.print("...");
                } else if (j == method.getParameters().size() - 1 && this.util().hasVarargs(overload.getCoreMethodElement())) {
                    this.print("<any>");
                }
                this.print(this.avoidJSKeyword(overload.getCoreMethod().getParameters().get(j).getName().toString())).print(", ");
            }
            if (!method.getParameters().isEmpty()) {
                this.removeLastChars(2);
            }
            this.print(");");
            this.println().endIndent().printIndent().print("}");
        }
    }

    protected void printMethodReturnDeclaration(MethodTree methodTree, OverloadScanner.Overload overload, boolean inCoreWrongOverload) {
        ExecutableElement methodElement = (ExecutableElement)Util.getElement(methodTree);
        if (methodTree.getReturnType() != null) {
            Object returnTypeElement = Util.getTypeElement(methodTree.getReturnType());
            Object returnType = Util.getType(methodTree.getReturnType());
            if (returnType.getKind() != TypeKind.VOID) {
                boolean promisify;
                this.print(": ");
                boolean bl = promisify = this.isAsyncMethod(methodTree) && (returnTypeElement == null || !this.util().getQualifiedName((Element)returnTypeElement).endsWith(".Promise"));
                if (promisify) {
                    this.print("Promise<");
                }
                boolean eraseOverloadsReturnTypeToAny = false;
                if (inCoreWrongOverload && methodElement.getKind() != ElementKind.CONSTRUCTOR) {
                    for (OverloadScanner.OverloadMethodEntry overloadEntry : overload.getEntries()) {
                        if (this.context.types.isSameType((TypeMirror)returnType, overloadEntry.methodElement.getReturnType())) continue;
                        eraseOverloadsReturnTypeToAny = true;
                        break;
                    }
                }
                if (eraseOverloadsReturnTypeToAny) {
                    this.print("any");
                } else {
                    this.substituteAndPrintType(methodTree.getReturnType());
                }
                if (promisify) {
                    this.print(">");
                }
            }
        }
    }

    protected void printAsyncKeyword(MethodTree methodDecl) {
        if (this.getScope().declareClassScope || this.getScope().interfaceScope) {
            return;
        }
        if (this.isAsyncMethod(methodDecl)) {
            this.print("async ");
        }
    }

    protected boolean isAsyncMethod(MethodTree methodTree) {
        return this.context.hasAnnotationType((Element)Util.getElement(methodTree), "jsweet.lang.Async");
    }

    protected void printMethodArgs(MethodTree methodTree, OverloadScanner.Overload overload, boolean inOverload, boolean inCoreWrongOverload, ClassScope scope) {
        ExecutableElement methodElement = (ExecutableElement)Util.getElement(methodTree);
        boolean isWrapped = false;
        if (this.context.hasAnnotationType(methodElement, "jsweet.lang.WrapParameters")) {
            isWrapped = true;
        }
        if (isWrapped) {
            this.print("{");
        }
        if (inCoreWrongOverload) {
            scope.setEraseVariableTypes(true);
        }
        boolean paramPrinted = false;
        if (scope.isInnerClassNotStatic() && methodElement.getKind() == ElementKind.CONSTRUCTOR && !scope.isEnumWrapperClassScope()) {
            this.print("__parent: any, ");
            paramPrinted = true;
        }
        if (scope.isConstructor() && scope.isEnumWrapperClassScope()) {
            this.print((this.isAnonymousClass() ? "" : "protected ") + "_$ordinal: number, ");
            this.print((this.isAnonymousClass() ? "" : "protected ") + "_$name: string, ");
            paramPrinted = true;
        }
        int i = 0;
        for (VariableTree variableTree : methodTree.getParameters()) {
            if (isWrapped) {
                this.print(variableTree.getName().toString());
            } else {
                this.print(variableTree);
            }
            if (inOverload && overload.isValid && overload.defaultValues.get(i) != null) {
                this.print(" = ").print(overload.defaultValues.get(i));
            }
            this.print(", ");
            ++i;
            paramPrinted = true;
        }
        if (inCoreWrongOverload) {
            scope.setEraseVariableTypes(false);
        }
        if (paramPrinted) {
            this.removeLastChars(2);
        }
        if (isWrapped) {
            this.print("}: {");
            for (VariableTree variableTree : methodTree.getParameters()) {
                this.print(variableTree).println(";");
            }
            this.print("}");
        }
    }

    protected void printMethodModifiers(MethodTree methodDecl, ClassTree parent, boolean constructor, boolean inOverload, OverloadScanner.Overload overload) {
        if ((methodDecl.getModifiers().getFlags().contains((Object)Modifier.PUBLIC) || inOverload && overload.getCoreMethod().equals(methodDecl)) && !this.getScope().interfaceScope) {
            this.print("public ");
        }
        if (methodDecl.getModifiers().getFlags().contains((Object)Modifier.PRIVATE) && !constructor && !this.getScope().innerClass) {
            if (!this.getScope().interfaceScope) {
                if (!(inOverload && overload.getCoreMethod().equals(methodDecl) || this.getScope().hasInnerClass)) {
                    this.print("/*private*/ ");
                }
            } else if (!inOverload || !overload.getCoreMethod().equals(methodDecl)) {
                this.report((Tree)methodDecl, methodDecl.getName(), JSweetProblem.INVALID_PRIVATE_IN_INTERFACE, methodDecl.getName(), parent == null ? "<no class>" : parent.getSimpleName());
            }
        }
        if (methodDecl.getModifiers().getFlags().contains((Object)Modifier.STATIC) && !this.getScope().interfaceScope) {
            this.print("static ");
        }
        if (methodDecl.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT) && !this.getScope().interfaceScope && !inOverload) {
            this.print("abstract ");
        }
    }

    private boolean shouldPrintFieldInitializationInConstructor(VariableTree var) {
        VariableElement varElement = (VariableElement)Util.getElement(var);
        if (varElement.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        return var.getInitializer() == null || !this.getScope().hasConstructorOverloadWithSuperClass && this.getScope().getFieldsWithInitializers().contains(var);
    }

    protected void printVariableInitialization(ClassTree clazz, VariableTree var) {
        VariableElement varElement = (VariableElement)Util.getElement(var);
        String name = var.getName().toString();
        name = this.context.getFieldNameMapping(varElement) != null ? this.context.getFieldNameMapping(varElement) : this.getIdentifier(varElement);
        if (this.getScope().innerClassNotStatic && !this.util().isConstantOrNullField(var) || var.getInitializer() != null && this.shouldPrintFieldInitializationInConstructor(var)) {
            if (this.doesMemberNameRequireQuotes(name)) {
                this.printIndent().print("this['").print(name).print("'] = ");
            } else {
                this.printIndent().print("this.").print(name).print(" = ");
            }
            this.substituteAndPrintAssignedExpression(varElement.asType(), var.getInitializer());
            this.print(";").println();
        } else if (var.getInitializer() == null) {
            if (this.doesMemberNameRequireQuotes(name)) {
                this.printIndent();
                this.print("if (").print("this['").print(name).print("']").print(" === undefined) { ");
                if (this.context.options.isNonEnumerableTransients() && varElement.getModifiers().contains((Object)Modifier.TRANSIENT)) {
                    this.print("Object.defineProperty(this, " + this.getStringLiteralQuote() + name + this.getStringLiteralQuote() + ", { value: ").print(this.getAdapter().getVariableInitialValue(varElement)).print(", enumerable: false }); } ").println();
                } else {
                    this.print("this['").print(name).print("'] = ").print(this.getAdapter().getVariableInitialValue(varElement)).print("; } ").println();
                }
            } else {
                this.printIndent().print("if (").print("this.").print(name).print(" === undefined) { ");
                if (this.context.options.isNonEnumerableTransients() && varElement.getModifiers().contains((Object)Modifier.TRANSIENT)) {
                    this.print("Object.defineProperty(this, " + this.getStringLiteralQuote() + name + this.getStringLiteralQuote() + ", { value: ").print(this.getAdapter().getVariableInitialValue(varElement)).print(", enumerable: false }); } ").println();
                } else {
                    this.print("this.").print(name).print(" = ").print(this.getAdapter().getVariableInitialValue(varElement)).print("; }").println();
                }
            }
        }
    }

    protected void printInstanceInitialization(ClassTree clazz, ExecutableElement method) {
        if (method == null || method.getKind() == ElementKind.CONSTRUCTOR) {
            this.getScope().hasDeclaredConstructor = true;
            TypeElement typeElement = (TypeElement)Util.getElement(clazz);
            if (this.types().isAssignable(typeElement.asType(), this.util().getType(Throwable.class))) {
                this.printIndent().print("(<any>Object).setPrototypeOf(this, " + this.getClassName(typeElement) + ".prototype);").println();
            }
            if (this.getScope().innerClassNotStatic && !this.getScope().enumWrapperClassScope) {
                this.printIndent().print("this.__parent = __parent;").println();
            }
            for (Tree tree : clazz.getMembers()) {
                BlockTree block;
                if (tree instanceof VariableTree) {
                    VariableTree var = (VariableTree)tree;
                    VariableElement varElement = (VariableElement)Util.getElement(var);
                    if (varElement.getModifiers().contains((Object)Modifier.STATIC) || this.context.hasAnnotationType(varElement, "jsweet.lang.Erased")) continue;
                    this.printVariableInitialization(clazz, var);
                    continue;
                }
                if (!(tree instanceof BlockTree) || (block = (BlockTree)tree).isStatic()) continue;
                this.printIndent().print("(() => {").startIndent().println();
                this.stack.push(block);
                this.printBlockStatements(block.getStatements());
                this.stack.pop();
                this.endIndent().printIndent().print("})();").println();
            }
        }
    }

    private void printInlinedMethod(OverloadScanner.Overload overload, MethodTree method, List<? extends Tree> args) {
        this.print("{").println().startIndent();
        if (this.getScope().innerClassNotStatic && this.getScope().constructor) {
            this.printIndent().print("let __args = Array.prototype.slice.call(arguments, [1]);").println();
        } else {
            this.printIndent().print("let __args = arguments;").println();
        }
        for (int j = 0; j < method.getParameters().size(); ++j) {
            if (args.get(j) instanceof VariableTree) {
                if (method.getParameters().get(j).getName().equals(((VariableTree)args.get(j)).getName())) continue;
                this.printIndent().print("let ").print(this.avoidJSKeyword(method.getParameters().get(j).getName().toString())).print(": ").print("any").print(this.util().isVarargs(method.getParameters().get(j)) ? "[]" : "").print(" = ").print("__args[" + j + "]").print(";").println();
                continue;
            }
            if (method.getParameters().get(j).getName().toString().equals(args.get(j).toString())) continue;
            this.getScope().inlinedConstructorArgs = method.getParameters().stream().map(p -> Util.getElement(p).getSimpleName().toString()).collect(Collectors.toList());
            this.printIndent().print("let ").print(this.avoidJSKeyword(method.getParameters().get(j).getName().toString())).print(": ").print("any").print(this.util().isVarargs(method.getParameters().get(j)) ? "[]" : "").print(" = ").print(args.get(j)).print(";").println();
            this.getScope().inlinedConstructorArgs = null;
        }
        ExecutableElement methodElement = (ExecutableElement)Util.getElement(method);
        if (method.getBody() != null) {
            boolean skipFirst = false;
            List<? extends StatementTree> statements = method.getBody().getStatements();
            if (!statements.isEmpty() && statements.get(0).toString().startsWith("this(")) {
                skipFirst = true;
                MethodInvocationTree inv = (MethodInvocationTree)((ExpressionStatementTree)statements.get(0)).getExpression();
                ExecutableElement ms = this.util().findMethodDeclarationInType((TypeElement)overload.getCoreMethodElement().getEnclosingElement(), inv);
                for (OverloadScanner.OverloadMethodEntry overloadMethodEntry : overload.getEntries()) {
                    if (!overloadMethodEntry.methodElement.equals(ms)) continue;
                    this.printIndent();
                    this.printInlinedMethod(overload, overloadMethodEntry.methodTree, inv.getArguments());
                    this.println();
                }
            }
            boolean isConstructor = methodElement.getKind() == ElementKind.CONSTRUCTOR;
            String replacedBody = null;
            if (this.context.hasAnnotationType(methodElement, "jsweet.lang.Replace")) {
                replacedBody = this.context.getAnnotationValue(methodElement, "jsweet.lang.Replace", String.class, null);
            }
            int position = this.getCurrentPosition();
            if (replacedBody == null || BODY_MARKER.matcher(replacedBody).find()) {
                List<? extends StatementTree> actualStatements;
                this.enter(method.getBody());
                List<? extends StatementTree> list = actualStatements = skipFirst ? statements.subList(1, statements.size()) : statements;
                if (isConstructor) {
                    this.getScope().hasDeclaredConstructor = true;
                }
                if (!actualStatements.isEmpty() && actualStatements.get(0).toString().startsWith("super(")) {
                    this.printBlockStatement(actualStatements.get(0));
                    this.printFieldInitializations(actualStatements);
                    List<? extends StatementTree> nextStatements = actualStatements.subList(1, actualStatements.size());
                    if (!nextStatements.isEmpty()) {
                        this.printBlockStatements(nextStatements);
                    }
                } else {
                    this.printFieldInitializations(actualStatements);
                    if (!actualStatements.isEmpty() || !isConstructor) {
                        this.printIndent();
                    }
                    if (!isConstructor) {
                        this.print("return <any>");
                    }
                    if (!actualStatements.isEmpty() || !isConstructor) {
                        this.print("((").print(") => {").startIndent().println();
                        this.printBlockStatements(actualStatements);
                        this.endIndent().printIndent().print("})(").print(");").println();
                    }
                }
                this.exit();
                if (replacedBody != null) {
                    this.getIndent();
                    this.printIndent();
                    String orgBody = this.getOutput().substring(position);
                    this.removeLastChars(this.getCurrentPosition() - position);
                    replacedBody = BODY_MARKER.matcher(replacedBody).replaceAll(orgBody);
                    replacedBody = BASE_INDENT_MARKER.matcher(replacedBody).replaceAll(this.getIndentString());
                    replacedBody = INDENT_MARKER.matcher(replacedBody).replaceAll("    ");
                    replacedBody = METHOD_NAME_MARKER.matcher(replacedBody).replaceAll(method.getName().toString());
                    replacedBody = CLASS_NAME_MARKER.matcher(replacedBody).replaceAll(this.util().getQualifiedName(methodElement.getEnclosingElement()));
                }
            }
            if (replacedBody != null) {
                if (isConstructor) {
                    this.getScope().hasDeclaredConstructor = true;
                }
                this.printIndent().print(replacedBody).println();
            }
        } else {
            String returnValue = this.util().getTypeInitialValue(methodElement.getReturnType());
            if (returnValue != null) {
                this.print(" return ").print(returnValue).print("; ");
            }
        }
        this.endIndent().printIndent().print("}");
    }

    private void printFieldInitializations(List<? extends StatementTree> potentialInitializationStatements) {
        ClassTree clazz = this.getParent(ClassTree.class);
        for (Tree tree : clazz.getMembers()) {
            VariableTree field;
            VariableElement fieldElement;
            if (!(tree instanceof VariableTree) || this.getScope().fieldsWithInitializers.contains(tree) || (fieldElement = (VariableElement)Util.getElement(field = (VariableTree)tree)).getModifiers().contains((Object)Modifier.STATIC) || this.context.hasAnnotationType(fieldElement, "jsweet.lang.Erased")) continue;
            String name = this.getIdentifier(fieldElement);
            if (this.context.getFieldNameMapping(fieldElement) != null) {
                name = this.context.getFieldNameMapping(fieldElement);
            }
            this.printIndent().print("if (").print("this.").print(name).print(" === undefined) { ");
            if (this.context.options.isNonEnumerableTransients() && fieldElement.getModifiers().contains((Object)Modifier.TRANSIENT)) {
                this.print("Object.defineProperty(this, " + this.getStringLiteralQuote() + name + this.getStringLiteralQuote() + ", { value: ").print(this.getAdapter().getVariableInitialValue(fieldElement)).print(", enumerable: false }); } ");
                continue;
            }
            this.print("this.").print(name).print(" = ").print(this.getAdapter().getVariableInitialValue(fieldElement)).print("; } ").println();
        }
        for (VariableTree variableTree : this.getScope().fieldsWithInitializers) {
            VariableElement fieldElement = (VariableElement)Util.getElement(variableTree);
            if (this.context.hasAnnotationType(fieldElement, "jsweet.lang.Erased")) continue;
            String name = this.getIdentifier(fieldElement);
            if (this.context.getFieldNameMapping(fieldElement) != null) {
                name = this.context.getFieldNameMapping(fieldElement);
            }
            this.printIndent().print("this.").print(name).print(" = ");
            if (!this.substituteAssignedExpression(fieldElement.asType(), variableTree.getInitializer())) {
                this.print(variableTree.getInitializer());
            }
            this.print(";").println();
        }
    }

    protected void printBlockStatements(List<? extends StatementTree> statements) {
        for (final StatementTree statementTree : statements) {
            MethodTree methodDecl;
            if (this.context.options.isDebugMode() && this.isDebugMode(methodDecl = this.getParent(MethodTree.class))) {
                SourcePosition statementPosition = this.util().getSourcePosition(statementTree, this.getCompilationUnit());
                this.printIndent();
                this.print("yield { row: ");
                this.print("" + statementPosition.getStartLine());
                this.print(", column: " + statementPosition.getStartColumn());
                this.print(", statement: \"");
                this.print(StringEscapeUtils.escapeJson((String)statementTree.toString())).print("\"");
                final Stack locals = new Stack();
                try {
                    new TreeScanner<Void, Trees>(){

                        @Override
                        public Void scan(Tree tree, Trees trees) {
                            if (tree == statementTree) {
                                throw new RuntimeException();
                            }
                            boolean contextChange = false;
                            if (tree instanceof BlockTree || tree instanceof EnhancedForLoopTree || tree instanceof LambdaExpressionTree || tree instanceof ForLoopTree || tree instanceof DoWhileLoopTree) {
                                locals.push(new ArrayList());
                                contextChange = true;
                            }
                            if (tree instanceof VariableTree) {
                                ((List)locals.peek()).add(((VariableTree)tree).getName().toString());
                            }
                            super.scan(tree, trees);
                            if (contextChange) {
                                locals.pop();
                            }
                            return Java2TypeScriptTranslator.returnNothing();
                        }
                    }.scan((Tree)methodDecl.getBody(), this.trees());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ArrayList accessibleLocals = new ArrayList();
                for (List l : locals) {
                    accessibleLocals.addAll(l);
                }
                if (!accessibleLocals.isEmpty()) {
                    this.print(", locals: ");
                    this.print("{");
                    for (String local : accessibleLocals) {
                        this.print(local + ": " + local + ", ");
                    }
                    this.removeLastChars(2);
                    this.print("}");
                }
                this.print(" };").println();
            }
            this.printBlockStatement(statementTree);
        }
    }

    private void printBlockStatement(StatementTree statement) {
        this.printIndent();
        int pos = this.getCurrentPosition();
        this.print(statement);
        if (this.getCurrentPosition() == pos) {
            this.removeLastIndent();
            return;
        }
        if (!this.isStatementWithNoSemiColon(statement)) {
            if (statement instanceof LabeledStatementTree) {
                if (!this.isStatementWithNoSemiColon(((LabeledStatementTree)statement).getStatement())) {
                    this.print(";");
                }
            } else {
                this.print(";");
            }
        }
        this.println();
    }

    private String getOverloadMethodName(ExecutableElement method) {
        if (method.getKind() == ElementKind.CONSTRUCTOR) {
            return "constructor";
        }
        StringBuilder nameBuilder = new StringBuilder(method.getSimpleName().toString());
        nameBuilder.append(ANONYMOUS_PREFIX);
        for (VariableElement variableElement : method.getParameters()) {
            nameBuilder.append(this.types().erasure(variableElement.asType()).toString().replace('.', '_').replace("[]", "_A"));
            nameBuilder.append(ANONYMOUS_PREFIX);
        }
        if (!method.getParameters().isEmpty()) {
            nameBuilder.deleteCharAt(nameBuilder.length() - 1);
        }
        return nameBuilder.toString();
    }

    private void checkType(Element type) {
        String name;
        ModuleImportDescriptor moduleImport;
        if (type instanceof TypeElement && !this.isMappedOrErasedType(type) && (moduleImport = this.getModuleImportDescriptor(name = type.getSimpleName().toString(), (TypeElement)type)) != null) {
            this.useModule(false, moduleImport.isDirect(), moduleImport.getTargetPackage(), null, moduleImport.getImportedName(), moduleImport.getPathToImportedClass(), null);
        }
    }

    private void printMethodParamsTest(OverloadScanner.Overload overload, OverloadScanner.OverloadMethodEntry methodEntry) {
        int i;
        MethodTree method = methodEntry.methodTree;
        for (i = 0; i < method.getParameters().size(); ++i) {
            Element firstArgTypeElement;
            List<? extends TypeMirror> typeArguments;
            this.print("(");
            VariableTree parameter = method.getParameters().get(i);
            Object paramType = Util.getType(parameter);
            Object paramTypeElement = Util.getTypeElement(parameter);
            if (Class.class.getName().equals(this.context.types.erasure((TypeMirror)paramType).toString()) && (typeArguments = ((DeclaredType)paramType).getTypeArguments()).size() > 0 && (firstArgTypeElement = this.types().asElement(typeArguments.get(0))) != null && firstArgTypeElement.getKind() == ElementKind.INTERFACE) {
                this.print(this.avoidJSKeyword(overload.getCoreMethod().getParameters().get(i).getName().toString())).print(" === ");
                this.print(this.getStringLiteralQuote()).print(typeArguments.get(0).toString()).print(this.getStringLiteralQuote());
                this.print(" || ");
            }
            this.printInstanceOf(this.avoidJSKeyword(overload.getCoreMethod().getParameters().get(i).getName().toString()), null, (TypeMirror)paramType);
            this.checkType((Element)paramTypeElement);
            this.print(" || ").print(this.avoidJSKeyword(overload.getCoreMethod().getParameters().get(i).getName().toString()) + " === null").print(")");
            this.print(" && ");
        }
        while (i < overload.getCoreMethod().getParameters().size()) {
            this.print(this.avoidJSKeyword(overload.getCoreMethod().getParameters().get(i).getName().toString())).print(" === undefined");
            if (i == overload.getCoreMethod().getParameters().size() - 1 && overload.getCoreMethodElement().isVarArgs()) {
                this.print(" || ");
                this.print(this.avoidJSKeyword(overload.getCoreMethod().getParameters().get(i).getName().toString())).print(".length === 0");
            }
            this.print(" && ");
            ++i;
        }
        this.removeLastChars(4);
    }

    @Override
    public Void visitBlock(BlockTree block, Trees trees) {
        boolean initializer;
        Tree parent = this.getParent();
        boolean globals = parent instanceof ClassTree && "Globals".equals(((ClassTree)parent).getSimpleName().toString());
        boolean bl = initializer = parent instanceof ClassTree && !globals;
        if (initializer) {
            if (this.getScope().interfaceScope) {
                this.report((Tree)block, JSweetProblem.INVALID_INITIALIZER_IN_INTERFACE, ((ClassTree)parent).getSimpleName());
            }
            if (!block.isStatic()) {
                return Java2TypeScriptTranslator.returnNothing();
            }
            this.printStaticInitializer(block);
            return Java2TypeScriptTranslator.returnNothing();
        }
        if (!globals) {
            this.print("{").println().startIndent();
        }
        this.printBlockStatements(block.getStatements());
        if (!globals) {
            this.endIndent().printIndent().print("}");
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    private void printStaticInitializer(BlockTree block) {
        if (this.getScope().isEnumScope()) {
            return;
        }
        if (this.getScope().isDeclareClassScope()) {
            return;
        }
        int static_i = 0;
        for (Tree tree : ((ClassTree)this.getParent()).getMembers()) {
            if (!(tree instanceof BlockTree) || !((BlockTree)tree).isStatic()) continue;
            if (block == tree) {
                String asyncKeyword = this.isAsyncStaticInitializer(block) ? "async" : "";
                this.print("static " + asyncKeyword + " __static_initializer_" + static_i + "() ");
                this.print("{");
                this.println().startIndent();
                this.printBlockStatements(block.getStatements());
                this.endIndent().printIndent();
                this.print("}");
                break;
            }
            ++static_i;
        }
    }

    protected boolean isAsyncStaticInitializer(BlockTree initializerBlock) {
        AsyncCallsFinder finder = new AsyncCallsFinder();
        initializerBlock.accept(finder, this.trees());
        return finder.found;
    }

    private String avoidJSKeyword(String name) {
        if (JSweetConfig.JS_KEYWORDS.contains(name)) {
            name = "__" + (String)name;
        }
        return name;
    }

    private boolean isLazyInitialized(VariableElement var) {
        return this.context.options.isLazyInitializedStatics() && var.getModifiers().contains((Object)Modifier.STATIC) && this.context.lazyInitializedStatics.contains(var) && (!this.util().isPartOfAnEnum(var) || !var.getEnclosingElement().equals(Util.getElement(var.asType())));
    }

    @Override
    public Void visitVariable(VariableTree varTree, Trees trees) {
        VariableElement varElement = (VariableElement)Util.getElement(varTree);
        if (this.getAdapter().substituteVariable(varElement)) {
            return Java2TypeScriptTranslator.returnNothing();
        }
        if (this.context.hasAnnotationType(varElement, "jsweet.lang.Erased")) {
            return Java2TypeScriptTranslator.returnNothing();
        }
        if (this.context.hasAnnotationType(varElement, "jsweet.lang.StringType")) {
            return Java2TypeScriptTranslator.returnNothing();
        }
        if (this.getScope().enumScope) {
            NewClassTree newClass;
            this.printDocComment(varTree, true);
            this.print(varTree.getName().toString());
            if (varTree.getInitializer() instanceof NewClassTree && (newClass = (NewClassTree)varTree.getInitializer()).getClassBody() != null) {
                this.initAnonymousClass(newClass);
            }
        } else {
            boolean globals;
            Tree parent = this.getParent();
            if (this.getScope().enumWrapperClassScope && varElement.getKind() == ElementKind.ENUM_CONSTANT) {
                return Java2TypeScriptTranslator.returnNothing();
            }
            Object name = this.getIdentifier(varElement);
            if (this.context.getFieldNameMapping(varElement) != null) {
                name = this.context.getFieldNameMapping(varElement);
            }
            boolean confictInDefinitionScope = false;
            if (parent instanceof ClassTree) {
                ExecutableElement parentMethod = this.util().findMethodDeclarationInType((TypeElement)Util.getElement((ClassTree)parent), (String)name, null);
                if (parentMethod != null) {
                    if (!this.isDefinitionScope) {
                        this.report((Tree)varTree, varTree.getName(), JSweetProblem.FIELD_CONFLICTS_METHOD, name, parentMethod.getEnclosingElement());
                    } else {
                        confictInDefinitionScope = true;
                    }
                }
                if (!this.getScope().interfaceScope && ((String)name).equals("constructor")) {
                    this.report((Tree)varTree, varTree.getName(), JSweetProblem.CONSTRUCTOR_MEMBER, new Object[0]);
                }
            } else {
                if (!this.context.useModules && this.context.importedTopPackages.contains(name)) {
                    name = "__var_" + (String)name;
                }
                if (JSweetConfig.JS_KEYWORDS.contains(name)) {
                    this.report((Tree)varTree, varTree.getName(), JSweetProblem.JS_KEYWORD_CONFLICT, name, name);
                    name = "__" + (String)name;
                }
            }
            boolean bl = globals = parent instanceof ClassTree && "Globals".equals(((ClassTree)parent).getSimpleName().toString());
            if (globals && !varTree.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                this.report((Tree)varTree, varTree.getName(), JSweetProblem.GLOBALS_CAN_ONLY_HAVE_STATIC_MEMBERS, new Object[0]);
                return Java2TypeScriptTranslator.returnNothing();
            }
            boolean bl2 = globals = globals || parent instanceof ClassTree && ((ClassTree)parent).getKind() == Tree.Kind.INTERFACE || this.getScope().interfaceScope && varElement.getModifiers().contains((Object)Modifier.STATIC);
            if (parent instanceof ClassTree) {
                this.printDocComment(varTree);
            }
            this.print(varTree.getModifiers());
            if (!globals && parent instanceof ClassTree) {
                if (varTree.getModifiers().getFlags().contains((Object)Modifier.PUBLIC) && !this.getScope().interfaceScope) {
                    this.print("public ");
                }
                if (varTree.getModifiers().getFlags().contains((Object)Modifier.PRIVATE)) {
                    if (!this.getScope().interfaceScope) {
                        if (!this.getScope().innerClass && !varTree.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                            this.print("/*private*/ ");
                        }
                    } else {
                        this.report((Tree)varTree, varTree.getName(), JSweetProblem.INVALID_PRIVATE_IN_INTERFACE, varTree.getName(), ((ClassTree)parent).getSimpleName());
                    }
                }
                if (varTree.getModifiers().getFlags().contains((Object)Modifier.STATIC) && !this.getScope().interfaceScope) {
                    this.print("static ");
                }
            }
            if (!this.getScope().interfaceScope && parent instanceof ClassTree && this.context.hasAnnotationType(varElement, "jsweet.lang.Optional")) {
                this.report((Tree)varTree, varTree.getName(), JSweetProblem.USELESS_OPTIONAL_ANNOTATION, varTree.getName(), ((ClassTree)parent).getSimpleName());
            }
            boolean ambient = this.context.hasAnnotationType(varElement, "jsweet.lang.Ambient");
            if (globals || !(parent instanceof ClassTree) && !(parent instanceof MethodTree) && !(parent instanceof LambdaExpressionTree)) {
                if (globals) {
                    if (this.context.hasAnnotationType(varElement, "jsweet.lang.Module")) {
                        this.getContext().addExportedElement(this.context.getAnnotationValue(varElement, "jsweet.lang.Module", String.class, null), varElement, this.getCompilationUnit());
                    }
                    if (this.context.useModules || this.context.moduleBundleMode) {
                        if (!varTree.getModifiers().getFlags().contains((Object)Modifier.PRIVATE)) {
                            this.print("export ");
                        }
                    } else if (!this.isTopLevelScope()) {
                        this.print("export ");
                    }
                    if (ambient || this.isTopLevelScope() && this.isDefinitionScope) {
                        this.print("declare ");
                    }
                }
                if (!(this.inArgListTail && parent instanceof ForLoopTree || this.getAdapter().substituteVariableDeclarationKeyword(varElement))) {
                    if (this.isDefinitionScope) {
                        this.print("var ");
                    } else if (!this.isLazyInitialized(varElement) && (!globals && this.context.constAnalyzer != null && !this.context.constAnalyzer.getModifiedVariables().contains(varElement) || globals && varElement.getModifiers().contains((Object)Modifier.FINAL) && varTree.getInitializer() != null)) {
                        this.print("const ");
                    } else {
                        this.print("let ");
                    }
                }
            } else if (ambient) {
                this.report((Tree)varTree, varTree.getName(), JSweetProblem.WRONG_USE_OF_AMBIENT, varTree.getName());
            }
            if (this.util().isVarargs(varTree)) {
                this.print("...");
            }
            if (this.doesMemberNameRequireQuotes((String)name)) {
                this.print("'" + (String)name + "'");
            } else {
                this.print((String)name);
            }
            if (!this.util().isVarargs(varTree) && (this.getScope().isEraseVariableTypes() || this.getScope().interfaceScope && this.context.hasAnnotationType(varElement, "jsweet.lang.Optional"))) {
                this.print("?");
            }
            if (!this.getScope().skipTypeAnnotations && !this.getScope().enumWrapperClassScope && this.typeChecker.checkType(varTree, varTree.getName(), varTree.getType(), this.compilationUnit)) {
                this.print(": ");
                if (confictInDefinitionScope) {
                    this.print("any");
                } else if (this.getScope().isEraseVariableTypes()) {
                    this.print("any");
                    if (this.util().isVarargs(varTree)) {
                        this.print("[]");
                    }
                } else {
                    Object varTypeElement = Util.getTypeElement(varTree.getType());
                    if (varTypeElement != null && this.context.hasAnnotationType((Element)varTypeElement, "jsweet.lang.StringType") && !this.util().isPartOfAnEnum((Element)varTypeElement)) {
                        this.print(this.getStringLiteralQuote());
                        this.print(this.context.getAnnotationValue((Element)varTypeElement, "jsweet.lang.StringType", String.class, varTypeElement.getSimpleName().toString()).toString());
                        this.print(this.getStringLiteralQuote());
                    } else {
                        this.substituteAndPrintType(varTree.getType());
                    }
                }
            }
            if (this.isLazyInitialized(varElement)) {
                ClassTree clazz = (ClassTree)parent;
                TypeElement classTypeElement = (TypeElement)Util.getElement(clazz);
                Object prefix = this.getClassName(classTypeElement);
                prefix = "Globals".equals(prefix) ? "" : (String)prefix + ".";
                this.print("; ");
                if (globals) {
                    if (!this.isTopLevelScope()) {
                        this.print("export ");
                    }
                    this.print("function ");
                } else {
                    this.print("public static ");
                }
                this.print((String)name).print("_$LI$(): ");
                this.substituteAndPrintType(varTree.getType());
                this.print(" { ");
                int liCount = this.context.getStaticInitializerCount(classTypeElement);
                if (liCount > 0 && !globals) {
                    this.print((String)prefix + "__static_initialize(); ");
                }
                if (varTree.getInitializer() != null && !this.isDefinitionScope) {
                    this.print("if (" + (String)prefix).print((String)name).print(" == null) { ").print((String)prefix).print((String)name).print(" = ");
                    if (!this.substituteAssignedExpression((TypeMirror)Util.getType(varTree), varTree.getInitializer())) {
                        this.print(varTree.getInitializer());
                    }
                    this.print("; } ");
                }
                this.print(" return ").print((String)prefix).print((String)name).print("; }");
                if (!globals && this.context.bundleMode) {
                    Object qualifiedClassName = this.getQualifiedTypeName(classTypeElement, globals, true);
                    if (this.util().isPartOfAnEnum(classTypeElement)) {
                        qualifiedClassName = (String)qualifiedClassName + ENUM_WRAPPER_CLASS_SUFFIX;
                    }
                    this.context.addTopFooterStatement((String)(StringUtils.isBlank((CharSequence)qualifiedClassName) ? "" : (String)qualifiedClassName + ".") + (String)name + "_$LI$();");
                }
            } else {
                if (!(varTree.getInitializer() == null || this.isDefinitionScope || parent instanceof ClassTree && this.getScope().innerClassNotStatic && !varElement.getModifiers().contains((Object)Modifier.STATIC) && !this.util().isConstantOrNullField(varTree))) {
                    if (!globals && parent instanceof ClassTree && this.getScope().interfaceScope) {
                        this.report((Tree)varTree, varTree.getName(), JSweetProblem.INVALID_FIELD_INITIALIZER_IN_INTERFACE, varTree.getName(), ((ClassTree)parent).getSimpleName());
                    } else if (!this.getScope().fieldsWithInitializers.contains(varTree)) {
                        this.print(" = ");
                        if (!this.substituteAssignedExpression((TypeMirror)Util.getType(varTree), varTree.getInitializer())) {
                            this.print(varTree.getInitializer());
                        }
                    }
                }
                if (!(this.isDefinitionScope || ambient || this.isTopLevelScope() && this.isDefinitionScope || !varElement.getModifiers().contains((Object)Modifier.STATIC) || varTree.getInitializer() != null)) {
                    this.print(" = ").print(this.getAdapter().getVariableInitialValue(varElement));
                }
            }
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    private String getTSMemberAccess(String memberName, boolean hasSelector) {
        if (this.doesMemberNameRequireQuotes(memberName)) {
            return (hasSelector ? "" : "window") + "['" + memberName + "']";
        }
        return (hasSelector ? "." : "") + memberName;
    }

    private boolean doesMemberNameRequireQuotes(String name) {
        for (char c : name.toCharArray()) {
            if (!JSweetConfig.TS_IDENTIFIER_FORBIDDEN_CHARS.contains(Character.valueOf(c))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Void visitParenthesized(ParenthesizedTree parens, Trees trees) {
        this.print("(");
        super.visitParenthesized(parens, trees);
        this.print(")");
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitImport(ImportTree importTree, Trees trees) {
        String qualId = importTree.getQualifiedIdentifier().toString();
        if (this.context.useModules && qualId.endsWith("*") && !qualId.endsWith(".Globals.*") && !qualId.equals("jsweet.util.Lang.*")) {
            this.report((Tree)importTree, JSweetProblem.WILDCARD_IMPORT, new Object[0]);
            return Java2TypeScriptTranslator.returnNothing();
        }
        String adaptedQualId = this.getAdapter().needsImport((ImportElement)this.createExtendedElement(importTree), qualId);
        if (adaptedQualId != null && adaptedQualId.contains(".") && (!importTree.isStatic() || qualId.contains(".Globals.") || qualId.contains(".StringTypes."))) {
            String[] namePath = this.context.useModules && importTree.isStatic() ? qualId.split("\\.") : adaptedQualId.split("\\.");
            String name = namePath[namePath.length - 1];
            if (this.context.useModules) {
                if (!adaptedQualId.startsWith("globals") && !this.context.getImportedNames(this.compilationUnit.getSourceFile().getName()).contains(name)) {
                    this.print("import ").print(name).print(" = ").print(adaptedQualId).print(";").println();
                    this.context.registerImportedName(this.compilationUnit.getSourceFile().getName(), null, name);
                }
            } else {
                if (this.topLevelPackage == null) {
                    if (this.context.globalImports.contains(name)) {
                        return Java2TypeScriptTranslator.returnNothing();
                    }
                    this.context.globalImports.add(name);
                }
                if (!this.context.useModules) {
                    this.context.importedTopPackages.add(namePath[0]);
                } else if (!this.context.getImportedNames(this.compilationUnit.getSourceFile().getName()).contains(name)) {
                    this.print("import ").print(name).print(" = ").print(adaptedQualId).print(";").println();
                    this.context.registerImportedName(this.compilationUnit.getSourceFile().getName(), null, name);
                }
            }
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    private void printInnerClassAccess(String accessedElementName, ElementKind kind) {
        this.printInnerClassAccess(accessedElementName, kind, null);
    }

    private void printInnerClassAccess(String accessedElementName, ElementKind kind, Integer methodArgsCount) {
        boolean foundInParent;
        this.print("this.");
        ClassTree parent = this.getParent(ClassTree.class);
        TypeElement parentTypeElement = (TypeElement)Util.getElement(parent);
        int level = 0;
        boolean bl = foundInParent = this.util().findFirstDeclarationInClassAndSuperClasses(parentTypeElement, accessedElementName, kind, methodArgsCount) != null;
        if (!foundInParent) {
            while (this.getScope((int)level++).innerClassNotStatic) {
                parent = this.getParent(ClassTree.class, parent);
                parentTypeElement = (TypeElement)Util.getElement(parent);
                if (parent == null || this.util().findFirstDeclarationInClassAndSuperClasses(parentTypeElement, accessedElementName, kind, methodArgsCount) == null) continue;
                foundInParent = true;
                break;
            }
        }
        if (foundInParent && level > 0) {
            if (this.getScope().constructor) {
                this.removeLastChars(5);
            }
            for (int i = 0; i < level; ++i) {
                this.print("__parent.");
            }
        }
    }

    public boolean printClass(TypeMirror type) {
        String className;
        Object element = Util.getElement(type);
        TypeElement typeElement = element instanceof TypeElement ? (TypeElement)element : null;
        String string = className = typeElement == null ? type.toString() : typeElement.toString();
        if (this.context.isMappedType(className)) {
            String target = this.context.getTypeMappingTarget(className);
            if (CONSTRUCTOR_TYPE_MAPPING.containsKey(target)) {
                this.print(Java2TypeScriptTranslator.mapConstructorType(target));
                return true;
            }
            if (typeElement != null) {
                this.print(this.getStringLiteralQuote()).print(this.context.getRootRelativeJavaName(typeElement)).print(this.getStringLiteralQuote());
                return true;
            }
        } else if (CONSTRUCTOR_TYPE_MAPPING.containsKey(className)) {
            this.print(Java2TypeScriptTranslator.mapConstructorType(className));
            return true;
        }
        return false;
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree memberSelectTree, Trees trees) {
        if (!this.getAdapter().substitute((ExtendedElement)this.createExtendedElement(memberSelectTree))) {
            Element selectedElement = null;
            if (memberSelectTree.getExpression() instanceof MemberSelectTree || memberSelectTree.getExpression() instanceof IdentifierTree) {
                selectedElement = (Element)Util.getElement(memberSelectTree.getExpression());
            }
            Object selectedType = Util.getType(memberSelectTree.getExpression());
            Object selectedTypeElement = Util.getTypeElement(memberSelectTree.getExpression());
            Object memberElement = Util.getElement(memberSelectTree);
            Object memberType = Util.getType(memberSelectTree);
            Object memberTypeElement = Util.getTypeElement(memberSelectTree);
            if (selectedElement instanceof PackageElement && this.context.isRootPackage(selectedElement)) {
                if (memberTypeElement != null) {
                    this.printIdentifier((Element)memberTypeElement);
                } else {
                    this.print(memberSelectTree.getIdentifier().toString());
                }
                return Java2TypeScriptTranslator.returnNothing();
            }
            if ("class".equals(memberSelectTree.getIdentifier().toString())) {
                if (memberType.getKind() == TypeKind.DECLARED && this.util().getFirstTypeArgumentAsElement((DeclaredType)memberType) != null && this.context.isInterface(this.util().getFirstTypeArgumentAsElement((DeclaredType)memberType))) {
                    this.print(this.getStringLiteralQuote()).print(this.context.getRootRelativeJavaName(this.util().getFirstTypeArgumentAsElement((DeclaredType)memberType))).print(this.getStringLiteralQuote());
                } else if (!this.printClass((TypeMirror)selectedType)) {
                    String name;
                    String string = name = selectedTypeElement == null ? selectedType.toString() : selectedTypeElement.toString();
                    if (this.context.isMappedType(name)) {
                        Element firstTypeArgumentAsElement = this.util().getFirstTypeArgumentAsElement((DeclaredType)memberType);
                        this.print(this.getStringLiteralQuote()).print(this.context.getRootRelativeJavaName(firstTypeArgumentAsElement)).print(this.getStringLiteralQuote());
                    } else {
                        this.print(memberSelectTree.getExpression());
                    }
                }
            } else if ("this".equals(memberSelectTree.getIdentifier().toString())) {
                this.print("this");
                if (this.getScope().innerClassNotStatic) {
                    ClassTree parent = this.getParent(ClassTree.class);
                    TypeElement parentTypeElement = (TypeElement)Util.getElement(parent);
                    int level = 0;
                    boolean foundInParent = false;
                    while (this.getScope((int)level++).innerClassNotStatic) {
                        parent = this.getParent(ClassTree.class, parent);
                        parentTypeElement = (TypeElement)Util.getElement(parent);
                        if (parent == null || !parentTypeElement.equals(selectedTypeElement)) continue;
                        foundInParent = true;
                        break;
                    }
                    if (foundInParent && level > 0) {
                        this.print(".");
                        if (this.getScope().constructor) {
                            this.removeLastChars(5);
                        }
                        for (int i = 0; i < level; ++i) {
                            this.print("__parent.");
                        }
                        this.removeLastChar();
                    }
                }
            } else {
                String selected = memberSelectTree.getExpression().toString();
                if (!selected.equals("Globals")) {
                    if (selected.equals("super") && memberElement instanceof VariableElement) {
                        this.print("this.");
                    } else if (this.getScope().innerClassNotStatic && ("this".equals(selected) || selected.endsWith(".this"))) {
                        this.printInnerClassAccess(memberSelectTree.getIdentifier().toString(), ElementKind.FIELD);
                    } else {
                        boolean accessSubstituted = false;
                        if (memberElement instanceof VariableElement) {
                            VariableElement varElement = (VariableElement)memberElement;
                            if (varElement.getModifiers().contains((Object)Modifier.STATIC) && varElement.getEnclosingElement() != selectedElement) {
                                accessSubstituted = true;
                                this.print(this.getRootRelativeName(varElement.getEnclosingElement())).print(".");
                                this.ensureModuleIsUsed(varElement.getEnclosingElement());
                            }
                        } else if (selectedElement instanceof PackageElement && this.context.useModules && !this.context.moduleBundleMode && memberElement instanceof TypeElement && this.util().isSourceElement((Element)memberElement)) {
                            accessSubstituted = true;
                            ModuleImportDescriptor moduleImport = this.getAdapter().getModuleImportDescriptor(this.getCompilationUnitElement(), memberElement.getSimpleName().toString(), (TypeElement)memberElement);
                            if (moduleImport != null) {
                                this.useModule(moduleImport);
                            }
                        }
                        if (!accessSubstituted) {
                            this.print(memberSelectTree.getExpression()).print(".");
                        }
                    }
                }
                String fieldName = null;
                fieldName = memberElement instanceof VariableElement && this.context.getFieldNameMapping((VariableElement)memberElement) != null ? this.context.getFieldNameMapping((VariableElement)memberElement) : this.getIdentifier((Element)memberElement);
                if (memberElement instanceof TypeElement && this.context.hasClassNameMapping((TypeElement)memberElement)) {
                    fieldName = this.context.getClassNameMapping((TypeElement)selectedElement);
                }
                if (this.doesMemberNameRequireQuotes(fieldName)) {
                    if (this.getLastPrintedChar() == '.') {
                        this.removeLastChar();
                        this.print("['").print(fieldName).print("']");
                    } else {
                        this.print("this['").print(fieldName).print("']");
                    }
                } else {
                    this.print(fieldName);
                }
                if (memberElement instanceof VariableElement && this.isLazyInitialized((VariableElement)memberElement) && !this.staticInitializedAssignment) {
                    this.print("_$LI$()");
                }
            }
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Trees trees) {
        Object methodElement;
        boolean debugMode = false;
        if (this.context.options.isDebugMode() && (methodElement = Util.getElement(methodInvocationTree.getMethodSelect())) instanceof ExecutableElement && methodElement.getKind() != ElementKind.CONSTRUCTOR && this.util().isSourceElement((Element)methodElement)) {
            debugMode = true;
        }
        if (debugMode) {
            this.print("__debug_result(yield ");
        }
        this.getAdapter().substituteMethodInvocation((MethodInvocationElement)this.createExtendedElement(methodInvocationTree));
        if (debugMode) {
            this.print(")");
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    /*
     * WARNING - void declaration
     */
    public void printDefaultMethodInvocation(MethodInvocationTree methodInvocationTree) {
        TypeElement typeElement;
        int argsLength;
        TypeElement targetType;
        int i;
        String meth = methodInvocationTree.getMethodSelect().toString();
        String methName = meth.substring(meth.lastIndexOf(46) + 1);
        if (methName.equals("super") && this.getScope().removedSuperclass) {
            return;
        }
        boolean applyVarargs = true;
        if ("$new".equals(methName)) {
            this.print("new ");
            applyVarargs = false;
        }
        if (this.context.isAwaitInvocation(methodInvocationTree)) {
            if (this.getParent() instanceof MethodInvocationTree) {
                this.print("(");
            }
            this.print("await ");
        }
        boolean anonymous = this.isAnonymousMethod(methName);
        boolean targetIsThis = meth.equals("this." + methName);
        boolean targetIsThisOrStaticImported = meth.equals(methName) || targetIsThis;
        ExecutableType type = Util.getType(methodInvocationTree.getMethodSelect()) instanceof ExecutableType ? (ExecutableType)Util.getType(methodInvocationTree.getMethodSelect()) : null;
        Element methSym = null;
        String methodName = null;
        boolean keywordHandled = false;
        if (targetIsThisOrStaticImported) {
            ImportTree staticImport = this.getStaticGlobalImport(methName);
            if (staticImport == null || targetIsThis) {
                ClassTree p = this.getParent(ClassTree.class);
                Element element = methSym = p == null ? null : this.util().findMethodDeclarationInType((TypeElement)Util.getElement(p), methName, type);
                if (methSym != null) {
                    this.typeChecker.checkApply(methodInvocationTree, (ExecutableElement)methSym);
                    if (!methSym.getModifiers().contains((Object)Modifier.STATIC)) {
                        if (!meth.startsWith("this.")) {
                            this.print("this");
                            if (!anonymous) {
                                this.print(".");
                            }
                        }
                    } else {
                        TypeElement methodOwner;
                        if (meth.startsWith("this.") && methSym.getModifiers().contains((Object)Modifier.STATIC)) {
                            this.report((Tree)methodInvocationTree, JSweetProblem.CANNOT_ACCESS_STATIC_MEMBER_ON_THIS, methSym.getSimpleName());
                        }
                        if (!"Globals".equals((methodOwner = this.util().getParentElement(methSym, TypeElement.class)).getSimpleName().toString())) {
                            this.print("" + methodOwner.getSimpleName());
                            if (this.util().isPartOfAnEnum(methodOwner)) {
                                this.print(ENUM_WRAPPER_CLASS_SUFFIX);
                            }
                            if (!anonymous) {
                                this.print(".");
                            }
                        }
                    }
                } else {
                    TypeElement target;
                    if (this.getScope().defaultMethodScope) {
                        target = this.util().getStaticImportTarget(this.getContext().getDefaultMethodCompilationUnit(this.getParent(MethodTree.class)), methName);
                        if (target != null) {
                            this.print(this.getRootRelativeName(target) + ".");
                        }
                    } else {
                        target = this.util().getStaticImportTarget(this.getCompilationUnit(), methName);
                        if (target != null) {
                            this.print(this.getRootRelativeName(target) + ".");
                        }
                    }
                    if (this.getScope().innerClass) {
                        void var16_28;
                        ClassTree parent = this.getParent(ClassTree.class);
                        int level = 0;
                        Object var16_27 = null;
                        if (parent != null) {
                            while (this.getScope((int)level++).innerClass) {
                                parent = this.getParent(ClassTree.class, parent);
                                ExecutableElement executableElement = this.util().findMethodDeclarationInType((TypeElement)Util.getElement(parent), methName, type);
                                if (executableElement == null) continue;
                            }
                        }
                        if (var16_28 != null) {
                            if (var16_28.getModifiers().contains((Object)Modifier.STATIC)) {
                                this.print(var16_28.getEnclosingElement().getSimpleName().toString() + ".");
                            } else {
                                if (level == 0 || !this.getScope().constructor) {
                                    this.print("this.");
                                }
                                for (i = 0; i < level; ++i) {
                                    this.print("__parent.");
                                }
                                if (anonymous) {
                                    this.removeLastChar();
                                }
                            }
                        }
                    }
                }
            } else {
                MemberSelectTree staticFieldAccess = (MemberSelectTree)staticImport.getQualifiedIdentifier();
                methSym = this.util().findMethodDeclarationInType((TypeElement)Util.getTypeElement(staticFieldAccess.getExpression()), methName, type);
                if (methSym != null) {
                    String string;
                    HashMap<String, VariableElement> vars = new HashMap<String, VariableElement>();
                    this.util().fillAllVariablesInScope(vars, this.getStack(), methodInvocationTree, this.getParent(MethodTree.class), this.getCompilationUnit());
                    if (vars.containsKey(methSym.getSimpleName().toString())) {
                        this.report((Tree)methodInvocationTree, JSweetProblem.HIDDEN_INVOCATION, methSym.getSimpleName());
                    }
                    TypeElement methodOwner = this.util().getParentElement(methSym, TypeElement.class);
                    if (!this.context.useModules && methodOwner.getSimpleName().toString().equals("Globals") && methodOwner.getEnclosingElement() != null && !methodOwner.getEnclosingElement().getSimpleName().toString().equals("globals") && !StringUtils.isEmpty((CharSequence)(string = this.getRootRelativeName(methodOwner.getEnclosingElement())))) {
                        this.print(this.getRootRelativeName(methodOwner.getEnclosingElement()) + ".");
                    }
                }
                if (JSweetConfig.TS_STRICT_MODE_KEYWORDS.contains(this.context.getActualName(methSym))) {
                    String targetClass = this.getStaticContainerFullName(staticImport);
                    if (!StringUtils.isBlank((CharSequence)targetClass)) {
                        this.print(targetClass);
                        this.print(".");
                        keywordHandled = true;
                    }
                    if (JSweetConfig.isLibPath(this.util().getQualifiedName(methSym.getEnclosingElement()))) {
                        methodName = methName.toLowerCase();
                    }
                }
            }
        } else if (methodInvocationTree.getMethodSelect() instanceof MemberSelectTree) {
            ExpressionTree selected = ((MemberSelectTree)methodInvocationTree.getMethodSelect()).getExpression();
            Object selectedTypeElement = Util.getTypeElement(selected);
            if (this.context.isFunctionalType((Element)selectedTypeElement)) {
                anonymous = true;
            }
            if (selectedTypeElement instanceof TypeParameterElement) {
                TypeParameterElement typeParameterElement = (TypeParameterElement)selectedTypeElement;
                for (TypeMirror typeMirror : typeParameterElement.getBounds()) {
                    TypeElement genericBoundTypeElement = (TypeElement)this.types().asElement(typeMirror);
                    methSym = this.util().findMethodDeclarationInType(genericBoundTypeElement, methName, type);
                    if (methSym == null) continue;
                    break;
                }
            } else {
                methSym = this.util().findMethodDeclarationInType((TypeElement)selectedTypeElement, methName, type);
            }
            if (methSym != null) {
                this.typeChecker.checkApply(methodInvocationTree, (ExecutableElement)methSym);
            }
        }
        boolean isStatic = methSym == null || methSym.getModifiers().contains((Object)Modifier.STATIC);
        List<? extends ExpressionTree> arguments = methodInvocationTree.getArguments();
        if (!(this.util().hasVarargs((ExecutableElement)methSym) && (arguments.isEmpty() || Util.getType(this.util().last(arguments)).getKind() == TypeKind.ARRAY && this.types().erasure(((ArrayType)Util.getType(this.util().last(arguments))).getComponentType()).equals(this.types().erasure(((ArrayType)this.util().last(methSym.getParameters()).asType()).getComponentType()))))) {
            applyVarargs = false;
        }
        ArrayList<? extends ExpressionTree> substitutionArgs = new ArrayList<ExpressionTree>(methodInvocationTree.getArguments());
        if (methSym != null && applyVarargs && arguments.size() > 0 && arguments.size() == methSym.getParameters().size()) {
            void var16_37;
            ExpressionTree expr = arguments.get(arguments.size() - 1);
            Object var16_34 = null;
            if (expr instanceof NewArrayTree) {
                NewArrayTree newArrayTree = (NewArrayTree)expr;
            } else if (expr instanceof TypeCastTree && ((TypeCastTree)expr).getExpression() instanceof NewArrayTree) {
                NewArrayTree newArrayTree = (NewArrayTree)((TypeCastTree)expr).getExpression();
            }
            if (var16_37 != null) {
                substitutionArgs = new ArrayList<ExpressionTree>(arguments.subList(0, arguments.size() - 1));
                applyVarargs = false;
                if (var16_37.getInitializers() != null) {
                    substitutionArgs.addAll(var16_37.getInitializers());
                }
            }
            if (expr instanceof LiteralTree && "null".equals(expr.toString()) || expr instanceof TypeCastTree && ((TypeCastTree)expr).getExpression() instanceof LiteralTree && "null".equals(((TypeCastTree)expr).getExpression().toString())) {
                substitutionArgs = new ArrayList<ExpressionTree>(arguments.subList(0, arguments.size() - 1));
                applyVarargs = false;
            }
        }
        if (anonymous) {
            applyVarargs = false;
            if (methodInvocationTree.getMethodSelect() instanceof MemberSelectTree) {
                ExpressionTree selected = ((MemberSelectTree)methodInvocationTree.getMethodSelect()).getExpression();
                this.print(selected);
            }
        } else if (methodInvocationTree.getMethodSelect() instanceof MemberSelectTree && applyVarargs && !targetIsThisOrStaticImported && !isStatic) {
            String accessedMemberName;
            this.print("(o => o");
            if (keywordHandled) {
                accessedMemberName = ((MemberSelectTree)methodInvocationTree.getMethodSelect()).getIdentifier().toString();
            } else {
                if (methSym == null) {
                    methSym = (ExecutableElement)Util.getElement((MemberSelectTree)methodInvocationTree.getMethodSelect());
                }
                accessedMemberName = methSym != null ? this.context.getActualName(methSym) : ((MemberSelectTree)methodInvocationTree.getMethodSelect()).getIdentifier().toString();
            }
            this.print(this.getTSMemberAccess(accessedMemberName, true));
        } else if (methodName != null) {
            this.print(this.getTSMemberAccess(methodName, this.removeLastChar('.')));
        } else if (keywordHandled) {
            this.print(methodInvocationTree.getMethodSelect());
        } else {
            if (methSym == null && methodInvocationTree.getMethodSelect() instanceof MemberSelectTree && Util.getElement((MemberSelectTree)methodInvocationTree.getMethodSelect()) instanceof ExecutableElement) {
                methSym = (ExecutableElement)Util.getElement((MemberSelectTree)methodInvocationTree.getMethodSelect());
            }
            if (methSym != null && methodInvocationTree.getMethodSelect() instanceof MemberSelectTree) {
                ExpressionTree selected = ((MemberSelectTree)methodInvocationTree.getMethodSelect()).getExpression();
                Object e = Util.getTypeElement(selected);
                if (e == null || !"Globals".equals(e.getSimpleName().toString())) {
                    if (this.getScope().innerClassNotStatic && ("this".equals(selected.toString()) || selected.toString().endsWith(".this"))) {
                        this.printInnerClassAccess(methSym.getSimpleName().toString(), methSym.getKind(), methSym.getParameters().size());
                    } else {
                        if (methSym.getModifiers().contains((Object)Modifier.STATIC) && selected instanceof IdentifierTree && Util.getElement(selected) instanceof VariableElement) {
                            if (this.context.useModules && !this.context.moduleBundleMode) {
                                this.print(this.getClassName((TypeElement)e));
                                ModuleImportDescriptor moduleImport = this.getAdapter().getModuleImportDescriptor(this.getCompilationUnitElement(), e.getSimpleName().toString(), (TypeElement)e);
                                if (moduleImport != null) {
                                    this.useModule(moduleImport);
                                }
                            } else {
                                this.print(this.getRootRelativeName((Element)e));
                            }
                        } else {
                            this.print(selected);
                        }
                        this.print(".");
                    }
                } else {
                    ModuleImportDescriptor moduleImport;
                    if (methSym.getModifiers().contains((Object)Modifier.STATIC) && (moduleImport = this.getAdapter().getModuleImportDescriptor(new CompilationUnitElementSupport(this.compilationUnit), methSym.getSimpleName().toString(), (TypeElement)e)) != null) {
                        this.useModule(moduleImport);
                    }
                    HashMap<String, VariableElement> vars = new HashMap<String, VariableElement>();
                    this.util().fillAllVariablesInScope(vars, this.getStack(), methodInvocationTree, this.getParent(MethodTree.class), this.getCompilationUnit());
                    if (vars.containsKey(methName)) {
                        this.report((Tree)methodInvocationTree, JSweetProblem.HIDDEN_INVOCATION, methName);
                    }
                }
            }
            if (methSym != null) {
                if (this.context.isInvalidOverload((ExecutableElement)methSym) && !this.util().hasTypeParameters((ExecutableElement)methSym) && !methSym.isDefault() && this.getParent(MethodTree.class) != null && !this.getParent(MethodTree.class).getModifiers().getFlags().contains((Object)Modifier.DEFAULT)) {
                    if (this.context.isInterface((TypeElement)methSym.getEnclosingElement())) {
                        this.removeLastChar('.');
                        this.print("['" + this.getOverloadMethodName((ExecutableElement)methSym) + "']");
                    } else {
                        this.print(this.getOverloadMethodName((ExecutableElement)methSym));
                    }
                } else {
                    this.print(this.getTSMemberAccess(this.context.getActualName(methSym), this.removeLastChar('.')));
                }
            } else {
                this.print(methodInvocationTree.getMethodSelect());
            }
        }
        if (applyVarargs) {
            this.print(".apply");
        } else if (methodInvocationTree.getTypeArguments() != null && !methodInvocationTree.getTypeArguments().isEmpty()) {
            TypeElement targetType2;
            OverloadScanner.Overload overload;
            this.print("<");
            for (Tree tree : methodInvocationTree.getTypeArguments()) {
                this.substituteAndPrintType(tree).print(",");
            }
            if (methSym != null && (overload = this.context.getOverload(targetType2 = (TypeElement)methSym.getEnclosingElement(), (ExecutableElement)methSym)) != null && overload.getMethodsCount() > 1) {
                int missingArgsCount = overload.getCoreMethodElement().getTypeParameters().size() - methodInvocationTree.getTypeArguments().size();
                this.print("any,".repeat(missingArgsCount));
            }
            this.removeLastChar(',');
            this.print(">");
        } else if (methSym != null && !methSym.getTypeParameters().isEmpty() && !(targetType = (TypeElement)methSym.getEnclosingElement()).getQualifiedName().toString().startsWith("def.")) {
            boolean inOverload;
            OverloadScanner.Overload overload = this.context.getOverload(targetType, (ExecutableElement)methSym);
            boolean bl = inOverload = overload != null && overload.getMethodsCount() > 1;
            if (!inOverload || overload.isValid) {
                this.printAnyTypeArguments(methSym.getTypeParameters().size());
            }
        }
        this.print("(");
        if (applyVarargs) {
            String contextVar = "null";
            if (targetIsThisOrStaticImported) {
                contextVar = "this";
            } else if (methodInvocationTree.getMethodSelect() instanceof MemberSelectTree && !targetIsThisOrStaticImported && !isStatic) {
                contextVar = "o";
            }
            this.print(contextVar + ", ");
            if (methodInvocationTree.getArguments().size() > 1) {
                this.print("[");
            }
        }
        int n = argsLength = applyVarargs ? substitutionArgs.size() - 1 : substitutionArgs.size();
        if (this.getScope().innerClassNotStatic && "super".equals(methName) && (typeElement = (TypeElement)Util.getTypeElement(this.getParent(ClassTree.class).getExtendsClause())).getEnclosingElement() instanceof TypeElement && !typeElement.getModifiers().contains((Object)Modifier.STATIC)) {
            this.print(PARENT_CLASS_FIELD_NAME);
            if (argsLength > 0) {
                this.print(", ");
            }
        }
        if (this.getScope().enumWrapperClassScope && this.isAnonymousClass() && "super".equals(methName)) {
            this.print("_$ordinal, _$name");
            if (argsLength > 0) {
                this.print(", ");
            }
        }
        if ("super".equals(methName)) {
            ClassTree classTree = this.getParent(ClassTree.class);
            methSym = classTree == null ? null : this.util().findMethodDeclarationInType((TypeElement)Util.getElement(classTree), "this", type);
        }
        Object t = Util.getType(methodInvocationTree.getMethodSelect());
        for (i = 0; i < argsLength; ++i) {
            ExpressionTree arg = (ExpressionTree)substitutionArgs.get(i);
            if (t != null && t.getKind() == TypeKind.EXECUTABLE) {
                VariableElement var;
                TypeMirror paramType;
                List<? extends TypeMirror> argTypes = ((ExecutableType)t).getParameterTypes();
                TypeMirror typeMirror = paramType = i < argTypes.size() ? argTypes.get(i) : this.util().last(argTypes);
                if (i == argsLength - 1 && !applyVarargs && methSym != null && methSym.isVarArgs() && arg instanceof IdentifierTree && Util.getElement((IdentifierTree)arg) instanceof VariableElement && (var = (VariableElement)Util.getElement((IdentifierTree)arg)).getEnclosingElement() instanceof ExecutableElement && this.util().isVarargs(var)) {
                    this.print("...");
                }
                if (!this.substituteAssignedExpression(paramType, arg)) {
                    this.print(arg);
                }
            } else {
                this.print(arg);
            }
            if (i >= argsLength - 1) continue;
            this.print(", ");
        }
        if (applyVarargs) {
            if (substitutionArgs.size() > 1) {
                this.print("].concat(<any[]>");
            }
            if (!substitutionArgs.isEmpty()) {
                this.print((Tree)substitutionArgs.get(substitutionArgs.size() - 1));
            }
            if (substitutionArgs.size() > 1) {
                this.print(")");
            }
            if (methodInvocationTree.getMethodSelect() instanceof MemberSelectTree && !targetIsThisOrStaticImported && !isStatic) {
                this.print("))(").print(((MemberSelectTree)methodInvocationTree.getMethodSelect()).getExpression());
            }
        }
        this.print(")");
        if (this.context.isAwaitInvocation(methodInvocationTree) && this.getParent() instanceof MethodInvocationTree) {
            this.print(")");
        }
    }

    private boolean isAnonymousMethod(String methName) {
        boolean anonymous = "$apply".equals(methName) || "$applyStatic".equals(methName) || this.context.deprecatedApply && "apply".equals(methName) || this.context.deprecatedApply && "applyStatic".equals(methName) || "$new".equals(methName);
        return anonymous;
    }

    private ImportTree getStaticGlobalImport(String methName) {
        if (this.compilationUnit == null) {
            return null;
        }
        for (ImportTree importTree : this.compilationUnit.getImports()) {
            if (!importTree.isStatic() || !importTree.getQualifiedIdentifier().toString().endsWith("Globals." + methName)) continue;
            return importTree;
        }
        return null;
    }

    private String getStaticContainerFullName(ImportTree importDecl) {
        if (importDecl.getQualifiedIdentifier() instanceof MemberSelectTree) {
            MemberSelectTree fa = (MemberSelectTree)importDecl.getQualifiedIdentifier();
            String name = this.context.getRootRelativeJavaName((Element)Util.getTypeElement(fa.getExpression()));
            if ("Globals".equals(name)) {
                return null;
            }
            boolean globals = name.endsWith(".Globals");
            if (globals) {
                name = name.substring(0, name.length() - "Globals".length() - 1);
            }
            if (this.util().getPackageFullNameForCompilationUnit(this.compilationUnit).startsWith(name)) {
                return null;
            }
            return name;
        }
        return null;
    }

    @Override
    public Void visitIdentifier(IdentifierTree identifierTree, Trees trees) {
        Object identifierElement = Util.getElement(identifierTree);
        Object name = identifierTree.toString();
        if (this.getScope().inlinedConstructorArgs != null && identifierElement instanceof VariableElement && this.getScope().inlinedConstructorArgs.contains(name)) {
            this.print("__args[" + this.getScope().inlinedConstructorArgs.indexOf(name) + "]");
            return Java2TypeScriptTranslator.returnNothing();
        }
        if (!this.getAdapter().substitute((ExtendedElement)this.createExtendedElement(identifierTree))) {
            VariableElement varElement;
            boolean lazyInitializedStatic = false;
            if (identifierElement instanceof VariableElement && !identifierElement.getSimpleName().toString().equals("this") && !identifierElement.getSimpleName().toString().equals("super") && (varElement = (VariableElement)identifierElement) != null) {
                Element varEnclosingElement = varElement.getEnclosingElement();
                if (varEnclosingElement instanceof TypeElement) {
                    name = this.context.getFieldNameMapping(varElement) != null ? this.context.getFieldNameMapping(varElement) : this.getIdentifier(varElement);
                    if (!varElement.getModifiers().contains((Object)Modifier.STATIC)) {
                        this.printInnerClassAccess(varElement.getSimpleName().toString(), ElementKind.FIELD);
                    } else {
                        String prefix;
                        if (this.isLazyInitialized(varElement)) {
                            lazyInitializedStatic = true;
                        }
                        if (!this.util().getQualifiedName(varEnclosingElement).toString().endsWith(".Globals")) {
                            if (!this.context.useModules && !varEnclosingElement.equals(Util.getElement(this.getParent(ClassTree.class)))) {
                                prefix = this.context.getRootRelativeName(null, varEnclosingElement);
                                if (!StringUtils.isEmpty((CharSequence)prefix)) {
                                    this.print(this.context.getRootRelativeName(null, varEnclosingElement));
                                    if (lazyInitializedStatic && this.util().isPartOfAnEnum(varEnclosingElement)) {
                                        this.print(ENUM_WRAPPER_CLASS_SUFFIX);
                                    }
                                    this.print(".");
                                }
                            } else if (!varEnclosingElement.getSimpleName().toString().equals("globals")) {
                                this.print(varEnclosingElement.getSimpleName().toString());
                                this.ensureModuleIsUsed(varEnclosingElement);
                                if (lazyInitializedStatic && this.util().isPartOfAnEnum(varEnclosingElement)) {
                                    this.print(ENUM_WRAPPER_CLASS_SUFFIX);
                                }
                                this.print(".");
                            }
                        } else if (!this.context.useModules) {
                            prefix = this.context.getRootRelativeName(null, varEnclosingElement);
                            if (!(prefix = prefix.substring(0, prefix.length() - "Globals".length())).equals("globals.") && !prefix.endsWith(".globals.")) {
                                this.print(prefix);
                            }
                        }
                    }
                } else if (varEnclosingElement instanceof ExecutableElement && this.isAnonymousClass() && this.getScope((int)1).finalVariables.get(this.getScope((int)1).anonymousClasses.indexOf(this.getParent(ClassTree.class))).contains(varElement)) {
                    this.print("this.");
                } else {
                    if (!this.context.useModules && varEnclosingElement instanceof ExecutableElement && this.context.importedTopPackages.contains(name)) {
                        name = "__var_" + (String)name;
                    }
                    if (JSweetConfig.JS_KEYWORDS.contains(name)) {
                        name = "__" + (String)name;
                    }
                }
            }
            if (identifierElement instanceof TypeElement) {
                TypeElement classIdentifierTypeElement = (TypeElement)identifierElement;
                boolean prefixAdded = false;
                if (this.getScope().defaultMethodScope && this.util().isImported(this.getContext().getDefaultMethodCompilationUnit(this.getParent(MethodTree.class)), classIdentifierTypeElement)) {
                    String rootRelativeName = this.getRootRelativeName(classIdentifierTypeElement.getEnclosingElement());
                    if (!rootRelativeName.isEmpty()) {
                        this.print(rootRelativeName + ".");
                        PackageElement identifierPackage = this.util().getParentElement(classIdentifierTypeElement, PackageElement.class);
                        String pathToModulePackage = this.util().getRelativePath((Element)Util.getElement(this.compilationUnit.getPackage()), identifierPackage);
                        if (pathToModulePackage == null) {
                            pathToModulePackage = ".";
                        }
                        File moduleFile = new File(new File(pathToModulePackage), classIdentifierTypeElement.getEnclosingElement().getSimpleName().toString());
                        this.useModule(false, false, identifierPackage, identifierTree, classIdentifierTypeElement.getEnclosingElement().getSimpleName().toString(), moduleFile.getPath().replace('\\', '/'), null);
                    }
                    prefixAdded = true;
                }
                if (!prefixAdded && classIdentifierTypeElement.getEnclosingElement() instanceof TypeElement) {
                    if (this.context.useModules) {
                        String enclosingName = classIdentifierTypeElement.getEnclosingElement().getSimpleName().toString();
                        if (this.context.hasClassNameMapping((TypeElement)classIdentifierTypeElement.getEnclosingElement())) {
                            enclosingName = this.context.getClassNameMapping((TypeElement)classIdentifierTypeElement.getEnclosingElement());
                        }
                        this.print(enclosingName + ".");
                        prefixAdded = true;
                    } else if (!this.getCompilationUnit().getImports().stream().map(i -> Util.getTypeElement(i.getQualifiedIdentifier())).anyMatch(t -> t == classIdentifierTypeElement)) {
                        if (classIdentifierTypeElement.getEnclosingElement() instanceof TypeElement) {
                            this.print(this.getClassName((TypeElement)classIdentifierTypeElement.getEnclosingElement()) + ".");
                        } else {
                            this.print(classIdentifierTypeElement.getEnclosingElement().getSimpleName() + ".");
                        }
                        prefixAdded = true;
                    }
                }
                if (!(prefixAdded || this.context.useModules || classIdentifierTypeElement.equals(Util.getElement(this.getParent(ClassTree.class))))) {
                    this.print(this.getRootRelativeName(classIdentifierTypeElement));
                } else if (this.context.hasClassNameMapping(classIdentifierTypeElement)) {
                    this.print(this.context.getClassNameMapping(classIdentifierTypeElement));
                } else {
                    this.print((String)name);
                }
            } else {
                if (this.doesMemberNameRequireQuotes((String)name)) {
                    if (this.getLastPrintedChar() == '.') {
                        this.removeLastChar();
                        this.print("['").print((String)name).print("']");
                    } else {
                        this.print("this['").print((String)name).print("']");
                    }
                } else {
                    this.print((String)name);
                }
                if (lazyInitializedStatic && !this.staticInitializedAssignment) {
                    this.print("_$LI$()");
                }
            }
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitParameterizedType(ParameterizedTypeTree typeApply, Trees trees) {
        this.substituteAndPrintType(typeApply);
        return Java2TypeScriptTranslator.returnNothing();
    }

    private int initAnonymousClass(NewClassTree newClass) {
        int anonymousClassIndex = this.getScope().anonymousClasses.indexOf(newClass.getClassBody());
        if (anonymousClassIndex == -1) {
            anonymousClassIndex = this.getScope().anonymousClasses.size();
            this.getScope().anonymousClasses.add(newClass.getClassBody());
            this.getScope().anonymousClassesConstructors.add(newClass);
            final LinkedHashSet finalVars = new LinkedHashSet();
            this.getScope().finalVariables.add(finalVars);
            final Object newClassTypeElement = Util.getElement(newClass.getClassBody());
            new TreeScanner<Void, Trees>(){

                @Override
                public Void visitIdentifier(IdentifierTree var, Trees trees) {
                    VariableElement varElement;
                    if (Util.getElement(var) instanceof VariableElement && (varElement = (VariableElement)Util.getElement(var)).getEnclosingElement() instanceof ExecutableElement) {
                        Element methodEnclosingTypeElement = varElement.getEnclosingElement().getEnclosingElement();
                        boolean finalVariableFromThisClass = false;
                        Element wrappingTypeElement = methodEnclosingTypeElement;
                        do {
                            if (wrappingTypeElement != newClassTypeElement) continue;
                            finalVariableFromThisClass = true;
                            break;
                        } while ((wrappingTypeElement = wrappingTypeElement.getEnclosingElement()) != null);
                        if (!finalVariableFromThisClass) {
                            finalVars.add(varElement);
                        }
                    }
                    return Java2TypeScriptTranslator.returnNothing();
                }
            }.visitClass(newClass.getClassBody(), this.trees());
        }
        return anonymousClassIndex;
    }

    @Override
    public Void visitNewClass(NewClassTree newClass, Trees trees) {
        TypeElement classTypeElement = (TypeElement)Util.getTypeElement(newClass.getIdentifier());
        if (classTypeElement.getSimpleName().toString().equals("Globals")) {
            this.report((Tree)newClass, JSweetProblem.GLOBAL_CANNOT_BE_INSTANTIATED, new Object[0]);
            return Java2TypeScriptTranslator.returnNothing();
        }
        if (this.getScope().isLocalClassType(classTypeElement.asType())) {
            this.print("new ").print(this.getScope().getName() + ".").print(newClass.getIdentifier().toString());
            this.print("(").printConstructorArgList(newClass, true).print(")");
            return Java2TypeScriptTranslator.returnNothing();
        }
        boolean isInterface = this.context.isInterface(classTypeElement);
        if (newClass.getClassBody() != null || isInterface) {
            if (this.context.isAnonymousClass(newClass, this.getCompilationUnit())) {
                int anonymousClassIndex = this.initAnonymousClass(newClass);
                this.print("new ").print(this.getScope().getName() + "." + this.getScope().getName() + ANONYMOUS_PREFIX + anonymousClassIndex);
                if (this.isStaticAnonymousClass(newClass, this.getCompilationUnit())) {
                    this.printAnonymousClassTypeArgs(newClass);
                }
                this.print("(");
                this.printConstructorArgList(newClass, false);
                this.print(")");
                return Java2TypeScriptTranslator.returnNothing();
            }
            if (isInterface || this.context.hasAnnotationType(classTypeElement, "jsweet.lang.ObjectType")) {
                boolean bl;
                if (isInterface) {
                    this.print("<any>");
                }
                HashSet<String> interfaces = new HashSet<String>();
                this.context.grabSupportedInterfaceNames(interfaces, classTypeElement, this.getAdapter());
                if (!interfaces.isEmpty()) {
                    this.print("Object.defineProperty(");
                }
                this.print("{").println().startIndent();
                boolean bl2 = false;
                boolean initializationBlockFound = false;
                if (newClass.getClassBody() != null) {
                    for (Tree tree : newClass.getClassBody().getMembers()) {
                        MethodTree method;
                        if (tree instanceof BlockTree) {
                            initializationBlockFound = true;
                            ArrayList<VariableElement> initializedVars = new ArrayList<VariableElement>();
                            for (Tree tree2 : ((BlockTree)tree).getStatements()) {
                                MethodInvocationTree invocation;
                                MethodInvocationElement invocationElement;
                                boolean currentStatementPrinted = false;
                                if (tree2 instanceof ExpressionStatementTree && ((ExpressionStatementTree)tree2).getExpression() instanceof AssignmentTree) {
                                    AssignmentTree assignment = (AssignmentTree)((ExpressionStatementTree)tree2).getExpression();
                                    VariableElement var = null;
                                    if (assignment.getVariable() instanceof MemberSelectTree) {
                                        var = this.util().findFieldDeclaration(classTypeElement, ((MemberSelectTree)assignment.getVariable()).getIdentifier());
                                        this.printIndent().print(var.getSimpleName().toString());
                                    } else {
                                        if (!(assignment.getVariable() instanceof IdentifierTree)) continue;
                                        var = this.util().findFieldDeclaration(classTypeElement, ((IdentifierTree)assignment.getVariable()).getName());
                                        this.printIndent().print(assignment.getVariable().toString());
                                    }
                                    initializedVars.add(var);
                                    this.print(": ").print(assignment.getExpression()).print(",").println();
                                    currentStatementPrinted = true;
                                    bl = true;
                                } else if (tree2 instanceof ExpressionStatementTree && ((ExpressionStatementTree)tree2).getExpression() instanceof MethodInvocationTree && (invocationElement = (MethodInvocationElement)this.createExtendedElement(invocation = (MethodInvocationTree)((ExpressionStatementTree)tree2).getExpression())).getMethodName().equals("$set")) {
                                    if (invocation.getArguments().size() == 3) {
                                        if ("this".equals(invocation.getArguments().get(0).toString())) {
                                            this.printIndent().print(invocation.getArguments().get(1)).print(": ").print(invocation.getArguments().get(2)).print(",").println();
                                        }
                                        currentStatementPrinted = true;
                                        bl = true;
                                    } else {
                                        this.printIndent().print(invocation.getArguments().get(0)).print(": ").print(invocation.getArguments().get(1)).print(",").println();
                                        currentStatementPrinted = true;
                                        bl = true;
                                    }
                                }
                                if (currentStatementPrinted) continue;
                                this.report(tree2, JSweetProblem.INVALID_INITIALIZER_STATEMENT, new Object[0]);
                            }
                            for (Element element : classTypeElement.getEnclosedElements()) {
                                if (!(element instanceof VariableElement) || initializedVars.contains(element) || this.context.hasAnnotationType(element, "jsweet.lang.Optional")) continue;
                                this.report(tree, JSweetProblem.UNINITIALIZED_FIELD, element);
                            }
                        }
                        if (!(tree instanceof MethodTree) || Util.getElement(method = (MethodTree)tree).getKind() == ElementKind.CONSTRUCTOR) continue;
                        this.printIndent().print(method.getName() + ": (");
                        for (VariableTree variableTree : method.getParameters()) {
                            this.print(variableTree.getName() + ", ");
                        }
                        if (!method.getParameters().isEmpty()) {
                            this.removeLastChars(2);
                        }
                        this.print(") => ");
                        this.print(method.getBody());
                        this.print(",").println();
                        bl = true;
                    }
                    if (bl) {
                        this.removeLastChars(2);
                    }
                }
                if (!bl && !initializationBlockFound) {
                    for (Element element : classTypeElement.getEnclosedElements()) {
                        if (!(element instanceof VariableElement) || this.context.hasAnnotationType(element, "jsweet.lang.Optional")) continue;
                        this.report((Tree)newClass, JSweetProblem.UNINITIALIZED_FIELD, element);
                    }
                }
                this.println().endIndent().printIndent().print("}");
                if (!interfaces.isEmpty()) {
                    this.print(", 'constructor', { configurable: true, value: { __interfaces: ");
                    this.print("[");
                    for (String string : interfaces) {
                        this.print(this.getStringLiteralQuote()).print(string).print(this.getStringLiteralQuote() + ",");
                    }
                    this.removeLastChar();
                    this.print("] }");
                    this.print(" })");
                }
            } else {
                this.print("((target:").print(newClass.getIdentifier()).print(") => {").println().startIndent();
                for (Tree tree : newClass.getClassBody().getMembers()) {
                    if (!(tree instanceof BlockTree)) continue;
                    for (Tree tree3 : ((BlockTree)tree).getStatements()) {
                        MethodInvocationTree invocation;
                        MethodInvocationElement invocationElement;
                        boolean bl = false;
                        if (tree3 instanceof ExpressionStatementTree && ((ExpressionStatementTree)tree3).getExpression() instanceof AssignmentTree) {
                            AssignmentTree assignment = (AssignmentTree)((ExpressionStatementTree)tree3).getExpression();
                            VariableElement var = null;
                            if (assignment.getVariable() instanceof MemberSelectTree) {
                                var = this.util().findFieldDeclaration(classTypeElement, ((MemberSelectTree)assignment.getVariable()).getIdentifier());
                                this.printIndent().print("target['").print(var.getSimpleName().toString()).print("']");
                            } else {
                                if (!(assignment.getVariable() instanceof IdentifierTree)) continue;
                                this.printIndent().print("target['").print(assignment.getVariable().toString()).print("']");
                            }
                            this.print(" = ").print(assignment.getExpression()).print(";").println();
                            bl = true;
                        } else if (tree3 instanceof ExpressionStatementTree && ((ExpressionStatementTree)tree3).getExpression() instanceof MethodInvocationTree && (invocationElement = (MethodInvocationElement)this.createExtendedElement(invocation = (MethodInvocationTree)((ExpressionStatementTree)tree3).getExpression())).getMethodName().equals("$set")) {
                            if (invocation.getArguments().size() == 3) {
                                if ("this".equals(invocation.getArguments().get(0).toString())) {
                                    this.printIndent().print("target[").print(invocation.getArguments().get(1)).print("]").print(" = ").print(invocation.getArguments().get(2)).print(";").println();
                                }
                                bl = true;
                            } else {
                                this.printIndent().print("target[").print(invocation.getArguments().get(0)).print("]").print(" = ").print(invocation.getArguments().get(1)).print(";").println();
                                bl = true;
                            }
                        }
                        if (bl) continue;
                        this.report(tree3, JSweetProblem.INVALID_INITIALIZER_STATEMENT, new Object[0]);
                    }
                }
                this.printIndent().print("return target;").println();
                this.println().endIndent().printIndent().print("})(");
                this.print("new ").print(newClass.getIdentifier()).print("(").printArgList(null, newClass.getArguments()).print("))");
            }
        } else if (this.context.hasAnnotationType(classTypeElement, "jsweet.lang.ObjectType")) {
            this.print("{}");
        } else {
            this.getAdapter().substituteNewClass((NewClassElement)this.createExtendedElement(newClass));
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    public void printDefaultNewClass(NewClassTree newClass) {
        Object classType = Util.getType(newClass.getIdentifier());
        TypeElement classTypeElement = (TypeElement)Util.getTypeElement(newClass.getIdentifier());
        String mappedType = this.context.getTypeMappingTarget(classType.toString());
        if (this.typeChecker.checkType(newClass, null, newClass.getIdentifier(), this.getCompilationUnit())) {
            boolean applyVarargs = true;
            Object constructorElement = Util.getElement(newClass);
            if (!(constructorElement instanceof ExecutableElement)) {
                this.print("null /*cannot resolve " + newClass.getIdentifier() + "*/");
                return;
            }
            ExecutableElement constructorExecutableElement = (ExecutableElement)constructorElement;
            if (newClass.getArguments().size() == 0 || !this.util().hasVarargs(constructorExecutableElement) || Util.getType(this.util().last(newClass.getArguments())).getKind() != TypeKind.ARRAY || !this.types().erasure(((ArrayType)Util.getType(this.util().last(newClass.getArguments()))).getComponentType()).equals(this.types().erasure(((ArrayType)this.util().last(constructorExecutableElement.getParameters()).asType()).getComponentType()))) {
                applyVarargs = false;
            }
            if (applyVarargs) {
                this.context.addGlobalsMapping("Function", "__Function");
                this.print("<any>new (__Function.prototype.bind.apply(");
                if (mappedType != null) {
                    this.print(Java2TypeScriptTranslator.mapConstructorType(mappedType));
                } else {
                    this.print(newClass.getIdentifier());
                }
                this.print(", [null");
                for (int i = 0; i < newClass.getArguments().size() - 1; ++i) {
                    this.print(", ").print(newClass.getArguments().get(i));
                }
                this.print("].concat(<any[]>").print(this.util().last(newClass.getArguments())).print(")))");
            } else if (newClass.getIdentifier() instanceof ParameterizedTypeTree) {
                ParameterizedTypeTree typeApply = (ParameterizedTypeTree)((Object)newClass.getIdentifier());
                mappedType = this.context.getTypeMappingTarget(Util.getType(typeApply.getType()).toString());
                this.print("new ");
                if (mappedType != null) {
                    this.print(Java2TypeScriptTranslator.mapConstructorType(mappedType));
                } else {
                    this.print(typeApply.getType());
                }
                if (!typeApply.getTypeArguments().isEmpty()) {
                    this.print("<").printTypeArgList(typeApply.getTypeArguments()).print(">");
                } else {
                    this.printAnyTypeArguments(classTypeElement.getTypeParameters().size());
                }
                this.print("(").printConstructorArgList(newClass, false).print(")");
            } else {
                if (constructorExecutableElement.asType().getKind() == TypeKind.ERROR) {
                    this.print("null /*cannot resolve " + newClass.getIdentifier() + "*/");
                    return;
                }
                this.print("new ");
                if (mappedType != null) {
                    this.print(Java2TypeScriptTranslator.mapConstructorType(mappedType));
                } else {
                    this.print(newClass.getIdentifier());
                }
                this.print("(").printConstructorArgList(newClass, false).print(")");
            }
        }
    }

    public void printAnyTypeArguments(int count) {
        this.print("<");
        for (int i = 0; i < count; ++i) {
            this.print("any, ");
        }
        if (count > 0) {
            this.removeLastChars(2);
        }
        this.print(">");
    }

    @Override
    public AbstractTreePrinter printConstructorArgList(NewClassTree newClass, boolean localClass) {
        TypeElement classTypeElement = (TypeElement)Util.getTypeElement(newClass.getIdentifier());
        boolean printed = false;
        if (localClass || this.getScope().anonymousClasses.contains(newClass.getClassBody()) && !this.isStaticAnonymousClass(newClass, this.getCompilationUnit())) {
            this.print("this");
            if (!newClass.getArguments().isEmpty()) {
                this.print(", ");
            }
            printed = true;
        } else if (classTypeElement.getEnclosingElement() instanceof TypeElement && !classTypeElement.getModifiers().contains((Object)Modifier.STATIC) && !this.isStaticAnonymousClass(newClass, this.getCompilationUnit())) {
            TypeElement parentSymbol;
            this.print("this");
            ClassTree parent = this.getParent(ClassTree.class);
            TypeElement typeElement = parentSymbol = parent == null ? null : (TypeElement)Util.getElement(parent);
            if (classTypeElement.getEnclosingElement() != parentSymbol) {
                this.print(".__parent");
            }
            if (!newClass.getArguments().isEmpty()) {
                this.print(", ");
            }
            printed = true;
        }
        ExecutableType methodType = (ExecutableType)Util.getElement(newClass).asType();
        this.printArgList(methodType == null ? null : methodType.getParameterTypes(), newClass.getArguments());
        int index = this.getScope().anonymousClasses.indexOf(newClass.getClassBody());
        if (index >= 0 && !this.getScope().finalVariables.get(index).isEmpty()) {
            if (printed || !newClass.getArguments().isEmpty()) {
                this.print(", ");
            }
            for (VariableElement paramToBeTransmittedToAnonymous : this.getScope().finalVariables.get(index)) {
                Element paramEnclosingTypeElement = paramToBeTransmittedToAnonymous.getEnclosingElement().getEnclosingElement();
                Object anonymousClassEnclosingTypeElement = Util.getElement(this.getParent(ClassTree.class));
                if (anonymousClassEnclosingTypeElement != paramEnclosingTypeElement) {
                    this.print("this.");
                }
                this.print(paramToBeTransmittedToAnonymous.getSimpleName().toString());
                this.print(", ");
            }
            this.removeLastChars(2);
        }
        return this;
    }

    @Override
    public Void visitLiteral(LiteralTree literal, Trees trees) {
        Object s = literal.toString();
        switch (Util.getType(literal).getKind()) {
            case FLOAT: {
                if (!((String)s).endsWith("F")) break;
                s = ((String)s).substring(0, ((String)s).length() - 1);
                break;
            }
            case LONG: {
                if (!((String)s).endsWith("L")) break;
                s = ((String)s).substring(0, ((String)s).length() - 1);
                break;
            }
        }
        if (((String)s).startsWith("\"") && this.context.options.isUseSingleQuotesForStringLiterals()) {
            s = "'" + ((String)s).substring(1, ((String)s).length() - 1).replace("'", "'") + "'";
        }
        this.print((String)s);
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitArrayAccess(ArrayAccessTree arrayAccess, Trees trees) {
        if (!this.getAdapter().substituteArrayAccess((ArrayAccessElement)this.createExtendedElement(arrayAccess))) {
            this.print(arrayAccess.getExpression()).print("[").substituteAndPrintAssignedExpression(this.util().getType(Integer.TYPE), arrayAccess.getIndex()).print("]");
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    private int getIndexVariableCount() {
        return this.getScope().foreachLoopContext == null ? 0 : this.getScope().foreachLoopContext.size();
    }

    private Set<String> getGeneratedVariableNames() {
        HashSet<String> names = new HashSet<String>();
        if (this.getScope().foreachLoopContext != null) {
            this.getScope().foreachLoopContext.stream().forEach(s -> {
                names.add(s.variableName);
                if (s.arrayName != null) {
                    names.add(s.arrayName);
                }
            });
        }
        return names;
    }

    private int getArrayVariableCount() {
        return this.getScope().foreachLoopContext == null ? 0 : (int)this.getScope().foreachLoopContext.stream().filter(s -> s.arrayName != null).count();
    }

    private String getFreeVariableName(String variablePrefix, int index) {
        int position;
        String name = variablePrefix + (String)(index == 0 ? "" : "" + index);
        Set<String> generatedVariableNames = this.getGeneratedVariableNames();
        while (generatedVariableNames.contains(name)) {
            name = variablePrefix + ++index;
        }
        for (position = this.stack.size() - 2; position >= 0 && !(this.stack.get(position) instanceof MethodTree); --position) {
            Tree t;
            if (!(this.stack.get(position) instanceof BlockTree)) continue;
            BlockTree block = (BlockTree)this.stack.get(position);
            Iterator<? extends StatementTree> iterator = block.getStatements().iterator();
            while (iterator.hasNext() && (t = (Tree)iterator.next()) != this.stack.get(position + 1)) {
                if (!(t instanceof VariableTree) || !name.equals(((VariableTree)t).getName().toString())) continue;
                return this.getFreeVariableName(variablePrefix, index + 1);
            }
        }
        if (position >= 0 && this.stack.get(position) instanceof MethodTree) {
            for (VariableTree variableTree : ((MethodTree)this.stack.get(position)).getParameters()) {
                if (!name.equals(variableTree.getName().toString())) continue;
                return this.getFreeVariableName(variablePrefix, index + 1);
            }
        }
        if (this.getCurrent() instanceof EnhancedForLoopTree) {
            EnhancedForLoopTree loop = (EnhancedForLoopTree)this.getCurrent();
            if (name.equals(loop.getVariable().getName().toString())) {
                return this.getFreeVariableName(variablePrefix, index + 1);
            }
            StatementTree statementTree = loop.getStatement();
            if (statementTree instanceof BlockTree) {
                BlockTree block = (BlockTree)statementTree;
                for (Tree tree : block.getStatements()) {
                    if (!(tree instanceof VariableTree) || !name.equals(((VariableTree)tree).getName().toString())) continue;
                    return this.getFreeVariableName(variablePrefix, index + 1);
                }
            }
        }
        return name;
    }

    @Override
    public Void visitEnhancedForLoop(EnhancedForLoopTree foreachLoop, Trees trees) {
        String indexVarName = this.getFreeVariableName("index".equals(foreachLoop.getVariable().getName().toString()) ? "loopIndex" : "index", this.getIndexVariableCount());
        boolean[] hasLength = new boolean[]{false};
        TypeElement targetType = (TypeElement)Util.getTypeElement(foreachLoop.getExpression());
        Object collectionType = Util.getType(foreachLoop.getExpression());
        if (collectionType.getKind() == TypeKind.ARRAY) {
            hasLength[0] = true;
        } else {
            this.util().scanMemberDeclarationsInType(targetType, this.getAdapter().getErasedTypes(), element -> {
                if (element instanceof VariableElement && "length".equals(element.getSimpleName().toString()) && this.util().isNumber(((VariableElement)element).asType())) {
                    hasLength[0] = true;
                    return false;
                }
                return true;
            });
        }
        if (!this.getAdapter().substituteForEachLoop((ForeachLoopElement)this.createExtendedElement(foreachLoop), hasLength[0], indexVarName)) {
            if (this.getScope().foreachLoopContext == null) {
                this.getScope().foreachLoopContext = new Stack();
            }
            ForeachLoopScope foreachLoopScope = new ForeachLoopScope(foreachLoop);
            this.getScope().foreachLoopContext.push(foreachLoopScope);
            boolean noVariable = foreachLoop.getExpression() instanceof IdentifierTree || foreachLoop.getExpression() instanceof MemberSelectTree;
            foreachLoopScope.variableName = indexVarName;
            if (noVariable) {
                this.print("for(let " + indexVarName + " = 0; " + indexVarName + " < ").print(foreachLoop.getExpression()).print(".length; " + indexVarName + "++) {").println().startIndent().printIndent();
                this.print("let " + this.avoidJSKeyword(foreachLoop.getVariable().getName().toString()) + " = ").print(foreachLoop.getExpression()).print("[" + indexVarName + "];").println();
            } else {
                String arrayVarName;
                foreachLoopScope.arrayName = arrayVarName = this.getFreeVariableName("array", this.getArrayVariableCount());
                this.print("{").println().startIndent().printIndent();
                this.print("let " + arrayVarName + " = ").print(foreachLoop.getExpression()).print(";").println().printIndent();
                this.print("for(let " + indexVarName + " = 0; " + indexVarName + " < " + arrayVarName + ".length; " + indexVarName + "++) {").println().startIndent().printIndent();
                this.print("let " + this.avoidJSKeyword(foreachLoop.getVariable().getName().toString()) + " = " + arrayVarName + "[" + indexVarName + "];").println();
            }
            this.visitBeforeForEachBody(foreachLoop);
            this.printIndent().print(foreachLoop.getStatement());
            this.endIndent().println().printIndent().print("}");
            if (!noVariable) {
                this.endIndent().println().printIndent().print("}");
            }
            this.getScope().foreachLoopContext.pop();
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    protected void visitBeforeForEachBody(EnhancedForLoopTree foreachLoop) {
    }

    @Override
    public Void visitPrimitiveType(PrimitiveTypeTree type, Trees trees) {
        switch (Util.getType(type).getKind()) {
            case FLOAT: 
            case LONG: 
            case BYTE: 
            case DOUBLE: 
            case INT: 
            case SHORT: {
                this.print("number");
                break;
            }
            default: {
                this.print(type.toString());
            }
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    private boolean singlePrecisionFloats() {
        return !this.context.options.isDisableSinglePrecisionFloats() && this.context.options.getEcmaTargetVersion().higherThan(EcmaScriptComplianceLevel.ES3);
    }

    @Override
    public Void visitBinary(BinaryTree binary, Trees trees) {
        if (!this.getAdapter().substituteBinaryOperator((BinaryOperatorElement)this.createExtendedElement(binary))) {
            Object op = this.util().toOperator(binary.getKind());
            boolean forceParens = false;
            boolean booleanOp = false;
            if (this.types().isSameType(this.util().getType(Boolean.TYPE), this.util().unboxedTypeOrType((TypeMirror)Util.getType(binary.getLeftOperand())))) {
                booleanOp = true;
                if ("^".equals(op)) {
                    forceParens = true;
                }
                if ("|".equals(op) || "&".equals(op)) {
                    this.print("((lhs, rhs) => lhs " + (String)op + (String)op + " rhs)(").print(binary.getLeftOperand()).print(", ").print(binary.getRightOperand()).print(")");
                    return Java2TypeScriptTranslator.returnNothing();
                }
            }
            Object binaryType = Util.getType(binary);
            Object leftType = Util.getType(binary.getLeftOperand());
            Object rightType = Util.getType(binary.getRightOperand());
            TypeMirror stringType = this.util().getType(String.class);
            boolean closeParen = false;
            boolean truncate = false;
            if (this.util().isIntegral((TypeMirror)binaryType) && binary.getKind() == Tree.Kind.DIVIDE) {
                if (binaryType.getKind() == TypeKind.LONG) {
                    this.print("(n => n<0?Math.ceil(n):Math.floor(n))(");
                    closeParen = true;
                } else {
                    this.print("(");
                    truncate = true;
                }
            }
            if (this.singlePrecisionFloats() && binaryType.getKind() == TypeKind.FLOAT) {
                this.print("(<any>Math).fround(");
                closeParen = true;
            }
            boolean charWrapping = this.util().isArithmeticOrLogicalOperator(binary.getKind()) || this.util().isComparisonOperator(binary.getKind());
            boolean actualCharWrapping = false;
            if (charWrapping && this.types().isSameType(this.util().getType(Character.TYPE), this.util().unboxedTypeOrType((TypeMirror)Util.getType(binary.getLeftOperand()))) && !this.types().isSameType((TypeMirror)rightType, stringType)) {
                actualCharWrapping = true;
                if (binary.getLeftOperand() instanceof LiteralTree) {
                    this.printBinaryLeftOperand(binary);
                    this.print(".charCodeAt(0)");
                } else {
                    this.print("(c => c.charCodeAt==null?<any>c:c.charCodeAt(0))(").print(binary.getLeftOperand()).print(")");
                }
            } else {
                if (forceParens) {
                    this.print("(");
                }
                this.printBinaryLeftOperand(binary);
                if (forceParens) {
                    this.print(")");
                }
            }
            if (booleanOp) {
                if ("|".equals(op)) {
                    op = "||";
                } else if ("&".equals(op)) {
                    op = "&&";
                } else if ("^".equals(op)) {
                    op = "!==";
                }
            }
            if (("==".equals(op) || "!=".equals(op)) && charWrapping && this.types().isSameType(this.util().getType(Character.TYPE), this.util().unboxedTypeOrType((TypeMirror)rightType)) && !this.types().isSameType((TypeMirror)leftType, stringType)) {
                actualCharWrapping = true;
            }
            if (!actualCharWrapping && ("==".equals(op) || "!=".equals(op))) {
                switch (this.getComparisonMode()) {
                    case FORCE_STRICT: {
                        op = (String)op + "=";
                        break;
                    }
                    case STRICT: {
                        if (this.util().isNullLiteral(binary.getLeftOperand()) || this.util().isNullLiteral(binary.getRightOperand())) break;
                        op = (String)op + "=";
                        break;
                    }
                }
            }
            this.space().print((String)op).space();
            if (charWrapping && this.types().isSameType(this.util().getType(Character.TYPE), this.util().unboxedTypeOrType((TypeMirror)rightType)) && !this.types().isSameType((TypeMirror)leftType, stringType)) {
                if (binary.getRightOperand() instanceof LiteralTree) {
                    this.printBinaryRightOperand(binary);
                    this.print(".charCodeAt(0)");
                } else {
                    this.print("(c => c.charCodeAt==null?<any>c:c.charCodeAt(0))(");
                    this.printBinaryRightOperand(binary);
                    this.print(")");
                }
            } else {
                if (forceParens) {
                    this.print("(");
                }
                this.printBinaryRightOperand(binary);
                if (forceParens) {
                    this.print(")");
                }
            }
            if (closeParen) {
                this.print(")");
            }
            if (truncate) {
                this.print("|0)");
            }
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    protected void printBinaryRightOperand(BinaryTree binary) {
        this.addInlinedExpression(binary.getRightOperand());
        this.print(binary.getRightOperand());
    }

    protected void printBinaryLeftOperand(BinaryTree binary) {
        this.addInlinedExpression(binary.getLeftOperand());
        this.print(binary.getLeftOperand());
    }

    @Override
    public Void visitIf(IfTree ifStatement, Trees trees) {
        this.print("if ");
        if (ifStatement.getCondition() instanceof ParenthesizedTree) {
            this.print(ifStatement.getCondition());
        } else {
            this.print("(");
            this.print(ifStatement.getCondition());
            this.print(") ");
        }
        this.print(ifStatement.getThenStatement());
        if (!(ifStatement.getThenStatement() instanceof BlockTree) && !this.isStatementWithNoSemiColon(ifStatement.getThenStatement())) {
            this.print(";");
        }
        if (ifStatement.getElseStatement() != null) {
            this.print(" else ");
            this.print(ifStatement.getElseStatement());
            if (!(ifStatement.getElseStatement() instanceof BlockTree) && !this.isStatementWithNoSemiColon(ifStatement.getElseStatement())) {
                this.print(";");
            }
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitReturn(ReturnTree returnStatement, Trees trees) {
        this.print("return");
        if (returnStatement.getExpression() != null) {
            Tree parentFunction = this.getFirstParent(MethodTree.class, LambdaExpressionTree.class);
            if (Util.getType(returnStatement.getExpression()) == null) {
                this.report((Tree)returnStatement, JSweetProblem.CANNOT_ACCESS_THIS, parentFunction == null ? returnStatement.toString() : parentFunction.toString());
                return Java2TypeScriptTranslator.returnNothing();
            }
            this.print(" ");
            TypeMirror returnType = null;
            if (parentFunction != null && parentFunction instanceof MethodTree) {
                returnType = (TypeMirror)Util.getType(((MethodTree)parentFunction).getReturnType());
            }
            if (!this.substituteAssignedExpression(returnType, returnStatement.getExpression())) {
                this.print(returnStatement.getExpression());
            }
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    private VariableElement getStaticInitializedField(Tree expr) {
        if (expr instanceof ArrayAccessTree) {
            return null;
        }
        Object element = Util.getElement(expr);
        if (element instanceof VariableElement && this.context.lazyInitializedStatics.contains(element)) {
            return (VariableElement)element;
        }
        return null;
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree assignOpTree, Trees trees) {
        if (!this.getAdapter().substituteAssignmentWithOperator((AssignmentWithOperatorElement)this.createExtendedElement(assignOpTree))) {
            boolean castToIntegral;
            this.staticInitializedAssignment = this.getStaticInitializedField(assignOpTree.getVariable()) != null;
            boolean expand = this.staticInitializedAssignment;
            Object variableType = Util.getType(assignOpTree.getVariable());
            Object expressionType = Util.getType(assignOpTree.getExpression());
            boolean expandChar = this.types().isSameType(this.util().getType(Character.TYPE), this.util().unboxedTypeOrType((TypeMirror)variableType));
            this.print(assignOpTree.getVariable());
            this.staticInitializedAssignment = false;
            String assignmentOperator = this.util().toOperator(assignOpTree.getKind());
            String operator = assignmentOperator.replace("=", "");
            if (this.types().isSameType(this.util().getType(Boolean.TYPE), this.util().unboxedTypeOrType((TypeMirror)variableType))) {
                if ("|".equals(operator)) {
                    this.print(" = ").print(assignOpTree.getExpression()).print(" || ").print(assignOpTree.getVariable());
                    return Java2TypeScriptTranslator.returnNothing();
                }
                if ("&".equals(operator)) {
                    this.print(" = ").print(assignOpTree.getExpression()).print(" && ").print(assignOpTree.getVariable());
                    return Java2TypeScriptTranslator.returnNothing();
                }
            }
            boolean bl = castToIntegral = "/".equals(operator) && this.util().isIntegral((TypeMirror)variableType) && this.util().isIntegral((TypeMirror)expressionType);
            if (expandChar) {
                this.print(" = String.fromCharCode(").substituteAndPrintAssignedExpression(this.util().getType(Integer.TYPE), assignOpTree.getVariable()).print(" " + operator + " ").substituteAndPrintAssignedExpression(this.util().getType(Integer.TYPE), assignOpTree.getExpression()).print(")");
                return Java2TypeScriptTranslator.returnNothing();
            }
            if (expand || castToIntegral) {
                this.print(" = ");
                if (castToIntegral) {
                    this.print("(n => n<0?Math.ceil(n):Math.floor(n))(");
                }
                this.print(assignOpTree.getVariable());
                this.print(" " + operator + " ");
                if (this.types().isSameType(this.util().getType(Character.TYPE), this.util().unboxedTypeOrType((TypeMirror)expressionType))) {
                    this.substituteAndPrintAssignedExpression(this.util().getType(Integer.TYPE), assignOpTree.getExpression());
                } else {
                    this.printAssignWithOperatorRightOperand(assignOpTree);
                }
                if (castToIntegral) {
                    this.print(")");
                }
                return Java2TypeScriptTranslator.returnNothing();
            }
            this.print(" " + operator + "= ");
            if (this.types().isSameType(this.util().getType(Character.TYPE), this.util().unboxedTypeOrType((TypeMirror)expressionType))) {
                boolean isLeftOperandString = this.types().asElement((TypeMirror)variableType) == this.types().asElement(this.util().getType(String.class));
                TypeMirror rightPromotedType = isLeftOperandString ? this.util().getType(Character.TYPE) : this.util().getType(Integer.TYPE);
                this.substituteAndPrintAssignedExpression(rightPromotedType, assignOpTree.getExpression());
            } else {
                this.printAssignWithOperatorRightOperand(assignOpTree);
            }
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    protected void printAssignWithOperatorRightOperand(CompoundAssignmentTree assignOp) {
        this.print(assignOp.getExpression());
    }

    @Override
    public Void visitConditionalExpression(ConditionalExpressionTree conditional, Trees trees) {
        this.print(conditional.getCondition());
        this.print(" ? ");
        if (!this.substituteAssignedExpression(this.rootConditionalAssignedTypes.isEmpty() ? null : this.rootConditionalAssignedTypes.peek(), conditional.getTrueExpression())) {
            this.print(conditional.getTrueExpression());
        }
        this.print(" : ");
        if (!this.substituteAssignedExpression(this.rootConditionalAssignedTypes.isEmpty() ? null : this.rootConditionalAssignedTypes.peek(), conditional.getFalseExpression())) {
            this.print(conditional.getFalseExpression());
        }
        if (!this.rootConditionalAssignedTypes.isEmpty()) {
            this.rootConditionalAssignedTypes.pop();
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitForLoop(ForLoopTree forLoopTree, Trees trees) {
        this.print("for(").printArgList(null, forLoopTree.getInitializer()).print("; ").print(forLoopTree.getCondition()).print("; ").printArgList(null, forLoopTree.getUpdate()).print(") ");
        this.print("{");
        this.visitBeforeForBody(forLoopTree);
        this.print(forLoopTree.getStatement()).print(";");
        this.print("}");
        return Java2TypeScriptTranslator.returnNothing();
    }

    protected void visitBeforeForBody(ForLoopTree forLoop) {
    }

    @Override
    public Void visitContinue(ContinueTree continueStatement, Trees trees) {
        this.print("continue");
        if (continueStatement.getLabel() != null) {
            this.print(" ").print(continueStatement.getLabel().toString());
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitBreak(BreakTree breakStatement, Trees trees) {
        this.print("break");
        if (breakStatement.getLabel() != null) {
            this.print(" ").print(breakStatement.getLabel().toString());
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitLabeledStatement(final LabeledStatementTree labelledStatement, Trees trees) {
        Tree parent = this.getParent(MethodTree.class);
        if (parent == null) {
            parent = this.getParent(BlockTree.class);
            while (parent != null && this.getParent(BlockTree.class, parent) != null) {
                parent = this.getParent(BlockTree.class, parent);
            }
        }
        final boolean[] used = new boolean[]{false};
        new TreeScanner<Void, Trees>(){

            @Override
            public Void visitBreak(BreakTree b, Trees trees) {
                if (b.getLabel() != null && labelledStatement.getLabel().equals(b.getLabel())) {
                    used[0] = true;
                }
                return Java2TypeScriptTranslator.returnNothing();
            }

            @Override
            public Void visitContinue(ContinueTree c, Trees trees) {
                if (c.getLabel() != null && labelledStatement.getLabel().equals(c.getLabel())) {
                    used[0] = true;
                }
                return Java2TypeScriptTranslator.returnNothing();
            }
        }.scan(parent, trees);
        if (!used[0]) {
            this.print("/*");
        }
        this.print(labelledStatement.getLabel().toString()).print(":");
        if (!used[0]) {
            this.print("*/");
        }
        this.print(" ");
        this.print(labelledStatement.getStatement());
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitArrayType(ArrayTypeTree arrayType, Trees trees) {
        this.print(arrayType.getType()).print("[]");
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitNewArray(NewArrayTree newArray, Trees trees) {
        if (newArray.getType() != null) {
            this.typeChecker.checkType(newArray, null, newArray.getType(), this.getCompilationUnit());
        }
        if (newArray.getDimensions() != null && !newArray.getDimensions().isEmpty()) {
            Object newArrayElementType = Util.getType(newArray.getType());
            if (newArray.getDimensions().size() == 1) {
                if (newArray.getDimensions().get(0) instanceof LiteralTree && (Integer)((LiteralTree)newArray.getDimensions().get(0)).getValue() <= 10) {
                    boolean bl;
                    boolean bl2 = false;
                    this.print("[");
                    for (int i = 0; i < (Integer)((LiteralTree)newArray.getDimensions().get(0)).getValue(); ++i) {
                        this.print(this.util().getTypeInitialValue((TypeMirror)newArrayElementType) + ", ");
                        bl = true;
                    }
                    if (bl) {
                        this.removeLastChars(2);
                    }
                    this.print("]");
                } else if (!this.getAdapter().substituteNewArrayWithVariableLength(new NewArrayElementSupport(newArray))) {
                    this.print("(s => { let a=[]; while(s-->0) a.push(" + this.util().getTypeInitialValue((TypeMirror)newArrayElementType) + "); return a; })(").print(newArray.getDimensions().get(0)).print(")");
                }
            } else {
                this.print("<any> (function(dims) { let allocate = function(dims) { if (dims.length === 0) { return " + this.util().getTypeInitialValue((TypeMirror)newArrayElementType) + "; } else { let array = []; for(let i = 0; i < dims[0]; i++) { array.push(allocate(dims.slice(1))); } return array; }}; return allocate(dims);})");
                this.print("([");
                this.printArgList(null, newArray.getDimensions());
                this.print("])");
            }
        } else {
            this.print("[");
            if (newArray.getInitializers() != null && !newArray.getInitializers().isEmpty()) {
                for (ExpressionTree expressionTree : newArray.getInitializers()) {
                    if (!this.rootArrayAssignedTypes.isEmpty()) {
                        if (!this.substituteAssignedExpression(this.rootArrayAssignedTypes.peek(), expressionTree)) {
                            this.print(expressionTree);
                        }
                    } else {
                        this.print(expressionTree);
                    }
                    this.print(", ");
                }
                this.removeLastChars(2);
                if (!this.rootArrayAssignedTypes.isEmpty()) {
                    this.rootArrayAssignedTypes.pop();
                }
            }
            this.print("]");
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitUnary(UnaryTree unary, Trees trees) {
        if (!this.getAdapter().substituteUnaryOperator((UnaryOperatorElement)this.createExtendedElement(unary))) {
            this.addInlinedExpression(unary.getExpression());
            String operatorAsString = this.util().toOperator(unary.getKind());
            if (!this.inRollback) {
                StatementTree statement = null;
                VariableElement[] staticInitializedField = new VariableElement[]{null};
                switch (operatorAsString) {
                    case "--": 
                    case "++": {
                        staticInitializedField[0] = this.getStaticInitializedField(unary.getExpression());
                        boolean bl = this.staticInitializedAssignment = staticInitializedField[0] != null;
                        if (!this.staticInitializedAssignment) break;
                        statement = this.getParent(StatementTree.class);
                    }
                }
                if (statement != null) {
                    this.rollback(statement, tree -> {
                        this.print(this.context.getRootRelativeName(null, staticInitializedField[0].getEnclosingElement())).print(".").print(staticInitializedField[0].getSimpleName().toString() + "_$LI$();").println().printIndent();
                        this.inRollback = true;
                        this.scan((Tree)tree, trees);
                    });
                }
            } else {
                this.inRollback = false;
            }
            switch (unary.getKind()) {
                case POSTFIX_DECREMENT: 
                case POSTFIX_INCREMENT: {
                    this.print(unary.getExpression());
                    this.print(operatorAsString);
                    break;
                }
                default: {
                    this.print(operatorAsString);
                    this.print(unary.getExpression());
                }
            }
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitSwitch(SwitchTree switchStatement, Trees trees) {
        this.print("switch(");
        if (!this.getAdapter().substituteSwitchStatementSelector((ExtendedElement)this.createExtendedElement(switchStatement.getExpression()))) {
            this.print(switchStatement.getExpression());
            if (this.types().isSameType(this.util().getType(Character.TYPE), this.util().unboxedTypeOrType((TypeMirror)Util.getType(switchStatement.getExpression())))) {
                this.print(".charCodeAt(0)");
            }
        }
        this.print(") {").println();
        for (CaseTree caseTree : switchStatement.getCases()) {
            this.printIndent();
            this.print(caseTree);
        }
        this.printIndent().print("}");
        return Java2TypeScriptTranslator.returnNothing();
    }

    protected void printCaseStatementPattern(ExpressionTree pattern) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitCase(CaseTree caseTree, Trees trees) {
        if (caseTree.getExpression() != null) {
            Object expressionType = Util.getType(caseTree.getExpression());
            this.print("case ");
            if (!this.getAdapter().substituteCaseStatementPattern((CaseElement)this.createExtendedElement(caseTree), (ExtendedElement)this.createExtendedElement(caseTree.getExpression()))) {
                if (this.util().isPrimitiveOrVoid((TypeMirror)expressionType) || this.types().isSameType(this.util().getType(String.class), (TypeMirror)expressionType)) {
                    Object value;
                    if (caseTree.getExpression() instanceof IdentifierTree) {
                        VariableElement variableElement = (VariableElement)Util.getElement((IdentifierTree)caseTree.getExpression());
                        value = variableElement.getConstantValue();
                        if (this.types().isSameType(this.util().getType(String.class), (TypeMirror)expressionType)) {
                            this.print(this.getStringLiteralQuote() + value + this.getStringLiteralQuote() + " /* " + caseTree.getExpression() + " */");
                        } else {
                            if (value != null && value.getClass() == Character.class) {
                                value = (int)((Character)value).charValue();
                            }
                            this.print(value + " /* " + caseTree.getExpression() + " */");
                        }
                    } else if (this.types().isSameType(this.util().getType(Character.TYPE), (TypeMirror)expressionType)) {
                        void var4_7;
                        ExpressionTree expressionTree = caseTree.getExpression();
                        if (expressionTree instanceof TypeCastTree) {
                            ExpressionTree expressionTree2 = ((TypeCastTree)expressionTree).getExpression();
                        }
                        if (var4_7 instanceof LiteralTree) {
                            value = ((LiteralTree)var4_7).getValue();
                            if (value instanceof Character) {
                                int charCodePoint = Character.codePointAt(value.toString(), 0);
                                value = charCodePoint;
                            }
                            this.print(value + " /* " + caseTree.getExpression() + " */");
                        } else {
                            this.print((Tree)var4_7);
                        }
                    } else {
                        this.print(caseTree.getExpression());
                    }
                } else {
                    Element element = this.types().asElement((TypeMirror)expressionType);
                    this.print(this.getRootRelativeName(element) + "." + caseTree.getExpression());
                    this.ensureModuleIsUsed(element);
                }
            }
        } else {
            this.print("default");
        }
        this.print(":");
        this.println().startIndent();
        for (StatementTree statementTree : caseTree.getStatements()) {
            this.printIndent();
            this.print(statementTree);
            if (!this.isStatementWithNoSemiColon(statementTree)) {
                this.print(";");
            }
            this.println();
        }
        this.endIndent();
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitTypeCast(TypeCastTree cast, Trees trees) {
        Object fromType = Util.getType(cast.getExpression());
        Element fromTypeElement = this.types().asElement((TypeMirror)fromType);
        Object toType = Util.getType(cast.getType());
        Element toTypeElement = this.types().asElement((TypeMirror)toType);
        if (this.substituteAssignedExpression((TypeMirror)toType, cast.getExpression())) {
            return Java2TypeScriptTranslator.returnNothing();
        }
        if (this.getAdapter().substituteTypeCast((TypeCastElement)this.createExtendedElement(cast))) {
            return Java2TypeScriptTranslator.returnNothing();
        }
        if (this.util().isIntegral((TypeMirror)toType)) {
            if (toType.getKind() == TypeKind.LONG) {
                this.print("(n => n<0?Math.ceil(n):Math.floor(n))(");
            } else {
                this.print("(");
            }
        }
        if (!this.context.hasAnnotationType(toTypeElement, "jsweet.lang.Erased", "jsweet.lang.ObjectType", JSweetConfig.ANNOTATION_FUNCTIONAL_INTERFACE)) {
            if (fromType.getKind() == TypeKind.TYPEVAR) {
                this.print("<any>");
            } else {
                this.print("<");
                this.substituteAndPrintType(cast.getType()).print(">");
                if (this.util().isInterface(fromTypeElement) || this.util().isInterface(toTypeElement) || toType.getKind() == TypeKind.TYPEVAR) {
                    this.print("<any>");
                }
            }
        }
        this.print(cast.getExpression());
        if (this.util().isIntegral((TypeMirror)toType)) {
            if (toType.getKind() == TypeKind.LONG) {
                this.print(")");
            } else {
                this.print("|0)");
            }
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitDoWhileLoop(DoWhileLoopTree doWhileLoop, Trees trees) {
        this.print("do ");
        this.print("{");
        this.visitBeforeDoWhileBody(doWhileLoop);
        if (doWhileLoop.getStatement() instanceof BlockTree) {
            this.print(doWhileLoop.getStatement());
        } else {
            this.print(doWhileLoop.getStatement()).print(";");
        }
        this.print("}");
        this.print(" while(").print(doWhileLoop.getCondition()).print(")");
        return Java2TypeScriptTranslator.returnNothing();
    }

    protected void visitBeforeDoWhileBody(DoWhileLoopTree doWhileLoop) {
    }

    @Override
    public Void visitWhileLoop(WhileLoopTree whileLoop, Trees trees) {
        this.print("while(").print(whileLoop.getCondition()).print(") ");
        this.print("{");
        this.visitBeforeWhileBody(whileLoop);
        this.print(whileLoop.getStatement());
        this.print("}");
        return Java2TypeScriptTranslator.returnNothing();
    }

    protected void visitBeforeWhileBody(WhileLoopTree whileLoop) {
    }

    @Override
    public Void visitAssignment(AssignmentTree assign, Trees trees) {
        if (!this.getAdapter().substituteAssignment((AssignmentElement)this.createExtendedElement(assign))) {
            this.staticInitializedAssignment = this.getStaticInitializedField(assign.getVariable()) != null;
            this.print(assign.getVariable()).print(this.isAnnotationScope ? ": " : " = ");
            if (!this.substituteAssignedExpression((TypeMirror)Util.getType(assign.getVariable()), assign.getExpression())) {
                this.print(assign.getExpression());
            }
            this.staticInitializedAssignment = false;
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitTry(TryTree tryStatement, Trees trees) {
        boolean resourced;
        boolean bl = resourced = tryStatement.getResources() != null && !tryStatement.getResources().isEmpty();
        if (resourced) {
            for (Tree tree : tryStatement.getResources()) {
                this.print(tree).println(";").printIndent();
            }
        } else if (tryStatement.getCatches().isEmpty() && tryStatement.getFinallyBlock() == null) {
            this.report((Tree)tryStatement, JSweetProblem.TRY_WITHOUT_CATCH_OR_FINALLY, new Object[0]);
        }
        this.print("try ").print(tryStatement.getBlock());
        if (tryStatement.getCatches().size() > 1) {
            this.print(" catch(__e) {").startIndent();
            for (CatchTree catchTree : tryStatement.getCatches()) {
                this.println().printIndent().print("if");
                this.printInstanceOf("__e", null, (TypeMirror)Util.getType(catchTree.getParameter()));
                this.print(" {").startIndent().println().printIndent();
                this.print(catchTree.getParameter()).print(" = <");
                this.substituteAndPrintType(catchTree.getParameter().getType());
                this.print(">__e;").println();
                this.printBlockStatements(catchTree.getBlock().getStatements());
                this.endIndent().println().printIndent().print("}");
            }
            this.endIndent().println().printIndent().print("}");
        } else if (tryStatement.getCatches().size() == 1) {
            this.print(tryStatement.getCatches().get(0));
        }
        if (resourced || tryStatement.getFinallyBlock() != null) {
            this.print(" finally {");
            if (resourced) {
                this.startIndent();
                ArrayList<? extends Tree> reversedResources = new ArrayList<Tree>(tryStatement.getResources());
                Collections.reverse(reversedResources);
                for (Tree tree : reversedResources) {
                    if (!(tree instanceof VariableTree)) continue;
                    this.println().printIndent().print(((VariableTree)tree).getName() + ".close();");
                }
                this.endIndent();
            }
            if (tryStatement.getFinallyBlock() != null) {
                this.startIndent();
                for (StatementTree statementTree : tryStatement.getFinallyBlock().getStatements()) {
                    this.println().printIndent().print(statementTree).print(";");
                }
                this.endIndent();
            }
            this.println().printIndent().print("}");
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitCatch(CatchTree catcher, Trees trees) {
        this.print(" catch(").print(catcher.getParameter().getName().toString()).print(") ");
        this.print(catcher.getBlock());
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitLambdaExpression(LambdaExpressionTree lamba, Trees trees) {
        MethodInvocationElement invocation;
        boolean regularFunction = false;
        if (this.getParent() instanceof MethodInvocationTree && ((MethodInvocationTree)this.getParent()).getMethodSelect().toString().endsWith("function") && this.getParentOfParent() instanceof MethodInvocationTree && ((MethodInvocationTree)this.getParentOfParent()).getMethodSelect().toString().endsWith("$noarrow") && "jsweet.util.Lang".equals((invocation = (MethodInvocationElement)this.createExtendedElement(this.getParent())).getMethod().getEnclosingElement().toString())) {
            regularFunction = true;
        }
        HashMap<String, VariableElement> varAccesses = new HashMap<String, VariableElement>();
        this.util().fillAllVariableAccesses(varAccesses, lamba, this.getCompilationUnit());
        ArrayList finalVars = new ArrayList(varAccesses.values());
        if (!varAccesses.isEmpty()) {
            int parentIndex;
            int i;
            HashMap<String, VariableElement> varDefs = new HashMap<String, VariableElement>();
            StatementTree statement = null;
            for (i = parentIndex = this.getStack().size() - 2; i > 0 && ((Tree)this.getStack().get(i)).getKind() != Tree.Kind.LAMBDA_EXPRESSION && ((Tree)this.getStack().get(i)).getKind() != Tree.Kind.METHOD; --i) {
                if (statement != null || !(this.getStack().get(i) instanceof StatementTree)) continue;
                statement = (StatementTree)this.getStack().get(i);
            }
            if (i >= 0 && ((Tree)this.getStack().get(i)).getKind() != Tree.Kind.LAMBDA_EXPRESSION && statement != null) {
                this.util().fillAllVariablesInScope(varDefs, this.getStack(), lamba, (Tree)this.getStack().get(i), this.getCompilationUnit());
            }
            finalVars.retainAll(varDefs.values());
        }
        if (!finalVars.isEmpty()) {
            this.print("((");
            for (VariableElement var : finalVars) {
                this.print(var.getSimpleName().toString()).print(",");
            }
            this.removeLastChar();
            this.print(") => {").println().startIndent().printIndent().print("return ");
        }
        this.getScope().skipTypeAnnotations = true;
        if (regularFunction) {
            this.print("function(").printArgList(null, lamba.getParameters()).print(") ");
        } else {
            this.print("(").printArgList(null, lamba.getParameters()).print(") => ");
        }
        this.getScope().skipTypeAnnotations = false;
        this.print(lamba.getBody());
        if (!finalVars.isEmpty()) {
            this.endIndent().println().printIndent().print("})(");
            for (VariableElement var : finalVars) {
                this.print(var.getSimpleName().toString()).print(",");
            }
            this.removeLastChar();
            this.print(")");
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitMemberReference(MemberReferenceTree memberReference, Trees trees) {
        ExecutableElement method;
        boolean exprIsInstance;
        Object element = Util.getElement(memberReference);
        String memberReferenceSimpleName = memberReference.getQualifierExpression() instanceof ArrayTypeTree ? "Array" : Util.getTypeElement(memberReference.getQualifierExpression()).getSimpleName().toString();
        boolean printAsInstanceMethod = !element.getModifiers().contains((Object)Modifier.STATIC) && !"<init>".equals(memberReference.getName().toString()) && !"Globals".equals(memberReferenceSimpleName);
        boolean bl = exprIsInstance = memberReference.getQualifierExpression().toString().equals("this") || memberReference.getQualifierExpression().toString().equals("super") || memberReference.getQualifierExpression() instanceof IdentifierTree && Util.getElement((IdentifierTree)memberReference.getQualifierExpression()) instanceof VariableElement || memberReference.getQualifierExpression() instanceof MemberSelectTree && Util.getElement((MemberSelectTree)memberReference.getQualifierExpression()) instanceof VariableElement;
        if (element instanceof ExecutableElement) {
            method = (ExecutableElement)element;
            if (this.getParent() instanceof TypeCastTree) {
                this.print("(");
            }
            this.print("(");
            int argumentsPrinted = 0;
            if (printAsInstanceMethod && !exprIsInstance) {
                this.print("instance$").print(memberReferenceSimpleName);
                this.print(",");
                ++argumentsPrinted;
            }
            if (method.getParameters() != null) {
                for (VariableElement variableElement : method.getParameters()) {
                    this.print(variableElement.getSimpleName().toString());
                    this.print(",");
                    ++argumentsPrinted;
                }
            }
            if (argumentsPrinted > 0) {
                this.removeLastChar();
            }
            this.print(")");
            this.print(" => { return ");
        }
        if ("Globals".equals(memberReferenceSimpleName)) {
            this.print(memberReference.getName().toString());
        } else if ("<init>".equals(memberReference.getName().toString())) {
            if (Util.getType(memberReference.getQualifierExpression()).getKind() == TypeKind.ARRAY) {
                this.print("new Array<");
                this.substituteAndPrintType(((ArrayTypeTree)((Object)memberReference.getQualifierExpression())).getType());
                this.print(">");
            } else {
                this.print("new ").print(memberReference.getQualifierExpression());
            }
        } else {
            if (printAsInstanceMethod && !exprIsInstance) {
                this.print("instance$").print(memberReferenceSimpleName);
            } else {
                this.print(memberReference.getQualifierExpression());
            }
            this.print(".").print(memberReference.getName().toString());
        }
        if (element instanceof ExecutableElement) {
            method = (ExecutableElement)element;
            this.print("(");
            if (method.getParameters() != null) {
                for (VariableElement variableElement : method.getParameters()) {
                    this.print(variableElement.getSimpleName().toString());
                    this.print(",");
                }
                if (!method.getParameters().isEmpty()) {
                    this.removeLastChar();
                }
            }
            this.print(")");
            this.print(" }");
            if (this.getParent() instanceof TypeCastTree) {
                this.print(")");
            }
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitTypeParameter(TypeParameterTree typeParameter, Trees trees) {
        this.print(typeParameter.getName().toString());
        if (typeParameter.getBounds() != null && !typeParameter.getBounds().isEmpty()) {
            this.print(" extends ");
            for (Tree tree : typeParameter.getBounds()) {
                this.substituteAndPrintType(tree).print(" & ");
            }
            this.removeLastChars(3);
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitSynchronized(SynchronizedTree sync, Trees trees) {
        this.report((Tree)sync, JSweetProblem.SYNCHRONIZATION, new Object[0]);
        if (sync.getBlock() != null) {
            this.print(sync.getBlock());
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    public void print(String exprStr, Tree expr) {
        if (exprStr == null) {
            this.print(expr);
        } else {
            this.print(exprStr);
        }
    }

    private void printInstanceOf(String exprStr, Tree expr, TypeMirror type) {
        this.printInstanceOf(exprStr, expr, type, false);
    }

    private void printInstanceOf(String exprStr, Tree expr, TypeMirror type, boolean checkFirstArrayElement) {
        if (!(this.getParent() instanceof ParenthesizedTree)) {
            this.print("(");
        }
        if (checkFirstArrayElement || !this.getAdapter().substituteInstanceof(exprStr, (ExtendedElement)this.createExtendedElement(expr), type)) {
            Element typeElement = this.types().asElement(type);
            if (TYPE_MAPPING.containsKey(type.toString())) {
                this.print("typeof ");
                this.print(exprStr, expr);
                if (checkFirstArrayElement) {
                    this.print("[0]");
                }
                this.print(" === ").print("'" + TYPE_MAPPING.get(type.toString()).toLowerCase() + "'");
            } else if (this.util().isPartOfAnEnum(typeElement)) {
                boolean isStringEnum;
                this.print("typeof ");
                this.print(exprStr, expr);
                if (checkFirstArrayElement) {
                    this.print("[0]");
                }
                if (isStringEnum = this.context.hasAnnotationType(typeElement, "jsweet.lang.StringEnum")) {
                    this.print(" === 'string'");
                } else {
                    this.print(" === 'number'");
                }
            } else if (type.toString().startsWith("jsweet.util.function.") || type.toString().startsWith("java.util.function.") || Runnable.class.getName().equals(type.toString()) || this.context.hasAnnotationType(typeElement, JSweetConfig.ANNOTATION_FUNCTIONAL_INTERFACE)) {
                this.print("typeof ");
                this.print(exprStr, expr);
                if (checkFirstArrayElement) {
                    this.print("[0]");
                }
                this.print(" === 'function'");
                int parameterCount = this.context.getFunctionalTypeParameterCount(type);
                if (parameterCount != -1) {
                    this.print(" && (<any>");
                    this.print(exprStr, expr);
                    if (checkFirstArrayElement) {
                        this.print("[0]");
                    }
                    this.print(").length === " + this.context.getFunctionalTypeParameterCount(type));
                }
            } else {
                this.print(exprStr, expr);
                if (checkFirstArrayElement) {
                    this.print("[0]");
                }
                if (this.context.isInterface(typeElement)) {
                    String interfaceQualifiedName = this.util().getQualifiedName(typeElement);
                    this.print(" != null && ");
                    this.print("(");
                    this.print(exprStr, expr);
                    if (checkFirstArrayElement) {
                        this.print("[0]");
                    }
                    this.print(".constructor != null && ");
                    this.print(exprStr, expr);
                    if (checkFirstArrayElement) {
                        this.print("[0]");
                    }
                    this.print(".constructor[" + this.getStringLiteralQuote() + INTERFACES_FIELD_NAME + this.getStringLiteralQuote() + "]").print(" != null && ");
                    this.print(exprStr, expr);
                    if (checkFirstArrayElement) {
                        this.print("[0]");
                    }
                    this.print(".constructor[" + this.getStringLiteralQuote() + INTERFACES_FIELD_NAME + this.getStringLiteralQuote() + "].indexOf(" + this.getStringLiteralQuote()).print(interfaceQualifiedName).print(this.getStringLiteralQuote() + ") >= 0");
                    if (CharSequence.class.getName().equals(interfaceQualifiedName)) {
                        this.print(" || typeof ");
                        this.print(exprStr, expr);
                        if (checkFirstArrayElement) {
                            this.print("[0]");
                        }
                        this.print(" === " + this.getStringLiteralQuote() + "string" + this.getStringLiteralQuote());
                    }
                    this.print(")");
                } else if (typeElement instanceof TypeElement && Class.class.getName().equals(((TypeElement)typeElement).getQualifiedName().toString())) {
                    this.print(" != null && ");
                    this.print("(");
                    this.print(exprStr, expr);
                    if (checkFirstArrayElement) {
                        this.print("[0]");
                    }
                    this.print("[" + this.getStringLiteralQuote() + CLASS_NAME_IN_CONSTRUCTOR + this.getStringLiteralQuote() + "]").print(" != null");
                    this.print(" || ((t) => { try { new t; return true; } catch { return false; } })(");
                    this.print(exprStr, expr);
                    if (checkFirstArrayElement) {
                        this.print("[0]");
                    }
                    this.print(")");
                    this.print(")");
                } else if (typeElement instanceof TypeParameterElement || Object.class.getName().equals(this.util().getQualifiedName(typeElement))) {
                    this.print(" != null");
                } else {
                    Object qualifiedName;
                    if (typeElement == null) {
                        qualifiedName = type.getKind() == TypeKind.ARRAY ? "Array" : this.getAdapter().getMappedType(type);
                    } else {
                        qualifiedName = this.getQualifiedTypeName(typeElement, false, false);
                        if (this.util().isPartOfAnEnum(typeElement)) {
                            qualifiedName = (String)qualifiedName + ENUM_WRAPPER_CLASS_SUFFIX;
                        }
                    }
                    if (((String)qualifiedName).startsWith("{")) {
                        qualifiedName = "Object";
                    }
                    this.print(" != null");
                    if (!"any".equals(qualifiedName)) {
                        this.print(" && ");
                        this.print(exprStr, expr);
                        if (checkFirstArrayElement) {
                            this.print("[0]");
                        }
                        if (((String)qualifiedName).startsWith("def.")) {
                            this.print(" instanceof ").print((String)qualifiedName);
                        } else {
                            this.print(" instanceof <any>").print((String)qualifiedName);
                        }
                        if (type instanceof ArrayType) {
                            ArrayType t = (ArrayType)type;
                            this.print(" && (");
                            this.print(exprStr, expr);
                            if (checkFirstArrayElement) {
                                this.print("[0]");
                            }
                            this.print(".length == 0 || ");
                            this.print(exprStr, expr);
                            this.print("[0] == null ||");
                            if (t.getComponentType() instanceof ArrayType) {
                                this.print(exprStr, expr);
                                this.print("[0] instanceof Array");
                            } else {
                                this.printInstanceOf(exprStr, expr, t.getComponentType(), true);
                            }
                            this.print(")");
                        }
                    }
                }
            }
        }
        if (!(this.getParent() instanceof ParenthesizedTree)) {
            this.print(")");
        }
    }

    @Override
    public Void visitInstanceOf(InstanceOfTree instanceOf, Trees trees) {
        this.printInstanceOf(null, instanceOf.getExpression(), (TypeMirror)Util.getType(instanceOf.getType()));
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitThrow(ThrowTree throwTree, Trees trees) {
        this.print("throw ").print(throwTree.getExpression());
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitAssert(AssertTree assertion, Trees trees) {
        if (!this.context.options.isIgnoreAssertions()) {
            String assertCode = assertion.toString().replace("\"", "'");
            this.print("if (!(").print(assertion.getCondition()).print(")) { throw new Error(\"Assertion error line " + this.getCurrentLine() + ": " + assertCode + "\"); }");
        }
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    public Void visitAnnotation(AnnotationTree annotation, Trees trees) {
        if (!this.context.hasAnnotationType((Element)Util.getTypeElement(annotation), "jsweet.lang.Decorator")) {
            return Java2TypeScriptTranslator.returnNothing();
        }
        if (this.getScope().isInterfaceScope()) {
            return Java2TypeScriptTranslator.returnNothing();
        }
        this.print("@").print(annotation.getAnnotationType());
        if (annotation.getArguments() != null && !annotation.getArguments().isEmpty()) {
            this.print("(");
            this.isAnnotationScope = true;
            this.print(" { ");
            for (ExpressionTree expressionTree : annotation.getArguments()) {
                this.print(expressionTree);
                this.print(", ");
            }
            this.removeLastChars(2);
            this.print(" } ");
            this.isAnnotationScope = false;
            this.print(")");
        } else {
            JSweetContext.GlobalMethodInfos globalMethodInfos;
            boolean parens = true;
            if (annotation.getAnnotationType() instanceof IdentifierTree && (globalMethodInfos = this.context.lookupGlobalMethod(Util.getElement(annotation.getAnnotationType()).toString())) != null && !globalMethodInfos.methodTree.getParameters().isEmpty()) {
                parens = false;
            }
            if (parens) {
                this.print("()");
            }
        }
        this.println().printIndent();
        return Java2TypeScriptTranslator.returnNothing();
    }

    @Override
    protected boolean substituteAssignedExpression(TypeMirror assignedType, ExpressionTree expression) {
        if (assignedType == null) {
            return false;
        }
        if (this.getAdapter().substituteAssignedExpression(assignedType, (ExtendedElement)this.createExtendedElement(expression))) {
            return true;
        }
        Object expressionTypeElement = Util.getTypeElement(expression);
        Object expressionType = Util.getType(expression);
        Element assignedTypeElement = this.types().asElement(assignedType);
        if (this.util().isInterface(assignedTypeElement) && expressionTypeElement != null && this.util().isPartOfAnEnum((Element)expressionTypeElement)) {
            String relTarget = this.getRootRelativeName((Element)expressionTypeElement);
            TypeElement targetTypeElement = (TypeElement)expressionTypeElement;
            this.useModule(this.getAdapter().getModuleImportDescriptor(this.getAdapter().getCompilationUnit(), this.context.getActualName(targetTypeElement), targetTypeElement));
            this.print("((wrappers, value) => wrappers===undefined?value:wrappers[value])(").print(relTarget).print("[" + this.getStringLiteralQuote() + ENUM_WRAPPER_CLASS_WRAPPERS + this.getStringLiteralQuote() + "], ").print(expression).print(")");
            return true;
        }
        if (expression instanceof ConditionalExpressionTree) {
            this.rootConditionalAssignedTypes.push(assignedType);
            return false;
        }
        if (expression instanceof NewArrayTree && assignedType instanceof ArrayType) {
            this.rootArrayAssignedTypes.push(((ArrayType)assignedType).getComponentType());
            return false;
        }
        if (assignedType.getKind() == TypeKind.CHAR && expressionType.getKind() != TypeKind.CHAR) {
            this.print("String.fromCharCode(").print(expression).print(")");
            return true;
        }
        if (this.util().isNumber(assignedType) && expressionType.getKind() == TypeKind.CHAR) {
            this.print("(").print(expression).print(").charCodeAt(0)");
            return true;
        }
        if (this.singlePrecisionFloats() && assignedType.getKind() == TypeKind.FLOAT && expressionType.getKind() == TypeKind.DOUBLE) {
            this.print("(<any>Math).fround(").print(expression).print(")");
            return true;
        }
        if (expression instanceof LambdaExpressionTree) {
            if (this.util().isInterface(assignedTypeElement) && !this.context.isFunctionalType((TypeElement)assignedTypeElement)) {
                LambdaExpressionTree lambda = (LambdaExpressionTree)expression;
                ExecutableElement method = (ExecutableElement)assignedTypeElement.getEnclosedElements().get(0);
                this.print("{ " + method.getSimpleName() + ": ").print(lambda).print(" }");
                return true;
            }
        } else if (expression instanceof NewClassTree) {
            NewClassTree newClass = (NewClassTree)expression;
            if (newClass.getClassBody() != null && this.context.isFunctionalType((TypeElement)assignedTypeElement)) {
                List<? extends Tree> defs = newClass.getClassBody().getMembers();
                boolean printed = false;
                for (Tree tree : defs) {
                    MethodTree method;
                    if (!(tree instanceof MethodTree)) continue;
                    if (printed) {
                        // empty if block
                    }
                    if (Util.getElement(method = (MethodTree)tree).getKind() == ElementKind.CONSTRUCTOR) continue;
                    this.getStack().push(method);
                    this.print("(").printArgList(null, method.getParameters()).print(") => ").print(method.getBody());
                    this.getStack().pop();
                    printed = true;
                }
                if (printed) {
                    return true;
                }
            } else {
                boolean lambdaPrinted;
                if (newClass.getClassBody() == null && this.context.isFunctionalType((TypeElement)assignedTypeElement) && (lambdaPrinted = this.printFunctionalTypeAsLambda((TypeElement)assignedTypeElement, () -> {
                    this.print("new ").print(newClass.getIdentifier()).print("(");
                    this.printArgList(null, newClass.getArguments());
                    this.print(")");
                }))) {
                    return true;
                }
                TypeElement newClassElement = (TypeElement)Util.getTypeElement(newClass);
                if (!newClassElement.getTypeParameters().isEmpty() && newClass.getTypeArguments().isEmpty()) {
                    this.print("<any>(").print(expression).print(")");
                    return true;
                }
            }
        } else {
            ExecutableElement methodElement;
            ExpressionTree methodSelectTree;
            Object m;
            if (!(expression instanceof LambdaExpressionTree) && !(expression instanceof MemberReferenceTree) && this.context.isFunctionalType(assignedTypeElement)) {
                this.print("<any>(");
                this.printFunctionalTypeAsLambda((TypeElement)assignedTypeElement, () -> this.print(expression));
                this.print(")");
                return true;
            }
            if (expression instanceof MethodInvocationTree && (m = Util.getElement(methodSelectTree = ((MethodInvocationTree)expression).getMethodSelect())) instanceof ExecutableElement && (methodElement = (ExecutableElement)m).getReturnType().getKind() == TypeKind.TYPEVAR && this.types().asElement(methodElement.getReturnType()).getEnclosingElement() == m) {
                this.print("<any>(").print(expression).print(")");
                return true;
            }
        }
        return false;
    }

    private boolean printFunctionalTypeAsLambda(TypeElement assignedTypeElement, Runnable printInstance) {
        if (this.context.isFunctionalType(assignedTypeElement)) {
            for (Element element : assignedTypeElement.getEnclosedElements()) {
                if (!(element instanceof ExecutableElement)) continue;
                ExecutableElement method = (ExecutableElement)element;
                String functionalMethodName = method.getSimpleName().toString();
                this.print("((funcInst: any) => { if (typeof funcInst == 'function') { return funcInst } ");
                this.print("return (");
                for (VariableElement variableElement : method.getParameters()) {
                    this.print(variableElement.getSimpleName().toString()).print(", ");
                }
                if (!method.getParameters().isEmpty()) {
                    this.removeLastChars(2);
                }
                this.print(") =>  (funcInst['" + functionalMethodName + "'] ? funcInst['" + functionalMethodName + "'] : funcInst) ");
                this.print(".call(funcInst, ");
                for (VariableElement variableElement : method.getParameters()) {
                    this.print(variableElement.getSimpleName().toString()).print(", ");
                }
                this.removeLastChar(' ');
                this.removeLastChar(',');
                this.print(")");
                this.print("})(");
                printInstance.run();
                this.print(")");
                return true;
            }
        }
        return false;
    }

    @Override
    public String getQualifiedTypeName(Element type, boolean globals, boolean ignoreLangTypes) {
        Object qualifiedName = super.getQualifiedTypeName(type, globals, ignoreLangTypes);
        String typeName = this.util().getQualifiedName(type);
        if (!ignoreLangTypes && this.context.getLangTypeMappings().containsKey(typeName)) {
            qualifiedName = this.context.getLangTypeMappings().get(typeName);
        } else if (this.context.isMappedType(typeName)) {
            qualifiedName = this.context.getTypeMappingTarget(typeName);
            if (((String)qualifiedName).endsWith("<>")) {
                qualifiedName = ((String)qualifiedName).substring(0, ((String)qualifiedName).length() - 2);
            }
        } else {
            if (this.context.useModules) {
                String[] namePath = ((String)qualifiedName).split("\\.");
                int i = namePath.length - 1;
                Element s = type;
                qualifiedName = "";
                while (i >= 0 && !(s instanceof PackageElement)) {
                    qualifiedName = namePath[i--] + (String)("".equals(qualifiedName) ? "" : "." + (String)qualifiedName);
                    s = s.getEnclosingElement();
                }
            }
            if (globals) {
                int dotIndex = ((String)qualifiedName).lastIndexOf(".");
                qualifiedName = dotIndex == -1 ? "" : ((String)qualifiedName).substring(0, dotIndex);
            }
        }
        return qualifiedName;
    }

    private static final Void returnNothing() {
        return null;
    }

    private boolean isStatementWithNoSemiColon(Tree tree) {
        return tree instanceof IfTree || tree instanceof ForLoopTree || tree instanceof EnhancedForLoopTree || tree instanceof SwitchTree || tree instanceof TryTree;
    }

    private boolean isStaticAnonymousClass(NewClassTree newClass, CompilationUnitTree compilationUnit) {
        if (!this.context.isAnonymousClass(newClass, compilationUnit)) {
            return false;
        }
        BlockTree parentBlock = this.getParent(BlockTree.class);
        if (parentBlock != null && parentBlock.isStatic()) {
            return true;
        }
        ExecutableElement parentMethodElement = null;
        Object newClassElement = Util.getElement(newClass);
        do {
            if (newClassElement.getModifiers().contains((Object)Modifier.STATIC)) {
                return false;
            }
            parentMethodElement = this.util().getParentElement((Element)newClassElement, ExecutableElement.class);
            if (parentMethodElement == null) {
                return false;
            }
            if (!parentMethodElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
            return true;
        } while ((newClassElement = this.util().getParentElement(parentMethodElement, TypeElement.class)) != null);
        return false;
    }

    static {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("java.lang.String", "String");
        mapping.put("java.lang.Number", "Number");
        mapping.put("java.lang.Integer", "Number");
        mapping.put("java.lang.Float", "Number");
        mapping.put("java.lang.Double", "Number");
        mapping.put("java.lang.Short", "Number");
        mapping.put("java.lang.Character", "String");
        mapping.put("java.lang.Byte", "Number");
        mapping.put("java.lang.Boolean", "Boolean");
        mapping.put("java.lang.Long", "Number");
        mapping.put("int", "Number");
        mapping.put("float", "Number");
        mapping.put("double", "Number");
        mapping.put("short", "Number");
        mapping.put("char", "String");
        mapping.put("boolean", "Boolean");
        mapping.put("byte", "Number");
        mapping.put("long", "Number");
        TYPE_MAPPING = Collections.unmodifiableMap(mapping);
        mapping = new HashMap();
        mapping.put("string", "String");
        mapping.put("number", "Number");
        mapping.put("boolean", "Boolean");
        mapping.put("any", "Object");
        CONSTRUCTOR_TYPE_MAPPING = Collections.unmodifiableMap(mapping);
    }

    public static enum ComparisonMode {
        FORCE_STRICT,
        STRICT,
        LOOSE;

    }

    public static class ClassScope {
        private String name;
        private MethodTree mainMethod;
        private boolean interfaceScope = false;
        private boolean enumScope = false;
        private boolean isComplexEnum = false;
        private boolean enumWrapperClassScope = false;
        private boolean stringEnumScope = false;
        private boolean removedSuperclass = false;
        private boolean declareClassScope;
        private boolean skipTypeAnnotations = false;
        private boolean defaultMethodScope = false;
        private boolean eraseVariableTypes = false;
        private boolean hasDeclaredConstructor = false;
        private boolean innerClass = false;
        private boolean innerClassNotStatic = false;
        private boolean hasInnerClass = false;
        private List<ClassTree> anonymousClasses = new ArrayList<ClassTree>();
        private List<NewClassTree> anonymousClassesConstructors = new ArrayList<NewClassTree>();
        private List<LinkedHashSet<VariableElement>> finalVariables = new ArrayList<LinkedHashSet<VariableElement>>();
        private boolean hasConstructorOverloadWithSuperClass;
        private List<VariableTree> fieldsWithInitializers = new ArrayList<VariableTree>();
        private List<String> inlinedConstructorArgs = null;
        private List<ClassTree> localClasses = new ArrayList<ClassTree>();
        private List<String> generatedMethodNames = new ArrayList<String>();
        private boolean isAnonymousClass = false;
        private boolean isInnerClass = false;
        private boolean isLocalClass = false;
        private boolean constructor = false;
        private boolean decoratorScope = false;
        public Stack<ForeachLoopScope> foreachLoopContext;
        private final JSweetContext context;
        private final CompilationUnitTree compilationUnit;

        private ClassScope(JSweetContext context, CompilationUnitTree compilationUnit) {
            this.context = context;
            this.compilationUnit = compilationUnit;
        }

        public String getName() {
            return this.name;
        }

        public MethodTree getMainMethod() {
            return this.mainMethod;
        }

        public ExecutableElement getMainMethodElement() {
            return (ExecutableElement)Util.getElement(this.mainMethod);
        }

        public List<DeclaredType> getLocalClassesTypes() {
            return this.getLocalClasses().stream().map(localClassTree -> {
                Util cfr_ignored_0 = this.context.util;
                return (DeclaredType)Util.getType(localClassTree);
            }).collect(Collectors.toList());
        }

        public boolean isLocalClassType(TypeMirror type) {
            return this.getLocalClassesTypes().stream().anyMatch(localClassType -> localClassType.equals(type));
        }

        public boolean isInterfaceScope() {
            return this.interfaceScope;
        }

        public boolean isEnumScope() {
            return this.enumScope;
        }

        public boolean isComplexEnum() {
            return this.isComplexEnum;
        }

        public boolean isEnumWrapperClassScope() {
            return this.enumWrapperClassScope;
        }

        public boolean isRemovedSuperclass() {
            return this.removedSuperclass;
        }

        public boolean isDeclareClassScope() {
            return this.declareClassScope;
        }

        public boolean isSkipTypeAnnotations() {
            return this.skipTypeAnnotations;
        }

        public boolean isDefaultMethodScope() {
            return this.defaultMethodScope;
        }

        public boolean isEraseVariableTypes() {
            return this.eraseVariableTypes;
        }

        public void setEraseVariableTypes(boolean eraseVariableTypes) {
            this.eraseVariableTypes = eraseVariableTypes;
        }

        public boolean isHasDeclaredConstructor() {
            return this.hasDeclaredConstructor;
        }

        public boolean getInnerClass() {
            return this.innerClass;
        }

        public boolean isInnerClassNotStatic() {
            return this.innerClassNotStatic;
        }

        public boolean isHasInnerClass() {
            return this.hasInnerClass;
        }

        public List<ClassTree> getAnonymousClasses() {
            return this.anonymousClasses;
        }

        public List<NewClassTree> getAnonymousClassesConstructors() {
            return this.anonymousClassesConstructors;
        }

        public NewClassTree getAnonymousClassConstructorFromClassTree(ClassTree classTree) {
            int anonymousClassIndex = this.anonymousClasses.indexOf(classTree);
            if (anonymousClassIndex == -1) {
                return null;
            }
            return this.anonymousClassesConstructors.get(anonymousClassIndex);
        }

        public List<LinkedHashSet<VariableElement>> getFinalVariables() {
            return this.finalVariables;
        }

        public boolean isHasConstructorOverloadWithSuperClass() {
            return this.hasConstructorOverloadWithSuperClass;
        }

        public List<VariableTree> getFieldsWithInitializers() {
            return this.fieldsWithInitializers;
        }

        public List<String> getInlinedConstructorArgs() {
            return this.inlinedConstructorArgs;
        }

        public List<ClassTree> getLocalClasses() {
            return this.localClasses;
        }

        public List<String> getGeneratedMethodNames() {
            return this.generatedMethodNames;
        }

        public boolean isAnonymousClass() {
            return this.isAnonymousClass;
        }

        public boolean isInnerClass() {
            return this.isInnerClass;
        }

        public boolean isLocalClass() {
            return this.isLocalClass;
        }

        public boolean isConstructor() {
            return this.constructor;
        }

        public boolean isDecoratorScope() {
            return this.decoratorScope;
        }
    }

    class UsedTypesScanner
    extends TreeScanner<Void, Trees> {
        private HashSet<String> names = new HashSet();

        UsedTypesScanner() {
        }

        private void checkType(Element type) {
            String name;
            if (type instanceof TypeElement) {
                String name2 = type.getSimpleName().toString();
                if (!this.names.contains(name2)) {
                    this.names.add(name2);
                    ModuleImportDescriptor moduleImport = Java2TypeScriptTranslator.this.getModuleImportDescriptor(name2, (TypeElement)type);
                    if (moduleImport != null) {
                        Java2TypeScriptTranslator.this.useModule(false, moduleImport.isDirect(), moduleImport.getTargetPackage(), null, moduleImport.getImportedName(), moduleImport.getPathToImportedClass(), moduleImport.getImportedClass());
                    }
                }
            } else if (type instanceof ExecutableElement && !this.names.contains(name = type.getSimpleName().toString())) {
                this.names.add(name);
                ModuleImportDescriptor moduleImport = Java2TypeScriptTranslator.this.getModuleImportDescriptor(name, (TypeElement)type.getEnclosingElement());
                if (moduleImport != null) {
                    Java2TypeScriptTranslator.this.useModule(false, moduleImport.isDirect(), moduleImport.getTargetPackage(), null, moduleImport.getImportedName(), moduleImport.getPathToImportedClass(), moduleImport.getImportedClass());
                }
            }
        }

        @Override
        public Void scan(Tree tree, Trees trees) {
            ExecutableElement sym;
            MethodInvocationTree inv;
            if (tree instanceof ImportTree) {
                return Java2TypeScriptTranslator.returnNothing();
            }
            if (tree != null) {
                Object treeElement = Util.getElementNoErrors(tree);
                if (!(treeElement instanceof TypeElement)) {
                    treeElement = Util.getTypeElement(tree);
                }
                if (treeElement instanceof TypeElement && !(tree instanceof ParameterizedTypeTree) && tree instanceof IdentifierTree && tree.toString().equals(treeElement.getSimpleName().toString())) {
                    this.checkType((Element)treeElement);
                }
            }
            if (tree instanceof MethodInvocationTree && (inv = (MethodInvocationTree)tree).getMethodSelect() instanceof IdentifierTree && Util.getElement((IdentifierTree)inv.getMethodSelect()) instanceof ExecutableElement && (sym = (ExecutableElement)Util.getElement((IdentifierTree)inv.getMethodSelect())).getModifiers().contains((Object)Modifier.STATIC)) {
                if ("Globals".equals(sym.getEnclosingElement().getSimpleName().toString())) {
                    this.checkType(sym);
                } else {
                    this.checkType(sym.getEnclosingElement());
                }
            }
            return (Void)super.scan(tree, trees);
        }
    }

    private class AsyncCallsFinder
    extends TreeScanner<Void, Trees> {
        protected boolean found = false;

        private AsyncCallsFinder() {
        }

        @Override
        public Void scan(Tree tree, Trees p) {
            if (this.found) {
                return Java2TypeScriptTranslator.returnNothing();
            }
            return (Void)super.scan(tree, p);
        }

        @Override
        public Void scan(Iterable<? extends Tree> nodes, Trees p) {
            if (this.found) {
                return Java2TypeScriptTranslator.returnNothing();
            }
            return (Void)super.scan(nodes, p);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree methodInvocation, Trees trees) {
            ExecutableElement method;
            Object methodSymbol = Util.getElement(methodInvocation.getMethodSelect());
            if (methodSymbol instanceof ExecutableElement && this.isAwait(method = (ExecutableElement)methodSymbol)) {
                this.found = true;
                return Java2TypeScriptTranslator.returnNothing();
            }
            return (Void)super.visitMethodInvocation(methodInvocation, trees);
        }

        private boolean isAwait(ExecutableElement method) {
            return method.getEnclosingElement() instanceof TypeElement && ((TypeElement)method.getEnclosingElement()).getQualifiedName().toString().equals("jsweet.util.Lang") && method.getSimpleName().toString().equals("await");
        }
    }

    private static class ForeachLoopScope {
        public EnhancedForLoopTree loop;
        public String variableName;
        public String arrayName;

        public ForeachLoopScope(EnhancedForLoopTree loop) {
            this.loop = loop;
        }
    }
}

