/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import com.sun.source.util.JavacTask;
import com.sun.source.util.Trees;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jsweet.JSweetConfig;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.JSweetDiagnosticHandler;
import org.jsweet.transpiler.JSweetFactory;
import org.jsweet.transpiler.TranspilationHandler;
import org.jsweet.transpiler.util.ConsoleTranspilationHandler;
import org.jsweet.transpiler.util.Util;

public class JavaCompilationComponents
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(JavaCompilationComponents.class);
    private final StandardJavaFileManager fileManager;
    private final JavaCompiler compiler;
    private final JavacTask task;
    private final List<JavaFileObject> sourceFileObjects;

    private JavaCompilationComponents(StandardJavaFileManager fileManager, JavaCompiler compiler, List<JavaFileObject> sourceFileObjects, JavacTask task) {
        this.fileManager = fileManager;
        this.compiler = compiler;
        this.sourceFileObjects = sourceFileObjects;
        this.task = task;
    }

    public static JavaCompilationComponents prepareFor(List<File> sourceFiles, JSweetContext context, JSweetFactory factory, Options options) {
        String encoding = StringUtils.isBlank((CharSequence)options.encoding) ? Charset.defaultCharset().name() : options.encoding;
        String classPath = StringUtils.isBlank((CharSequence)options.classPath) ? System.getProperty("java.class.path") : options.classPath;
        TranspilationHandler transpilationHandler = options.transpilationHandler != null ? options.transpilationHandler : new ConsoleTranspilationHandler();
        JavaCompilerOptions compilerOptions = new JavaCompilerOptions();
        if (classPath != null) {
            compilerOptions.put("--module-path", classPath);
            compilerOptions.put("-cp", classPath);
            for (String s : classPath.split(File.pathSeparator)) {
                if (!s.contains(JSweetConfig.MAVEN_JAVA_OVERRIDE_ARTIFACT)) continue;
                context.strictMode = true;
                compilerOptions.put("-bootclasspath", s);
            }
        }
        compilerOptions.put("-Xlint:path");
        Charset charset = null;
        if (encoding != null) {
            compilerOptions.put("-encoding", encoding);
            try {
                charset = Charset.forName(encoding);
            }
            catch (Exception e) {
                logger.warn((Object)("cannot use charset " + encoding), (Throwable)e);
            }
        }
        if (encoding == null) {
            charset = Charset.forName("UTF-8");
        }
        logger.debug((Object)("charset: " + charset));
        logger.debug((Object)("strict mode: " + context.strictMode));
        for (Map.Entry<String, String> extraOption : options.extraOptions.entrySet()) {
            compilerOptions.put(extraOption.getKey(), extraOption.getValue());
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, context.locale, charset);
        List<JavaFileObject> sourceFileObjects = context.util.toJavaFileObjects(fileManager, sourceFiles);
        JSweetDiagnosticHandler diagnosticHandler = factory.createDiagnosticHandler(transpilationHandler, context);
        compilerOptions = factory.finalizeJavaCompilerOptions(compilerOptions);
        logger.info((Object)("creating JavaCompiler task with options: " + compilerOptions));
        JavacTask task = (JavacTask)compiler.getTask(null, fileManager, diagnosticHandler, compilerOptions.optionsAsList, null, sourceFileObjects);
        context.trees = Trees.instance(task);
        context.elements = task.getElements();
        context.types = task.getTypes();
        context.util = new Util(context);
        return new JavaCompilationComponents(fileManager, compiler, sourceFileObjects, task);
    }

    public JavaCompiler getCompiler() {
        return this.compiler;
    }

    public StandardJavaFileManager getFileManager() {
        return this.fileManager;
    }

    public JavacTask getTask() {
        return this.task;
    }

    public Iterable<JavaFileObject> getSourceFileObjects() {
        return this.sourceFileObjects;
    }

    @Override
    public void close() throws IOException {
        this.getFileManager().close();
    }

    public static class Options {
        public String classPath;
        public String encoding;
        public Map<String, String> extraOptions = new HashMap<String, String>();
        public TranspilationHandler transpilationHandler = new ConsoleTranspilationHandler();
    }

    public static class JavaCompilerOptions {
        protected List<String> optionsAsList = new ArrayList<String>();

        public void put(String name, String value) {
            this.optionsAsList.add(name);
            this.optionsAsList.add(value);
        }

        public void put(String singleArgument) {
            this.optionsAsList.add(singleArgument);
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.optionsAsList;
        }
    }
}

