/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.TranspilationHandler;
import org.jsweet.transpiler.util.AbstractTreeScanner;
import org.jsweet.transpiler.util.Util;

public class OverloadScanner
extends AbstractTreeScanner {
    private int pass = 1;

    public OverloadScanner(TranspilationHandler logHandler, JSweetContext context) {
        super(logHandler, context, null);
    }

    private void inspectSuperTypes(CompilationUnitTree compilationUnit, TypeElement clazz, Overload overload, MethodTree method, ExecutableElement methodElement) {
        if (clazz == null) {
            return;
        }
        Overload superOverload = this.context.getOverload(clazz, methodElement);
        if (superOverload != null && superOverload != overload) {
            superOverload.merge(overload);
        }
        this.inspectSuperTypes(compilationUnit, (TypeElement)this.context.types.asElement(clazz.getSuperclass()), overload, method, methodElement);
        for (TypeMirror typeMirror : clazz.getInterfaces()) {
            this.inspectSuperTypes(compilationUnit, (TypeElement)this.context.types.asElement(typeMirror), overload, method, methodElement);
        }
    }

    @Override
    public Void visitClass(ClassTree classTree, Trees trees) {
        TypeElement classElement = (TypeElement)Util.getElement(classTree);
        if (classElement.getQualifiedName().toString().startsWith("def.") || this.context.hasAnnotationType(classElement, "jsweet.lang.Erased", "jsweet.lang.Ambient")) {
            return null;
        }
        for (Tree tree : classTree.getMembers()) {
            if (!(tree instanceof MethodTree)) continue;
            this.processMethod(this.getCompilationUnit(), classTree, this.getCompilationUnit(), classTree, (MethodTree)tree);
        }
        HashSet<JSweetContext.DefaultMethodEntry> defaultMethods = new HashSet<JSweetContext.DefaultMethodEntry>();
        this.util().findDefaultMethodsInType(defaultMethods, this.context, classElement);
        for (JSweetContext.DefaultMethodEntry defaultMethod : defaultMethods) {
            this.processMethod(this.getCompilationUnit(), classTree, defaultMethod.compilationUnit, defaultMethod.enclosingClassTree, defaultMethod.methodTree);
        }
        return (Void)super.visitClass(classTree, trees);
    }

    private void processMethod(CompilationUnitTree currentClassCompilationUnit, ClassTree currentClassTree, CompilationUnitTree methodCompilationUnit, ClassTree owningClassTree, MethodTree methodTree) {
        ExecutableElement methodElement = (ExecutableElement)Util.getElement(methodTree);
        if (this.context.hasAnnotationType(methodElement, "jsweet.lang.Erased", "jsweet.lang.Ambient")) {
            return;
        }
        TypeElement classElement = (TypeElement)Util.getElement(currentClassTree);
        Overload overload = this.context.getOrCreateOverload(classElement, methodElement);
        if (this.pass == 1) {
            overload.register(currentClassCompilationUnit, currentClassTree, methodCompilationUnit, owningClassTree, methodTree);
        } else if (methodElement.getKind() != ElementKind.CONSTRUCTOR) {
            this.inspectSuperTypes(this.compilationUnit, classElement, overload, methodTree, methodElement);
        }
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree cu, Trees trees) {
        this.setCompilationUnit(cu);
        super.visitCompilationUnit(cu, trees);
        this.setCompilationUnit(null);
        return null;
    }

    public void process(List<CompilationUnitTree> cuList) {
        for (CompilationUnitTree cu : cuList) {
            this.scan((Tree)cu, this.getContext().trees);
        }
        ++this.pass;
        for (CompilationUnitTree cu : cuList) {
            this.scan((Tree)cu, this.getContext().trees);
        }
        for (Overload overload : this.context.getAllOverloads()) {
            overload.calculate();
            if (overload.getMethodsCount() <= 1 || overload.isValid || overload.getCoreMethodElement().getKind() != ElementKind.CONSTRUCTOR) continue;
            this.context.classesWithWrongConstructorOverload.add((TypeElement)overload.getCoreMethodElement().getEnclosingElement());
        }
    }

    public static class Overload {
        public String methodName;
        private final List<OverloadMethodEntry> entries = new ArrayList<OverloadMethodEntry>();
        public boolean isValid = true;
        private OverloadMethodEntry coreEntry;
        public Map<Integer, Tree> defaultValues;
        public boolean printed = false;
        private final List<String> parameterNames = new ArrayList<String>();
        private final JSweetContext context;
        private final Util util;
        private final Types types;

        public Iterable<MethodTree> getMethods() {
            return this.entries.stream().map(entry -> entry.methodTree).collect(Collectors.toList());
        }

        public MethodTree getMethodAt(int i) {
            return this.entries.get((int)i).methodTree;
        }

        public MethodTree getCoreMethod() {
            return this.coreEntry == null ? null : this.coreEntry.methodTree;
        }

        public OverloadMethodEntry getCoreEntry() {
            return this.coreEntry;
        }

        public Overload(JSweetContext context) {
            this.context = context;
            this.util = context.util;
            this.types = context.types;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("overload(" + this.methodName + ")[" + this.getMethodsCount() + "," + this.isValid + "]");
            if (this.getMethodsCount() > 1) {
                for (OverloadMethodEntry entry : this.entries) {
                    ExecutableElement methodElement = entry.methodElement;
                    sb.append("\n      # " + methodElement.getEnclosingElement() + "." + methodElement);
                }
            }
            return sb.toString();
        }

        public int getMethodsCount() {
            return this.entries.size();
        }

        public int getSmallerParameterCount() {
            return this.getMethodAt(this.getMethodsCount() - 1).getParameters().size();
        }

        public String getParameterName(int index) {
            return this.parameterNames.get(index);
        }

        public void calculate() {
            if (this.getMethodsCount() < 2) {
                this.coreEntry = this.entries.get(0);
                return;
            }
            this.entries.sort((m1Entry, m2Entry) -> {
                MethodTree m1 = m1Entry.methodTree;
                MethodTree m2 = m2Entry.methodTree;
                ExecutableElement m1Element = m1Entry.methodElement;
                ExecutableElement m2Element = m2Entry.methodElement;
                int i = m2.getParameters().size() - m1.getParameters().size();
                if (i == 0) {
                    this.isValid = false;
                    for (int j = 0; j < m1.getParameters().size(); ++j) {
                        boolean abstract2;
                        TypeMirror m2ParamType;
                        TypeMirror m1ParamType = this.types.erasure((TypeMirror)Util.getType(m1.getParameters().get(j)));
                        if (this.types.isAssignable(m1ParamType, m2ParamType = this.types.erasure((TypeMirror)Util.getType(m2.getParameters().get(j))))) {
                            --i;
                        }
                        if (this.types.isAssignable(m2ParamType, m1ParamType)) {
                            ++i;
                        }
                        if (i == 0) {
                            boolean core1 = this.util.isCoreType(m1ParamType);
                            if (this.util.isStringType(m1ParamType)) {
                                core1 = false;
                            }
                            boolean core2 = this.util.isCoreType(m2ParamType);
                            if (this.util.isStringType(m2ParamType)) {
                                core2 = false;
                            }
                            if (!core1 && core2) {
                                --i;
                            }
                            if (core1 && !core2) {
                                ++i;
                            }
                        }
                        if (i != 0) continue;
                        boolean abstract1 = m1.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT) || this.util.isInterface(m1Element.getEnclosingElement()) && !m1.getModifiers().getFlags().contains((Object)Modifier.DEFAULT);
                        boolean bl = abstract2 = m2.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT) || this.util.isInterface(m2Element.getEnclosingElement()) && !m2.getModifiers().getFlags().contains((Object)Modifier.DEFAULT);
                        if (abstract1 && !abstract2) {
                            ++i;
                        }
                        if (abstract1 || !abstract2) continue;
                        --i;
                    }
                }
                if (m1Element.getEnclosingElement() != m2Element.getEnclosingElement()) {
                    this.isValid = false;
                }
                return i;
            });
            this.coreEntry = this.entries.get(0);
            TypeMirror coreMethodType = this.coreEntry.methodType;
            coreMethodType = this.util.erasureRecursive(coreMethodType);
            for (OverloadMethodEntry currentEntry : new ArrayList<OverloadMethodEntry>(this.entries)) {
                if (currentEntry == this.coreEntry || !coreMethodType.toString().equals(currentEntry.methodType.toString())) continue;
                this.entries.remove(currentEntry);
            }
            if (this.isValid) {
                this.defaultValues = new HashMap<Integer, Tree>();
            }
            if (this.getMethodsCount() > 1 && this.isValid) {
                block1: for (OverloadMethodEntry entry : this.entries) {
                    MethodTree methodDecl = entry.methodTree;
                    if (methodDecl.getBody() != null && methodDecl.getBody().getStatements().size() == 1) {
                        if (entry == this.coreEntry) continue;
                        List<? extends StatementTree> statements = methodDecl.getBody().getStatements();
                        MethodInvocationTree invocation = null;
                        StatementTree stat = statements.get(0);
                        if (stat instanceof ReturnTree) {
                            if (((ReturnTree)stat).getExpression() instanceof MethodInvocationTree) {
                                invocation = (MethodInvocationTree)((ReturnTree)stat).getExpression();
                            }
                        } else if (stat instanceof ExpressionStatementTree && ((ExpressionStatementTree)stat).getExpression() instanceof MethodInvocationTree) {
                            invocation = (MethodInvocationTree)((ExpressionStatementTree)stat).getExpression();
                        }
                        if (invocation == null) {
                            this.isValid = false;
                            continue;
                        }
                        ExecutableElement methodElement = entry.methodElement;
                        ExecutableElement invokedMethodElement = this.context.util.findMethodDeclarationInType((TypeElement)methodElement.getEnclosingElement(), invocation);
                        if (invokedMethodElement != null && invokedMethodElement.getSimpleName().toString().equals(this.methodName)) {
                            String inv = invocation.getMethodSelect().toString();
                            if (!(inv.equals(this.methodName) || inv.equals("this." + this.methodName) || inv.equals("this"))) {
                                this.isValid = false;
                            }
                            if (!this.isValid || invocation.getArguments() == null) continue;
                            for (int i = 0; i < invocation.getArguments().size(); ++i) {
                                ExpressionTree expr = invocation.getArguments().get(i);
                                if (this.context.util.isConstant(expr)) {
                                    this.defaultValues.put(i, expr);
                                    continue;
                                }
                                if (expr instanceof IdentifierTree && i < methodDecl.getParameters().size() && methodDecl.getParameters().get(i).getName().toString().equals(((IdentifierTree)expr).getName().toString())) continue;
                                this.isValid = false;
                                continue block1;
                            }
                            continue;
                        }
                        this.isValid = false;
                        continue;
                    }
                    this.isValid = false;
                }
            }
        }

        private boolean hasMethodType(OverloadMethodEntry searchedMethodEntry) {
            ExecutableElement searchedMethodElement = searchedMethodEntry.methodElement;
            TypeMirror searchedMethodType = this.util.erasureRecursive(searchedMethodEntry.methodType);
            for (OverloadMethodEntry thisMethodEntry : this.getEntries()) {
                ExecutableElement thisMethodElement = thisMethodEntry.methodElement;
                TypeMirror thisMethodType = this.util.erasureRecursive(thisMethodEntry.methodType);
                boolean match = thisMethodType.toString().equals(searchedMethodType.toString());
                if (match && thisMethodElement.getEnclosingElement() != searchedMethodElement.getEnclosingElement()) {
                    this.isValid = false;
                }
                if (!match) continue;
                return true;
            }
            return false;
        }

        private void safeAdd(OverloadMethodEntry methodEntry) {
            if (!this.entries.contains(methodEntry) && !this.hasMethodType(methodEntry)) {
                this.entries.add(methodEntry);
            }
        }

        public void merge(Overload subOverload) {
            for (OverloadMethodEntry overloadMethodEntry : this.entries) {
                MethodTree overloadMethod = overloadMethodEntry.methodTree;
                if (!overloadMethod.getModifiers().getFlags().contains((Object)Modifier.DEFAULT)) continue;
                boolean overriden = false;
                for (OverloadMethodEntry subOverloadMethodEntry : subOverload.getEntries()) {
                    MethodTree subOverloadMethod = subOverloadMethodEntry.methodTree;
                    if (subOverloadMethod.getParameters().size() != overloadMethod.getParameters().size()) continue;
                    overriden = true;
                    for (int i = 0; i < subOverloadMethod.getParameters().size(); ++i) {
                        Object subOverloadParamType;
                        Object overloadParamType = Util.getType(overloadMethod.getParameters().get(i));
                        if (this.types.isAssignable((TypeMirror)overloadParamType, (TypeMirror)(subOverloadParamType = Util.getType(subOverloadMethod.getParameters().get(i))))) continue;
                        overriden = false;
                    }
                }
                if (overriden) continue;
                subOverload.safeAdd(overloadMethodEntry);
            }
            boolean merge = false;
            for (OverloadMethodEntry subOverloadEntry : new ArrayList<OverloadMethodEntry>(subOverload.entries)) {
                MethodTree subOverloadMethod = subOverloadEntry.methodTree;
                boolean overrides = false;
                for (OverloadMethodEntry overloadEntry : new ArrayList<OverloadMethodEntry>(this.entries)) {
                    MethodTree overloadMethod = overloadEntry.methodTree;
                    if (subOverloadMethod.getParameters().size() != overloadMethod.getParameters().size()) continue;
                    overrides = true;
                    for (int i = 0; i < subOverloadMethod.getParameters().size(); ++i) {
                        Object subOverloadParamType;
                        Object overloadParamType = Util.getType(overloadMethod.getParameters().get(i));
                        if (this.types.isAssignable((TypeMirror)overloadParamType, (TypeMirror)(subOverloadParamType = Util.getType(subOverloadMethod.getParameters().get(i))))) continue;
                        overrides = false;
                    }
                }
                merge = merge || !overrides;
            }
            boolean bl = merge = merge || this.getMethodsCount() > 1;
            if (merge) {
                for (OverloadMethodEntry overloadEntry : this.entries) {
                    subOverload.safeAdd(overloadEntry);
                }
            }
        }

        public Iterable<OverloadMethodEntry> getEntries() {
            return this.entries;
        }

        public ExecutableElement getCoreMethodElement() {
            return this.coreEntry.methodElement;
        }

        public void register(CompilationUnitTree classCompilationUnit, ClassTree classTree, CompilationUnitTree methodCompilationUnit, ClassTree owningClassTree, MethodTree methodTree) {
            Object classElement = Util.getElement(classTree);
            ExecutableElement methodElement = (ExecutableElement)Util.getElement(methodTree);
            this.safeAdd(new OverloadMethodEntry(classCompilationUnit, classTree, (Element)classElement, methodCompilationUnit, owningClassTree, methodTree, methodElement, methodElement.asType()));
        }
    }

    public static class OverloadMethodEntry {
        public final CompilationUnitTree classCompilationUnit;
        public final ClassTree classTree;
        public final Element classElement;
        public final CompilationUnitTree methodCompilationUnit;
        public final ClassTree owningClassTree;
        public final MethodTree methodTree;
        public final ExecutableElement methodElement;
        public final TypeMirror methodType;

        public OverloadMethodEntry(CompilationUnitTree classCompilationUnit, ClassTree classTree, Element classElement, CompilationUnitTree methodCompilationUnit, ClassTree owningClassTree, MethodTree methodTree, ExecutableElement methodElement, TypeMirror methodType) {
            this.classCompilationUnit = classCompilationUnit;
            this.classTree = classTree;
            this.classElement = classElement;
            this.methodCompilationUnit = methodCompilationUnit;
            this.owningClassTree = owningClassTree;
            this.methodTree = methodTree;
            this.methodElement = methodElement;
            this.methodType = methodType;
        }

        public int hashCode() {
            return this.methodTree.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof OverloadMethodEntry && this.methodTree == ((OverloadMethodEntry)other).methodTree;
        }
    }
}

