/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import com.sun.source.tree.Tree;
import java.io.File;
import org.jsweet.transpiler.util.Position;

public final class SourcePosition {
    private final File file;
    private final Position startPosition;
    private final Position endPosition;
    private final Tree sourceElement;

    public SourcePosition(File file, Tree sourceElement, int startLine, int startColumn, int endLine, int endColumn) {
        this.file = file;
        this.startPosition = new Position(startLine, startColumn);
        this.endPosition = new Position(endLine, endColumn);
        this.sourceElement = sourceElement;
    }

    public SourcePosition(File file, Tree sourceElement, int line, int column) {
        this(file, sourceElement, new Position(line, column));
    }

    public SourcePosition(File file, Tree sourceElement, Position startPosition, Position endPosition) {
        this.file = file;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.sourceElement = sourceElement;
    }

    public SourcePosition(File file, Tree sourceElement, Position position) {
        this.file = file;
        this.endPosition = this.startPosition = position;
        this.sourceElement = sourceElement;
    }

    public final File getFile() {
        return this.file;
    }

    public final Position getStartPosition() {
        return this.startPosition;
    }

    public final Position getEndPosition() {
        return this.endPosition;
    }

    public final int getStartLine() {
        return this.startPosition.getLine();
    }

    public final int getStartColumn() {
        return this.startPosition.getColumn();
    }

    public final int getEndLine() {
        return this.endPosition.getLine();
    }

    public final int getEndColumn() {
        return this.endPosition.getColumn();
    }

    public final Tree getSourceElement() {
        return this.sourceElement;
    }

    public final String toString() {
        return this.file + "(" + this.getStartLine() + "," + this.getStartColumn() + ")";
    }
}

