/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;
import org.jsweet.transpiler.JSweetOptions;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.SourceFile;
import org.jsweet.transpiler.util.ErrorCountTranspilationHandler;
import org.jsweet.transpiler.util.Util;

public abstract class TypeScript2JavaScriptTranspiler {
    protected final Logger logger = Logger.getLogger(this.getClass());

    public void ts2js(ErrorCountTranspilationHandler transpilationHandler, Collection<SourceFile> tsSourceFiles, Collection<File> tsDefDirs, JSweetOptions options, boolean ignoreErrors, OnTsTranspilationCompletedCallback onTsTranspilationCompleted) {
        block4: {
            try {
                LinkedHashSet<File> tsFiles = new LinkedHashSet<File>();
                for (SourceFile sourceFile : tsSourceFiles) {
                    tsFiles.add(sourceFile.getTsFile());
                }
                for (File dir : tsDefDirs) {
                    Util.Static.addFiles(".d.ts", dir, tsFiles);
                }
                this.doTranspile(transpilationHandler, tsFiles, tsSourceFiles, options, ignoreErrors, onTsTranspilationCompleted);
            }
            catch (Exception e) {
                this.logger.error((Object)"ts2js transpilation failed", (Throwable)e);
                if (ignoreErrors || transpilationHandler.getProblemCount() != 0) break block4;
                transpilationHandler.report(JSweetProblem.INTERNAL_TSC_ERROR, null, "Unknown tsc error");
            }
        }
    }

    protected abstract void doTranspile(ErrorCountTranspilationHandler var1, Collection<File> var2, Collection<SourceFile> var3, JSweetOptions var4, boolean var5, OnTsTranspilationCompletedCallback var6) throws Exception;

    public static interface OnTsTranspilationCompletedCallback {
        public void call(boolean var1, ErrorCountTranspilationHandler var2, Collection<SourceFile> var3);
    }
}

