/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import java.io.File;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.jsweet.transpiler.EcmaScriptComplianceLevel;
import org.jsweet.transpiler.JSweetOptions;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.SourceFile;
import org.jsweet.transpiler.SourcePosition;
import org.jsweet.transpiler.TypeScript2JavaScriptTranspiler;
import org.jsweet.transpiler.util.ErrorCountTranspilationHandler;
import org.jsweet.transpiler.util.Position;
import org.jsweet.transpiler.util.ProcessUtil;
import ts.TypeScriptException;
import ts.TypeScriptNoContentAvailableException;
import ts.client.ExternalFile;
import ts.client.ITypeScriptServiceClient;
import ts.client.ScriptKindName;
import ts.client.TypeScriptServiceClient;
import ts.client.diagnostics.DiagnosticEvent;
import ts.client.diagnostics.DiagnosticEventBody;
import ts.client.diagnostics.IDiagnostic;
import ts.client.projectinfo.ProjectInfo;
import ts.cmd.tsc.CompilerOptions;
import ts.utils.FileUtils;

public class TypeScript2JavaScriptWithTsserverTranspiler
extends TypeScript2JavaScriptTranspiler {
    public static TypeScript2JavaScriptWithTsserverTranspiler INSTANCE = new TypeScript2JavaScriptWithTsserverTranspiler();
    private ITypeScriptServiceClient typeScriptServiceClient;

    private TypeScript2JavaScriptWithTsserverTranspiler() {
    }

    @Override
    protected synchronized void doTranspile(ErrorCountTranspilationHandler transpilationHandler, Collection<File> tsFiles, Collection<SourceFile> tsSourceFiles, JSweetOptions options, boolean ignoreErrors, TypeScript2JavaScriptTranspiler.OnTsTranspilationCompletedCallback onTsTranspilationCompleted) throws Exception {
        Collection sourceFilePaths;
        if (options.isTscWatchMode()) {
            throw new RuntimeException("tsserver implementation doesn't support watch mode - but it is so fast you shouldn't need it :)");
        }
        this.logger.debug((Object)("ts2js with tsserver: " + tsFiles));
        CompilerOptions compilerOptions = new CompilerOptions();
        compilerOptions.setTarget(options.getEcmaTargetVersion().name());
        if (options.isUsingModules()) {
            compilerOptions.setModule(options.getModuleKind().name());
        }
        compilerOptions.setModuleResolution(options.getModuleResolution().name());
        if (options.getEcmaTargetVersion().ordinal() >= EcmaScriptComplianceLevel.ES5.ordinal()) {
            compilerOptions.setExperimentalDecorators(Boolean.valueOf(true));
            compilerOptions.setEmitDecoratorMetadata(Boolean.valueOf(true));
        }
        compilerOptions.setSourceMap(Boolean.valueOf(options.isGenerateSourceMaps()));
        compilerOptions.setDeclaration(Boolean.valueOf(options.isGenerateDeclarations()));
        compilerOptions.setRootDir(options.getTsOutputDir().getAbsolutePath());
        compilerOptions.setSkipDefaultLibCheck(Boolean.valueOf(options.isSkipTypeScriptChecks()));
        if (options.getJsOutputDir() != null) {
            compilerOptions.setOutDir(options.getJsOutputDir().getAbsolutePath());
        }
        if ((sourceFilePaths = (Collection)tsFiles.stream().map(FileUtils::getPath).collect(Collectors.toList())).isEmpty()) {
            throw new RuntimeException("no files to transpile");
        }
        this.logger.info((Object)("launching tsserver compilation : \ncompilerOptions=" + compilerOptions + " \nsourcesFilePaths=" + sourceFilePaths));
        ITypeScriptServiceClient client = this.getTypeScriptServiceClient();
        this.logger.debug((Object)"tsserver client built");
        String projectFileName = FileUtils.getPath((File)options.getTsOutputDir());
        String referenceFileName = (String)sourceFilePaths.iterator().next();
        this.logger.info((Object)("open external project: " + projectFileName));
        client.openExternalProject(projectFileName, sourceFilePaths.stream().map(path -> new ExternalFile(path, ScriptKindName.TS, Boolean.valueOf(false), null)).collect(Collectors.toList()), compilerOptions);
        this.logger.debug((Object)("tsserver project opened: " + projectFileName));
        for (String fileName : sourceFilePaths) {
            client.updateFile(fileName, null);
        }
        for (String fileName : sourceFilePaths) {
            try {
                Boolean result = (Boolean)client.compileOnSaveEmitFile(fileName, Boolean.valueOf(true)).get();
                this.logger.trace((Object)("ts compilation [" + fileName + "] result=" + result));
            }
            catch (ExecutionException e) {
                Throwable actualException = e.getCause();
                if (!(actualException instanceof TypeScriptNoContentAvailableException)) continue;
                this.logger.warn((Object)("ts compilation: no content for " + fileName));
            }
        }
        this.logger.info((Object)("tsserver project compiled: " + projectFileName));
        ProjectInfo projectInfo = (ProjectInfo)client.projectInfo(referenceFileName, projectFileName, true).get();
        Collection compilationErrors = (Collection)client.geterrForProject(referenceFileName, 0, projectInfo).get();
        if (!ignoreErrors) {
            for (DiagnosticEvent errorEvent : compilationErrors) {
                File fileInError = new File(((DiagnosticEventBody)errorEvent.getBody()).getFile());
                for (IDiagnostic error : ((DiagnosticEventBody)errorEvent.getBody()).getDiagnostics()) {
                    SourcePosition originalPosition = new SourcePosition(fileInError, null, new Position(error.getStartLocation().getLine(), error.getStartLocation().getOffset()));
                    this.logger.error((Object)("TypeScript error: " + error.getFullText() + " at " + originalPosition.getFile() + "(" + originalPosition.getStartLine() + ")"));
                    SourcePosition position = SourceFile.findOriginPosition(originalPosition, tsSourceFiles);
                    if (position == null) {
                        transpilationHandler.report(JSweetProblem.INTERNAL_TSC_ERROR, originalPosition, error.getFullText());
                        continue;
                    }
                    transpilationHandler.report(JSweetProblem.MAPPED_TSC_ERROR, position, error.getFullText());
                }
            }
        } else {
            this.printTsserverDiagnostics(compilationErrors);
        }
        client.closeExternalProject(projectFileName);
        onTsTranspilationCompleted.call(false, transpilationHandler, tsSourceFiles);
    }

    private void printTsserverDiagnostics(Collection<DiagnosticEvent> events) {
        Object diagReport = "";
        for (DiagnosticEvent event : events) {
            if (((DiagnosticEventBody)event.getBody()).getDiagnostics().size() <= 0) continue;
            diagReport = (String)diagReport + ((DiagnosticEventBody)event.getBody()).getFile() + ":: " + event.getEvent() + "\n";
            for (IDiagnostic diag : ((DiagnosticEventBody)event.getBody()).getDiagnostics()) {
                diagReport = (String)diagReport + "  > " + diag.getStartLocation().getLine() + ":" + diag.getStartLocation().getOffset() + diag.getFullText() + "\n";
            }
        }
        this.logger.info((Object)("tsserver diagnostics: " + (String)diagReport));
    }

    private ITypeScriptServiceClient getTypeScriptServiceClient() {
        try {
            if (this.typeScriptServiceClient == null) {
                String tsserverPath = ProcessUtil.getGlobalNpmPackageNodeMainFilePath("typescript", "tsserver");
                TypeScriptServiceClient client = new TypeScriptServiceClient(new File("."), new File(tsserverPath), null, false, false, null, null, new TypeScriptServiceClient.TypeScriptServiceLogConfiguration("/tmp/tss.log", TypeScriptServiceClient.TypeScriptServiceLogLevel.verbose));
                this.typeScriptServiceClient = client;
                this.logger.info((Object)"creating TypeScriptServiceClient");
            }
            return this.typeScriptServiceClient;
        }
        catch (TypeScriptException e) {
            throw new RuntimeException(e);
        }
    }
}

