/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.eval;

import com.sun.source.tree.CompilationUnitTree;
import java.util.Arrays;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.JSweetTranspiler;
import org.jsweet.transpiler.JavaCompilationComponents;
import org.jsweet.transpiler.SourceFile;
import org.jsweet.transpiler.eval.EvalOptions;
import org.jsweet.transpiler.eval.RuntimeEval;
import org.jsweet.transpiler.util.EvaluationResult;
import org.jsweet.transpiler.util.MainMethodFinder;

public class JavaEval
extends RuntimeEval {
    private JSweetTranspiler transpiler;

    public JavaEval(JSweetTranspiler transpiler, EvalOptions options) {
        this.transpiler = transpiler;
    }

    public EvaluationResult performEval(SourceFile[] sourceFiles) throws Exception {
        JSweetContext context = new JSweetContext(this.transpiler);
        JavaCompilationComponents compilationComponents = JavaCompilationComponents.prepareFor(Arrays.asList(SourceFile.toFiles(sourceFiles)), context, this.transpiler.getFactory(), new JavaCompilationComponents.Options(){
            {
                this.classPath = JavaEval.this.transpiler.getClassPath();
                this.encoding = JavaEval.this.transpiler.getEncoding();
            }
        });
        this.logger.info((Object)("parsing: " + compilationComponents.getSourceFileObjects()));
        ExecutableElement mainMethod = null;
        Iterable<? extends CompilationUnitTree> compilationUnits = compilationComponents.getTask().parse();
        compilationComponents.getTask().analyze();
        MainMethodFinder mainMethodFinder = new MainMethodFinder();
        try {
            mainMethodFinder.scan(compilationUnits, context.trees);
        }
        catch (MainMethodFinder.MainMethodFoundSignal foundSignal) {
            mainMethod = foundSignal.mainMethod;
        }
        if (mainMethod != null) {
            try {
                this.initExportedVarMap();
                Class<?> c = Class.forName(((TypeElement)mainMethod.getEnclosingElement()).getQualifiedName().toString());
                c.getMethod("main", String[].class).invoke(null, new Object[]{null});
            }
            catch (Exception e) {
                throw new Exception("evalution error", e);
            }
        }
        final Map<String, Object> map = this.getExportedVarMap();
        return new EvaluationResult(){

            @Override
            public <T> T get(String variableName) {
                return (T)map.get("_exportedVar_" + variableName);
            }

            public String toString() {
                return map.toString();
            }

            @Override
            public String getExecutionTrace() {
                return "<not available>";
            }
        };
    }
}

