/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.extension;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.apache.log4j.Logger;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.JSweetOptions;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.ModuleImportDescriptor;
import org.jsweet.transpiler.OverloadScanner;
import org.jsweet.transpiler.SourcePosition;
import org.jsweet.transpiler.extension.AnnotationManager;
import org.jsweet.transpiler.model.ArrayAccessElement;
import org.jsweet.transpiler.model.AssignmentElement;
import org.jsweet.transpiler.model.AssignmentWithOperatorElement;
import org.jsweet.transpiler.model.BinaryOperatorElement;
import org.jsweet.transpiler.model.CaseElement;
import org.jsweet.transpiler.model.CompilationUnitElement;
import org.jsweet.transpiler.model.ExtendedElement;
import org.jsweet.transpiler.model.ExtendedElementFactory;
import org.jsweet.transpiler.model.ForeachLoopElement;
import org.jsweet.transpiler.model.IdentifierElement;
import org.jsweet.transpiler.model.ImportElement;
import org.jsweet.transpiler.model.MethodInvocationElement;
import org.jsweet.transpiler.model.NewArrayElement;
import org.jsweet.transpiler.model.NewClassElement;
import org.jsweet.transpiler.model.TypeCastElement;
import org.jsweet.transpiler.model.UnaryOperatorElement;
import org.jsweet.transpiler.model.VariableAccessElement;
import org.jsweet.transpiler.model.support.CompilationUnitElementSupport;
import org.jsweet.transpiler.model.support.ExtendedElementSupport;
import org.jsweet.transpiler.model.support.MethodInvocationElementSupport;
import org.jsweet.transpiler.util.AbstractTreePrinter;
import org.jsweet.transpiler.util.Util;

public class PrinterAdapter {
    protected Logger logger = Logger.getLogger(this.getClass());
    private PrinterAdapter parentAdapter;
    private AbstractTreePrinter printer;
    protected JSweetContext context;
    public Set<TypeParameterElement> typeVariablesToErase = new HashSet<TypeParameterElement>();

    public PrinterAdapter(JSweetContext context) {
        this.context = context;
        this.parentAdapter = null;
    }

    public PrinterAdapter(PrinterAdapter parentAdapter) {
        if (parentAdapter == null) {
            throw new RuntimeException("cannot create an adatper with a null parent adapter: pass the context instead");
        }
        this.parentAdapter = parentAdapter;
        this.context = parentAdapter.getContext();
    }

    public JSweetContext getContext() {
        if (this.context != null) {
            return this.context;
        }
        if (this.getParentAdapter() != null) {
            this.context = this.getParentAdapter().getContext();
        }
        return this.context;
    }

    public void onTranspilationStarted() {
        if (this.getParentAdapter() != null) {
            this.getParentAdapter().onTranspilationStarted();
        }
    }

    public void onTranspilationFinished() {
        if (this.getParentAdapter() != null) {
            this.getParentAdapter().onTranspilationFinished();
        }
    }

    protected final void addTypeMapping(String sourceTypeName, String targetTypeName) {
        this.context.addTypeMapping(sourceTypeName, targetTypeName);
    }

    protected final void addTypeMappings(Map<String, String> nameMappings) {
        this.context.addTypeMappings(nameMappings);
    }

    protected final boolean isMappedType(String sourceTypeName) {
        return this.context.isMappedType(sourceTypeName);
    }

    protected final String getTypeMappingTarget(String sourceTypeName) {
        return this.context.getTypeMappingTarget(sourceTypeName);
    }

    protected final List<BiFunction<ExtendedElement, String, Object>> getFunctionalTypeMappings() {
        return this.context.getFunctionalTypeMappings();
    }

    public void addTypeMapping(BiFunction<ExtendedElement, String, Object> mappingFunction) {
        this.context.addTypeMapping(mappingFunction);
    }

    protected final void addTypeMapping(Function<TypeMirror, String> mappingFunction) {
        this.context.addTypeMapping(mappingFunction);
    }

    protected final List<Function<TypeMirror, String>> getTypeMirrorMappings() {
        return this.context.getFunctionalTypeMirrorMappings();
    }

    public final String getMappedType(TypeMirror type) {
        return this.getMappedType(type, null);
    }

    public final String getMappedType(TypeMirror type, Map<TypeMirror, TypeMirror> resolvedTypeArgs) {
        StringBuilder stringBuilder = new StringBuilder();
        this.buildMappedType(stringBuilder, type, resolvedTypeArgs);
        return stringBuilder.toString();
    }

    private final void buildMappedType(StringBuilder stringBuilder, TypeMirror type, Map<TypeMirror, TypeMirror> resolvedTypeArgs) {
        switch (type.getKind()) {
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)type;
                Element element = declaredType.asElement();
                String elementName = element.toString();
                String mapped = this.context.getTypeMappingTarget(elementName);
                if (mapped != null) {
                    stringBuilder.append(mapped);
                } else {
                    stringBuilder.append(element.getSimpleName().toString());
                }
                if ("any".equals(mapped) || declaredType.getTypeArguments().isEmpty()) break;
                stringBuilder.append("<");
                for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                    this.buildMappedType(stringBuilder, typeMirror, resolvedTypeArgs);
                    stringBuilder.append(", ");
                }
                stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
                stringBuilder.append(">");
                break;
            }
            case ARRAY: {
                this.buildMappedType(stringBuilder, ((ArrayType)type).getComponentType(), resolvedTypeArgs);
                stringBuilder.append("[]");
                break;
            }
            case TYPEVAR: 
            case WILDCARD: {
                if (resolvedTypeArgs != null && resolvedTypeArgs.get(type) != null && resolvedTypeArgs.get(type) != type) {
                    this.buildMappedType(stringBuilder, resolvedTypeArgs.get(type), resolvedTypeArgs);
                    break;
                }
                stringBuilder.append("any");
                break;
            }
            default: {
                if (this.context.isMappedType(type.toString())) {
                    stringBuilder.append(this.context.getTypeMappingTarget(type.toString()));
                    break;
                }
                stringBuilder.append(type.toString());
            }
        }
    }

    public final void addAnnotation(Class<? extends Annotation> annotationType, String ... filters) {
        this.addAnnotation(annotationType.getName(), filters);
    }

    public final void addAnnotationWithValue(Class<? extends Annotation> annotationType, Object value, String ... filters) {
        this.addAnnotation(annotationType.getName() + "('" + value.toString() + "')", filters);
    }

    public final void addAnnotationManager(AnnotationManager annotationManager) {
        this.context.addAnnotationManager(annotationManager);
    }

    public final boolean hasAnnotationType(Element element, String ... annotationTypes) {
        return this.context.hasAnnotationType(element, annotationTypes);
    }

    public final <T> T getAnnotationValue(Element element, String annotationType, Class<T> propertyClass, T defaultValue) {
        return this.getAnnotationValue(element, annotationType, null, propertyClass, defaultValue);
    }

    public final <T> T getAnnotationValue(Element element, String annotationType, String propertyName, Class<T> propertyClass, T defaultValue) {
        return this.context.getAnnotationValue(element, annotationType, propertyName, propertyClass, defaultValue);
    }

    public final void addAnnotation(String annotationDescriptor, String ... filters) {
        this.context.addAnnotation(annotationDescriptor, filters);
    }

    public PrinterAdapter print(ExtendedElement element) {
        this.printer.print((Tree)((ExtendedElementSupport)element).getTree());
        return this;
    }

    public PrinterAdapter print(String string) {
        this.printer.print(string);
        return this;
    }

    protected final PrinterAdapter print(Tree tree) {
        this.printer.print(tree);
        return this;
    }

    public PrinterAdapter print(Name name) {
        this.printer.print(name.toString());
        return this;
    }

    public PrinterAdapter println() {
        this.printer.println();
        return this;
    }

    public PrinterAdapter printArgList(List<? extends ExtendedElement> args) {
        this.printer.printArgList(null, args.stream().map(a -> ((ExtendedElementSupport)a).getTree()).collect(Collectors.toList()));
        return this;
    }

    public PrinterAdapter printIdentifierList(String prefix, int count) {
        for (int i = 0; i < count; ++i) {
            this.print(prefix + i + ", ");
        }
        if (count > 0) {
            this.removeLastChars(2);
        }
        return this;
    }

    public void print(String exprStr, ExtendedElement expr) {
        if (exprStr == null) {
            this.print(expr);
        } else {
            this.print(exprStr);
        }
    }

    public PrinterAdapter printIndent() {
        this.printer.printIndent();
        return this;
    }

    public final PrinterAdapter startIndent() {
        this.printer.startIndent();
        return this;
    }

    public final PrinterAdapter endIndent() {
        this.printer.endIndent();
        return this;
    }

    public final PrinterAdapter space() {
        this.printer.space();
        return this;
    }

    public final boolean removeLastChar(char expectedChar) {
        return this.printer.removeLastChar(expectedChar);
    }

    public final PrinterAdapter removeLastChar() {
        this.printer.removeLastChar();
        return this;
    }

    public final PrinterAdapter removeLastChars(int count) {
        this.printer.removeLastChars(count);
        return this;
    }

    public final PrinterAdapter removeLastIndent() {
        this.printer.removeLastIndent();
        return this;
    }

    public final ExtendedElement getCurrentElement() {
        return ExtendedElementFactory.INSTANCE.create(this.printer.getCurrent());
    }

    public final ExtendedElement getParentElement() {
        return this.printer.getParentElement();
    }

    public final <T extends Element> T getParentElement(Class<T> type) {
        return this.printer.getParentElement(type);
    }

    public final ExecutableElement findExecutableDeclarationInType(TypeElement type, MethodInvocationElement invocation) {
        return this.util().findMethodDeclarationInType(type, (MethodInvocationTree)((MethodInvocationElementSupport)invocation).getTree());
    }

    public final String getRootRelativeName(Element element) {
        return this.printer.getRootRelativeName(element);
    }

    protected void report(ExtendedElement element, JSweetProblem problem, Object ... params) {
        this.printer.report((Tree)((ExtendedElementSupport)element).getTree(), problem, params);
    }

    protected void report(Element element, JSweetProblem problem, Object ... params) {
        this.printer.report(this.util().lookupTree(this.context, element), problem, params);
    }

    public boolean substituteArrayAccess(ArrayAccessElement arrayAccess) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteArrayAccess(arrayAccess);
    }

    public boolean substituteBinaryOperator(BinaryOperatorElement binaryOperator) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteBinaryOperator(binaryOperator);
    }

    public boolean substituteUnaryOperator(UnaryOperatorElement unaryOperator) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteUnaryOperator(unaryOperator);
    }

    public boolean substituteIdentifier(IdentifierElement identifier) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteIdentifier(identifier);
    }

    public boolean substituteExtends(TypeElement type) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteExtends(type);
    }

    public boolean substituteImplements(TypeElement type) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteImplements(type);
    }

    public boolean substituteNewClass(NewClassElement newClass) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteNewClass(newClass);
    }

    public boolean substituteAssignedExpression(TypeMirror type, ExtendedElement assignedExpression) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteAssignedExpression(type, assignedExpression);
    }

    public final boolean substitute(ExtendedElement extendedElement) {
        if (extendedElement instanceof VariableAccessElement) {
            return this.substituteVariableAccess((VariableAccessElement)extendedElement);
        }
        if (extendedElement instanceof IdentifierElement) {
            return this.substituteIdentifier((IdentifierElement)extendedElement);
        }
        return false;
    }

    public boolean substituteVariableAccess(VariableAccessElement variableAccess) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteVariableAccess(variableAccess);
    }

    public boolean substituteOverloadMethodBody(TypeElement parentTypeElement, OverloadScanner.Overload overload) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteOverloadMethodBody(parentTypeElement, overload);
    }

    public boolean substituteMethodBody(TypeElement parentTypeElement, ExecutableElement method) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteMethodBody(parentTypeElement, method);
    }

    public String getVariableInitialValue(VariableElement variable) {
        return this.parentAdapter == null ? this.util().getTypeInitialValue(variable.asType()) : this.parentAdapter.getVariableInitialValue(variable);
    }

    public String needsImport(ImportElement importElement, String qualifiedName) {
        return this.parentAdapter == null ? (importElement.getImportedType() == null ? null : this.getRootRelativeName(importElement.getImportedType())) : this.parentAdapter.needsImport(importElement, qualifiedName);
    }

    public ModuleImportDescriptor getModuleImportDescriptor(CompilationUnitElement currentCompilationUnit, String importedName, TypeElement importedClass) {
        if (this.parentAdapter != null) {
            return this.parentAdapter.getModuleImportDescriptor(currentCompilationUnit, importedName, importedClass);
        }
        if (this.util().isSourceElement(importedClass) && !importedClass.getQualifiedName().toString().startsWith("def.")) {
            String importedModule = this.util().getSourceFilePath(importedClass);
            if (importedModule.equals(currentCompilationUnit.getSourceFilePath())) {
                return null;
            }
            Element parent = importedClass.getEnclosingElement();
            while (!(parent instanceof PackageElement)) {
                importedName = parent.getSimpleName().toString();
                parent = parent.getEnclosingElement();
            }
            while (importedClass.getEnclosingElement() instanceof TypeElement) {
                importedClass = (TypeElement)importedClass.getEnclosingElement();
            }
            if (parent != null && !this.hasAnnotationType(importedClass, "jsweet.lang.Erased") && (importedClass.getKind() != ElementKind.ANNOTATION_TYPE || this.context.elementHasAnnotationType(importedClass, "jsweet.lang.Decorator"))) {
                Object pathToImportedClass = this.util().getRelativePath("@/" + currentCompilationUnit.getPackage().toString().replace('.', '/'), "@/" + importedClass.toString().replace('.', '/'));
                if (!((String)pathToImportedClass).startsWith(".")) {
                    pathToImportedClass = "./" + (String)pathToImportedClass;
                }
                return new ModuleImportDescriptor(false, (PackageElement)parent, importedName, ((String)pathToImportedClass).replace('\\', '/'), importedClass);
            }
        }
        return null;
    }

    public boolean substituteMethodInvocation(MethodInvocationElement invocation) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteMethodInvocation(invocation);
    }

    public boolean substituteNewArrayWithVariableLength(NewArrayElement newArray) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteNewArrayWithVariableLength(newArray);
    }

    public boolean substituteType(TypeElement type) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteType(type);
    }

    public boolean substituteExecutable(ExecutableElement executable) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteExecutable(executable);
    }

    public boolean substituteVariable(VariableElement variable) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteVariable(variable);
    }

    public boolean substituteAssignment(AssignmentElement assignment) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteAssignment(assignment);
    }

    public boolean substituteAssignmentWithOperator(AssignmentWithOperatorElement assignment) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteAssignmentWithOperator(assignment);
    }

    public AbstractTreePrinter getPrinter() {
        return this.printer;
    }

    public void setPrinter(AbstractTreePrinter printer) {
        this.printer = printer;
        if (this.parentAdapter != null) {
            this.parentAdapter.setPrinter(printer);
        }
    }

    public Set<String> getErasedTypes() {
        if (this.parentAdapter == null) {
            throw new RuntimeException("unimplemented behavior");
        }
        return this.parentAdapter.getErasedTypes();
    }

    public boolean substituteForEachLoop(ForeachLoopElement foreachLoop, boolean targetHasLength, String indexVarName) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteForEachLoop(foreachLoop, targetHasLength, indexVarName);
    }

    public boolean eraseSuperClass(TypeElement type, TypeElement superClass) {
        return this.parentAdapter == null ? false : this.parentAdapter.eraseSuperClass(type, superClass);
    }

    public boolean eraseSuperInterface(TypeElement type, TypeElement superInterface) {
        return this.parentAdapter == null ? false : this.parentAdapter.eraseSuperInterface(type, superInterface);
    }

    public boolean isSubstituteSuperTypes() {
        return this.parentAdapter == null ? false : this.parentAdapter.isSubstituteSuperTypes();
    }

    public boolean substituteInstanceof(String exprStr, ExtendedElement expr, TypeMirror type) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteInstanceof(exprStr, expr, type);
    }

    public boolean substituteTypeCast(TypeCastElement castExpression) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteTypeCast(castExpression);
    }

    public boolean substituteCaseStatementPattern(CaseElement caseStatement, ExtendedElement pattern) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteCaseStatementPattern(caseStatement, pattern);
    }

    public boolean substituteSwitchStatementSelector(ExtendedElement selector) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteSwitchStatementSelector(selector);
    }

    public void afterType(TypeElement type) {
        if (this.parentAdapter != null) {
            this.parentAdapter.afterType(type);
        }
    }

    public void beforeCompilationUnit() {
        if (this.parentAdapter != null) {
            this.parentAdapter.beforeCompilationUnit();
        }
    }

    public void beforeTypeBody(TypeElement type) {
        if (this.parentAdapter != null) {
            this.parentAdapter.beforeTypeBody(type);
        }
    }

    public void afterTypeBody(TypeElement type) {
        if (this.parentAdapter != null) {
            this.parentAdapter.afterTypeBody(type);
        }
    }

    public String adaptDocComment(Element element, String commentText) {
        return this.parentAdapter == null ? commentText : this.parentAdapter.adaptDocComment(element, commentText);
    }

    public PrinterAdapter getParentAdapter() {
        return this.parentAdapter;
    }

    public void setParentAdapter(PrinterAdapter parentAdapter) {
        this.parentAdapter = parentAdapter;
    }

    public Types types() {
        return this.context.types;
    }

    public Util util() {
        return this.context.util;
    }

    protected Trees trees() {
        return this.context.trees;
    }

    protected final void printMacroName(String macroName) {
        this.print("/* " + macroName + " */");
    }

    public final boolean isAmbientDeclaration(Element element) {
        return this.context.isAmbientDeclaration(element);
    }

    public final JSweetOptions getTranspilerOptions() {
        return this.context.options;
    }

    public final void addHeader(String key, String header) {
        this.context.addHeader(key, header);
    }

    public final String getHeader(String key) {
        return this.context.getHeader(key);
    }

    public final boolean isInlinedExpression(ExtendedElement element) {
        return this.printer.isInlinedExpression((Tree)((ExtendedElementSupport)element).getTree());
    }

    public Comparator<ExtendedElement> getClassMemberComparator() {
        if (this.parentAdapter == null) {
            return new Comparator<ExtendedElement>(){

                @Override
                public int compare(ExtendedElement e1, ExtendedElement e2) {
                    SourcePosition sourcePosition1 = e1.getSourcePosition();
                    SourcePosition sourcePosition2 = e2.getSourcePosition();
                    return sourcePosition1.getStartPosition().compareTo(sourcePosition2.getStartPosition());
                }
            };
        }
        return this.parentAdapter.getClassMemberComparator();
    }

    public boolean substituteVariableDeclarationKeyword(VariableElement variable) {
        return this.parentAdapter == null ? false : this.parentAdapter.substituteVariableDeclarationKeyword(variable);
    }

    public CompilationUnitElement getCompilationUnit() {
        return new CompilationUnitElementSupport(this.getCompilationUnitTree());
    }

    protected final CompilationUnitTree getCompilationUnitTree() {
        return this.printer.getCompilationUnit();
    }

    protected final PackageElement getPackageElement() {
        return (PackageElement)Util.getElement(this.getCompilationUnitTree().getPackage());
    }
}

