/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.extension;

import com.sun.source.tree.EnhancedForLoopTree;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeMirror;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.extension.PrinterAdapter;
import org.jsweet.transpiler.extension.RemoveJavaDependenciesAdapter;
import org.jsweet.transpiler.model.ExtendedElement;
import org.jsweet.transpiler.model.ForeachLoopElement;
import org.jsweet.transpiler.model.MethodInvocationElement;
import org.jsweet.transpiler.model.NewClassElement;
import org.jsweet.transpiler.model.support.ForeachLoopElementSupport;
import org.jsweet.transpiler.util.Util;

public class RemoveJavaDependenciesES6Adapter
extends RemoveJavaDependenciesAdapter {
    protected static final Set<String> SET_CLASS_NAMES = Stream.of(Set.class, HashSet.class, LinkedHashSet.class, TreeSet.class, AbstractSet.class).map(Class::getName).collect(Collectors.toSet());
    protected static final Set<String> MAP_CLASS_NAMES = Stream.of(Map.class, HashMap.class, LinkedHashMap.class, TreeMap.class, AbstractMap.class).map(Class::getName).collect(Collectors.toSet());

    public RemoveJavaDependenciesES6Adapter(PrinterAdapter parentAdapter) {
        super(parentAdapter);
    }

    @Override
    protected void initTypesMapping() {
        super.initTypesMapping();
        SET_CLASS_NAMES.forEach(name -> this.extTypesMapping.put(name, "Set"));
        MAP_CLASS_NAMES.forEach(name -> this.extTypesMapping.put(name, "Map"));
        this.extTypesMapping.put(Map.class.getName() + ".Entry", "any");
    }

    @Override
    public boolean substituteForEachLoop(ForeachLoopElement foreachLoop, boolean targetHasLength, String indexVarName) {
        EnhancedForLoopTree loop = (EnhancedForLoopTree)((ForeachLoopElementSupport)foreachLoop).getTree();
        if (!targetHasLength && SET_CLASS_NAMES.contains(this.context.types.erasure((TypeMirror)Util.getType(loop.getExpression())).toString())) {
            this.getPrinter().print(loop.getExpression()).print(".forEach((" + loop.getVariable().getName().toString() + ")=>");
            this.getPrinter().printIndent().print(loop.getStatement());
            this.endIndent().println().printIndent().print(")");
            return true;
        }
        return super.substituteForEachLoop(foreachLoop, targetHasLength, indexVarName);
    }

    @Override
    public boolean substituteNewClass(NewClassElement newClass) {
        String className = newClass.getTypeAsElement().toString();
        if (SET_CLASS_NAMES.contains(className)) {
            this.substituteNewSet(newClass);
            return true;
        }
        if (MAP_CLASS_NAMES.contains(className)) {
            this.substituteNewMap(newClass);
            return true;
        }
        return super.substituteNewClass(newClass);
    }

    protected void substituteNewSet(NewClassElement newClass) {
        boolean ignoreArguments;
        TypeMirror genericIterable = this.context.types.erasure(this.util().getType(Iterable.class));
        boolean bl = ignoreArguments = newClass.getArgumentCount() == 0 || !(newClass.getArgument(0).getType() instanceof ArrayType) && !this.context.types.isAssignable(this.context.types.erasure(newClass.getArgument(0).getType()), genericIterable);
        if (ignoreArguments) {
            this.print("new Set()");
        } else {
            this.print("new Set(").print(newClass.getArgument(0)).print(")");
        }
    }

    protected void substituteNewMap(NewClassElement newClass) {
        boolean ignoreArguments;
        boolean bl = ignoreArguments = newClass.getArgumentCount() == 0 || !this.context.types.erasure(newClass.getArgument(0).getType()).toString().endsWith("Map");
        if (ignoreArguments) {
            this.print("new Map()");
        } else {
            this.print("new Map(").print(newClass.getArgument(0)).print(")");
        }
    }

    @Override
    public boolean substituteMethodInvocation(MethodInvocationElement invocation) {
        String targetClassName = invocation.getMethod().getEnclosingElement().toString();
        ExtendedElement targetExpression = invocation.getTargetExpression();
        if (targetExpression != null) {
            targetClassName = targetExpression.getTypeAsElement().toString();
        }
        if (SET_CLASS_NAMES.contains(targetClassName)) {
            this.substituteMethodOnSet(invocation);
            return true;
        }
        if (MAP_CLASS_NAMES.contains(targetClassName)) {
            this.substituteMethodOnMap(invocation);
            return true;
        }
        return super.substituteMethodInvocation(invocation);
    }

    protected void substituteMethodOnSet(MethodInvocationElement invocation) {
        String targetMethodName = invocation.getMethodName();
        ExtendedElement targetExpression = invocation.getTargetExpression();
        switch (targetMethodName) {
            case "add": {
                this.printMacroName(targetMethodName);
                this.print("((s, v) => { const n = s.size; s.add(v); return n !== s.size; })(").print(targetExpression).print(",").print(invocation.getArgument(0)).print(")");
                break;
            }
            case "addAll": {
                this.printMacroName(targetMethodName);
                this.print("((s, c) => { const len = s.size; for (const e of c) s.add(e); return s.size !== len; })(").print(targetExpression).print(",").print(invocation.getArgument(0)).print(")");
                break;
            }
            case "clear": {
                this.printMacroName(targetMethodName);
                this.print(targetExpression).print(".clear()");
                break;
            }
            case "contains": {
                this.printMacroName(targetMethodName);
                this.print(targetExpression).print(".has(").print(invocation.getArgument(0)).print(")");
                break;
            }
            case "containsAll": {
                this.printMacroName(targetMethodName);
                this.print("((s, c) => c.every(e => s.has(e)))(").print(targetExpression).print(",").print(invocation.getArgument(0)).print(")");
                break;
            }
            case "equals": {
                this.printMacroName(targetMethodName);
                this.print("((s1, s2) => { if (!s1 || !s2) return s1 === s2; return s1.size === s2.size && Array.from(s1).every(e => s2.has(e)) })(").print(targetExpression).print(",").print(invocation.getArgument(0)).print(")");
                break;
            }
            case "hashCode": {
                this.printMacroName(targetMethodName);
                this.report(invocation, JSweetProblem.USER_ERROR, "hashCode() is not supported.");
                break;
            }
            case "isEmpty": {
                this.printMacroName(targetMethodName);
                this.print("(").print(targetExpression).print(".size === 0").print(")");
                break;
            }
            case "iterator": {
                this.printMacroName(targetMethodName);
                this.print(targetExpression).print(".values()");
                break;
            }
            case "remove": {
                this.printMacroName(targetMethodName);
                this.print("(").print(targetExpression).print(".delete(").print(invocation.getArgument(0)).print(")").print(")");
                break;
            }
            case "removeAll": {
                this.printMacroName(targetMethodName);
                this.print("((s, c) => { const len = s.size; for (const e of c) s.delete(e); return s.size !== len; })(").print(targetExpression).print(",").print(invocation.getArgument(0)).print(")");
                break;
            }
            case "retainAll": {
                this.printMacroName(targetMethodName);
                this.print("((s, c) => { const len = s.size; const ca = Array.from(c); s.forEach(e => { if (ca.indexOf(e) == -1) s.delete(e) }); return len !== s.size; })(").print(targetExpression).print(",").print(invocation.getArgument(0)).print(")");
                break;
            }
            case "size": {
                this.print("(<any>");
                this.printMacroName(targetMethodName);
                this.print(targetExpression).print(".size");
                this.print(")");
                break;
            }
            case "toArray": {
                this.printMacroName(targetMethodName);
                this.print("(").print("Array.from(").print(targetExpression).print(")").print(")");
                break;
            }
            default: {
                this.printCallToEponymMethod(invocation);
            }
        }
    }

    protected void substituteMethodOnMap(MethodInvocationElement invocation) {
        String targetMethodName = invocation.getMethodName();
        ExtendedElement targetExpression = invocation.getTargetExpression();
        switch (targetMethodName) {
            case "put": {
                this.printMacroName(targetMethodName);
                this.print("((m, k, v) => { const prev = m.get(k); m.set(k,v); return prev; })(");
                this.print(targetExpression).print(",");
                this.print(invocation.getArgument(0)).print(",");
                this.print(invocation.getArgument(1));
                this.print(")");
                break;
            }
            case "putAll": {
                this.printMacroName(targetMethodName);
                this.print("((m, m2) => { for (const e of m2) m.set(e[0], e[1]) })(").print(targetExpression).print(",").print(invocation.getArgument(0)).print(")");
                break;
            }
            case "containsKey": {
                this.printMacroName(targetMethodName);
                this.print(targetExpression).print(".has(").print(invocation.getArgument(0)).print(")");
                break;
            }
            case "containsValue": {
                this.printMacroName(targetMethodName);
                this.print("((m, v) => Array.from(m.values()).indexOf(v)>-1)(");
                this.print(targetExpression).print(",").print(invocation.getArgument(0));
                this.print(")");
                break;
            }
            case "entrySet": {
                this.printMacroName(targetMethodName);
                this.print("((m) => new Set(Array.from(m.entries()).map(entry => ({ getKey: () => entry[0], getValue: () => entry[1] }) ) ))(");
                this.print(targetExpression);
                this.print(")");
                break;
            }
            case "keySet": {
                this.printMacroName(targetMethodName);
                this.print("((m) => new Set(m.keys()))(");
                this.print(targetExpression);
                this.print(")");
                break;
            }
            case "values": {
                this.printMacroName(targetMethodName);
                this.print("((m) => Array.from(m.values()))(");
                this.print(targetExpression);
                this.print(")");
                break;
            }
            case "equals": {
                this.printMacroName(targetMethodName);
                this.print("((s1, s2) => { if (!s1 || !s2) return s1 === s2; return s1.size === s2.size && Array.from(s1.keys()).every(i => x[i] == x2[i]) })(").print(targetExpression).print(",").print(invocation.getArgument(0)).print(")");
                break;
            }
            case "hashCode": {
                this.printMacroName(targetMethodName);
                this.report(invocation, JSweetProblem.USER_ERROR, "hashCode() is not supported.");
                break;
            }
            case "isEmpty": {
                this.printMacroName(targetMethodName);
                this.print("(").print(targetExpression).print(".size === 0").print(")");
                break;
            }
            case "remove": {
                this.printMacroName(targetMethodName);
                this.print("((m, k) => { const v = m.get(k); return m.delete(k) ? v : undefined; })(");
                this.print(targetExpression).print(",").print(invocation.getArgument(0));
                this.print(")");
                break;
            }
            case "getOrDefault": {
                this.printMacroName(targetMethodName);
                this.print("(");
                this.print(targetExpression);
                this.print(" .get(");
                this.print(invocation.getArgument(0));
                this.print(" ) || ");
                this.print(invocation.getArgument(1));
                this.print(")");
                break;
            }
            case "compute": {
                this.printMacroName(targetMethodName);
                this.print("((m, k, f) => { const v = f(k, m.get(k)); m.set(k, v); return v; })(");
                this.print(targetExpression).print(",").print(invocation.getArgument(0)).print(",").print(invocation.getArgument(1));
                this.print(")");
                break;
            }
            case "computeIfAbsent": {
                this.printMacroName(targetMethodName);
                this.print("((m, k, f) => { if (m.get(k) == null) { const v = f(k); m.set(k, v); return v; } })(");
                this.print(targetExpression).print(",").print(invocation.getArgument(0)).print(",").print(invocation.getArgument(1));
                this.print(")");
                break;
            }
            case "computeIfPresent": {
                this.printMacroName(targetMethodName);
                this.print("((m, k, f) => { if (m.get(k) != null) { const v = f(k, m.get(k)); m.set(k, v); return v; } })(");
                this.print(targetExpression).print(",").print(invocation.getArgument(0)).print(",").print(invocation.getArgument(1));
                this.print(")");
                break;
            }
            case "size": {
                this.printMacroName(targetMethodName);
                this.print("(<any>");
                this.print(targetExpression).print(".size");
                this.print(")");
                break;
            }
            default: {
                this.printCallToEponymMethod(invocation);
            }
        }
    }

    private void printCallToEponymMethod(MethodInvocationElement invocation) {
        String targetMethodName = invocation.getMethodName();
        ExtendedElement targetExpression = invocation.getTargetExpression();
        this.printMacroName(targetMethodName);
        this.print(targetExpression).print(".").print(targetMethodName);
        this.print("(");
        for (int i = 0; i < invocation.getArgumentCount(); ++i) {
            this.print(invocation.getArgument(i));
            if (i >= invocation.getArgumentCount() - 1) continue;
            this.print(",");
        }
        this.print(")");
    }
}

