/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.model;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.VariableElement;
import org.jsweet.transpiler.model.ExtendedElement;
import org.jsweet.transpiler.model.support.ArrayAccessElementSupport;
import org.jsweet.transpiler.model.support.AssignmentElementSupport;
import org.jsweet.transpiler.model.support.AssignmentWithOperatorElementSupport;
import org.jsweet.transpiler.model.support.BinaryOperatorElementSupport;
import org.jsweet.transpiler.model.support.CaseElementSupport;
import org.jsweet.transpiler.model.support.CompilationUnitElementSupport;
import org.jsweet.transpiler.model.support.ExecutableElementSupport;
import org.jsweet.transpiler.model.support.ExtendedElementSupport;
import org.jsweet.transpiler.model.support.ForeachLoopElementSupport;
import org.jsweet.transpiler.model.support.IdentifierElementSupport;
import org.jsweet.transpiler.model.support.ImportElementSupport;
import org.jsweet.transpiler.model.support.LiteralElementSupport;
import org.jsweet.transpiler.model.support.MethodInvocationElementSupport;
import org.jsweet.transpiler.model.support.NewArrayElementSupport;
import org.jsweet.transpiler.model.support.NewClassElementSupport;
import org.jsweet.transpiler.model.support.TypeCastElementSupport;
import org.jsweet.transpiler.model.support.UnaryOperatorElementSupport;
import org.jsweet.transpiler.model.support.VariableAccessElementSupport;
import org.jsweet.transpiler.model.support.VariableElementSupport;
import org.jsweet.transpiler.util.Util;

public class ExtendedElementFactory {
    public static final ExtendedElementFactory INSTANCE = new ExtendedElementFactory();

    public static <T extends Tree> T toTree(ExtendedElement element) {
        return ((ExtendedElementSupport)element).getTree();
    }

    public ExtendedElement create(Tree tree) {
        switch (tree.getKind()) {
            case METHOD: {
                return new ExecutableElementSupport((MethodTree)tree);
            }
            case VARIABLE: {
                return new VariableElementSupport((VariableTree)tree);
            }
            case TYPE_CAST: {
                return new TypeCastElementSupport((TypeCastTree)tree);
            }
            case METHOD_INVOCATION: {
                return new MethodInvocationElementSupport((MethodInvocationTree)tree);
            }
            case MEMBER_SELECT: {
                if (Util.getElement(tree) instanceof VariableElement) {
                    return new VariableAccessElementSupport((MemberSelectTree)tree);
                }
                return new ExtendedElementSupport<Tree>(tree);
            }
            case NEW_CLASS: {
                return new NewClassElementSupport((NewClassTree)tree);
            }
            case IDENTIFIER: {
                if (Util.getElement(tree) instanceof VariableElement) {
                    return new VariableAccessElementSupport(tree);
                }
                return new IdentifierElementSupport((IdentifierTree)tree);
            }
            case BOOLEAN_LITERAL: 
            case CHAR_LITERAL: 
            case DOUBLE_LITERAL: 
            case FLOAT_LITERAL: 
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case NULL_LITERAL: 
            case STRING_LITERAL: {
                return new LiteralElementSupport((LiteralTree)tree);
            }
            case CASE: {
                return new CaseElementSupport((CaseTree)tree);
            }
            case NEW_ARRAY: {
                return new NewArrayElementSupport((NewArrayTree)tree);
            }
            case ARRAY_ACCESS: {
                return new ArrayAccessElementSupport((ArrayAccessTree)tree);
            }
            case ENHANCED_FOR_LOOP: {
                return new ForeachLoopElementSupport((EnhancedForLoopTree)tree);
            }
            case AND_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case MULTIPLY_ASSIGNMENT: 
            case OR_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case XOR_ASSIGNMENT: {
                return new AssignmentWithOperatorElementSupport((CompoundAssignmentTree)tree);
            }
            case ASSIGNMENT: {
                return new AssignmentElementSupport((AssignmentTree)tree);
            }
            case IMPORT: {
                return new ImportElementSupport((ImportTree)tree);
            }
            case COMPILATION_UNIT: {
                return new CompilationUnitElementSupport((CompilationUnitTree)tree);
            }
            case MINUS: 
            case PLUS: 
            case MULTIPLY: 
            case DIVIDE: 
            case AND: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case OR: 
            case XOR: 
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: 
            case EQUAL_TO: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case NOT_EQUAL_TO: 
            case REMAINDER: 
            case UNSIGNED_RIGHT_SHIFT: {
                return new BinaryOperatorElementSupport((BinaryTree)tree);
            }
            case POSTFIX_DECREMENT: 
            case PREFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case PREFIX_INCREMENT: 
            case UNARY_MINUS: 
            case UNARY_PLUS: 
            case BITWISE_COMPLEMENT: 
            case LOGICAL_COMPLEMENT: {
                return new UnaryOperatorElementSupport((UnaryTree)tree);
            }
        }
        return new ExtendedElementSupport<Tree>(tree);
    }
}

