/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.model.support;

import com.sun.source.tree.BreakTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import javax.lang.model.element.VariableElement;
import org.jsweet.transpiler.ConstAnalyzer;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.model.ExtendedElement;
import org.jsweet.transpiler.model.ForeachLoopElement;
import org.jsweet.transpiler.model.support.ExtendedElementSupport;
import org.jsweet.transpiler.util.Util;

public class ForeachLoopElementSupport
extends ExtendedElementSupport<EnhancedForLoopTree>
implements ForeachLoopElement {
    public ForeachLoopElementSupport(EnhancedForLoopTree tree) {
        super(tree);
    }

    @Override
    public ExtendedElement getBody() {
        return this.createElement(((EnhancedForLoopTree)this.getTree()).getStatement());
    }

    @Override
    public VariableElement getIterationVariable() {
        return (VariableElement)Util.getElement(((EnhancedForLoopTree)this.getTree()).getVariable());
    }

    @Override
    public ExtendedElement getIterableExpression() {
        return this.createElement(((EnhancedForLoopTree)this.getTree()).getExpression());
    }

    @Override
    public boolean hasControlFlowStatement() {
        final boolean[] hasControlFlowStatement = new boolean[]{false};
        new TreeScanner<Void, Trees>(){

            @Override
            public Void visitBreak(BreakTree node, Trees p) {
                hasControlFlowStatement[0] = true;
                return null;
            }

            @Override
            public Void visitContinue(ContinueTree node, Trees p) {
                hasControlFlowStatement[0] = true;
                return null;
            }

            @Override
            public Void visitReturn(ReturnTree node, Trees p) {
                hasControlFlowStatement[0] = true;
                return null;
            }

            @Override
            public Void visitEnhancedForLoop(EnhancedForLoopTree node, Trees p) {
                return null;
            }

            @Override
            public Void visitDoWhileLoop(DoWhileLoopTree node, Trees p) {
                return null;
            }

            @Override
            public Void visitWhileLoop(WhileLoopTree node, Trees p) {
                return null;
            }

            @Override
            public Void visitForLoop(ForLoopTree node, Trees p) {
                return null;
            }
        }.scan(((EnhancedForLoopTree)this.getTree()).getStatement(), JSweetContext.current.get().trees);
        return hasControlFlowStatement[0];
    }

    @Override
    public boolean isIterationVariableModified() {
        ConstAnalyzer a = new ConstAnalyzer();
        a.scan(((EnhancedForLoopTree)this.getTree()).getStatement(), JSweetContext.current.get().trees);
        return a.getModifiedVariables().contains(this.getIterationVariable());
    }
}

