/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.util;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.File;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.function.Consumer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.apache.commons.io.FileUtils;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.SourcePosition;
import org.jsweet.transpiler.TranspilationHandler;
import org.jsweet.transpiler.model.CompilationUnitElement;
import org.jsweet.transpiler.model.ExtendedElement;
import org.jsweet.transpiler.model.ExtendedElementFactory;
import org.jsweet.transpiler.model.support.CompilationUnitElementSupport;
import org.jsweet.transpiler.model.support.ExtendedElementSupport;
import org.jsweet.transpiler.util.RollbackException;
import org.jsweet.transpiler.util.Util;

public abstract class AbstractTreeScanner
extends TreePathScanner<Void, Trees> {
    private TranspilationHandler logHandler;
    protected Stack<Tree> stack = new Stack();
    protected Map<String, ImportTree> staticImports = new HashMap<String, ImportTree>();
    protected CompilationUnitTree compilationUnit;
    protected final JSweetContext context;
    private Map.Entry<String, String[]> sourceCache;

    public void report(Tree tree, JSweetProblem problem, Object ... params) {
        this.report(tree, null, problem, params);
    }

    public void report(Tree tree, Name name, JSweetProblem problem, Object ... params) {
        if (this.logHandler == null) {
            System.err.println(problem.getMessage(params));
        } else if (this.compilationUnit == null) {
            this.logHandler.report(problem, null, problem.getMessage(params));
        } else {
            SourcePosition sourcePosition = this.util().getSourcePosition(tree, name, this.compilationUnit);
            this.logHandler.report(problem, sourcePosition, problem.getMessage(params));
        }
    }

    public Map<String, ImportTree> getStaticImports() {
        return this.staticImports;
    }

    public CompilationUnitTree getCompilationUnit() {
        return this.compilationUnit;
    }

    public CompilationUnitElement getCompilationUnitElement() {
        return new CompilationUnitElementSupport(this.getCompilationUnit());
    }

    public JSweetContext getContext() {
        return this.context;
    }

    protected SourcePositions sourcePositions() {
        return this.trees().getSourcePositions();
    }

    protected Trees trees() {
        return this.getContext().trees;
    }

    protected Types types() {
        return this.getContext().types;
    }

    protected Elements elements() {
        return this.getContext().elements;
    }

    protected Util util() {
        return this.getContext().util;
    }

    protected String[] getGetSource(CompilationUnitTree compilationUnit) {
        if (this.sourceCache != null && this.sourceCache.getKey().equals(compilationUnit.getSourceFile().getName())) {
            return this.sourceCache.getValue();
        }
        try {
            this.sourceCache = new AbstractMap.SimpleEntry<String, String[]>(compilationUnit.getSourceFile().getName(), FileUtils.readFileToString((File)new File(compilationUnit.getSourceFile().getName())).split("\\n"));
        }
        catch (Exception e) {
            return null;
        }
        return this.sourceCache.getValue();
    }

    protected AbstractTreeScanner(TranspilationHandler logHandler, JSweetContext context, CompilationUnitTree compilationUnit) {
        this.logHandler = logHandler;
        this.context = context;
        this.setCompilationUnit(compilationUnit);
    }

    protected final void setCompilationUnit(CompilationUnitTree compilationUnit) {
        JSweetContext.currentCompilationUnit.set(compilationUnit);
        if (compilationUnit != null) {
            this.compilationUnit = compilationUnit;
            for (ImportTree importTree : this.compilationUnit.getImports()) {
                if (!importTree.isStatic()) continue;
                String importedIdentifier = importTree.getQualifiedIdentifier().toString();
                this.staticImports.put(importedIdentifier.substring(importedIdentifier.lastIndexOf(".") + 1), importTree);
            }
        } else {
            this.compilationUnit = null;
        }
    }

    public void scan(ExtendedElement element) {
        this.scan((Tree)((ExtendedElementSupport)element).getTree(), this.trees());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void scan(Tree tree, Trees trees) {
        block10: {
            if (tree == null) {
                return null;
            }
            this.enter(tree);
            try {
                super.scan(tree, trees);
            }
            catch (RollbackException rollback) {
                if (rollback.getTarget() == tree) {
                    this.onRollbacked(tree);
                    if (rollback.getOnRollbacked() != null) {
                        rollback.getOnRollbacked().accept(tree);
                    }
                    break block10;
                }
                throw rollback;
            }
            catch (Exception e) {
                this.report(tree, JSweetProblem.INTERNAL_TRANSPILER_ERROR, new Object[0]);
                this.dumpStackTrace();
                e.printStackTrace();
            }
            finally {
                this.exit();
            }
        }
        return null;
    }

    public void dumpStackTrace() {
        System.err.println("dumping transpiler's strack trace:");
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Tree tree = (Tree)this.stack.get(i);
            if (tree == null) continue;
            String str = tree.toString().trim();
            int intialLength = str.length();
            int index = str.indexOf(10);
            if (index > 0) {
                str = str.substring(0, index + 1);
            }
            str = str.replace('\n', ' ');
            str = str.substring(0, Math.min(str.length() - 1, 30));
            System.err.print("   [" + ((Tree)this.stack.get(i)).getClass().getSimpleName() + "] " + str + (str.length() < intialLength ? "..." : "") + " (" + this.util().getSourcePosition(tree, this.compilationUnit));
            System.err.println(")");
        }
    }

    protected void onRollbacked(Tree target) {
    }

    protected void rollback(Tree target, Consumer<Tree> onRollbacked) {
        throw new RollbackException(target, onRollbacked);
    }

    protected void enter(Tree tree) {
        this.stack.push(tree);
    }

    protected void exit() {
        this.stack.pop();
    }

    public Stack<Tree> getStack() {
        return this.stack;
    }

    public Tree getCurrent() {
        if (this.stack.size() >= 1) {
            return (Tree)this.stack.get(this.stack.size() - 1);
        }
        return null;
    }

    public Tree getParent() {
        if (this.stack.size() >= 2) {
            return (Tree)this.stack.get(this.stack.size() - 2);
        }
        return null;
    }

    public Tree getParentOfParent() {
        if (this.stack.size() >= 3) {
            return (Tree)this.stack.get(this.stack.size() - 3);
        }
        return null;
    }

    public ExtendedElement getParentElement() {
        return ExtendedElementFactory.INSTANCE.create(this.getParent());
    }

    public <T extends Tree> T getParent(Class<T> type) {
        for (int i = this.stack.size() - 2; i >= 0; --i) {
            if (!type.isAssignableFrom(((Tree)this.stack.get(i)).getClass())) continue;
            return (T)((Tree)this.stack.get(i));
        }
        return null;
    }

    public <T extends Element> T getParentElement(Class<T> elementType) {
        for (int i = this.stack.size() - 2; i >= 0; --i) {
            Tree treeAtIndex = (Tree)this.stack.get(i);
            Element element = this.trees().getElement(this.trees().getPath(this.compilationUnit, treeAtIndex));
            if (!elementType.isAssignableFrom(element.getClass())) continue;
            return (T)element;
        }
        return null;
    }

    public Tree getFirstParent(Class<?> ... types) {
        for (int i = this.stack.size() - 2; i >= 0; --i) {
            for (Class<?> type : types) {
                if (!type.isAssignableFrom(((Tree)this.stack.get(i)).getClass())) continue;
                return (Tree)this.stack.get(i);
            }
        }
        return null;
    }

    public <T extends Tree> T getParent(Class<T> type, Tree from) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            if (this.stack.get(i) != from) continue;
            for (int j = i - 1; j >= 0; --j) {
                if (!type.isAssignableFrom(((Tree)this.stack.get(j)).getClass())) continue;
                return (T)((Tree)this.stack.get(j));
            }
            return null;
        }
        return null;
    }

    public TranspilationHandler getLogHandler() {
        return this.logHandler;
    }

    protected <T extends ExtendedElement> T createExtendedElement(Tree tree) {
        if (tree == null) {
            return null;
        }
        return (T)ExtendedElementFactory.INSTANCE.create(tree);
    }
}

