/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.util;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.model.ExtendedElement;
import org.jsweet.transpiler.model.ExtendedElementFactory;
import org.jsweet.transpiler.util.Util;

public class JSDoc {
    public static final Pattern paramPattern = Pattern.compile("(\\s*@param\\s+)(\\w+)(.*)");
    public static final Pattern authorPattern = Pattern.compile("(\\s*@author\\s+)(\\w+)(.*)");
    public static final Pattern returnPattern = Pattern.compile("(\\s*@return\\s+)(.*)");
    public static final Pattern linkPattern = Pattern.compile("(\\{@link\\s+)([\\w\\.#,]+)\\s+[^}]*(\\})");

    private JSDoc() {
    }

    public static String getMappedDocType(JSweetContext context, Tree typeTree, TypeMirror type, CompilationUnitTree compilationUnit) {
        String qualifiedName = type.toString();
        if (typeTree instanceof ParameterizedTypeTree) {
            Object parametrizedType = Util.getType(((ParameterizedTypeTree)typeTree).getType());
            qualifiedName = parametrizedType.toString();
        }
        boolean isMapped = false;
        for (Function<TypeMirror, String> mapping : context.getFunctionalTypeMirrorMappings()) {
            String string = mapping.apply(type);
            if (string == null) continue;
            isMapped = true;
            qualifiedName = string;
        }
        if (typeTree != null) {
            if (type instanceof TypeVariable) {
                TypeVariable typeVar = (TypeVariable)type;
                if (typeVar.getUpperBound() == null) {
                    return "*";
                }
                return JSDoc.getMappedDocType(context, null, typeVar.getUpperBound(), compilationUnit);
            }
            ExtendedElement extendedElement = ExtendedElementFactory.INSTANCE.create(typeTree);
            for (BiFunction biFunction : context.getFunctionalTypeMappings()) {
                Object mapped = biFunction.apply(extendedElement, qualifiedName);
                if (mapped instanceof String) {
                    isMapped = true;
                    qualifiedName = (String)mapped;
                    continue;
                }
                if (!(mapped instanceof Tree)) continue;
                isMapped = true;
                qualifiedName = JSDoc.getMappedDocType(context, (Tree)mapped, Util.getType((Tree)mapped), compilationUnit);
            }
        }
        if (context.isMappedType(qualifiedName)) {
            isMapped = true;
            qualifiedName = context.getTypeMappingTarget(qualifiedName);
        }
        if (!isMapped && !context.util.isPrimitiveOrVoid(type) && context.types.asElement(type) != null) {
            qualifiedName = context.getRootRelativeName(null, context.types.asElement(type));
        }
        if ("Array".equals(qualifiedName) && typeTree instanceof ParameterizedTypeTree) {
            Tree firstTypeArgTree = ((ParameterizedTypeTree)typeTree).getTypeArguments().get(0);
            Object firstTypeArgType = Util.getType(firstTypeArgTree);
            return JSDoc.getMappedDocType(context, firstTypeArgTree, firstTypeArgType, compilationUnit) + "[]";
        }
        if (typeTree instanceof ParameterizedTypeTree) {
            Object parametrizedType = Util.getType(((ParameterizedTypeTree)typeTree).getType());
            return JSDoc.getMappedDocType(context, ((ParameterizedTypeTree)typeTree).getType(), parametrizedType, compilationUnit);
        }
        if (!isMapped && context.isInterface((TypeElement)context.types.asElement(type))) {
            return "*";
        }
        return "any".equals(qualifiedName) ? "*" : qualifiedName;
    }

    private static String replaceLinks(JSweetContext context, String text) {
        Matcher linkMatcher = linkPattern.matcher(text);
        boolean result = linkMatcher.find();
        int lastMatch = 0;
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                sb.append(text.substring(lastMatch, linkMatcher.start()));
                sb.append(linkMatcher.group(1));
                TypeElement type = context.util.getTypeElementByName(context, linkMatcher.group(2));
                sb.append(type == null ? linkMatcher.group(2) : JSDoc.getMappedDocType(context, null, type.asType(), context.util.getCompilationUnit(type)));
                sb.append(linkMatcher.group(3));
                lastMatch = linkMatcher.end();
            } while (result = linkMatcher.find());
            sb.append(text.substring(lastMatch));
            return sb.toString();
        }
        return text;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String adaptDocComment(JSweetContext context, TreePath treePath, Tree tree, String commentText) {
        if (tree instanceof ClassTree) {
            MethodTree mainConstructor = null;
            for (Tree tree2 : ((ClassTree)tree).getMembers()) {
                TreePath memberTreePath;
                ExecutableElement executableElement;
                if (!(tree2 instanceof MethodTree) || (executableElement = (ExecutableElement)context.util.getElementForTreePath(memberTreePath = TreePath.getPath(treePath, tree2))).getKind() != ElementKind.CONSTRUCTOR || !((MethodTree)tree2).getModifiers().getFlags().contains((Object)Modifier.PUBLIC) || mainConstructor != null && mainConstructor.getParameters().size() >= ((MethodTree)tree2).getParameters().size()) continue;
                mainConstructor = (MethodTree)tree2;
            }
            if (mainConstructor != null) {
                TreePath mainConstructorTreePath = TreePath.getPath(treePath, mainConstructor);
                String string = context.trees.getDocComment(mainConstructorTreePath);
                Object author = null;
                if (string != null) {
                    ArrayList<String> arrayList = commentText == null ? null : new ArrayList<String>(Arrays.asList(commentText.split("\n")));
                    commentText = string;
                    if (arrayList != null) {
                        for (String line : arrayList) {
                            if (!authorPattern.matcher(line).matches()) continue;
                            author = line;
                            break;
                        }
                    }
                }
                if (commentText != null) {
                    commentText = JSDoc.replaceLinks(context, commentText);
                    ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(commentText.split("\n")));
                    JSDoc.applyForMethod(context, mainConstructor, mainConstructorTreePath, arrayList);
                    ClassTree clazz = (ClassTree)tree;
                    TypeElement classElement = (TypeElement)context.util.getElementForTreePath(treePath);
                    if (classElement.getKind() == ElementKind.ENUM) {
                        arrayList.add(" @enum");
                    }
                    if (clazz.getExtendsClause() != null) {
                        arrayList.add(" @extends " + JSDoc.getMappedDocType(context, clazz.getExtendsClause(), classElement.getSuperclass(), treePath.getCompilationUnit()));
                    }
                    if (author == null) return String.join((CharSequence)"\n", arrayList);
                    arrayList.add((String)author);
                    return String.join((CharSequence)"\n", arrayList);
                }
            }
        }
        Object element = context.util.getElementForTreePath(treePath);
        ArrayList<String> commentLines = null;
        if (commentText == null && tree instanceof MethodTree && context.hasAnnotationType((Element)element, Override.class.getName())) {
            commentText = "";
            commentLines = new ArrayList();
            JSDoc.applyForMethod(context, (MethodTree)tree, treePath, commentLines);
        }
        if (commentText == null) {
            return null;
        }
        commentText = JSDoc.replaceLinks(context, commentText);
        commentLines = new ArrayList<String>(Arrays.asList(commentText.split("\n")));
        if (tree instanceof MethodTree) {
            MethodTree methodTree = (MethodTree)tree;
            if (element.getKind() == ElementKind.CONSTRUCTOR) return null;
            JSDoc.applyForMethod(context, methodTree, treePath, commentLines);
            return String.join((CharSequence)"\n", commentLines);
        } else {
            if (!(tree instanceof ClassTree)) return String.join((CharSequence)"\n", commentLines);
            ClassTree classTree = (ClassTree)tree;
            if (element.getKind() == ElementKind.ENUM) {
                commentLines.add(" @enum");
                for (Tree tree3 : classTree.getMembers()) {
                    VariableTree var;
                    TreePath varTreePath;
                    VariableElement varElement;
                    if (!(tree3 instanceof VariableTree) || (varElement = (VariableElement)context.util.getElementForTreePath(varTreePath = TreePath.getPath(treePath, (Tree)(var = (VariableTree)tree3)))).getModifiers() == null || !varElement.getModifiers().contains((Object)Modifier.PUBLIC) || !varElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
                    commentLines.add("@property {" + JSDoc.getMappedDocType(context, var.getType(), context.util.getTypeForTreePath(TreePath.getPath(varTreePath, var.getType())), varTreePath.getCompilationUnit()) + "} " + var.getName().toString());
                    String varComment = context.trees.getDocComment(varTreePath);
                    if (varComment == null) continue;
                    varComment = JSDoc.replaceLinks(context, varComment);
                    commentLines.addAll(new ArrayList<String>(Arrays.asList(varComment.split("\n"))));
                }
            }
            if (classTree.getExtendsClause() != null) {
                TreePath extendsTreePath = TreePath.getPath(treePath, classTree.getExtendsClause());
                commentLines.add(" @extends " + JSDoc.getMappedDocType(context, classTree.getExtendsClause(), context.util.getTypeForTreePath(extendsTreePath), treePath.getCompilationUnit()));
            }
            commentLines.add(" @class");
        }
        return String.join((CharSequence)"\n", commentLines);
    }

    private static void applyForMethod(JSweetContext context, MethodTree method, TreePath methodTreePath, List<String> commentLines) {
        String name;
        ExecutableElement methodElement = (ExecutableElement)context.util.getElementForTreePath(methodTreePath);
        HashSet<String> params = new HashSet<String>();
        boolean hasReturn = false;
        for (int i = 0; i < commentLines.size(); ++i) {
            Matcher matcher = paramPattern.matcher(commentLines.get(i));
            if (matcher.matches()) {
                name = matcher.group(2);
                params.add(name);
                VariableTree parameter = context.util.findParameter(method, name);
                if (parameter == null) continue;
                TreePath parameterTypeTreePath = TreePath.getPath(methodTreePath, parameter.getType());
                commentLines.set(i, matcher.group(1) + "{" + JSDoc.getMappedDocType(context, parameter.getType(), context.util.getTypeForTreePath(parameterTypeTreePath), methodTreePath.getCompilationUnit()) + "} " + matcher.group(2) + matcher.group(3));
                continue;
            }
            Matcher matcher2 = returnPattern.matcher(commentLines.get(i));
            if (!matcher2.matches()) continue;
            hasReturn = true;
            if (method.getReturnType() == null) continue;
            TreePath returnTypeTreePath = TreePath.getPath(methodTreePath, method.getReturnType());
            commentLines.set(i, matcher2.group(1) + "{" + JSDoc.getMappedDocType(context, method.getReturnType(), context.util.getTypeForTreePath(returnTypeTreePath), returnTypeTreePath.getCompilationUnit()) + "} " + matcher2.group(2));
        }
        for (VariableTree variableTree : method.getParameters()) {
            name = variableTree.getName().toString();
            if (params.contains(name)) continue;
            TreePath parameterTypeTreePath = TreePath.getPath(methodTreePath, variableTree.getType());
            commentLines.add(" @param {" + JSDoc.getMappedDocType(context, variableTree.getType(), context.util.getTypeForTreePath(parameterTypeTreePath), parameterTypeTreePath.getCompilationUnit()) + "} " + name);
        }
        if (!hasReturn && method.getReturnType() != null && context.util.getTypeForTreePath(TreePath.getPath(methodTreePath, method.getReturnType())).getKind() != TypeKind.VOID && methodElement.getKind() != ElementKind.CONSTRUCTOR) {
            TreePath returnTypeTreePath = TreePath.getPath(methodTreePath, method.getReturnType());
            commentLines.add(" @return {" + JSDoc.getMappedDocType(context, method.getReturnType(), context.util.getTypeForTreePath(returnTypeTreePath), returnTypeTreePath.getCompilationUnit()) + "}");
        }
        if (methodElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            commentLines.add(" @private");
        }
        if (methodElement.getKind() == ElementKind.CONSTRUCTOR) {
            commentLines.add(" @class");
        }
    }
}

