/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jsweet.transpiler.util.Position;

public class SourceMap {
    private SortedSet<Entry> entries = new TreeSet<Entry>();
    private List<Entry> insertionOrderEntries = new ArrayList<Entry>();
    private long minOutputLine = 0L;
    private long maxOutputLine = 0L;

    public final Entry addEntry(Position inputPosition, Position outputPosition) {
        Entry entry = new Entry(inputPosition, outputPosition);
        this.entries.add(entry);
        this.insertionOrderEntries.add(entry);
        this.maxOutputLine = Math.max(this.maxOutputLine, (long)outputPosition.getLine());
        return entry;
    }

    public final Position findInputPosition(Position outputPosition) {
        return this.findInputPosition(outputPosition.getLine(), outputPosition.getColumn());
    }

    public final Position findInputPosition(long outputLine, long outputColumn) {
        if (this.entries.isEmpty()) {
            return null;
        }
        if (outputLine < this.minOutputLine) {
            return null;
        }
        if (outputLine > this.maxOutputLine) {
            return null;
        }
        if (this.entries != null) {
            Entry[] e = this.entries.toArray(new Entry[0]);
            for (int i = 0; i < this.entries.size(); ++i) {
                if (i != e.length - 1 && (long)e[i].getOutputPosition().getLine() != outputLine && (long)e[i + 1].getOutputPosition().getLine() <= outputLine) continue;
                while (i + 1 < e.length && (long)e[i + 1].getOutputPosition().getLine() == outputLine && (long)e[i].getOutputPosition().getColumn() < outputColumn) {
                    ++i;
                }
                return e[i].getInputPosition();
            }
        }
        return null;
    }

    public final void shiftOutputPositions(int lineOffset) {
        for (Entry entry : this.entries) {
            entry.setOutputPosition(new Position(entry.getOutputPosition().getLine() + lineOffset, entry.getOutputPosition().getColumn()));
        }
        this.minOutputLine += (long)lineOffset;
        this.maxOutputLine += (long)lineOffset;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Entry entry : this.entries) {
            sb.append(entry.toString());
            sb.append(" ");
        }
        return sb.toString();
    }

    public List<Entry> getSortedEntries(Comparator<Entry> comparator) {
        ArrayList<Entry> list = new ArrayList<Entry>(this.entries);
        list.sort(comparator);
        return list;
    }

    public void removeLastInsertedEntry() {
        if (this.entries.isEmpty()) {
            return;
        }
        Entry e = this.insertionOrderEntries.remove(this.insertionOrderEntries.size() - 1);
        this.entries.remove(e);
        this.maxOutputLine = 0L;
        for (Entry entry : this.entries) {
            this.maxOutputLine = Math.max(this.maxOutputLine, (long)entry.getOutputPosition().getLine());
        }
    }

    public static final class Entry
    implements Comparable<Entry> {
        private final Position inputPosition;
        private Position outputPosition;

        private Entry(Position inputPosition, Position outputPosition) {
            this.inputPosition = inputPosition;
            this.outputPosition = outputPosition;
        }

        public final Position getInputPosition() {
            return this.inputPosition;
        }

        public final Position getOutputPosition() {
            return this.outputPosition;
        }

        public final void setOutputPosition(Position position) {
            this.outputPosition = position;
        }

        @Override
        public int compareTo(Entry entry) {
            return this.getInputPosition().compareTo(entry.getInputPosition());
        }

        public String toString() {
            return this.getInputPosition().toString() + "->" + this.getOutputPosition().toString();
        }
    }
}

