/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.reflection.model.java;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jtwig.reflection.model.java.JavaClass;
import org.jtwig.reflection.model.java.JavaConstant;
import org.jtwig.reflection.model.java.JavaField;
import org.jtwig.reflection.model.java.JavaMethod;
import org.jtwig.reflection.model.java.JavaMethods;
import org.jtwig.reflection.model.java.MethodSignature;

public class JavaClassFactory {
    public JavaClass create(Class type) {
        HashMap<String, JavaConstant> constants = new HashMap<String, JavaConstant>();
        HashMap<String, JavaField> fields = new HashMap<String, JavaField>();
        HashMap<String, Map<MethodSignature, JavaMethod>> methodsByName = new HashMap<String, Map<MethodSignature, JavaMethod>>();
        HashMap<String, JavaMethods> javaMethods = new HashMap<String, JavaMethods>();
        this.extractFields(type, constants, fields);
        this.extractMethods(type, methodsByName);
        for (Map.Entry entry : methodsByName.entrySet()) {
            javaMethods.put((String)entry.getKey(), new JavaMethods((Map)entry.getValue()));
        }
        JavaClass result = new JavaClass(type, constants, fields, javaMethods);
        if (type.getSuperclass() != Object.class) {
            JavaClass javaClass = this.create(type.getSuperclass());
            result.merge(javaClass);
        }
        return result;
    }

    private void extractMethods(Class type, Map<String, Map<MethodSignature, JavaMethod>> methodsByName) {
        HashSet methods = new HashSet();
        Collections.addAll(methods, type.getMethods());
        Collections.addAll(methods, type.getDeclaredMethods());
        for (Method method : methods) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            JavaMethod javaMethod = new JavaMethod(method);
            if (!methodsByName.containsKey(method.getName())) {
                methodsByName.put(method.getName(), new HashMap());
            }
            methodsByName.get(method.getName()).put(new MethodSignature(method.getParameterTypes()), javaMethod);
        }
    }

    private void extractFields(Class type, Map<String, JavaConstant> constants, Map<String, JavaField> fields) {
        for (Field field : type.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) {
                constants.put(field.getName(), new JavaConstant(field));
                continue;
            }
            fields.put(field.getName(), new JavaField(field));
        }
    }
}

