/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.web.resource;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.servlet.ServletContext;
import org.jtwig.resource.loader.ResourceLoader;

public class WebResourceLoader
implements ResourceLoader {
    public static final String TYPE = "web";
    private final Supplier<ServletContext> servletContextSupplier;

    public WebResourceLoader(Supplier<ServletContext> servletContextSupplier) {
        this.servletContextSupplier = servletContextSupplier;
    }

    public Optional<Charset> getCharset(String path) {
        return Optional.absent();
    }

    public InputStream load(String path) {
        return ((ServletContext)this.servletContextSupplier.get()).getResourceAsStream(path);
    }

    public boolean exists(String path) {
        try {
            return ((ServletContext)this.servletContextSupplier.get()).getResource(path) != null;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public Optional<URL> toUrl(String path) {
        try {
            return Optional.of((Object)((ServletContext)this.servletContextSupplier.get()).getResource(path));
        }
        catch (MalformedURLException e) {
            return Optional.absent();
        }
    }
}

