/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.web.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jtwig.JtwigModel;
import org.jtwig.JtwigTemplate;
import org.jtwig.environment.Environment;
import org.jtwig.resource.exceptions.ResourceNotFoundException;
import org.jtwig.resource.metadata.ResourceMetadata;
import org.jtwig.resource.reference.ResourceReference;
import org.jtwig.web.servlet.ServletRequestHolder;
import org.jtwig.web.servlet.ServletResponseHolder;
import org.jtwig.web.servlet.model.factory.ApplicationFactory;

public class JtwigDispatcher {
    private final JtwigModel model = new JtwigModel();
    private final Environment environment;
    private final ResourceReference resourceReference;
    private final ApplicationFactory applicationFactory;

    public JtwigDispatcher(Environment environment, ResourceReference resourceReference, ApplicationFactory applicationFactory) {
        this.environment = environment;
        this.resourceReference = resourceReference;
        this.applicationFactory = applicationFactory;
    }

    public JtwigDispatcher with(String name, Object value) {
        this.model.with(name, value);
        return this;
    }

    public JtwigDispatcher with(Map<String, Object> values) {
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            this.model.with(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public void render(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.fillModelWithRequest((ServletRequest)request);
        ServletRequestHolder.set(request);
        ServletResponseHolder.set(response);
        this.model.with("app", (Object)this.applicationFactory.create(request));
        this.render((OutputStream)response.getOutputStream());
    }

    public void render(OutputStream outputStream) {
        ResourceMetadata resourceMetadata = this.environment.getResourceEnvironment().getResourceService().loadMetadata(this.resourceReference);
        if (!resourceMetadata.exists()) {
            throw new ResourceNotFoundException(String.format("Resource %s not found", this.resourceReference));
        }
        JtwigTemplate jtwigTemplate = new JtwigTemplate(this.environment, this.resourceReference);
        jtwigTemplate.render(this.model, outputStream);
    }

    private void fillModelWithRequest(ServletRequest request) {
        Enumeration attributeNames = request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String element = (String)attributeNames.nextElement();
            this.model.with(element, request.getAttribute(element));
        }
    }
}

