/*
 * Decompiled with CFR 0.152.
 */
package org.juhewu.mail;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.juhewu.mail.MailAccount;
import org.juhewu.mail.MailAccountLocator;

public class CompositeMailAccountLocator
implements MailAccountLocator {
    private final List<MailAccountLocator> mailAccountLocators;

    public CompositeMailAccountLocator(List<MailAccountLocator> mailAccountLocators) {
        this.mailAccountLocators = mailAccountLocators;
    }

    @Override
    public List<MailAccount> getMailAccounts() {
        return this.mailAccountLocators.stream().flatMap(item -> item.getMailAccounts().stream()).collect(Collectors.toList());
    }

    @Override
    public MailAccount getMailAccount(String id) {
        return this.mailAccountLocators.stream().map(item -> item.getMailAccount(id)).filter(Objects::nonNull).findFirst().orElseThrow(NullPointerException::new);
    }
}

