/*
 * Decompiled with CFR 0.152.
 */
package org.juhewu.mail;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.juhewu.mail.MailAccount;
import org.juhewu.mail.MailAccountRepository;

public class InMemoryMailAccountRepository
implements MailAccountRepository {
    private final Map<String, MailAccount> mailAccounts = Collections.synchronizedMap(new LinkedHashMap());

    @Override
    public List<MailAccount> getMailAccounts() {
        return new ArrayList<MailAccount>(this.mailAccounts.values());
    }

    @Override
    public MailAccount getMailAccount(String id) {
        return this.mailAccounts.get(id);
    }

    @Override
    public void add(MailAccount mailAccount) {
        this.mailAccounts.put(mailAccount.getId(), mailAccount);
    }

    @Override
    public void add(List<MailAccount> mailAccounts) {
        this.mailAccounts.putAll(mailAccounts.stream().collect(Collectors.toMap(MailAccount::getId, Function.identity())));
    }

    @Override
    public void delete(String id) {
        this.mailAccounts.remove(id);
    }

    @Override
    public void delete(List<String> ids) {
        for (String id : ids) {
            this.delete(id);
        }
    }
}

