/*
 * Decompiled with CFR 0.152.
 */
package org.junit.contrib.theories;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.javaruntype.type.Type;
import org.javaruntype.type.Types;
import org.junit.runners.model.FrameworkMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterSignature {
    private final java.lang.reflect.Type fType;
    private final Annotation[] fAnnotations;

    public static ArrayList<ParameterSignature> signatures(Method method) {
        return ParameterSignature.signatures(method.getGenericParameterTypes(), method.getParameterAnnotations());
    }

    public static List<ParameterSignature> signatures(Constructor<?> constructor) {
        return ParameterSignature.signatures(constructor.getGenericParameterTypes(), constructor.getParameterAnnotations());
    }

    private static ArrayList<ParameterSignature> signatures(java.lang.reflect.Type[] parameterTypes, Annotation[][] parameterAnnotations) {
        ArrayList<ParameterSignature> sigs = new ArrayList<ParameterSignature>();
        for (int i = 0; i < parameterTypes.length; ++i) {
            sigs.add(new ParameterSignature(parameterTypes[i], parameterAnnotations[i]));
        }
        return sigs;
    }

    private ParameterSignature(java.lang.reflect.Type type, Annotation[] annotations) {
        this.fType = type;
        this.fAnnotations = annotations;
    }

    public boolean canAcceptResultOf(FrameworkMethod dataPointMethod) {
        Method method = dataPointMethod.getMethod();
        return method.getParameterTypes().length == 0 && this.canAcceptType(method.getGenericReturnType());
    }

    public boolean canAcceptValue(Object candidate) {
        return candidate == null ? !Types.forJavaLangReflectType((java.lang.reflect.Type)this.fType).getRawClass().isPrimitive() : this.canAcceptType(candidate.getClass());
    }

    public boolean canAcceptType(java.lang.reflect.Type candidate) {
        return Types.forJavaLangReflectType((java.lang.reflect.Type)this.fType).isAssignableFrom(Types.forJavaLangReflectType((java.lang.reflect.Type)candidate));
    }

    public java.lang.reflect.Type getType() {
        return this.fType;
    }

    public List<Annotation> getAnnotations() {
        return Arrays.asList(this.fAnnotations);
    }

    public boolean canAcceptArrayType(java.lang.reflect.Type type) {
        Type typeToken = Types.forJavaLangReflectType((java.lang.reflect.Type)type);
        return typeToken.isArray() && this.canAcceptType(typeToken.getComponentClass());
    }

    public boolean hasAnnotation(Class<? extends Annotation> type) {
        return this.getAnnotation(type) != null;
    }

    public <T extends Annotation> T findDeepAnnotation(Class<T> annotationType) {
        return this.findDeepAnnotation(this.fAnnotations, annotationType, 3);
    }

    private <T extends Annotation> T findDeepAnnotation(Annotation[] annotations, Class<T> annotationType, int depth) {
        if (depth == 0) {
            return null;
        }
        for (Annotation each : annotations) {
            if (annotationType.isInstance(each)) {
                return (T)((Annotation)annotationType.cast(each));
            }
            T candidate = this.findDeepAnnotation(each.annotationType().getAnnotations(), annotationType, depth - 1);
            if (candidate == null) continue;
            return (T)((Annotation)annotationType.cast(candidate));
        }
        return null;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation each : this.getAnnotations()) {
            if (!annotationType.isInstance(each)) continue;
            return (T)((Annotation)annotationType.cast(each));
        }
        return null;
    }
}

