/*
 * Decompiled with CFR 0.152.
 */
package org.junit.contrib.theories.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.junit.contrib.theories.DataPoint;
import org.junit.contrib.theories.DataPoints;
import org.junit.contrib.theories.ParameterSignature;
import org.junit.contrib.theories.ParameterSupplier;
import org.junit.contrib.theories.PotentialAssignment;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllMembersSupplier
extends ParameterSupplier {
    private final TestClass fClass;

    public AllMembersSupplier(TestClass type) {
        this.fClass = type;
    }

    @Override
    public List<PotentialAssignment> getValueSources(ParameterSignature sig) {
        ArrayList<PotentialAssignment> list = new ArrayList<PotentialAssignment>();
        this.addFields(sig, list);
        this.addSinglePointMethods(sig, list);
        this.addMultiPointMethods(sig, list);
        return list;
    }

    private void addMultiPointMethods(ParameterSignature sig, List<PotentialAssignment> list) {
        for (FrameworkMethod dataPointsMethod : this.fClass.getAnnotatedMethods(DataPoints.class)) {
            try {
                this.addMultiPointArrayValues(sig, dataPointsMethod.getName(), list, dataPointsMethod.invokeExplosively(null, new Object[0]));
            }
            catch (Throwable e) {}
        }
    }

    private void addSinglePointMethods(ParameterSignature sig, List<PotentialAssignment> list) {
        for (FrameworkMethod dataPointMethod : this.fClass.getAnnotatedMethods(DataPoint.class)) {
            if (!sig.canAcceptResultOf(dataPointMethod)) continue;
            list.add(new MethodParameterValue(dataPointMethod));
        }
    }

    private void addFields(ParameterSignature sig, List<PotentialAssignment> list) {
        for (Field field : this.fClass.getJavaClass().getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            Type type = field.getGenericType();
            if (sig.canAcceptArrayType(type) && field.getAnnotation(DataPoints.class) != null) {
                try {
                    this.addArrayValues(field.getName(), list, this.getStaticFieldValue(field));
                }
                catch (Throwable e) {}
                continue;
            }
            if (!sig.canAcceptType(type) || field.getAnnotation(DataPoint.class) == null) continue;
            list.add(PotentialAssignment.forValue(field.getName(), this.getStaticFieldValue(field)));
        }
    }

    private void addArrayValues(String name, List<PotentialAssignment> list, Object array) {
        for (int i = 0; i < Array.getLength(array); ++i) {
            list.add(this.potentialAssignmentForArrayElement(name, array, i));
        }
    }

    private void addMultiPointArrayValues(ParameterSignature sig, String name, List<PotentialAssignment> list, Object array) throws Throwable {
        for (int i = 0; i < Array.getLength(array); ++i) {
            if (!sig.canAcceptValue(Array.get(array, i))) {
                return;
            }
            list.add(this.potentialAssignmentForArrayElement(name, array, i));
        }
    }

    private PotentialAssignment potentialAssignmentForArrayElement(String name, Object array, int index) {
        return PotentialAssignment.forValue(name + '[' + index + ']', Array.get(array, index));
    }

    private Object getStaticFieldValue(Field field) {
        try {
            return field.get(null);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("unexpected: field from getClass doesn't exist on object");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("unexpected: getFields returned an inaccessible field");
        }
    }

    static class MethodParameterValue
    extends PotentialAssignment {
        private final FrameworkMethod fMethod;

        private MethodParameterValue(FrameworkMethod dataPointMethod) {
            this.fMethod = dataPointMethod;
        }

        public Object getValue() throws PotentialAssignment.CouldNotGenerateValueException {
            try {
                return this.fMethod.invokeExplosively(null, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("unexpected: argument length is checked");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("unexpected: getMethods returned an inaccessible method");
            }
            catch (Throwable e) {
                throw new PotentialAssignment.CouldNotGenerateValueException();
            }
        }

        public String getDescription() throws PotentialAssignment.CouldNotGenerateValueException {
            return this.fMethod.getName();
        }
    }
}

