/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.launcher.main;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.junit.gen5.engine.TestExecutionResult;
import org.junit.gen5.engine.reporting.ReportEntry;
import org.junit.gen5.launcher.TestExecutionListener;
import org.junit.gen5.launcher.TestIdentifier;
import org.junit.gen5.launcher.TestPlan;

class TestExecutionListenerRegistry {
    private final List<TestExecutionListener> testExecutionListeners = new LinkedList<TestExecutionListener>();

    TestExecutionListenerRegistry() {
    }

    void registerListener(TestExecutionListener ... listeners) {
        for (TestExecutionListener listener : listeners) {
            this.testExecutionListeners.add(listener);
        }
    }

    private void notifyTestExecutionListeners(Consumer<TestExecutionListener> consumer) {
        this.testExecutionListeners.forEach(consumer);
    }

    TestExecutionListener getCompositeTestExecutionListener() {
        return new CompositeTestExecutionListener();
    }

    private class CompositeTestExecutionListener
    implements TestExecutionListener {
        private CompositeTestExecutionListener() {
        }

        @Override
        public void dynamicTestRegistered(TestIdentifier testIdentifier) {
            TestExecutionListenerRegistry.this.notifyTestExecutionListeners(listener -> listener.dynamicTestRegistered(testIdentifier));
        }

        @Override
        public void executionSkipped(TestIdentifier testIdentifier, String reason) {
            TestExecutionListenerRegistry.this.notifyTestExecutionListeners(listener -> listener.executionSkipped(testIdentifier, reason));
        }

        @Override
        public void executionStarted(TestIdentifier testIdentifier) {
            TestExecutionListenerRegistry.this.notifyTestExecutionListeners(listener -> listener.executionStarted(testIdentifier));
        }

        @Override
        public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
            TestExecutionListenerRegistry.this.notifyTestExecutionListeners(listener -> listener.executionFinished(testIdentifier, testExecutionResult));
        }

        @Override
        public void testPlanExecutionStarted(TestPlan testPlan) {
            TestExecutionListenerRegistry.this.notifyTestExecutionListeners(listener -> listener.testPlanExecutionStarted(testPlan));
        }

        @Override
        public void testPlanExecutionFinished(TestPlan testPlan) {
            TestExecutionListenerRegistry.this.notifyTestExecutionListeners(listener -> listener.testPlanExecutionFinished(testPlan));
        }

        @Override
        public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
            TestExecutionListenerRegistry.this.notifyTestExecutionListeners(listener -> listener.reportingEntryPublished(testIdentifier, entry));
        }
    }
}

