/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit5.descriptor;

import java.util.Map;
import java.util.Optional;
import org.junit.gen5.api.extension.ExtensionContext;
import org.junit.gen5.engine.EngineExecutionListener;
import org.junit.gen5.engine.TestDescriptor;
import org.junit.gen5.engine.junit5.execution.ExtensionValuesStore;
import org.junit.gen5.engine.junit5.execution.NamespaceAwareStore;
import org.junit.gen5.engine.reporting.ReportEntry;

abstract class AbstractExtensionContext
implements ExtensionContext {
    private final ExtensionContext parent;
    private final EngineExecutionListener engineExecutionListener;
    private final TestDescriptor testDescriptor;
    private final ExtensionValuesStore valuesStore;

    AbstractExtensionContext(ExtensionContext parent, EngineExecutionListener engineExecutionListener, TestDescriptor testDescriptor) {
        this.parent = parent;
        this.engineExecutionListener = engineExecutionListener;
        this.testDescriptor = testDescriptor;
        this.valuesStore = this.createStore(parent);
    }

    private ExtensionValuesStore createStore(ExtensionContext parent) {
        ExtensionValuesStore parentStore = null;
        if (parent != null) {
            parentStore = ((AbstractExtensionContext)parent).valuesStore;
        }
        return new ExtensionValuesStore(parentStore);
    }

    public void publishReportEntry(Map<String, String> values) {
        this.engineExecutionListener.reportingEntryPublished(this.testDescriptor, ReportEntry.from(values));
    }

    public Optional<ExtensionContext> getParent() {
        return Optional.ofNullable(this.parent);
    }

    protected TestDescriptor getTestDescriptor() {
        return this.testDescriptor;
    }

    public ExtensionContext.Store getStore(ExtensionContext.Namespace namespace) {
        return new NamespaceAwareStore(this.valuesStore, namespace);
    }
}

