/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.api.MethodDescriptor;
import org.junit.jupiter.api.MethodOrdererContext;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ClassUtils;

@API(status=API.Status.EXPERIMENTAL, since="5.4")
public interface MethodOrderer {
    public void orderMethods(MethodOrdererContext var1);

    default public Optional<ExecutionMode> getDefaultExecutionMode() {
        return Optional.of(ExecutionMode.SAME_THREAD);
    }

    public static class Random
    implements MethodOrderer {
        private static final Logger logger = LoggerFactory.getLogger(Random.class);
        public static final String RANDOM_SEED_PROPERTY_NAME = "junit.jupiter.execution.order.random.seed";
        private boolean usingCustomSeed = false;

        @Override
        public void orderMethods(MethodOrdererContext context) {
            Long seed = null;
            Optional<String> configurationParameter = context.getConfigurationParameter(RANDOM_SEED_PROPERTY_NAME);
            if (configurationParameter.isPresent()) {
                String value = configurationParameter.get();
                try {
                    seed = Long.valueOf(value);
                    this.usingCustomSeed = true;
                    logger.config(() -> String.format("Using custom seed for configuration parameter [%s] with value [%s].", RANDOM_SEED_PROPERTY_NAME, value));
                }
                catch (NumberFormatException ex) {
                    logger.warn((Throwable)ex, () -> String.format("Failed to convert configuration parameter [%s] with value [%s] to a long. Using System.nanoTime() as fallback.", RANDOM_SEED_PROPERTY_NAME, value));
                }
            }
            if (seed == null) {
                seed = System.nanoTime();
            }
            Collections.shuffle(context.getMethodDescriptors(), new java.util.Random(seed));
        }

        @Override
        public Optional<ExecutionMode> getDefaultExecutionMode() {
            return this.usingCustomSeed ? Optional.of(ExecutionMode.SAME_THREAD) : Optional.empty();
        }
    }

    public static class OrderAnnotation
    implements MethodOrderer {
        private static final Comparator<MethodDescriptor> comparator = (descriptor1, descriptor2) -> Integer.compare(OrderAnnotation.getOrder(descriptor1), OrderAnnotation.getOrder(descriptor2));

        @Override
        public void orderMethods(MethodOrdererContext context) {
            context.getMethodDescriptors().sort(comparator);
        }

        private static Integer getOrder(MethodDescriptor descriptor) {
            return descriptor.findAnnotation(Order.class).map(Order::value).orElse(Integer.MAX_VALUE);
        }
    }

    public static class Alphanumeric
    implements MethodOrderer {
        private static final Comparator<MethodDescriptor> comparator = (descriptor1, descriptor2) -> {
            Method method1 = descriptor1.getMethod();
            Method method2 = descriptor2.getMethod();
            int result = method1.getName().compareTo(method2.getName());
            if (result != 0) {
                return result;
            }
            return Alphanumeric.parameterList(method1).compareTo(Alphanumeric.parameterList(method2));
        };

        @Override
        public void orderMethods(MethodOrdererContext context) {
            context.getMethodDescriptors().sort(comparator);
        }

        private static String parameterList(Method method) {
            return ClassUtils.nullSafeToString((Class[])method.getParameterTypes());
        }
    }
}

